

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMKillActiveJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMKillActiveJobs.sp,v $ $Id: JMKillActiveJobs.sp,v 1.14.2.7 2020/05/20 14:01:53 jragunathan Exp $";
--
--  +========================================================================+
--  |   Procedure:  JMKillActiveJobs
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:
--  |
--  |       Input:  xxxx
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMKillActiveJobs')
BEGIN
	print '>>> Drop Stored Procedure: JMKillActiveJobs <<<'
	drop procedure JMKillActiveJobs
END
IF EXISTS (select * from GxQscripts where name='JMKillActiveJobs')
	delete from GxQscripts where name = 'JMKillActiveJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMKillActiveJobs')
	delete from GXDBVersions where aliasname = 'JMKillActiveJobs'
GO
print '... Creating Procedure: JMKillActiveJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMKillActiveJobs
AS
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
	declare @inJobId		integer
	declare @inCommcellId	integer
	declare @inAppId		integer
	declare @inAppType		integer
	declare @inmodifiedTime	integer
	declare @inOpType		integer
	declare @isOracleAppType integer
	declare @isRMan			 integer
	declare @errorCode		 integer
	declare @sqlStringT nvarchar(max)
	declare @bkpAttributesEx BIGINT = 0
	BEGIN TRY
	BEGIN TRAN killJobTran
	IF object_id('tempdb.dbo.#tempFileType') IS NOT NULL DROP TABLE #tempFileType
	IF object_id('tempdb.dbo.#tempCopyFileType') IS NOT NULL DROP TABLE #tempCopyFileType
	CREATE TABLE #tempFileType (archGroupId int, fileType int)
	CREATE TABLE #tempCopyFileType (archGroupId int, copyId int, copyFlags int, fileType int, isValid int, physicalSize bigint)
	DECLARE runningJobCur CURSOR FOR select jobId, commcellId, opType from jmjobinfo Where opType != 90
	OPEN runningJobCur
	--before killing jobs lets mark unpicked jobs as picked so that they do not get picked.
	--MR#107631
	Update TM_jobs set status = 2 where status in (0,1)
	FETCH NEXT FROM runningJobCur	INTO @inJobId, @inCommcellId, @inOpType
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @errorCode = 0
		SET @bkpAttributesEx = 0
		DELETE FROM #tempFileType
		DELETE FROM #tempCopyFileType
		IF ((SELECT max(id) FROM simAllGalaxyRel) = 14)	-- From 9.0
		BEGIN
			IF EXISTS(SELECT *FROM JMBkpJobInfo where jobId = @inJobId and commcellId = @inCommcellId)
			BEGIN
			-- Fetch the appTypeId
			select @inAppType = APP_Application.appTypeId, @inAppId= APP_Application.id, @bkpAttributesEx = JMBkpJobInfo.bkpAttributesEx
			From JMBkpJobInfo, APP_Application where jobid = @inJobId and commcellId = @inCommcellId and JMBkpJobInfo.applicationId = APP_Application.id
			SET @isRMan				=0
			SET @isOracleAppType	=0
			-- Set oracle, rman properties
			if(@inAppType = 2 or @inAppType = 22 or @inAppType = 23 or @inAppType = 80) /*Oracle*/
			BEGIN
				SET @isOracleAppType = 1;
				if exists (select *From APP_SubClientProp where componentNameId = @inAppId and attrName = 'Use RMAN for Tape Movement' and modified = 0)
					SET @isRMan = 1
			END
			INSERT INTO #tempCopyFileType
			SELECT A.archGroupId, B.archCopyId, (SELECT flags FROM archGroupCopy WHERE id = B.archCopyId),
				   A.fileType, MAX(B.isValid), SUM(B.physicalSize)
			FROM   archFile as A, archFileCopy as B
			WHERE  A.id = B.archFileId AND A.commCellId = @inCommcellId AND B.commCellId = @inCommcellId
				   AND A.jobId = @inJobId AND (B.physicalSize > 0 OR (A.flags & 2) <> 0)
			GROUP BY A.archGroupId, B.archCopyId, A.fileType
			INSERT INTO #tempFileType
			SELECT DISTINCT archGroupId, fileType
			FROM   #tempCopyFileType
			INSERT INTO #tempCopyFileType
			SELECT A.archGroupId, A.copyId, A.copyFlags, B.fileType, 0, 0
			FROM   #tempCopyFileType A, #tempFileType B
			WHERE  (A.copyFlags & 1024) <> 0 AND A.archGroupId = B.archGroupId AND NOT EXISTS (
				   SELECT * FROM #tempCopyFileType WHERE copyId = A.copyId AND fileType = B.fileType)
			-- Step1: Mark archive Files
			IF @inOpType = 59/*SNAPBACKUP*/ or @inOpType = 65 /*SNAPBACKUP3RD*/
			BEGIN
				IF @isRMan = 0 EXEC ArchFileSetInvalidByJob @inJobId, @inCommcellId, 0
			END
			ELSE IF @inOpType = 60/*SNAPTOTAPE*/ or @inOpType = 70/*MININGBACKUP*/
			BEGIN
				IF @isRMan = 0 EXEC ArchFileSetInvalidByJob @inJobId, @inCommcellId, 0
			END
			ELSE IF @isOracleAppType = 0/*Not Oracle*/
			BEGIN
				EXEC ArchFileSetInvalidByJob @inJobId, @inCommcellId, 0
			END
			-- Step2: Populate JMBkpStats
			SET @sqlStringT = N'Insert into JMBkpStats
			Select
			a.jobId,
			a.commcellId,
			a.applicationId,
			@inAppType,
			(select count(*) as NumAttemps From JMBkpAttemptInfo WITH(NOLOCK) where jobId = @inJobId),
			a.dataPolicy,
			0/*copy Id*/,
			a.bkpLevel, a.indexOverride, 4 /*KILLED STATUS*/,
			c.elapsedTime,
			a.numStreams,
			c.jobStartTime,
			dbo.GetUnixTime(GetUTCDate()),
			c.opType,
			case c.opType when 60/*SNAPTOTAPE*/ then 0
				else (ISNULL((select cast(attrVal as int) From APP_SubClientProp where componentNameId = @inAppId and attrName = ''sys:full cycle num'' and modified = 0),0)) end,
			c.initFrom,
			c.failureReason,
			a.bkpOptions,
			a.scanFileFailures,
			a.scanFolderFailures,
			a.backupFileFailures,
			a.backupFolderFailures,
			a.oraSubLevel,
			ISNULL((SELECT login FROM UMUsers WITH (READUNCOMMITTED) WHERE id = c.userId),''Unknown'') AS [UserName],
			ISNULL((select sum(ISNULL(writeTime,0))from JMBkpAttemptInfo d WITH(NOLOCK) where d.jobId = @inJobId and (d.attributes & 1) =1 and (d.attributes & 2) = 2),0),
			c.combPriority,
			a.compBytes,
			a.unCompBytes,
			ISNULL((select sum(ISNULL(numFiles,0))from JMBkpAttemptInfo d WITH(NOLOCK) where d.jobId = @inJobId and (d.attributes & 1) =1 and (d.attributes & 2) = 2),0),
			a.bkpattributes, a.logPolicy,
			ISNULL((select sum(ISNULL(numFolders,0))from JMBkpAttemptInfo d WITH(NOLOCK) where d.jobId = @inJobId and (d.attributes & 1) =1 and (d.attributes & 2) = 2), 0),
			0/*failureErrorCode*/,
			0, a.scanType, a.scanTypeChangeReason, a.numStreams,
			(case when EXISTS(SELECT * FROM archFile WITH(NOLOCK) Where jobId = @inJobId and commCellId = @inCommcellId) then 0 /*DATA_STATUS_VALID*/
				 else 3/*DATA_STATUS_NODATA*/ end) AS DataStatus,
			0, 0, dbo.GetUnixTime(GetUTCDate()), 1/*Undefined IDA Version*/,
			15 /*SIM_ID_GX_CURRENT*/,
			0,
			case c.opType when 60/*SNAPTOTAPE*/ then 0
				else (ISNULL((select cast(attrVal as int) From APP_SubClientProp where componentNameId = @inAppId and attrName = ''sys:non full cycle num'' and modified = 0), 0)) end,
			a.filesToXfer,
			a.cloudId,
			a.diffPolicy,
			0 /*TotalBackupSize*/, 0, 0, a.unCompBytesToXfer, 4 /*KILLED STATUS*/,
			case when exists(select *From #tempCopyFileType where fileType = 1/*CVA_DATATYPE_DATA*/) then 1
				 else 0 end as DataBackedUp,
			case when exists(select *From #tempCopyFileType where fileType = 4/*CVA_DATATYPE_LOGS*/) then 1
				 else 0 end as LogsBackedUp,
			0, a.secondaryBkpLevel, 0, a.jobIdActedOn, a.fromTime, a.toTime, a.backupTaskId, a.nwTransBytes
			from JMBkpJobInfo a, jmjobinfo c
			where a.jobId = @inJobId  and a.commcellId = @inCommcellId and
			a.jobid = c.jobid and a.commCellId = c.commCellId'
			EXEC sp_executesql @sqlStringT
			SET @inmodifiedTime = dbo.GetUnixTime(GetUTCDate())
			-- Step3: Populate attempts table
			EXEC JMCreateBkpAttemptStats @inJobId, @inCommcellId, @inmodifiedTime
			-- Step4: Populate JMJobDataStats
			EXEC ArchJobDataStatsCreate @inJobId, @inCommcellId, @inAppType, 4/*FAILED STATE*/, @inmodifiedTime
IF @bkpAttributesEx & 0x200 = 0x200 -- Edge drive job, always make it CWE.
			BEGIN
				UPDATE JMBkpStats
				SET status = 3 , displayStatus = 3 -- PARTIALSUCCESS
				WHERE jobId = @inJobId AND commCellId = @inCommcellId
			END
			END
			ELSE IF EXISTS(SELECT *FROM JMRstJobInfo where jobId = @inJobId and commcellId = @inCommcellId)
			BEGIN
				Insert into JMRestoreStats
				SELECT a.jobId, a.commCellId, a.srcClientId, a.bkpSetID, a.appType, 4/*KILLED STATUS*/,0/*duration*/,
				b.jobStartTime,
				dbo.GetUnixTime(GetUTCDate()),a.destClientId,
				(select count(*) as NumAttemps From JMRestoreAtmptStats where jobId = @inJobId),
				0/*totSuccess_h*/,
				a.totSuccess,
				0/*totCompBytes_h*/,
				a.totCompBytes,
				0/*totUnCompBytes_h*/,
				a.totUnCompBytes,
				0/*totBytes2Xfer_h*/,
				a.totBytes2Xfer,
				a.instanceID,
				b.opType,
				b.initFrom,
				b.failureReason,
				ISNULL((SELECT login FROM UMUsers WITH (READUNCOMMITTED) WHERE id = b.userId),'Unknown') AS [UserName],
				b.combPriority,
				0/*rstType*/,
				0/*FailureErrorCode*/,
				a.totSkipped,
				a.totFailures,
				a.srcClientId,
				dbo.GetUnixTime(GetUTCDate()),
				15 /*SIM_ID_GX_CURRENT*/,
				a.rstattributes,
				a.rstTaskID,
				0.0 /*readAverageThroughput*/,
				0.0 /*writeAverageThroughput*/,
				0.0 /*networkAverageThroughput*/,
				0.0 /*sidbAverageLookups*/,
				a.destInstanceId
				FROM JMRstJobInfo a, JMJobInfo b
				WHERE a.jobid = @inJobId and a.commCellId = @inCommcellId and a.jobId = b.jobId and a.commCellId = b.commCellId
				SET @inmodifiedTime = dbo.GetUnixTime(GetUTCDate())
				SET @sqlStringT = N'INSERT INTO JMRestoreAtmptStats
									(jobId, attemptNum, phase, status, servStart, servEnd, elapsedTime, numSuccess_h, numSuccess_l,
									numFailures_h, numFailures_l, compBytes_h, compBytes_l, uncompBytes_h, uncompBytes_l, failureReason, commCellId, numSkipped, modifiedTime, totalAllocationTime,
									totalWaitTimeBeforeAllocation, readThroughput, writeThroughput, networkThroughput, sidbLookups)
									SELECT jobId, attemptNum, phaseNum, status, startTime, endTime, elapsedTime, numSuccess_h, numSuccess_l,
									numFailures_h, numFailures_l, compBytes_h, compBytes_l, uCompBytes_h, uCompBytes_l, failureReason, 2/*commcellId*/, numSkipped, @inmodifiedTime, totalAllocationTime,
									totalWaitTimeBeforeAllocation, 0, 0, 0, 0
									FROM JMRstAttemptInfo WITH (READUNCOMMITTED) WHERE jobId = ' + cast(@inJobId as varchar(15))
				EXEC sp_executesql @sqlStringT
			END
			ELSE IF EXISTS(SELECT *FROM JMAdminJobInfoTable where jobId = @inJobId)
			BEGIN
				IF @inOpType = 11/*CSDRBKP*/ or @inOpType = 44 /*BROWSEANDDELETE*/ or @inOpType = 44 /*INFOMGMT*/
					EXEC ArchFileSetInvalidByJob @inJobId, @inCommcellId, 0
				Insert into JMAdminJobStatsTable
				SELECT a.jobId, b.opType, 4/*KILLED STATUS*/,
				b.jobStartTime,
				dbo.GetUnixTime(GetUTCDate()),
				a.archGrpID,
				a.archGrpName,
				a.AP_NumDays,
				a.AP_IsForecast,
				a.AP_SeqNum,
				a.AC_NewMediaFlag,
				a.ER_BkpLevel,
				a.ER_DbName,
				a.ER_Destination,
				a.ER_SendCount,
				a.ER_MediasUsed,
				a.TotalObjects,
				a.ObjectsDone,
				a.ObjectsFailed,
				b.initFrom,
				b.failureReason,
				a.archGrpCopyID,
				a.LibraryID,
				a.MI_InventoryType,
				ISNULL((SELECT login FROM UMUsers WITH (READUNCOMMITTED) WHERE id = b.userId),'Unknown') AS [UserName],
				ISNULL((select sum(ISNULL(writeTime,0))from JMAdminJobAttemptInfoTable d WITH(NOLOCK) where d.jobId = @inJobId), 0) AS WriteTime,
				a.noOfStreams,
				b.combPriority,
				2/*CommcellId*/,
				a.appID,
				0/*failureErrorCode*/,
				a.totalSize,
				ISNULL((select cast(attrVal as int) From APP_SubClientProp where componentNameId = a.appId and attrName = 'sys:full cycle num' and modified = 0),0) as fullCycleNumber,
				(case when a.uncompBytes >0 then 0/*DATA_STATUS_VALID*/
					  else 3/*DATA_STATUS_NODATA*/ end) AS DataStatus,
				a.workFlowId,
				a.embeddedObjects,
				a.uncompBytes,
				a.numFiles,
				a.skippedItems,
				0/*jobFlags*/,
				a.cloudId,
				case b.opType When 53/*OFFLINECONTENTINDEX*/ then -1 else 0 end/*SuccessIndex*/,
				case b.opType When 53/*OFFLINECONTENTINDEX*/ then -1 else 0 end/*failIndex*/,
				0/*totalBackupSize*/,
				15 /*SIM_ID_GX_CURRENT*/,
				a.fromTime,
				a.toTime,
				a.subTaskId,
				a.otherOpName,
				a.nwTransBytes
				FROM JMAdminJobInfoTable a, JMJobInfo b
				WHERE a.jobid = @inJobId and a.jobId = b.jobId
				SET @sqlStringT = N'INSERT INTO JMAdminJobAttemptStatsTable
									SELECT jobId, attemptNum, phaseNum, status, startTime, endTime, elapsedTime, failureReason, writeTime, 2/*CommcellId*/, embeddedObjects, uncompBytes, numFiles,
									skippedItems, TotalSize, nwTransBytes
									FROM JMAdminJobAttemptInfoTable WITH (READUNCOMMITTED) WHERE jobId = ' + cast(@inJobId as varchar(15))
				EXEC sp_executesql @sqlStringT
				SET @inmodifiedTime = dbo.GetUnixTime(GetUTCDate())
				-- Populate JMJobDataStats
				IF @inOpType = 11/*CSDRBKP*/ or @inOpType = 44 /*BROWSEANDDELETE*/ or @inOpType = 44 /*INFOMGMT*/
					EXEC ArchJobDataStatsCreate @inJobId, @inCommcellId, 1000 /*COMMSRVMGMT*/, 4/*FAILED STATE*/, @inmodifiedTime
			END
		END
		ELSE IF ((SELECT max(id) FROM simAllGalaxyRel) > 14)	-- From 10.0
		BEGIN
			IF EXISTS(SELECT *FROM JMBkpJobInfo where jobId = @inJobId and commcellId = @inCommcellId)
			BEGIN
			-- Fetch the appTypeId
			select @inAppType = APP_Application.appTypeId, @inAppId= APP_Application.id From JMBkpJobInfo, APP_Application where jobid = @inJobId and commcellId = @inCommcellId and JMBkpJobInfo.applicationId = APP_Application.id
			SET @isRMan				=0
			SET @isOracleAppType	=0
			-- Set oracle, rman properties
			if(@inAppType = 2 or @inAppType = 22 or @inAppType = 23 or @inAppType = 80) /*Oracle*/
			BEGIN
				SET @isOracleAppType = 1;
				if exists (select *From APP_SubClientProp where componentNameId = @inAppId and attrName = 'Use RMAN for Tape Movement' and modified = 0)
					SET @isRMan = 1
			END
			INSERT INTO #tempCopyFileType
			SELECT A.archGroupId, B.archCopyId, (SELECT flags FROM archGroupCopy WHERE id = B.archCopyId),
				   A.fileType, MAX(B.isValid), SUM(B.physicalSize)
			FROM   archFile as A, archFileCopy as B
			WHERE  A.id = B.archFileId AND A.commCellId = @inCommcellId AND B.commCellId = @inCommcellId
				   AND A.jobId = @inJobId AND (B.physicalSize > 0 OR (A.flags & 2) <> 0)
			GROUP BY A.archGroupId, B.archCopyId, A.fileType
			INSERT INTO #tempFileType
			SELECT DISTINCT archGroupId, fileType
			FROM   #tempCopyFileType
			INSERT INTO #tempCopyFileType
			SELECT A.archGroupId, A.copyId, A.copyFlags, B.fileType, 0, 0
			FROM   #tempCopyFileType A, #tempFileType B
			WHERE  (A.copyFlags & 1024) <> 0 AND A.archGroupId = B.archGroupId AND NOT EXISTS (
				   SELECT * FROM #tempCopyFileType WHERE copyId = A.copyId AND fileType = B.fileType)
			-- Step1: Mark archive Files
			IF @inOpType = 59/*SNAPBACKUP*/ or @inOpType = 65 /*SNAPBACKUP3RD*/
			BEGIN
				IF @isRMan = 0 EXEC ArchFileSetInvalidByJob @inJobId, @inCommcellId, 0
			END
			ELSE IF @inOpType = 60/*SNAPTOTAPE*/ or @inOpType = 70/*MININGBACKUP*/
			BEGIN
				IF @isRMan = 0 EXEC ArchFileSetInvalidByJob @inJobId, @inCommcellId, 0
			END
			ELSE IF @isOracleAppType = 0/*Not Oracle*/
			BEGIN
				EXEC ArchFileSetInvalidByJob @inJobId, @inCommcellId, 0
			END
			-- Step2: Populate JMBkpStats
			Insert into JMBkpStats
			Select
			a.jobId,
			a.commcellId,
			a.applicationId,
			@inAppType,
			(select count(*) as NumAttemps From JMBkpAttemptInfo WITH(NOLOCK) where jobId = @inJobId),
			a.dataPolicy,
			0/*copy Id*/,
			a.bkpLevel, a.indexOverride, 4 /*KILLED STATUS*/,
			c.elapsedTime,
			a.numStreams,
			c.jobStartTime,
			dbo.GetUnixTime(GetUTCDate()),
			c.opType,
			case c.opType when 60/*SNAPTOTAPE*/ then 0
				else (ISNULL((select cast(attrVal as int) From APP_SubClientProp where componentNameId = @inAppId and attrName = 'sys:full cycle num' and modified = 0),0)) end,
			c.initFrom,
			c.failureReason,
			a.bkpOptions,
			a.scanFileFailures,
			a.scanFolderFailures,
			a.backupFileFailures,
			a.backupFolderFailures,
			a.oraSubLevel,
			ISNULL((SELECT login FROM UMUsers WITH (READUNCOMMITTED) WHERE id = c.userId),'Unknown') AS [UserName],
			ISNULL((select sum(ISNULL(writeTime,0))from JMBkpAttemptInfo d WITH(NOLOCK) where d.jobId = @inJobId and (d.attributes & 1) =1 and (d.attributes & 2) = 2),0),
			c.combPriority,
			a.compBytes,
			a.unCompBytes,
			ISNULL((select sum(ISNULL(numFiles,0))from JMBkpAttemptInfo d WITH(NOLOCK) where d.jobId = @inJobId and (d.attributes & 1) =1 and (d.attributes & 2) = 2),0),
			a.bkpattributes, a.logPolicy,
			ISNULL((select sum(ISNULL(numFolders,0))from JMBkpAttemptInfo d WITH(NOLOCK) where d.jobId = @inJobId and (d.attributes & 1) =1 and (d.attributes & 2) = 2), 0),
			0/*failureErrorCode*/,
			0, a.scanType, a.scanTypeChangeReason, a.numStreams,
			(case when EXISTS(SELECT * FROM archFile WITH(NOLOCK) Where jobId = @inJobId and commCellId = @inCommcellId) then 0 /*DATA_STATUS_VALID*/
				 else 3/*DATA_STATUS_NODATA*/ end) AS DataStatus,
			0, 0, dbo.GetUnixTime(GetUTCDate()), 1/*Undefined IDA Version*/,
			15 /*SIM_ID_GX_CURRENT*/,
			0,
			case c.opType when 60/*SNAPTOTAPE*/ then 0
				else (ISNULL((select cast(attrVal as int) From APP_SubClientProp where componentNameId = @inAppId and attrName = 'sys:non full cycle num' and modified = 0), 0)) end,
			a.filesToXfer,
			a.cloudId,
			a.diffPolicy,
			0 /*TotalBackupSize*/, 0, 0, a.unCompBytesToXfer, 4 /*KILLED STATUS*/,
			case when exists(select *From #tempCopyFileType where fileType = 1/*CVA_DATATYPE_DATA*/) then 1
				 else 0 end as DataBackedUp,
			case when exists(select *From #tempCopyFileType where fileType = 4/*CVA_DATATYPE_LOGS*/) then 1
				 else 0 end as LogsBackedUp,
			0, a.secondaryBkpLevel, 0, a.jobIdActedOn, a.fromTime, a.toTime, a.backupTaskId, a.nwTransBytes, a.totSkippedObjects, a.bkpAttributesEx, a.jobReferenceTime
			from JMBkpJobInfo a, jmjobinfo c
			where a.jobId = @inJobId  and a.commcellId = @inCommcellId and
			a.jobid = c.jobid and a.commCellId = c.commCellId
			SET @inmodifiedTime = dbo.GetUnixTime(GetUTCDate())
			-- Step3: Populate attempts table
			EXEC JMCreateBkpAttemptStats @inJobId, @inCommcellId, @inmodifiedTime
			-- Step4: Populate JMJobDataStats
			EXEC ArchJobDataStatsCreate @inJobId, @inCommcellId, @inAppType, 4/*FAILED STATE*/, @inmodifiedTime
			END
			ELSE IF EXISTS(SELECT *FROM JMRstJobInfo where jobId = @inJobId and commcellId = @inCommcellId)
			BEGIN
				Insert into JMRestoreStats
				SELECT a.jobId, a.commCellId, a.srcClientId, a.bkpSetID, a.appType, 4/*KILLED STATUS*/,0/*duration*/,
				b.jobStartTime,
				dbo.GetUnixTime(GetUTCDate()),a.destClientId,
				(select count(*) as NumAttemps From JMRestoreAtmptStats where jobId = @inJobId),
				0/*totSuccess_h*/,
				a.totSuccess,
				0/*totCompBytes_h*/,
				a.totCompBytes,
				0/*totUnCompBytes_h*/,
				a.totUnCompBytes,
				0/*totBytes2Xfer_h*/,
				a.totBytes2Xfer,
				a.instanceID,
				b.opType,
				b.initFrom,
				b.failureReason,
				ISNULL((SELECT login FROM UMUsers WITH (READUNCOMMITTED) WHERE id = b.userId),'Unknown') AS [UserName],
				b.combPriority,
				0/*rstType*/,
				0/*FailureErrorCode*/,
				a.totSkipped,
				a.totFailures,
				a.srcClientId,
				dbo.GetUnixTime(GetUTCDate()),
				15 /*SIM_ID_GX_CURRENT*/,
				a.rstattributes,
				a.rstTaskID,
				0.0 /*readAverageThroughput*/,
				0.0 /*writeAverageThroughput*/,
				0.0 /*networkAverageThroughput*/,
				0.0 /*sidbAverageLookups*/,
				a.destInstanceId
				FROM JMRstJobInfo a, JMJobInfo b
				WHERE a.jobid = @inJobId and a.commCellId = @inCommcellId and a.jobId = b.jobId and a.commCellId = b.commCellId
				SET @inmodifiedTime = dbo.GetUnixTime(GetUTCDate())
				INSERT INTO JMRestoreAtmptStats
				(jobId, attemptNum, phase, status, servStart, servEnd, elapsedTime, numSuccess_h, numSuccess_l,
				numFailures_h, numFailures_l, compBytes_h, compBytes_l, uncompBytes_h, uncompBytes_l, failureReason, commCellId, numSkipped, modifiedTime, totalAllocationTime,
				totalWaitTimeBeforeAllocation, readThroughput, writeThroughput, networkThroughput, sidbLookups)
				SELECT jobId, attemptNum, phaseNum, status, startTime, endTime, elapsedTime, numSuccess_h, numSuccess_l,
				numFailures_h, numFailures_l, compBytes_h, compBytes_l, uCompBytes_h, uCompBytes_l, failureReason, commcellId, numSkipped, @inmodifiedTime, totalAllocationTime,
				totalWaitTimeBeforeAllocation, 0, 0, 0, 0
				FROM JMRstAttemptInfo WITH (READUNCOMMITTED) WHERE jobId = @inJobId
			END
			ELSE IF EXISTS(SELECT *FROM JMAdminJobInfoTable where jobId = @inJobId and commcellId = @inCommcellId)
			BEGIN
				IF @inOpType = 11/*CSDRBKP*/ or @inOpType = 44 /*BROWSEANDDELETE*/ or @inOpType = 44 /*INFOMGMT*/
					EXEC ArchFileSetInvalidByJob @inJobId, @inCommcellId, 0
				Insert into JMAdminJobStatsTable
				SELECT a.jobId, b.opType, 4/*KILLED STATUS*/,
				b.jobStartTime,
				dbo.GetUnixTime(GetUTCDate()),
				a.archGrpID,
				a.archGrpName,
				a.AP_NumDays,
				a.AP_IsForecast,
				a.AP_SeqNum,
				a.AC_NewMediaFlag,
				a.ER_BkpLevel,
				a.ER_DbName,
				a.ER_Destination,
				a.ER_SendCount,
				a.ER_MediasUsed,
				a.TotalObjects,
				a.ObjectsDone,
				a.ObjectsFailed,
				b.initFrom,
				b.failureReason,
				a.archGrpCopyID,
				a.LibraryID,
				a.MI_InventoryType,
				ISNULL((SELECT login FROM UMUsers WITH (READUNCOMMITTED) WHERE id = b.userId),'Unknown') AS [UserName],
				ISNULL((select sum(ISNULL(writeTime,0))from JMAdminJobAttemptInfoTable d WITH(NOLOCK) where d.jobId = @inJobId), 0) AS WriteTime,
				a.noOfStreams,
				b.combPriority,
				a.commCellId,
				a.appID,
				0/*failureErrorCode*/,
				a.totalSize,
				ISNULL((select cast(attrVal as int) From APP_SubClientProp where componentNameId = a.appId and attrName = 'sys:full cycle num' and modified = 0),0) as fullCycleNumber,
				(case when a.uncompBytes >0 then 0/*DATA_STATUS_VALID*/
					  else 3/*DATA_STATUS_NODATA*/ end) AS DataStatus,
				a.workFlowId,
				a.embeddedObjects,
				a.uncompBytes,
				a.numFiles,
				a.skippedItems,
				0/*jobFlags*/,
				a.cloudId,
				case b.opType When 53/*OFFLINECONTENTINDEX*/ then -1 else 0 end/*SuccessIndex*/,
				case b.opType When 53/*OFFLINECONTENTINDEX*/ then -1 else 0 end/*failIndex*/,
				0/*totalBackupSize*/,
				15 /*SIM_ID_GX_CURRENT*/,
				a.fromTime,
				a.toTime,
				a.subTaskId,
				a.otherOpName,
				a.nwTransBytes
				FROM JMAdminJobInfoTable a, JMJobInfo b
				WHERE a.jobid = @inJobId and a.commCellId = @inCommcellId and a.jobId = b.jobId and a.commCellId = b.commCellId
				INSERT INTO JMAdminJobAttemptStatsTable
				SELECT jobId, attemptNum, phaseNum, status, startTime, endTime, elapsedTime, failureReason, writeTime, commcellId, embeddedObjects, uncompBytes, numFiles,
				skippedItems, TotalSize, nwTransBytes, totalAllocationTime, totalWaitTimeBeforeAllocation
				FROM JMAdminJobAttemptInfoTable WITH (READUNCOMMITTED) WHERE jobId = @inJobId
				SET @inmodifiedTime = dbo.GetUnixTime(GetUTCDate())
				-- Populate JMJobDataStats
				IF @inOpType = 11/*CSDRBKP*/ or @inOpType = 44 /*BROWSEANDDELETE*/ or @inOpType = 44 /*INFOMGMT*/
					EXEC ArchJobDataStatsCreate @inJobId, @inCommcellId, 1000 /*COMMSRVMGMT*/, 4/*FAILED STATE*/, @inmodifiedTime
			END
		END
		FETCH NEXT FROM runningJobCur	INTO @inJobId, @inCommcellId, @inOpType
	END
	close runningJobCur
	deallocate runningJobCur
	---- Step4: Delete the running jobs
	---- a) JMJobInfo
	---- b) JMJobControlInfo
	---- c) MMResourceToJob, MMResource, MMMediaReport
	UPDATE MMCopyManager SET CurrentConcurrency = 0 WHERE copyManagerId != 0
	UPDATE MMDrivePool SET ReservedDrives = 0 WHERE drivePoolId != 0
	UPDATE MMMasterPool SET ReservedDrives = 0 WHERE masterPoolId != 0
	DELETE FROM MMResourceToJob
	DELETE FROM MMResource
	DELETE FROM MMMediaExport					-- media export request
	exec sp_executesql N'DELETE FROM JMJobControlInfo'
	exec sp_executesql N'DELETE FROM JMJobInfo WHERE opType <> 90'
	exec sp_executesql N'DELETE FROM JMJobTaskLink WHERE jobId <> 0'
	COMMIT TRAN killJobTran
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        DECLARE @ErrorMessage NVARCHAR(4000);
        DECLARE @ErrorSeverity INT;
        DECLARE @ErrorState INT;
        SELECT
            @ErrorMessage = ERROR_MESSAGE(),
            @ErrorSeverity = ERROR_SEVERITY(),
            @ErrorState = ERROR_STATE();
		close runningJobCur
		deallocate runningJobCur
		Print 'Error:'+ ERROR_MESSAGE()
		ROLLBACK TRAN killJobTran
		-- Rethrow the exception.
        RAISERROR (@ErrorMessage, -- Message text.
                   @ErrorSeverity, -- Severity.
                   @ErrorState -- State.
                   );
		SET @errorCode = 1
	END CATCH
	SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'JMKillActiveJobs')
	delete from GxQscripts where name = 'JMKillActiveJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMKillActiveJobs')
	delete from GXDBVersions where aliasname = 'JMKillActiveJobs'
GO

insert into GXDBVersions values(2, 'JMKillActiveJobs',  '00010014000200070000', 'JMKillActiveJobs', '00010014000200070000')
GO

