

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMJobUpdateInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMJobUpdateInfo.sp,v $ $Id: JMJobUpdateInfo.sp,v 1.1.2.3 2017/02/10 21:48:12 sjohnson Exp $";
---- =============================================
---- Author:		Divakar Radhakrishnan
---- Create date:	10/05/2016
---- Description:	Update Job Information
---- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMJobUpdateInfo <<<'

IF EXISTS (select * from sysobjects where name='JMJobUpdateInfo')
	drop procedure JMJobUpdateInfo
IF EXISTS (select * from GxQscripts where name='JMJobUpdateInfo')
	delete from GxQscripts where name = 'JMJobUpdateInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMJobUpdateInfo')
	delete from GXDBVersions where aliasname = 'JMJobUpdateInfo'
GO
print '... Creating Procedure: JMJobUpdateInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMJobUpdateInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inXML XML
AS
BEGIN
  DECLARE @xmlText XML 
SET NOCOUNT ON
DECLARE @inJobID BIGINT
DECLARE @commCellID INTEGER
DECLARE @inOpType	   INT
DECLARE @noOfFilesStubbed BIGINT
DECLARE @userName NVARCHAR(1024)
DECLARE @userId INTEGER
DECLARE @errorCode INTEGER = 0
DECLARE @errorMsg NVARCHAR(1024) = ''
DECLARE @reset INTEGER = 0
SET @inJobID = ISNULL (( SELECT ref.value('@jobId', 'BIGINT')FROM @inXMl.nodes('JobManager_JobUpdateInfoReq') R(ref)), 0)
SET @commCellID = ISNULL (( SELECT ref.value('@commCellID', 'INTEGER')FROM @inXMl.nodes('JobManager_JobUpdateInfoReq') R(ref)), 2)
SET @noOfFilesStubbed = ISNULL ((SELECT ref.value('@noOfStubFiles', 'BIGINT')FROM @inXMl.nodes('JobManager_JobUpdateInfoReq/stubInfo') R(ref)), 0)
SET @reset = ISNULL ((SELECT ref.value('@reset', 'BIGINT')FROM @inXMl.nodes('JobManager_JobUpdateInfoReq/stubInfo') R(ref)), 0)
SET @userId = ISNULL ((SELECT ref.value('@userId', 'INTEGER')FROM @inXMl.nodes('JobManager_JobUpdateInfoReq/thirdPartyJobInfo/user') R(ref)), 0)
SET @userName = ISNULL ((SELECT ref.value('@userName', 'NVARCHAR(1024)')FROM @inXMl.nodes('JobManager_JobUpdateInfoReq/thirdPartyJobInfo/user') R(ref)), '')
BEGIN TRY
DECLARE @attrid INTEGER  = 60
	DECLARE @attrName NVARCHAR(128) = 'Stub files count'
	DECLARE @opType INTEGER = (SELECT opType FROM JMJobInfo WHERE jobId = @inJobID)
	--This has to be running job
	IF EXISTS (SELECT 1 FROM JMJobInfo WHERE jobId = @inJobID)
	BEGIN
		--Update stub information
		IF @noOfFilesStubbed > 0 AND @inJobID > 0
		BEGIN
SET @attrid = 60
			SET @attrName = 'Stub files count'
			MERGE  JMJobOptions as jobOptions
			USING (SELECT @inJobID as inJobID,@commCellID as commCellID ,@attrid as attrid,@attrName as attributeName) as src
			ON jobOptions.commCellId = src.commCellID AND jobOptions.jobId = src.inJobID AND jobOptions.attributeId = src.attrid AND jobOptions.attributeName = src.attributeName
			WHEN MATCHED THEN UPDATE SET attributeValueInt = (CASE WHEN @reset = 1 THEN @noOfFilesStubbed ELSE attributeValueInt + @noOfFilesStubbed END)
			WHEN NOT MATCHED THEN
				INSERT(jobId,commCellId,attributeId,attributeName,attributeValueInt,attributeValue)
				VALUES(@inJobID,@commCellID,@attrid,@attrName,@noOfFilesStubbed,'');
		END
		--Update username for 3rd party jobs
		IF (@userId> 0 OR LEN(@userName) > 0) AND @inJobID > 0 AND @opType IN (18,65)
		BEGIN
SET @attrid = 61
			SET @attrName = 'Job overriden Username'
			MERGE  JMJobOptions as jobOptions
			USING (SELECT @inJobID as inJobID,@commCellID as commCellID ,@attrid as attrid,@attrName as attributeName) as src
			ON jobOptions.commCellId = src.commCellID AND jobOptions.jobId = src.inJobID AND jobOptions.attributeId = src.attrid AND jobOptions.attributeName = src.attributeName
			WHEN MATCHED THEN UPDATE SET attributeValue = @userName
			WHEN NOT MATCHED THEN
				INSERT(jobId,commCellId,attributeId,attributeName,attributeValueInt,attributeValue)
				VALUES(@inJobID,@commCellID,@attrid,@attrName,0,@userName);
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = @@ERROR
	SET @errorMsg = ERROR_MESSAGE()
END CATCH
SET @xmlText = (SELECT @inJobID as '@jobId' , (SELECT @errorCode AS '@errorCode', @errorMsg as '@errLogMessage' FOR XML PATH('error'),TYPE)
				FOR XML PATH('JobManager_JobUpdateInfoResp'))
IF @xmlText IS NULL
	SET @xmlText = '<JobManager_JobUpdateInfoResp/>'
SELECT @xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMJobUpdateInfo')
	delete from GxQscripts where name = 'JMJobUpdateInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMJobUpdateInfo')
	delete from GXDBVersions where aliasname = 'JMJobUpdateInfo'
GO

insert into GXDBVersions values(2, 'JMJobUpdateInfo',  '00010001000200030000', 'JMJobUpdateInfo', '00010001000200030000')
GO

