

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMJobMMStatePopulate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMJobMMStatePopulate.sp,v $ $Id: JMJobMMStatePopulate.sp,v 1.3.12.1 2017/09/19 21:16:38 dkraplanee Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   CNJobMMStatePopulate   - Add properties for the APP_SubClientProp table
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMJobMMStatePopulate <<<'

IF EXISTS (select * from sysobjects where name='JMJobMMStatePopulate')
	drop procedure JMJobMMStatePopulate
IF EXISTS (select * from GxQscripts where name='JMJobMMStatePopulate')
	delete from GxQscripts where name = 'JMJobMMStatePopulate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMJobMMStatePopulate')
	delete from GXDBVersions where aliasname = 'JMJobMMStatePopulate'
GO
print '... Creating Procedure: JMJobMMStatePopulate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMJobMMStatePopulate
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
AS
  DECLARE @ErrVal INT
  DECLARE @ErrString VARCHAR(1024)
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--DECLARE @ERRVAL INT
--DECLARE @ErrString VARCHAR(1024)
DECLARE	@RunIfQNetAgentRegistered	INT = 0
DECLARE @transferringJobsList   varchar(max)
DECLARE @pendingJobsList        varchar(max)
DECLARE @waitingJobsList        varchar(max)
DECLARE @suspendedJobsList      varchar(max)
SET @transferringJobsList   = ''
SET @pendingJobsList        = ''
SET @waitingJobsList        = ''
SET @suspendedJobsList      = ''
SET NOCOUNT ON
SET	@ERRVAL = 0
SET	@ErrString = ' '
SET @RunIfQNetAgentRegistered = 0
SET @RunIfQNetAgentRegistered = ISNULL(
				(SELECT CAST(CAST(ISNULL(value,'') as varchar(10)) AS INT)
				 FROM GXGlobalParam
				 WHERE name = 'GatherJobMAStateInfoForCommNet'), 0)
DECLARE	@CurrentTime DateTime
SET	@CurrentTime = GetUTCDate()
-- -----------------------------------------------------------------------
--  Check for the conditions and do the insert
-- -----------------------------------------------------------------------
IF (@RunIfQNetAgentRegistered = 0)
BEGIN
	-- begin transaction
	DECLARE	@DataTransferring integer
	DECLARE	@StreamsTransferring integer
	SELECT @DataTransferring = COUNT(DISTINCT M.JobId_l), @StreamsTransferring = COUNT(*) FROM MMResourceToJob M WITH(NOLOCK), JMJobInfo J  WITH(NOLOCK)
					WHERE M.JobID_l = J.JobID AND LogicalReleased = 0
						AND J.State IN (1, 6, 7, 8, 13, 17, 18)
    SELECT  @transferringJobsList = @transferringJobsList + CAST( T.TransferringJobId as varchar(24)) + ','
    FROM
    (   SELECT DISTINCT M.JobId_l AS TransferringJobId
        FROM    MMResourceToJob M WITH(NOLOCK), JMJobInfo J WITH(NOLOCK)
        WHERE   M.JobID_l = J.JobID AND LogicalReleased = 0
                AND J.State IN (1, 6, 7, 8, 13, 17, 18)
    ) T
	DECLARE	@StreamsWaiting integer
	SET	@StreamsWaiting = (SELECT ISNULL(SUM( CASE WHEN J.State IN (1, 6, 7, 8, 13, 17, 18) AND resourcesAllocated = 1 THEN (noOfStreams - noOfStreamsAllocated)
							   WHEN J.State IN (3) AND resourcesAllocated = 0 THEN noOfStreams
							   ELSE 0
							   END ), 0)
							FROM JMJobInfo J WITH(NOLOCK), JMAdminJobInfoTable AJ WITH(NOLOCK)
							WHERE J.JobID = AJ.JobID
								  AND noOfStreams <> -1)
	SET	@StreamsWaiting = @StreamsWaiting + (SELECT ISNULL(SUM( CASE WHEN J.State IN (1, 6, 7, 8, 13, 17, 18) AND resourcesAllocated = 1 THEN (numStreams - numStreamsAllocated)
							   WHEN J.State IN (3) AND resourcesAllocated = 0 THEN numStreams
							   ELSE 0
							   END ), 0)
							FROM JMJobInfo J WITH(NOLOCK), JMBkpJobInfo BJ WITH(NOLOCK)
							WHERE J.JobID = BJ.JobID
								  AND numStreams <> -1)
	DECLARE	@JobActivityLevel integer
	SET	@JobActivityLevel = (SELECT COUNT(*) FROM JMJobInfo WITH(NOLOCK) LEFT OUTER JOIN MMResourceToJob WITH(NOLOCK)
					ON MMResourceToJob.JobId_l = JMJobInfo.jobId
					WHERE JMJobInfo.state IN (1,6,7,8,13,17,18))
    SELECT  @pendingJobsList =  @pendingJobsList + CAST(jobId as varchar(24)) + ','
    FROM	JMJobInfo WITH(NOLOCK)
    WHERE   [State] IN (2, 15, 16)
    SELECT  @waitingJobsList =  @waitingJobsList + CAST(jobId as varchar(24)) + ','
    FROM	JMJobInfo WITH(NOLOCK)
    WHERE   [State] = 3
    SELECT  @suspendedJobsList =  @suspendedJobsList + CAST(jobId as varchar(24)) + ','
    FROM	JMJobInfo WITH(NOLOCK)
    WHERE   [State] IN (5, 14)
	-- commit transaction
	INSERT INTO JMJobStateHistory
	SELECT	ISNULL(SUM( CASE WHEN (State IN (1, 6, 7, 8, 13, 17, 18)) then 1 ELSE 0 END), 0) AS 'Running',
			ISNULL(SUM( CASE WHEN (State IN (2, 15, 16)) then 1 ELSE 0 END), 0) AS 'Pending',
			ISNULL(SUM( CASE WHEN (State = 3) then 1 ELSE 0 END), 0) AS 'Waiting',
			ISNULL(SUM( CASE WHEN (State IN (5, 14)) then 1 ELSE 0 END), 0) AS 'Suspended',
			DataTransferring = ISNULL(@DataTransferring, 0),
			StreamsTransferring = ISNULL(@StreamsTransferring, 0),
			StreamsWaiting = ISNULL(@StreamsWaiting, 0),
			JobActivityLevel = ISNULL(@JobActivityLevel, 0),
			JMJobActivityLevelLowWaterMark = ISNULL((SELECT CONVERT(integer, CONVERT(nvarchar(10), value)) FROM GXGlobalParam WHERE name = 'JMJobActivityLevelLowWaterMark'), 0),
			JMJobActivityLevelHighWaterMark = ISNULL((SELECT CONVERT(integer, CONVERT(nvarchar(10), value)) FROM GXGlobalParam WHERE name = 'JMJobActivityLevelHighWaterMark'), 0),
			@CurrentTime,
            @transferringJobsList, @pendingJobsList, @waitingJobsList, @suspendedJobsList
	FROM	JMJobInfo WITH(NOLOCK)
	SET @ERRVAL = @@ERROR
	IF (@ERRVAL <> 0)
	BEGIN
		SET @ERRSTRING = 'Failed to INSERT job state information into JMJobStateHistory table'
		GOTO ERROR_EXIT
	END
	INSERT INTO JMMAPipeLineHistory
	SELECT	R.ClientID, COUNT(*) AS 'PipeLineCount', @CurrentTime
	FROM	MMResource R WITH(NOLOCK), MMResourceToJob RJ WITH(NOLOCK)
	WHERE	R.ReservationId = RJ.ReservationId
--			AND (MMResourceToJob & 1) = 1
	GROUP BY	R.ClientID
	SET @ERRVAL = @@ERROR
	IF (@ERRVAL <> 0)
	BEGIN
		SET @ERRSTRING = 'Failed to INSERT pipeline information into JMMAPipeLineHistory table'
		GOTO ERROR_EXIT
	END
END
-- -----------------------------------------------------------------------
--  EXIT
-- -----------------------------------------------------------------------
ERROR_EXIT:
-- -----------------------------------------------------------------------
--  RETURN
-- -----------------------------------------------------------------------
SELECT  @ERRVAL, @ERRSTRING
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'JMJobMMStatePopulate')
	delete from GxQscripts where name = 'JMJobMMStatePopulate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMJobMMStatePopulate')
	delete from GXDBVersions where aliasname = 'JMJobMMStatePopulate'
GO

insert into GXDBVersions values(2, 'JMJobMMStatePopulate',  '00010003001200010000', 'JMJobMMStatePopulate', '00010003001200010000')
GO

