

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMIsDRIncrPossible.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMIsDRIncrPossible.sp,v $ $Id: JMIsDRIncrPossible.sp,v 1.4.34.1 2018/03/22 03:13:09 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: JMIsDRIncrPossible
--  |
--  | Description:
--  |
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMIsDRIncrPossible <<<'

IF EXISTS (select * from sysobjects where name='JMIsDRIncrPossible')
	drop procedure JMIsDRIncrPossible
IF EXISTS (select * from GxQscripts where name='JMIsDRIncrPossible')
	delete from GxQscripts where name = 'JMIsDRIncrPossible'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMIsDRIncrPossible')
	delete from GXDBVersions where aliasname = 'JMIsDRIncrPossible'
GO
print '... Creating Procedure: JMIsDRIncrPossible'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMIsDRIncrPossible
  @jobId INTEGER
AS
BEGIN
  DECLARE @o_xml XML
	DECLARE @databases TABLE(name nvarchar(256), lastBkpType char, lastBkpSetName nvarchar(256), lastRecoveryModel nvarchar(256), recoveryModel nvarchar(256), errorCode int)
	DECLARE @o_errorCode INT = 0
	INSERT INTO @databases(name) VALUES(N'CommServ')
	UPDATE t
	SET
	t.lastBkpType = B.type,
	t.lastBkpSetName = B.name,
	t.lastRecoveryModel = B.recovery_model
	FROM @databases t
	CROSS APPLY (
		SELECT top 1 database_name, type, name, recovery_model
		FROM msdb..backupset
		WHERE database_name = t.name AND is_copy_only = 0
		ORDER BY backup_finish_date DESC) B
	UPDATE t
	SET t.recoveryModel = S.recovery_model_desc
	FROM @databases t,
	sys.databases S
	WHERE t.name = S.name
	IF Exists(select *from @databases t Where t.lastBkpSetName IS NULL OR t.lastBkpSetName != 'COMMSERV_DR')
	BEGIN
	 SET @o_errorCode = 1
	 UPDATE @databases
	 SET errorCode = @o_errorCode
	 WHERE lastBkpSetName IS NULL OR lastBkpSetName != 'COMMSERV_DR'
	END
	ELSE IF Exists(select *from @databases t Where t.recoveryModel In(N'SIMPLE', N'BULK-LOGGED'))
	BEGIN
	 SET @o_errorCode = 2
	 UPDATE @databases
	 SET errorCode = @o_errorCode
	 WHERE recoveryModel In(N'SIMPLE', N'BULK-LOGGED')
	END
	ELSE IF EXISTS( select *from @databases t Where t.lastRecoveryModel = N'SIMPLE' AND t.lastRecoveryModel != t.recoveryModel)
	BEGIN
	 SET @o_errorCode = 3
	 UPDATE @databases
	 SET errorCode = @o_errorCode
	 WHERE lastRecoveryModel = N'SIMPLE' AND lastRecoveryModel != recoveryModel
	END
	ELSE IF EXISTS( select * from @databases t where t.lastBkpType = 'I')
	BEGIN
		SET @o_errorCode = 4
		UPDATE @databases
		SET errorCode = @o_errorCode
		WHERE lastBkpType = 'I'
	END
	SET @o_xml =
	(SELECT
			t.name as '@name',
			t.lastBkpSetName as '@backupSetName',
			t.recoveryModel as '@recoveryMode',
			t.lastRecoveryModel as '@lastRecoveryMode',
			t.errorCode as '@errorCode'
			FROM @databases t
			WHERE t.errorCode ! =0
			FOR XML PATH('database'), ROOT('JobManager_DiasterRecoverDbs'))
	IF @o_xml IS NULL
		SET @o_xml = '<JobManager_DiasterRecoverDbs/>'
	SELECT @o_xml
	END
GO

IF EXISTS (select * from GxQscripts where name = 'JMIsDRIncrPossible')
	delete from GxQscripts where name = 'JMIsDRIncrPossible'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMIsDRIncrPossible')
	delete from GXDBVersions where aliasname = 'JMIsDRIncrPossible'
GO

insert into GXDBVersions values(2, 'JMIsDRIncrPossible',  '00010004003400010000', 'JMIsDRIncrPossible', '00010004003400010000')
GO

