

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMIsClientOnPOCMode.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  JMIsClientOnPOCMode()
--  |
--  | Description:  Select 1 when to run in POC Mode and 0 when not
--  |
--  |       Input:  clientID
--  |
--  |      Output:  1 or 0
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------------------	        --------------------------------
--  |   1.1        Jawahar Ragunathan           Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMIsClientOnPOCMode')
BEGIN
	print '>>> Drop Stored Procedure: JMIsClientOnPOCMode <<<'
	drop procedure JMIsClientOnPOCMode
END
IF EXISTS (select * from GxQscripts where name='JMIsClientOnPOCMode')
	delete from GxQscripts where name = 'JMIsClientOnPOCMode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMIsClientOnPOCMode')
	delete from GXDBVersions where aliasname = 'JMIsClientOnPOCMode'
GO
print '... Creating Procedure: JMIsClientOnPOCMode'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMIsClientOnPOCMode
  @i_clientID INT
AS
  DECLARE @isPOCMode INTEGER
SET NOCOUNT ON
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @firstTurboJobEndTime INTEGER;
	SET @firstTurboJobEndTime = (SELECT ISNULL(MIN(created),0) FROM APP_SubClientProp SCP WITH(NOLOCK) INNER JOIN APP_Application APP WITH(NOLOCK) ON APP.clientId = @i_clientID AND SCP.componentNameId=APP.id AND SCP.modified = 0 AND SCP.cs_attrName = CHECKSUM(N'First Turbo Job Id'))
	IF ((@firstTurboJobEndTime = 0) OR (@firstTurboJobEndTime > (dbo.GetUnixTime(GETUTCDATE()) - 7 * 24 * 3600)))
		SELECT 1
	ELSE
		SELECT 0
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMIsClientOnPOCMode')
	delete from GxQscripts where name = 'JMIsClientOnPOCMode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMIsClientOnPOCMode')
	delete from GXDBVersions where aliasname = 'JMIsClientOnPOCMode'
GO

insert into GXDBVersions values(2, 'JMIsClientOnPOCMode',  '00000000000000000000', 'JMIsClientOnPOCMode', '00000000000000000000')
GO

