

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMInvalidateArchFilesForIncompleteVmPseudoJobs.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  JMInvalidateArchFilesForIncompleteVmPseudoJobs()
--  |				 Description:  Invalidate arch files for incomplete vm pseudo jobs
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMInvalidateArchFilesForIncompleteVmPseudoJobs.sp,v $ $Id: JMInvalidateArchFilesForIncompleteVmPseudoJobs.sp,v 1.1.2.7 2020/11/16 21:50:38 bzhu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMInvalidateArchFilesForIncompleteVmPseudoJobs')
BEGIN
	print '>>> Drop Stored Procedure: JMInvalidateArchFilesForIncompleteVmPseudoJobs <<<'
	drop procedure JMInvalidateArchFilesForIncompleteVmPseudoJobs
END
IF EXISTS (select * from GxQscripts where name='JMInvalidateArchFilesForIncompleteVmPseudoJobs')
	delete from GxQscripts where name = 'JMInvalidateArchFilesForIncompleteVmPseudoJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMInvalidateArchFilesForIncompleteVmPseudoJobs')
	delete from GXDBVersions where aliasname = 'JMInvalidateArchFilesForIncompleteVmPseudoJobs'
GO
print '... Creating Procedure: JMInvalidateArchFilesForIncompleteVmPseudoJobs'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMInvalidateArchFilesForIncompleteVmPseudoJobs
  @i_jobId integer,
  @i_commcellId integer,
  @i_isIndexingV2 integer,
  @i_dbgPrint integer = 0
AS
  DECLARE @jobId INTEGER
SET NOCOUNT ON
DECLARE @errorCode INTEGER
SET @errorCode = 0
IF @i_isIndexingV2 = 1
BEGIN
	BEGIN TRY
		IF OBJECT_ID('tempdb.dbo.#vmPseudoJobs') IS NOT NULL
			DROP TABLE #vmPseudoJobs
		CREATE TABLE #vmPseudoJobs (JobId INT, CommCellId INT)
		CREATE CLUSTERED INDEX vmPseudoJobs_jobId_Idx on #vmPseudoJobs(JobId)
		INSERT INTO #vmPseudoJobs
		(JobId, CommCellId)
        SELECT JBJI.jobId, JBJI.commcellId FROM JMBkpJobInfo JBJI (NOLOCK)
            INNER JOIN JMJobDataLink JJDL (NOLOCK) ON  JBJI.jobId = JJDL.childJobId AND JBJI.commcellId = JJDL.commCellId
            INNER JOIN APP_Application APP (NOLOCK) ON JBJI.applicationId = APP.id
            INNER JOIN APP_VMProp VMP (NOLOCK) ON VMP.jobid = JJDL.parentJobId AND VMP.commCellId = JJDL.commCellId AND VMP.vmclientid = APP.clientId AND VMP. attrName = 'vmStatus'
            WHERE  JJDL.linkType = 7 -- LINK_TYPE_FOR_VSA_V2_PARENT_CHILD
                AND JJDL.parentJobId = @i_jobId
                AND JBJI.commcellId = @i_commcellId
                AND VMP.attrVal not in (N'0', N'3')  -- 0 - COMPLETED, 3 - PARTIAL_SUCCESS
		DECLARE @tranCnt INT = @@TRANCOUNT
		IF (@tranCnt > 0)
		BEGIN
			SAVE TRAN JMInvalidateArchFiles_Tran
		END
		ELSE
		BEGIN
			BEGIN TRAN JMInvalidateArchFiles_Tran
		END
		-- for VSA snap parent job, needs to invalidate arch files for incomplete vm Pesudo Jobs
		DECLARE incompleteVmPseudoJobsCur CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR SELECT JobId, CommCellId FROM #vmPseudoJobs
		OPEN incompleteVmPseudoJobsCur
		DECLARE @vmJobId		integer
		DECLARE @commCellId		integer
		FETCH NEXT FROM incompleteVmPseudoJobsCur	INTO @vmJobId, @commCellId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			EXEC @errorCode = ArchFileSetInvalidByJobNewSP @vmJobId, @commCellId, 0
			IF @errorCode <> 0
				PRINT 'EXEC ArchFileSetInvalidByJob : vmJobId = ' + CONVERT(NVARCHAR(MAX), @vmJobId)  + ', commCellId = ' + CONVERT(NVARCHAR(MAX),@commCellId) + ' failed with error : ' + CONVERT(NVARCHAR(MAX),@errorCode)
			ELSE if (@i_dbgPrint = 1)
				PRINT 'EXEC ArchFileSetInvalidByJob : vmJobId = ' + CONVERT(NVARCHAR(MAX), @vmJobId)  + ', commCellId = ' + CONVERT(NVARCHAR(MAX),@commCellId) + ' successfully.'
			-- reset bytes counter for VM job
			UPDATE JMBkpJobInfo SET compBytes = 0, unCompBytes = 0 WHERE jobId = @vmJobId AND commcellId = @commCellId
			FETCH NEXT FROM incompleteVmPseudoJobsCur INTO @vmJobId, @commCellId
		END
		CLOSE incompleteVmPseudoJobsCur
		DEALLOCATE incompleteVmPseudoJobsCur
		IF (@tranCnt = 0)
		BEGIN
			COMMIT TRAN JMInvalidateArchFiles_Tran
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		--Close cursor
		IF ( CURSOR_STATUS('local', 'incompleteVmPseudoJobsCur') >= 0 )
			CLOSE incompleteVmPseudoJobsCur
		IF ( CURSOR_STATUS('local','incompleteVmPseudoJobsCur') = -1 )
			DEALLOCATE incompleteVmPseudoJobsCur
		IF XACT_STATE() <> 0
		BEGIN
			ROLLBACK TRAN JMInvalidateArchFiles_Tran
		END
	END CATCH;
		SELECT JobId FROM #vmPseudoJobs
		IF OBJECT_ID('tempdb.dbo.#vmPseudoJobs') IS NOT NULL
			DROP TABLE #vmPseudoJobs
END
ELSE
BEGIN
	IF OBJECT_ID('tempdb.dbo.#vmGuids') IS NOT NULL
		DROP TABLE #vmGuids
CREATE TABLE #vmGuids (vmGuid nvarchar(40))
	CREATE CLUSTERED INDEX vmGuids_vmGuid_Idx on #vmGuids(vmGuid)
	INSERT INTO #vmGuids
	(vmGuid)
	SELECT attrVal FROM APP_VMProp VMP
		INNER JOIN JMQinetixUpdateStatus JMQUS ON JMQUS.jobId =  VMP.jobId AND JMQUS.commCellId = VMP.commCellId AND JMQUS.clientId = VMP.VMclientId
		WHERE  VMP.jobId = @i_jobId
			AND VMP.commcellId = @i_commcellId
			AND JMQUS.status not in (0, 3)  -- 0 - COMPLETED, 3 - PARTIAL_SUCCESS
AND VMP.attrName = 'vmGUID'
	DECLARE @afIdList VARCHAR(MAX)
	SELECT @afIdList = coalesce(@afIdList + ',', '') +  convert(varchar(12), id)  FROM archFile WHERE jobId = @i_jobId AND commCellId = @i_commcellId
		AND name in (SELECT vmGuid FROM #vmGuids)
	-- only call when there is valid entries, otherwise all arch file will be marked as invalid for this job
	IF @afIdList IS NOT NULL AND @afIdList <> ''
	BEGIN
		EXEC @errorCode = ArchFileSetInvalidByJobNewSP @i_jobId, @i_commcellId, 0, 0, '', @afIdList
		IF @errorCode <> 0
			PRINT 'EXEC ArchFileSetInvalidByJob : i_jobId = ' + CONVERT(NVARCHAR(MAX), @i_jobId)  + ', commCellId = ' + CONVERT(NVARCHAR(MAX),@commCellId) + ' failed with error : ' + CONVERT(NVARCHAR(MAX),@errorCode)
		ELSE if (@i_dbgPrint = 1)
			PRINT 'EXEC ArchFileSetInvalidByJob : i_jobId = ' + CONVERT(NVARCHAR(MAX), @i_jobId)  + ', commCellId = ' + CONVERT(NVARCHAR(MAX),@commCellId) + ' successfully.'
	END
	IF OBJECT_ID('tempdb.dbo.#vmGuids') IS NOT NULL
		DROP TABLE #vmGuids
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMInvalidateArchFilesForIncompleteVmPseudoJobs')
	delete from GxQscripts where name = 'JMInvalidateArchFilesForIncompleteVmPseudoJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMInvalidateArchFilesForIncompleteVmPseudoJobs')
	delete from GXDBVersions where aliasname = 'JMInvalidateArchFilesForIncompleteVmPseudoJobs'
GO

insert into GXDBVersions values(2, 'JMInvalidateArchFilesForIncompleteVmPseudoJobs',  '00010001000200070000', 'JMInvalidateArchFilesForIncompleteVmPseudoJobs', '00010001000200070000')
GO

