

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetVmListWithBackupJobSkipped.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  JMGetVmListWithBackupJobSkipped()
--  |				 Description:  Get VM List which had job being skipped becuae previous scheduled job ran longer than schedule interval
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetVmListWithBackupJobSkipped.sp,v $ $Id: JMGetVmListWithBackupJobSkipped.sp,v 1.1.2.1 2020/08/20 22:43:12 bzhu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetVmListWithBackupJobSkipped')
BEGIN
	print '>>> Drop Stored Procedure: JMGetVmListWithBackupJobSkipped <<<'
	drop procedure JMGetVmListWithBackupJobSkipped
END
IF EXISTS (select * from GxQscripts where name='JMGetVmListWithBackupJobSkipped')
	delete from GxQscripts where name = 'JMGetVmListWithBackupJobSkipped'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetVmListWithBackupJobSkipped')
	delete from GXDBVersions where aliasname = 'JMGetVmListWithBackupJobSkipped'
GO
print '... Creating Procedure: JMGetVmListWithBackupJobSkipped'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetVmListWithBackupJobSkipped
  @i_jobId integer,
  @i_commcellId integer,
  @i_appId integer
AS
  DECLARE @vmClientId integer
  DECLARE @vmGUID varchar(255)
  DECLARE @bkpLevel integer
	DECLARE @backupStartTime INT = 0
	SELECT @backupStartTime = ISNULL(jobStartTime, 0)
	FROM JMJobInfo(NOLOCK)
	WHERE jobId = @i_jobId And commCellId = @i_commcellId
	IF @backupStartTime = 0
	BEGIN
		SELECT @backupStartTime = servStartDate
		FROM JMBkpStats WHERE jobId = @i_jobId AND commcellId = @i_commcellId
	END
	IF OBJECT_ID('tempdb.dbo.#VsaJobList') IS NOT NULL
	DROP TABLE #VsaJobList
	CREATE TABLE #VsaJobList (jobId integer, commcellId	integer, bkpLevel integer)
	CREATE CLUSTERED INDEX VsaJobList_jobId_commcellId_idx ON #VsaJobList (jobId, commcellId)
	-- get VSA job list
	INSERT INTO #VsaJobList
	SELECT jobId, commcellId, bkpLevel FROM JMBkpStats WITH(NOLOCK)
	WHERE appId = @i_AppId AND commCellId = @i_commcellId AND servStartDate > @backupStartTime AND opType  <> 14 -- synthetic full
	UNION ALL
	SELECT bkpJobInfo.jobId, bkpJobInfo.commcellId, bkpJobInfo.bkpLevel FROM JMBkpJobInfo bkpJobInfo  WITH(NOLOCK)
	INNER JOIN JMJobInfo jobInfo WITH(NOLOCK) ON jobInfo.jobId = bkpJobInfo.jobId
		AND jobInfo.commCellId = bkpJobInfo.commcellId
	WHERE bkpJobInfo.applicationId = @i_AppId
		AND bkpJobInfo.commCellId = @i_commcellId
		AND jobInfo.jobStartTime > @backupStartTime
		AND jobInfo.opType  <> 14 -- synthetic full
	-- return any VM has been skiped becuase of current job
	SELECT DISTINCT JQS.clientId, CP.attrVal as GUID, L.bkpLevel FROM JMQinetixUpdateStatus JQS  WITH(NOLOCK)
	INNER JOIN #VsaJobList L ON JQS.jobId = L.jobId AND JQS.commCellId = L.commCellId
	INNER JOIN App_ClientProp CP  WITH(NOLOCK) ON CP.componentNameId = JQS.clientId
	WHERE CP.attrName = 'Virtual Machine Instance UUID'
		AND NOT EXISTS(SELECT status FROM JMQinetixUpdateStatus JQS1  WITH(NOLOCK)
			INNER JOIN #VsaJobList L1 ON JQS1.jobId = L1.jobId AND JQS1.commCellId = L1.commCellId
			WHERE JQS1.clientId = JQS.clientId AND JQS1.status <> 10) -- SKIPPED
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'JMGetVmListWithBackupJobSkipped')
	delete from GxQscripts where name = 'JMGetVmListWithBackupJobSkipped'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetVmListWithBackupJobSkipped')
	delete from GXDBVersions where aliasname = 'JMGetVmListWithBackupJobSkipped'
GO

insert into GXDBVersions values(2, 'JMGetVmListWithBackupJobSkipped',  '00010001000200010000', 'JMGetVmListWithBackupJobSkipped', '00010001000200010000')
GO

