

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetVmListForVsaDataCopyJobV2.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  JMGetVmListForVsaDataCopyJobV2()
--  |				 Description:  Get VM List for Data Copy Job
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetVmListForVsaDataCopyJobV2.sp,v $ $Id: JMGetVmListForVsaDataCopyJobV2.sp,v 1.1.2.7 2020/10/04 00:31:24 bzhu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetVmListForVsaDataCopyJobV2')
BEGIN
	print '>>> Drop Stored Procedure: JMGetVmListForVsaDataCopyJobV2 <<<'
	drop procedure JMGetVmListForVsaDataCopyJobV2
END
IF EXISTS (select * from GxQscripts where name='JMGetVmListForVsaDataCopyJobV2')
	delete from GxQscripts where name = 'JMGetVmListForVsaDataCopyJobV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetVmListForVsaDataCopyJobV2')
	delete from GXDBVersions where aliasname = 'JMGetVmListForVsaDataCopyJobV2'
GO
print '... Creating Procedure: JMGetVmListForVsaDataCopyJobV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetVmListForVsaDataCopyJobV2
  @i_wfJobId integer,
  @i_parentJobIdToBeTapeBackedUp integer,
  @i_commcellId integer
AS
  DECLARE @jobId integer
  DECLARE @targetClientId integer
  DECLARE @appId integer
  DECLARE @GUID varchar(255)
  DECLARE @archFileId integer
  DECLARE @AppGuid varchar(255)
  DECLARE @BackupSetGuid varchar(255)
  DECLARE @VmName varchar(255)
  DECLARE @EsxHostName varchar(255)
	IF OBJECT_ID('tempdb.dbo.#TblVmList') IS NOT NULL
   	DROP TABLE #TblVmList
CREATE TABLE #TblVmList (jobId integer, targetClientId integer, appId integer, vmGUID varchar(255), archFileId integer, AppGuid varchar(255), BackupSetGuid varchar(255), VmName varchar(255), parentAppId integer, EsxHostName varchar(255))
	CREATE CLUSTERED INDEX TblVmList_parentAppId_idx ON #TblVmList (parentAppId)
	INSERT INTO #TblVmList
	SELECT JMS.jobId, JMS.targetClientId, JMS.appId, VMP.attrVal as GUID , AF.id as archFileId, APP.GUID as AppGuid, BS.GUID as BackupSetGuid, CL.name as VmName, JDL.parentAppid, NULL
	FROM JMBkpStats JMS WITH(NOLOCK)
	INNER JOIN App_Client CL WITH(NOLOCK) ON JMS.targetClientId = CL.id
	INNER JOIN App_application APP WITH(NOLOCK) ON APP.clientId = CL.id
	INNER JOIN  APP_BackupSetName BS WITH(NOLOCK) ON APP.backupSet = BS.id
	INNER JOIN archFile AF WITH(NOLOCK) ON AF.commCellId = @i_commcellId AND AF.fileType = 1 AND JMS.jobId = AF.jobId
	INNER JOIN JMJobDataLink JDL WITH(NOLOCK) ON JMS.jobId = JDL.childJobId AND JMS.commcellId = JDL.commCellId AND JDL.parentJobId = @i_parentJobIdToBeTapeBackedUp AND JDL.linkType = 7   -- LINK_TYPE_FOR_VSA_V2_PARENT_CHILD
	INNER JOIN  JMJobWF WF WITH(NOLOCK) ON WF.jobid = @i_wfJobId AND JMS.jobId = WF.processedJobId AND JMS.commcellId = WF.commCellId AND APP.id = WF.applicationId
	-- change to return vmGUID from App_VMProp table as VM GUID could change if original VM got deleted and new VM with same name merged with the deleted VM
	-- to backup copy the old snap backup, we want to return back the old vmGUID in app_VMProp table
	LEFT JOIN APP_VMProp VMP WITH(NOLOCK) ON VMP.jobId = @i_parentJobIdToBeTapeBackedUp AND VMP.commCellId = @i_commcellId AND VMP.attrName = 'vmGUID' AND VMP.VMclientId = JMS.targetClientId
	WHERE JMS.commCellId = @i_commcellId
	-- fall back for GUID if vmGUID not in App_VMProp
	UPDATE #TblVmList
	SET vmGUID = App_ClientProp.attrVal
	FROM #TblVmList tblVMList WITH(NOLOCK), App_ClientProp WITH(NOLOCK)
	WHERE App_ClientProp.componentNameId = tblVMList.targetClientId
		AND App_ClientProp.attrName = 'Virtual Machine Instance UUID'
		AND App_ClientProp.modified = 0
		AND vmGUID is NULL
	-- try to update esx host name from parent subclient App_SubClientProp first - 'Virtual Server ESX Host name'
	UPDATE #TblVmList
	SET EsxHostName = appProp.attrVal
	FROM #TblVmList tblVMList WITH(NOLOCK), App_application app WITH(NOLOCK), App_SubClientProp appProp WITH(NOLOCK)
	WHERE app.id = tblVMList.parentAppId
		AND appProp.componentNameId = app.id
		AND appProp.attrName = 'Virtual Server ESX Host name'
		AND EsxHostName is NULL
	-- if esx host name not set yet, try to update esx host name from parent instance APP_InstanceProp - 'Snap Mount Proxy'
	UPDATE #TblVmList
	SET EsxHostName = instProp.attrVal
	FROM #TblVmList tblVMList WITH(NOLOCK), JMJobDataLink dataLink WITH(NOLOCK), App_application app WITH(NOLOCK), APP_InstanceProp  instProp WITH(NOLOCK)
	WHERE app.id = tblVMList.parentAppId
		AND instProp.componentNameId = app.instance
		AND instProp.attrName = 'Snap Mount Proxy'
		AND EsxHostName is NULL
	SELECT jobId, targetClientId, appId, vmGUID, archFileId, AppGuid, BackupSetGuid, VmName, EsxHostName FROM #TblVmList
	DROP TABLE #TblVmList
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'JMGetVmListForVsaDataCopyJobV2')
	delete from GxQscripts where name = 'JMGetVmListForVsaDataCopyJobV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetVmListForVsaDataCopyJobV2')
	delete from GXDBVersions where aliasname = 'JMGetVmListForVsaDataCopyJobV2'
GO

insert into GXDBVersions values(2, 'JMGetVmListForVsaDataCopyJobV2',  '00010001000200070000', 'JMGetVmListForVsaDataCopyJobV2', '00010001000200070000')
GO

