

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetTopMostJobErrors.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetTopMostJobErrors.sp,v $ $Id: JMGetTopMostJobErrors.sp,v 1.18.72.5 2019/09/13 19:42:05 dkraplanee Exp $";
--
--  +========================================================================+
--  |   Procedure:  JMGetTopMostJobErrors()
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Gokul Pattabiraman   Initial Edit
--  |   1.19		AEBilbrey		   Performance changes to improve data scaling.
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetTopMostJobErrors')
BEGIN
	print '>>> Drop Stored Procedure: JMGetTopMostJobErrors <<<'
	drop procedure JMGetTopMostJobErrors
END
IF EXISTS (select * from GxQscripts where name='JMGetTopMostJobErrors')
	delete from GxQscripts where name = 'JMGetTopMostJobErrors'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetTopMostJobErrors')
	delete from GXDBVersions where aliasname = 'JMGetTopMostJobErrors'
GO
print '... Creating Procedure: JMGetTopMostJobErrors'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetTopMostJobErrors
  @i_userId INT,
  @inXmlReq XML,
  @outXmlResp XML	OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	IF OBJECT_ID('tempdb.dbo.#jobs') IS NOT NULL
		DROP TABLE #jobs
	CREATE TABLE #jobs
	(
		jobId INTEGER,
		commcellId INTEGER,
		jobState INTEGER,
		failureReason VARCHAR(256)
		PRIMARY KEY(jobId)
	)
	IF OBJECT_ID('tempdb.dbo.#errorMessages') IS NOT NULL
		DROP TABLE #errorMessages
	CREATE TABLE #errorMessages
	(
		messageId INTEGER,
		jobId	  INTEGER,
		failureId INTEGER,
		PRIMARY KEY(messageId, jobId)
	)
	DECLARE @Reasons TABLE
	(
		type			INTEGER,		-- type: 1 waiting, 2 pending, 3 failure
		numberOfJobs	INTEGER,
		messageId		INTEGER,
		recentfailureID	nvarchar(64),
		errorCode		nvarchar(64),
		PRIMARY KEY (type, messageId)
	)
	-- Variables
	DECLARE @msgID INT = 0
	DECLARE @subsystemID INT = 0
	DECLARE @msgNum INT = 0
	DECLARE @errorCodeStr nvarchar(64)
	DECLARE @defaultCCId INT = 2
	DECLARE @entityCount INT = 0
	DECLARE @entityFilterXML XML
	DECLARE @i INT = 1
	DECLARE @entityID INT = 0
	DECLARE @entityType INT = 0
	DECLARE @clientID INT = 0
DECLARE @AppTypeEntity		INT = 4
DECLARE @ClientEntity		INT = 3
DECLARE @InstanceEntity		INT = 5
DECLARE @BackupSetEntity	INT = 6
DECLARE @ApplicationEntity	INT = 7
DECLARE @ClientGroupEntity	INT = 28
	-- Form the configuration from input XML if present
	DECLARE @topCount			INT = 3
	DECLARE @type				INT = 1
	DECLARE @entityFilterType	INT = 0
	DECLARE @localeId			INT = 0
	DECLARE @startTime			INT = 0
	DECLARE @endTime			INT = 0
	SELECT
		@topCount = ISNULL(a.value('@topNErrors', 'INT'), 3),		-- Default top 3 reasons
		@type = ISNULL(a.value('@type', 'INT'), 1),					-- Default Active jobs
		@entityFilterType = ISNULL(a.value('(//filter/@filterType)[1]', 'INT'), 0),		-- Default No Filter
		@localeId = ISNULL(a.value('@localeId', 'INT'), 0),			-- Default No localeId
		@startTime = ISNULL(a.value('(//timeRange/@fromTime)[1]', 'INT'), 0),
		@endTime = ISNULL(a.value('(//timeRange/@toTime)[1]', 'INT'), 0)
	FROM
		@inXmlReq.nodes('/JobManager_TopMostJobErrorsReq') doc(a)
	IF @topCount = 0
		SET @topCount = 3 -- Default top 3 reasons
	-- Parse data from XML input
	IF OBJECT_ID('tempdb.dbo.#Entities') IS NOT NULL
		DROP TABLE #Entities
	CREATE TABLE #Entities (
		type			INT,
		clientId		INT,
		appTypeId		INT,
		instanceId		INT,
		backupsetId		INT,
		applicationId	INT,
		clientGroupId	INT
	)
	CREATE CLUSTERED INDEX Entities_idx1 ON #Entities (type)
	INSERT INTO #Entities (type, clientId, appTypeId, instanceId, backupsetId, applicationId, clientGroupId)
		SELECT
			a.value('@_type_', 'INT') type,
			a.value('@clientId', 'INT') clientId,
			a.value('@appTypeId', 'INT') appTypeId,
			a.value('@instanceId', 'INT') instanceId,
			a.value('@backupsetId', 'INT') backupsetId,
			a.value('@applicationId', 'INT') applicationId,			-- special case for appTypeId stored in applicationId attribute if type = @AppTypeEntity
			a.value('@clientGroupId', 'INT') clientGroupId
		FROM
			@inXmlReq.nodes('/JobManager_TopMostJobErrorsReq/filter/entity') doc(a)
		WHERE
			a.value('@_type_', 'INT') IS NOT NULL
	-- work tables
	IF OBJECT_ID('tempdb.dbo.#clientTable') IS NOT NULL
		DROP TABLE #clientTable
	CREATE TABLE #clientTable (
		clientId	INT PRIMARY KEY
	)
	IF OBJECT_ID('tempdb.dbo.#appIDTable') IS NOT NULL
		DROP TABLE #appIDTable
	CREATE TABLE #appIDTable (
		appId		INT PRIMARY KEY
	)
	IF OBJECT_ID('tempdb.dbo.#appTypeTable') IS NOT NULL
		DROP TABLE #appTypeTable
	CREATE TABLE #appTypeTable (
		appTypeId INTEGER PRIMARY KEY
	)
    IF @entityFilterType = 1 -- Client Group \Client and Agents
    BEGIN
		DECLARE @clientCount INT = 0
		DECLARE @appTypeCount INT = 0
		INSERT INTO #clientTable
			SELECT
				e.clientId
			FROM #Entities e
			WHERE
				e.type = @ClientEntity
				AND e.clientId IS NOT NULL
				AND e.clientId <> 0
			UNION
			SELECT
				cga.clientId
			FROM #Entities e
				INNER JOIN APP_ClientGroupAssoc cga ON
					e.type = @ClientGroupEntity
					AND e.clientGroupId IS NOT NULL
					AND e.clientGroupId <> 0
					AND e.clientGroupId = cga.clientGroupId
		SET @clientCount = @@ROWCOUNT	-- How many rows inserted?
		INSERT INTO #appTypeTable
			SELECT
				e.applicationId		-- special case for appTypeId stored in applicationId attribute if type = @AppTypeEntity
			FROM #Entities e
			WHERE
				e.type = @AppTypeEntity
				AND e.applicationId IS NOT NULL
				AND e.applicationId <> 0
		SET @appTypeCount = @@ROWCOUNT	-- How many rows inserted?
		SET @entityCount = @clientCount + @appTypeCount
		-- If count is 0 then no filtering
		IF @entityCount = 0
			SET @entityFilterType = 0
		ELSE
		-- Do filtering only if entity count is not 0
		BEGIN
			INSERT INTO #appIDTable
				SELECT
					a.id
				FROM APP_Application a
				WHERE
					@clientCount = 0
					AND @appTypeCount = 0
				UNION
				SELECT
					a.id
				FROM #clientTable c
					INNER JOIN APP_Application a ON
						@clientCount > 0
						AND @appTypeCount = 0
						AND a.clientId = c.clientId
				UNION
				SELECT
					a.id
				FROM #appTypeTable at
					INNER JOIN APP_Application a ON
						@appTypeCount > 0
						AND @clientCount = 0
						AND a.appTypeId = at.appTypeId
				UNION
				SELECT
					a.id
				FROM #appTypeTable at
					INNER JOIN APP_Application a ON
						@appTypeCount > 0
						AND @clientCount > 0
						AND a.appTypeId = at.appTypeId
					INNER JOIN #clientTable c ON
						c.clientId = a.clientId
		END
    END
    ELSE IF @entityFilterType = 2 -- Subclient
    BEGIN
		-- Populate SubClient data
		INSERT INTO #appIDTable
			SELECT		-- Insert All Subclients under the client
				a.id
			FROM #Entities e
				INNER JOIN App_Application a ON
					e.type = @ClientEntity
					AND e.clientId IS NOT NULL
					AND e.clientId <> 0
					AND e.clientId = a.clientId
			UNION
			SELECT		-- Insert All Subclients under that client and iDA
				a.id
			FROM #Entities e
				INNER JOIN App_Application a ON
					e.type = @AppTypeEntity
					AND e.clientId IS NOT NULL
					AND e.applicationId IS NOT NULL
					AND e.clientId <> 0
					AND e.applicationId <> 0
					AND e.applicationId = a.appTypeId	-- special case for appTypeId stored in applicationId attribute if type = @AppTypeEntity
					AND e.clientId = a.clientId
			UNION
			SELECT		-- Insert All Subclients under the instance, under the client, under apptype
				a.id
			FROM #Entities e
				INNER JOIN App_Application a ON
					e.type = @InstanceEntity
					AND e.clientId IS NOT NULL
					AND e.instanceId IS NOT NULL
					AND e.clientId <> 0
					AND e.instanceId <> 0
					AND e.clientId = a.clientId
					AND e.instanceId = a.instance
			UNION
			SELECT		-- Insert All Subclients under the backupset
				a.id
			FROM #Entities e
				INNER JOIN App_Application a ON
					e.type = @BackupSetEntity
					AND e.backupsetId IS NOT NULL
					AND e.backupsetId <> 0
					AND e.backupsetId = a.backupset
			UNION
			SELECT		-- Insert the subclient
				e.applicationId
			FROM #Entities e
			WHERE
				e.type = @ApplicationEntity
				AND e.applicationId IS NOT NULL
				AND e.applicationId <> 0
		SET @entityCount = @@ROWCOUNT	-- How many rows inserted?
		-- If count is 0 then no filtering
		IF @entityCount = 0
			SET @entityFilterType = 0
    END
    IF @type = 1  -- JOB_ACTIVE = 1
    BEGIN
		-- Get all running backup jobs
		INSERT INTO #jobs
			SELECT jobId, commCellId, state, failureReason FROM RunningBackups
			WHERE commCellId = @defaultCCId
			AND (@entityFilterType = 0 OR applicationId IN (select appId from #appIDTable))
			AND (@i_userId = 0 OR @i_userId = userId OR dbo.isBkpJobVisible(@i_userId,commCellId,clientId,appTypeId,instance,backupSet,applicationId) = 1)
		--  Get all error message IDs from Failure Table grouped by jobs os that repeating error for same job are considered only once
		INSERT INTO #errorMessages
			SELECT JFA.messageId, JFA.jobId, MAX(JFA.id)
			FROM #jobs RB
			CROSS APPLY dbo.SplitIDString(RB.failureReason) FR
			INNER JOIN JMFailureReasonMsg JFA ON JFA.jobId = RB.jobID AND JFA.commCellId = RB.commCellId AND JFA.id = CAST(FR._ID AS INT)
			WHERE RB.failureReason IS NOT NULL AND RB.failureReason <> ''
			GROUP BY JFA.jobId, JFA.messageId
		-- Find out the top 3 waiting errors among them
		INSERT INTO @Reasons
			SELECT TOP (@topCount)
				1,	-- type waiting
				COUNT(*) AS Occurrences,
				messageId,
				CAST( MAX(failureId) as nvarchar(64)) + ',',
				''
			FROM #errorMessages A
				INNER JOIN #jobs B ON
					A.jobId = B.jobId
			WHERE
				B.jobState = 3 -- waiting state
			GROUP BY messageId
			ORDER BY Occurrences DESC
		-- Find out the top 3 pending errors among them
		INSERT INTO @Reasons
			SELECT TOP (@topCount)
				2,	-- type pending
				COUNT(*) AS Occurrences,
				messageId,
				CAST( MAX(failureId) as nvarchar(64)) + ',',
				''
			FROM #errorMessages A
				INNER JOIN #jobs B ON
					A.jobId = B.jobId
			WHERE B.jobState = 2 -- pending state
			GROUP BY messageId
			ORDER BY Occurrences DESC
		TRUNCATE TABLE #jobs
		TRUNCATE TABLE #errorMessages
		DECLARE @currentTime	INTEGER = DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE())
		DECLARE @pastNHours		INTEGER = 6 -- Default - Last six hours
		IF @startTime = 0 AND @endTime = 0
		BEGIN
			-- Default values
			SET @endTime = @currentTime
			SET @startTime = @currentTime - (@pastNHours * 60 * 60)
		END
		-- Get all backup jobs in Time frame
		INSERT INTO #jobs
			SELECT jobId, commCellId, status, failureReason FROM
			JMBkpStats, APP_Application APP
			WHERE
			(@entityFilterType = 0 OR appId IN (select appId from #appIDTable))
			AND (@i_userId = 0 OR @i_userId = ISNULL((Select id From UMUsers(NOLOCK) where login = username),0)
		     OR dbo.isBkpJobVisible(@i_userId,commCellId,clientId,appType,instance,backupSet, appID) = 1)
			AND JMBkpStats.appId = APP.id
			AND servEndDate >= @startTime
			AND servEndDate <= @endTime
			AND commCellId = @defaultCCId
			AND status IN (2,9)-- Failed, Failed to start
		--  Get all error message IDs from Failure Table grouped by jobs os that repeating error for same job are considered only once
		INSERT INTO #errorMessages
			SELECT JFA.messageId, JFA.jobId, MAX(JFA.id)
			FROM #jobs RB
			CROSS APPLY dbo.SplitIDString(RB.failureReason) FR
			INNER JOIN JMFailureReasonMsg JFA ON JFA.jobId = RB.jobID AND JFA.commCellId = RB.commCellId AND JFA.id = CAST(FR._ID AS INT)
			WHERE RB.failureReason IS NOT NULL AND RB.failureReason <> ''
			GROUP BY JFA.jobId, JFA.messageId
		-- Find out the top 3 failure errors among them
		INSERT INTO @Reasons
			SELECT TOP (@topCount)
				3,	-- type failure
				COUNT(*) AS Occurrences,
				messageId,
				CAST( MAX(failureId) as nvarchar(64)) + ',',
				''
			FROM #errorMessages A
			INNER JOIN #jobs B ON A.jobId = B.jobId
			GROUP BY messageId ORDER BY Occurrences DESC
	END
	-- Add errorCode to reasons
	UPDATE r
		SET errorCode = t.errorCode
	FROM @Reasons r
		INNER JOIN (
			SELECT
				m.MessageID messageId,
				CAST(m.SubsystemID AS nvarchar(12)) + ':' + CAST(m.MessageNum AS nvarchar(16)) errorCode
			FROM
				EvLocaleMsgs m WITH(READUNCOMMITTED)
				INNER JOIN (
					SELECT DISTINCT messageId FROM @Reasons
				) e on
					m.MessageID = e.messageId
			WHERE
				m.LocaleID = @localeId
		) t ON
			r.messageId = t.messageId
	-- Form the XML Response
	SET @outXmlResp =
			(
				SELECT
					(
						SELECT
							errorCode AS '@errorCode',
							dbo.NormalizeForXML(dbo.JMGetLocalizedMessageFunc(@localeId, recentfailureID)) AS '@errorDescription',
							numberOfJobs AS '@numberOfJobsAffected',
							messageId AS '@messageId'
						FROM @Reasons
						WHERE type = 1	-- waiting type
						ORDER BY numberOfJobs DESC
						FOR XML PATH ('waitingErrorList'), TYPE
					),
					(
						SELECT
							errorCode AS '@errorCode',
							dbo.NormalizeForXML(dbo.JMGetLocalizedMessageFunc(@localeId, recentfailureID)) AS '@errorDescription',
							numberOfJobs AS '@numberOfJobsAffected',
							messageId AS '@messageId'
						FROM @Reasons
						WHERE type = 2	-- pending type
						ORDER BY numberOfJobs DESC
						FOR XML PATH ('pendingErrorList'), TYPE
					),
					(
						SELECT
							errorCode AS '@errorCode',
							dbo.NormalizeForXML(dbo.JMGetLocalizedMessageFunc(@localeId, recentfailureID)) AS '@errorDescription',
							numberOfJobs AS '@numberOfJobsAffected',
							messageId AS '@messageId'
						FROM @Reasons
						WHERE type = 3	-- failure type
						ORDER BY numberOfJobs DESC
						FOR XML PATH ('failedErrorList'), TYPE
					)
				FOR XML PATH('JobManager_TopMostJobErrorsResp'), TYPE
			)
	IF ( @outXmlResp IS null )
			SET @outXmlResp = '<JobManager_TopMostJobErrorsResp />'
	SELECT @outXmlResp
	IF OBJECT_ID('tempdb.dbo.#clientTable') IS NOT NULL
		DROP TABLE #clientTable
	IF OBJECT_ID('tempdb.dbo.#appIDTable') IS NOT NULL
		DROP TABLE #appIDTable
	IF OBJECT_ID('tempdb.dbo.#appTypeTable') IS NOT NULL
		DROP TABLE #appTypeTable
	IF OBJECT_ID('tempdb.dbo.#Entities') IS NOT NULL
		DROP TABLE #Entities
	IF OBJECT_ID('tempdb.dbo.#jobs') IS NOT NULL
		DROP TABLE #jobs
	IF OBJECT_ID('tempdb.dbo.#errorMessages') IS NOT NULL
		DROP TABLE #errorMessages
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetTopMostJobErrors')
	delete from GxQscripts where name = 'JMGetTopMostJobErrors'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetTopMostJobErrors')
	delete from GXDBVersions where aliasname = 'JMGetTopMostJobErrors'
GO

insert into GXDBVersions values(2, 'JMGetTopMostJobErrors',  '00010018007200050000', 'JMGetTopMostJobErrors', '00010018007200050000')
GO

