

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetSubClientsDynPriorityComputation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--			Author: Divakar Radhakrishnan
--			Date:   12/06/2011
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetSubClientsDynPriorityComputation <<<'

IF EXISTS (select * from sysobjects where name='JMGetSubClientsDynPriorityComputation')
	drop procedure JMGetSubClientsDynPriorityComputation
IF EXISTS (select * from GxQscripts where name='JMGetSubClientsDynPriorityComputation')
	delete from GxQscripts where name = 'JMGetSubClientsDynPriorityComputation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetSubClientsDynPriorityComputation')
	delete from GXDBVersions where aliasname = 'JMGetSubClientsDynPriorityComputation'
GO
print '... Creating Procedure: JMGetSubClientsDynPriorityComputation'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMGetSubClientsDynPriorityComputation
  @lastRunTime BIGINT
AS
  DECLARE @appID INTEGER
  DECLARE @opType INTEGER
  DECLARE @bkpLevel INTEGER
	IF OBJECT_ID('tempdb.dbo.#clientsList') IS NOT NULL DROP TABLE #clientsList
	IF OBJECT_ID('tempdb.dbo.#subClientIDList') IS NOT NULL DROP TABLE #subClientIDList
	CREATE TABLE #clientsList (ClientID INTEGER)
	CREATE TABLE #subClientIDList (subClientID INTEGER, lastUpdateTime INTEGER)
	CREATE INDEX #subClientIDList_SubClientID_lastUpdateTime_idx ON #subClientIDList(subClientID,lastUpdateTime)
	DECLARE @enaledAtCSLevel INTEGER = 0
	IF EXISTS (SELECT 1 FROM APP_AdvanceSettings WITH(NOLOCK)
		WHERE keyName = 'bEnableDynamicPriorityForJobs' AND relativePath = 'CommServe'
				AND enabled = 1 AND deleted = 0 AND (value like N'true' OR value like N'1') AND entityType = 3 and entityId = 2)
	BEGIN
		SET @enaledAtCSLevel = 1
	END
	INSERT INTO #clientsList
	SELECT entityId FROM APP_AdvanceSettings WITH(NOLOCK)
		WHERE keyName = 'bEnableDynamicPriorityForJobs' AND relativePath = 'CommServDB.Client' AND enabled = 1 AND deleted = 0 AND (value like N'true' OR value like N'1') AND entityType = 3
	INSERT INTO #subClientIDList
	SELECT DISTINCT app.id,scProp.created FROM #clientsList cl INNER JOIN APP_Application app WITH(NOLOCK)
		ON cl.ClientID = app.clientId
		LEFT JOIN APP_SubClientProp scProp
			ON app.id = scProp.componentNameId AND scProp.cs_attrName = CHECKSUM(N'Compute Dynamic priority') AND scProp.modified = 0
		WHERE scProp.attrVal IS NULL OR (scProp.created >= @lastRunTime AND scProp.attrVal = N'1')
	UNION
	SELECT componentNameId,created
	FROM APP_SubClientProp WITH(NOLOCK)
	WHERE @enaledAtCSLevel = 1 AND cs_attrName = CHECKSUM(N'Compute Dynamic priority') AND modified = 0 AND attrVal = N'1'
	--UNION
	--SELECT DISTINCT applicationId,0
	--FROM JMBkpJobInfo WITH(NOLOCK)
	--WHERE NOT EXISTS (SELECT 1 FROM APP_SubClientProp WHERE componentNameId = applicationId AND attrName LIKE 'Estimated Run%')
	UPDATE sclist
	SET sclist.lastUpdateTime = ISNULL((SELECT MAX(jmst.servEndDate) FROM JMBkpStats jmst WHERE jmst.jobId = stats.jobId),0)
	FROM #subClientIDList sclist INNER JOIN JMBkpStats stats WITH(NOLOCK)
		on sclist.lastUpdateTime = 0 AND sclist.subClientID = stats.appId AND stats.servEndDate > @lastRunTime
		--ORDER BY stats.servEndDate
	--SELECT * FROM #subClientIDList
	SELECT DISTINCT TOP 1000 jmstats.appId,jmstats.opType,jmstats.bkpLevel FROM
	JMBkpStats jmstats WITH(NOLOCK)
	WHERE EXISTS (SELECT 1 FROM #subClientIDList scl WHERE scl.subClientID = jmstats.appId)
	DROP TABLE #clientsList
	DROP TABLE #subClientIDList
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetSubClientsDynPriorityComputation')
	delete from GxQscripts where name = 'JMGetSubClientsDynPriorityComputation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetSubClientsDynPriorityComputation')
	delete from GXDBVersions where aliasname = 'JMGetSubClientsDynPriorityComputation'
GO

insert into GXDBVersions values(2, 'JMGetSubClientsDynPriorityComputation',  '00000000000000000000', 'JMGetSubClientsDynPriorityComputation', '00000000000000000000')
GO

