

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetSnapToTapeWorkflowInProgress.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +=======================================================================================================================+
--  | Stored Proc:  JMGetSnapToTapeWorkflowInProgress()
--  |
--  | Description:  Return existing backup copy/deferred catalog workflow jobIds for given subclient or storage policy
--  +=======================================================================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetSnapToTapeWorkflowInProgress.sp,v $ $Id: JMGetSnapToTapeWorkflowInProgress.sp,v 1.1.2.1 2020/03/05 17:58:13 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetSnapToTapeWorkflowInProgress')
BEGIN
	print '>>> Drop Stored Procedure: JMGetSnapToTapeWorkflowInProgress <<<'
	drop procedure JMGetSnapToTapeWorkflowInProgress
END
IF EXISTS (select * from GxQscripts where name='JMGetSnapToTapeWorkflowInProgress')
	delete from GxQscripts where name = 'JMGetSnapToTapeWorkflowInProgress'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetSnapToTapeWorkflowInProgress')
	delete from GXDBVersions where aliasname = 'JMGetSnapToTapeWorkflowInProgress'
GO
print '... Creating Procedure: JMGetSnapToTapeWorkflowInProgress'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetSnapToTapeWorkflowInProgress
  @i_appId INTEGER,
  @i_archGroupId INTEGER,
  @i_opType INTEGER
AS
  DECLARE @jobId INT;
/* These are enums in CvConstDefCommon.h */
BEGIN TRY
	/*
		I'm moving this logic from cpp code that treats non-snaptotapeworkflow as delayedcatalogworkflow. So sticking to same logic here
	*/
IF(@i_opType != 61)
SET @i_opType = 95
	IF(@i_appId > 0) --Subclient level workflow
	BEGIN
		IF(OBJECT_ID('tempdb..#tblRunningWorkFlows') IS NOT NULL)
			DROP TABLE #tblRunningWorkFlows
		CREATE TABLE #tblRunningWorkFlows (WFJobId int, commcellId int, primary key(WFJobId, commcellId))
		--These are the workflow jobs currently running with backup copies pending for this suclient
		INSERT INTO #tblRunningWorkFlows
		SELECT DISTINCT JWF.jobId, JWF.commcellId
		FROM JMJobWF JWF INNER JOIN JMAdminJobInfoTable JI ON JWF.jobId = JI.jobId AND JWF.commcellId = JI.commcellId AND JI.opType = @i_opType
		WHERE JWF.applicationId = @i_appId AND JWF.childJobId = 0 AND JWF.submitStatus <> 2 /* enum CVWFJobSubmitStatus{ CVWFJOB_NOTSUBMITTED=0, CVWFJOB_SUBMITTING, CVWFJOB_SUBMITTED_COMPLETE} */
		--If the workflow had any backup copy job failed for subclient, then workflow will not process these any more. So remove those from running workflow list
		DELETE #tblRunningWorkFlows
		FROM #tblRunningWorkFlows T INNER JOIN JMJobWF JWF ON T.WFJobId = JWF.jobId AND T.commcellId = JWF.commcellId AND JWF.applicationId = @i_appId
		INNER JOIN JMBkpStats JBKP ON JWF.childJobId = JBKP.jobId AND JWF.commcellId = JBKP.commcellId AND JBKP.status NOT IN (1, 3, 14)
		--Return the list of subclient level workflow jobs on this subclient + storage policy level workflow jobs that are going to process this subclient
		SELECT jobId FROM JMAdminJobInfoTable
		WHERE opType = @i_opType AND appId = @i_appId
		UNION
		SELECT jobId FROM JMAdminJobInfoTable JAJ INNER JOIN #tblRunningWorkFlows T
		ON JAJ.jobId = T.WFJobId AND JAJ.commcellId = T.commcellId
		WHERE JAJ.appId = 0
		IF(OBJECT_ID('tempdb..#tblRunningWorkFlows') IS NOT NULL)
			DROP TABLE #tblRunningWorkFlows
	END
	ELSE			--Storage policy level workflow
	BEGIN
		SELECT jobId FROM JMAdminJobInfoTable
		WHERE opType = @i_opType AND archGrpId = @i_archGroupId AND appId = 0
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
IF(OBJECT_ID('tempdb..#tblRunningWorkFlows') IS NOT NULL)
			DROP TABLE #tblRunningWorkFlows
;THROW
SELECT -1
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetSnapToTapeWorkflowInProgress')
	delete from GxQscripts where name = 'JMGetSnapToTapeWorkflowInProgress'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetSnapToTapeWorkflowInProgress')
	delete from GXDBVersions where aliasname = 'JMGetSnapToTapeWorkflowInProgress'
GO

insert into GXDBVersions values(2, 'JMGetSnapToTapeWorkflowInProgress',  '00010001000200010000', 'JMGetSnapToTapeWorkflowInProgress', '00010001000200010000')
GO

