

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetSnapIndexCreationInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetSnapIndexCreationInfo.sp,v $ $Id: JMGetSnapIndexCreationInfo.sp,v 1.2.274.1 2018/03/22 03:18:03 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "JMGetSnapIndexCreationInfo"								|
--	|																		|
--	|																		|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetSnapIndexCreationInfo <<<'

IF EXISTS (select * from sysobjects where name='JMGetSnapIndexCreationInfo')
	drop procedure JMGetSnapIndexCreationInfo
IF EXISTS (select * from GxQscripts where name='JMGetSnapIndexCreationInfo')
	delete from GxQscripts where name = 'JMGetSnapIndexCreationInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetSnapIndexCreationInfo')
	delete from GXDBVersions where aliasname = 'JMGetSnapIndexCreationInfo'
GO
print '... Creating Procedure: JMGetSnapIndexCreationInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMGetSnapIndexCreationInfo
  @in_SubClientId integer
AS
  DECLARE @o_fullBkpJobId integer
  DECLARE @o_fullBkpJobTime integer
  DECLARE @o_incrBkpJobId integer
  DECLARE @o_incrBkpJobTime integer
  DECLARE @o_bkpType integer
  DECLARE @o_indexCreationTime integer
--Select last successful FULL jobid, time for the give subclient
--Status =1 means completed, 3 = partial and bkpLevel = 1 mean FULL
select top 1 @o_fullBkpJobId = jobId, @o_fullBkpJobTime = servEndDate from JmBkpStats where appId = @in_SubClientId and status IN (1,3) and bkpLevel = 1 and (opType = 60 or (opType = 59 and bkpattributes & 0x200000000 = 0x200000000))  order by jobId desc
--Select last successful Incremental jobid, time for the give subclient
--Status =1 means completed, 3 = partial and bkpLevel = 2 mean Incremental
select top 1 @o_incrBkpJobId = jobId, @o_incrBkpJobTime = servEndDate from JmBkpStats where appId = @in_SubClientId and status IN (1,3) and bkpLevel = 2 and (opType = 60 or (opType = 59 and bkpattributes & 0x200000000 = 0x200000000)) order by jobId desc
--Select indexCreationTime and bkplevel
--Here we are fetching the latest index creation time(It may be incremental or full backup type)
select top 1 @o_indexCreationTime = cTime, @o_bkpType = backupLevel from archfile where fileType = 1 and appId =@in_SubClientId order by cTime desc
select @o_fullBkpJobId, @o_fullBkpJobTime, @o_incrBkpJobId, @o_incrBkpJobTime, @o_bkpType, @o_indexCreationTime
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetSnapIndexCreationInfo')
	delete from GxQscripts where name = 'JMGetSnapIndexCreationInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetSnapIndexCreationInfo')
	delete from GXDBVersions where aliasname = 'JMGetSnapIndexCreationInfo'
GO

insert into GXDBVersions values(2, 'JMGetSnapIndexCreationInfo',  '00010002027400010000', 'JMGetSnapIndexCreationInfo', '00010002027400010000')
GO

