

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetSkipCatalogParams.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetSkipCatalogParams.sp,v $ $Id: JMGetSkipCatalogParams.sp,v 1.1.2.13.54.1 2021/02/09 05:51:05 gpattabiraman Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "JMGetSkipCatalogParams"
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMGetSkipCatalogParams')
BEGIN
	print '>>> Drop Stored Procedure: JMGetSkipCatalogParams <<<'
	drop procedure JMGetSkipCatalogParams
END
IF EXISTS (select * from GxQscripts where name='JMGetSkipCatalogParams')
	delete from GxQscripts where name = 'JMGetSkipCatalogParams'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetSkipCatalogParams')
	delete from GXDBVersions where aliasname = 'JMGetSkipCatalogParams'
GO
print '... Creating Procedure: JMGetSkipCatalogParams'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMGetSkipCatalogParams
-- Input arguments
  @inJobID integer,
  @inSubclientId integer,
  @inBkpLevel integer,
  @inCommCellId integer,
  @jobQueryType integer 
AS
  DECLARE @outSnapJobId integer
  DECLARE @outSnapRefTime integer
  DECLARE @outSnapBkpLevel integer
  DECLARE @outSnapJobEndTime integer
  DECLARE @outIsJobValidInSnapCopy integer
BEGIN
	DECLARE @FULL_CYCLE_NUM_PROP_NAME NVARCHAR(MAX) = 'sys:full cycle num'
	DECLARE @currentCycleNum INT = 0
	DECLARE @myOpType INT = 0
	DECLARE @myJobIdActedOn INT = 0
	DECLARE @myAppId INT = 0
	DECLARE @isSnapDiffCase INT = 0
	SET @outSnapJobId = 0
	SET @outSnapRefTime = 0
	SET @outSnapJobEndTime = 0
	SET @outIsJobValidInSnapCopy = 0
	IF OBJECT_ID('tempdb.dbo.#Jobinfo') IS NOT NULL
    DROP TABLE #Jobinfo
	   CREATE TABLE #Jobinfo
	   (Jobid            INT  PRIMARY KEY,
	    commcellid       INT,
	    appid            INT,
	    bkplevel         INT,
	    servEndDate      INT,
	    status           INT,
	    Optype           INT,
	    fullcyclenum     INT,
	    bkpAttributes    BIGINT,
	    bkpAttributesEx  BIGINT,
	    jobIdActedOn     INT,
	    jobReferenceTime INT
        )
	   INSERT INTO #Jobinfo
       SELECT JobID,
              Commcellid,
              appid,
              bkplevel,
              servEndDate,
              status,
              Optype,
              fullcyclenum,
              bkpattributes,
              bkpAttributesEx,
              jobIdActedOn,
              jobReferenceTime
       FROM JMBkpStats
       WHERE appid = @inSubclientId
             AND commCellId = @inCommCellId
             AND status IN(1, 3, 14)  -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SELECT	@myOpType = (CASE WHEN subOpType  > 0 THEN subOpType ELSE opType END),
			@myJobIdActedOn = jobIdActedOn,
			@myAppId = JBI.applicationId
	FROM JMBkpJobInfo JBI
	INNER JOIN JMJobInfo JI ON JBI.jobId = JI.jobId AND JBI.commcellId = JI.commCellId
	WHERE JBI.jobId = @inJobID AND JBI.commCellId = @inCommCellId
	-- Check if it is snap diff case
	SET @isSnapDiffCase = ISNULL( ( SELECT TOP 1 1
									FROM APP_Application APP
									INNER JOIN APP_Client CL ON APP.clientId = CL.id
									LEFT OUTER JOIN APP_AppTypeGroupAssoc AG ON APP.appTypeId = AG.appTypeId AND AG.appGroupId IN (22, 34) --APPGRP_W2KFileSystem, APPGRP_UnixFileSystem
WHERE (CL.simOperatingSystemId = 16) -- NAS client
AND (APP.appTypeId = 13 OR AG.appTypeId IS NOT NULL) -- Either NAS FS apptype or Windows/Unix FS apptypes under NAS client
									AND APP.id = @myAppId), 0)
	-- Need current cycle number for non-full jobs
	IF @inBkpLevel <> 1
	BEGIN
		IF @myOptype = 59 /*SNAPBACKUP*/
		BEGIN
			SELECT @currentCycleNum = ISNULL(CAST(SP.attrVal AS INT), 0)
			FROM APP_SubClientProp SP
			WHERE SP.componentNameId = @inSubclientId AND SP.modified = 0
			AND SP.attrName = @FULL_CYCLE_NUM_PROP_NAME AND SP.cs_attrName = CHECKSUM(@FULL_CYCLE_NUM_PROP_NAME)
		END
		ELSE IF @myJobIdActedOn > 0
		BEGIN
			SELECT @currentCycleNum = fullCycleNum FROM JMBkpStats WHERE jobId = @myJobIdActedOn AND commCellId = @inCommCellId
		END
	END
	IF @jobQueryType = 1 -- QueryType_LastCatalogued
	BEGIN
		-- Job ID is across cycles
		SELECT TOP 1 @outSnapJobId = JBS.jobId, @outSnapBkpLevel = JBS.bkpLevel, @outSnapJobEndTime = JBS.servEndDate
		FROM #Jobinfo JBS
		INNER JOIN JMJobDataStats JDS ON JBS.jobId = JDS.jobId AND JBS.commCellId = JDS.commCellId
		INNER JOIN JMJobStats JS ON JBS.jobId = JS.jobId AND JBS.commCellId = JS.commCellId
		INNER JOIN archGroupCopy AGC ON JDS.archGrpCopyId = AGC.id AND (@isSnapDiffCase = 0 OR AGC.isSnapCopy = 1) -- Check snap copy validity for snap diff cases
		WHERE   JBS.opType = 59 AND JS.subOpType = 0 -- Exclude skip catalog job itself
		AND JDS.status = 100 AND JDS.disabled & 256 = 0 -- CVA_AGED_DATA_FLAG
		AND (@inBkpLevel <> 4
				OR
				-- For differential jobs, get full from current cycle or any job before that.
				((JBS.fullCycleNum = @currentCycleNum AND JBS.bkpLevel = 1)
									OR
				  JBS.fullCycleNum < @currentCycleNum
				)
			)
		AND
		(
			((JBS.bkpAttributes & 0x200000000000000) = 0) -- JMBKP_SKIP_CATALOG_PHASE_SNAP_BKUP when catalog is done with snap job
						OR
			EXISTS (
						SELECT 1
						FROM #Jobinfo DCJ
						INNER JOIN JMJobStats JS ON DCJ.jobId = JS.jobId AND DCJ.commCellId = JS.commCellId
						WHERE DCJ.jobIdActedOn = JBS.jobId AND DCJ.status IN (1,3,14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
						AND JS.subOpType = 96
					) -- Delayed catalog was run for it
		)
		ORDER BY JBS.jobId DESC
		-- reftime is in cycle
		IF @inBkpLevel <> 1
		BEGIN
			DECLARE @isSynthFullCatalog INT = 0
			SELECT TOP 1 @outSnapRefTime = JBS.jobReferenceTime, @isSynthFullCatalog = CASE WHEN JBS.opType = 14 THEN 1 ELSE 0 END
			FROM #Jobinfo JBS
			INNER JOIN JMJobStats JS ON JBS.jobId = JS.jobId AND JBS.commCellId = JS.commCellId
			INNER JOIN JMJobDataStats JDS ON JBS.jobId = JDS.jobId AND JBS.commCellId = JDS.commCellId
			INNER JOIN archGroupCopy AGC ON JDS.archGrpCopyId = AGC.id AND (AGC.isSnapCopy = 1 OR JBS.opType = 14 OR @isSnapDiffCase = 0) -- Check snap copy except for synthfull and snap diff cases
			WHERE  JBS.fullCycleNum = @currentCycleNum
			AND JBS.opType IN(59, 14) -- Synthetic full jobs should be considered as catalogued
			AND JS.subOpType = 0 -- Exclude skip catalog job itself
			AND JDS.status = 100 AND JDS.disabled & 256 = 0 -- CVA_AGED_DATA_FLAG
			AND (@inBkpLevel <> 4 OR (JBS.bkpLevel = 1 OR JBS.opType = 14)) -- For differential get only Full/Synthfull jobs in current cycle
			AND
			(
				((JBS.bkpAttributes & 0x200000000000000) = 0) -- JMBKP_SKIP_CATALOG_PHASE_SNAP_BKUP when catalog is done with snap job
							OR
				EXISTS (
							SELECT 1
							FROM #Jobinfo DCJ
							INNER JOIN JMJobStats JS ON DCJ.jobId = JS.jobId AND DCJ.commCellId = JS.commCellId
							WHERE DCJ.jobIdActedOn = JBS.jobId AND DCJ.status IN (1,3,14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
							AND JS.subOpType = 96
						) -- Delayed catalog was run for it
			)
			ORDER BY JBS.jobId DESC
			-- If we found a synthetic full job as catalogued, get the refTime from previous incremental.
			IF @isSynthFullCatalog = 1
			BEGIN
				SELECT TOP 1 @outSnapRefTime = JBS.jobReferenceTime
				FROM #Jobinfo JBS
				INNER JOIN JMJobDataStats JDS ON JBS.jobId = JDS.jobId AND JBS.commCellId = JDS.commCellId
				INNER JOIN archGroupCopy AGC ON JDS.archGrpCopyId = AGC.id AND (@isSnapDiffCase = 0 OR AGC.isSnapCopy = 1) -- Check snap copy validity for snap diff cases
				WHERE  JBS.fullCycleNum  = (@currentCycleNum - 1)
				AND JBS.opType = 59
				AND JDS.status = 100 AND JDS.disabled & 256 = 0 -- CVA_AGED_DATA_FLAG
				AND JBS.bkpLevel <> 1 -- Only Incrementals and Differentials
				ORDER BY JBS.jobId DESC
			END
		END
	END
	ELSE If @jobQueryType = 2 -- QueryType_LastBackupCopied
	BEGIN
		DECLARE @snapToTapeArchiveIndexPhase INT = 0
		DECLARE @snapToTapeArchiveIndexPhaseType INT = 0x600000 -- (JM_PHASE_TYPE_SNAPTAPE_PHASE_OF_SNAPBACKUP | JM_PHASE_TYPE_ARCHIVE_INDEX)
		SELECT @snapToTapeArchiveIndexPhase =  P.phase
		FROM JMPhase P
		INNER JOIN JMOpTable O ON P.opTableId = O.id
		INNER JOIN APP_Application A ON O.appTypeType = A.appTypeId
		WHERE A.id = @inSubclientId
		AND O.operation = 59 -- SNAPBACKUP
		AND P.phaseType & @snapToTapeArchiveIndexPhaseType = @snapToTapeArchiveIndexPhaseType
		-- Job ID is across cycles
		SELECT TOP 1 @outSnapJobId = JBS.jobIdActedOn, @outSnapBkpLevel = JSNAP.bkpLevel, @outSnapJobEndTime = JSNAP.servEndDate
		FROM #Jobinfo JBS
		INNER JOIN JMJobDataStats JDS ON JBS.jobIdActedOn = JDS.jobId AND JBS.commCellId = JDS.commCellId
		INNER JOIN JMJobSnapShotStats JSS ON JBS.jobIdActedOn = JSS.jobId AND JBS.commCellId = JSS.commCellId AND JSS.materializationStatus <> 101 --  NODATACOPIED
		INNER JOIN archGroupCopy AGC ON JDS.archGrpCopyId = AGC.id AND (@isSnapDiffCase = 0 OR AGC.isSnapCopy = 1) -- Check snap copy validity for snap diff cases
		INNER JOIN JMBkpStats JSNAP ON JBS.jobIdActedOn = JSNAP.jobId AND JBS.commCellId = JSNAP.commCellId
		WHERE   JDS.status = 100 AND JDS.disabled & 256 = 0 -- CVA_AGED_DATA_FLAG
		AND (@inBkpLevel <> 4
				OR
				-- For differential jobs, get full from current cycle or any job before that.
				((JSNAP.fullCycleNum = @currentCycleNum AND JSNAP.bkpLevel = 1)
									OR
				  JSNAP.fullCycleNum < @currentCycleNum
				)
			)
		AND(
				JBS.opType = 60  --When backup copy is run as separate job
					OR
				(
JBS.opType = 59 AND ((JBS.bkpAttributesEx & 0x800000) <> 0) -- JMBKP_EX_SNAPTOTAPE_IN_SAME_JOB When backup copy is run in same job, then we need to check if ArchiveIndex phase of backup copy has been run
					AND EXISTS (
									SELECT 1
									FROM JMBkpAtmptStats BAS
									WHERE JBS.jobId = BAS.jobId AND JBS.commCellId = BAS.commCellId
									AND BAS.phase = @snapToTapeArchiveIndexPhase AND BAS.status in (1,3,14)
								)
				)
			)
		ORDER BY JBS.jobIdActedOn DESC
		-- reftime is in cycle
		IF @inBkpLevel <> 1
		BEGIN
			DECLARE @isSynthFullBackupCopy INT = 0
			SELECT TOP 1 @outSnapRefTime = JSNAP.jobReferenceTime
			FROM #Jobinfo JBS
			INNER JOIN JMJobDataStats JDS ON JBS.jobIdActedOn = JDS.jobId AND JBS.commCellId = JDS.commCellId
			INNER JOIN JMJobSnapShotStats JSS ON JBS.jobIdActedOn = JSS.jobId AND JBS.commCellId = JSS.commCellId AND JSS.materializationStatus <> 101 --  NODATACOPIED
			INNER JOIN archGroupCopy AGC ON JDS.archGrpCopyId = AGC.id AND (@isSnapDiffCase = 0 OR AGC.isSnapCopy = 1) -- Check snap copy validity for snap diff cases
			INNER JOIN JMBkpStats JSNAP ON JBS.jobIdActedOn = JSNAP.jobId AND JBS.commCellId = JSNAP.commCellId AND JSNAP.fullCycleNum = @currentCycleNum
			WHERE  JDS.status = 100 AND JDS.disabled & 256 = 0 -- CVA_AGED_DATA_FLAG
			AND (@inBkpLevel <> 4 OR (JBS.bkpLevel = 1)) -- For differential get only Full jobs in current cycle
			AND(
					JBS.opType = 60  --When backup copy is run as separate job
						OR
					(
JBS.opType = 59 AND ((JBS.bkpAttributesEx & 0x800000) <> 0) -- JMBKP_EX_SNAPTOTAPE_IN_SAME_JOB When backup copy is run in same job, then we need to check if ArchiveIndex phase of backup copy has been run
						AND EXISTS (
										SELECT 1
										FROM JMBkpAtmptStats BAS
										WHERE JBS.jobId = BAS.jobId AND JBS.commCellId = BAS.commCellId
										AND BAS.phase = @snapToTapeArchiveIndexPhase AND BAS.status in (1,3,14)
									)
					)
				)
			ORDER BY JBS.jobIdActedOn DESC
			-- If we could not reftime in our cycle, check if cycle has a synthfull job
			IF @outSnapRefTime = 0
			BEGIN
				SELECT @isSynthFullBackupCopy = 1
				FROM #Jobinfo JBS
				INNER JOIN JMJobDataStats JDS ON JBS.jobId = JDS.jobId AND JBS.commCellId = JDS.commCellId
				INNER JOIN archGroupCopy AGC ON JDS.archGrpCopyId = AGC.id
				WHERE   JBS.fullCycleNum = @currentCycleNum
				AND JBS.opType = 14
			END
			-- If we found a synthetic full job as backupcopied, get the refTime from previous incremental.
			IF @isSynthFullBackupCopy = 1
			BEGIN
				SELECT TOP 1 @outSnapRefTime = JBS.jobReferenceTime
				FROM #Jobinfo JBS
				INNER JOIN JMJobDataStats JDS ON JBS.jobId = JDS.jobId AND JBS.commCellId = JDS.commCellId
				INNER JOIN archGroupCopy AGC ON JDS.archGrpCopyId = AGC.id AND (@isSnapDiffCase = 0 OR AGC.isSnapCopy = 1) -- Check snap copy validity for snap diff cases
				WHERE   JBS.fullCycleNum  = (@currentCycleNum - 1)
				AND JBS.opType = 59
				AND JDS.status = 100 AND JDS.disabled & 256 = 0 -- CVA_AGED_DATA_FLAG
				AND JBS.bkpLevel <> 1 -- Only Incrementals and Differentials
				ORDER BY JBS.jobId DESC
			END
		END
	END
	SET @outIsJobValidInSnapCopy = ISNULL( (SELECT TOP 1 1
											FROM JMJobDataStats JDS
											INNER JOIN archGroupCopy AGC ON JDS.archGrpCopyId = AGC.id AND AGC.isSnapCopy = 1
											WHERE JDS.jobId = @outSnapJobId AND JDS.commCellId = @inCommCellId
											AND JDS.status = 100 AND JDS.disabled & 256 = 0 -- CVA_AGED_DATA_FLAG
											), 0)
	SELECT @outSnapJobId, @outSnapRefTime, @outSnapBkpLevel, @outSnapJobEndTime, @outIsJobValidInSnapCopy
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetSkipCatalogParams')
	delete from GxQscripts where name = 'JMGetSkipCatalogParams'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetSkipCatalogParams')
	delete from GXDBVersions where aliasname = 'JMGetSkipCatalogParams'
GO

insert into GXDBVersions values(2, 'JMGetSkipCatalogParams',  'v1.1.2.13.54.1', 'JMGetSkipCatalogParams', 'v1.1.2.13.54.1')
GO

