

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetRunningRestores.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetRunningRestores.sp,v $ $Id: JMGetRunningRestores.sp,v 1.1.2.6 2020/01/08 20:46:27 sbonilla Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 				Procedure: "JMGetRunningRestores"						|
--	|	Select from RunningRestores.view to return information about		|
--	|	running backups for Job Controller window.							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetRunningRestores')
BEGIN
	print '>>> Drop Stored Procedure: JMGetRunningRestores <<<'
	drop procedure JMGetRunningRestores
END
IF EXISTS (select * from GxQscripts where name='JMGetRunningRestores')
	delete from GxQscripts where name = 'JMGetRunningRestores'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRunningRestores')
	delete from GXDBVersions where aliasname = 'JMGetRunningRestores'
GO
print '... Creating Procedure: JMGetRunningRestores'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetRunningRestores
  @i_userId integer,
  @whereClause char(512)
AS
--	The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
--************************************************************************
--	NEW ITEMS MAY ONLY BE ADDED AT THE END OF THE :DECLARE LIST!!!!!!!!!!!!!!
--	This is because some code (myIndicator) uses a hardcoded index # into
--	this list for certain items, so if an item is inserted before them,
--	the index # will reference the wrong item and we will get the wrong
--	data to send to the GUI!
--************************************************************************
  DECLARE @isVisible integer
  DECLARE @jobID integer
  DECLARE @opType integer
  DECLARE @userId integer
  DECLARE @commCellId integer
  DECLARE @srcClientId integer
  DECLARE @destClientId integer
  DECLARE @appType integer
  DECLARE @instanceID integer
  DECLARE @bkpSetID integer
  DECLARE @state integer
  DECLARE @displayState integer
  DECLARE @clientPriority integer
  DECLARE @opPriority integer
  DECLARE @appPriority integer
  DECLARE @combPriority integer
  DECLARE @currentPhase integer
  DECLARE @jobStartTime integer
  DECLARE @attemptStartTime integer
  DECLARE @elapsedTime integer
  DECLARE @jobElapsedTime integer
  DECLARE @startAttempts integer
  DECLARE @runAttempts integer
  DECLARE @isPreemptable integer
  DECLARE @totCompBytes bigint
  DECLARE @totUnCompBytes bigint
  DECLARE @totSuccess bigint
  DECLARE @totFailures bigint
  DECLARE @totSkipped bigint
  DECLARE @totFiles2Xfer bigint
  DECLARE @totBytes2Xfer bigint
  DECLARE @initFrom integer
  DECLARE @pendingCause integer
  DECLARE @errorType integer
  DECLARE @guiAlertColorLevel integer
  DECLARE @timeToComplete integer
  DECLARE @percentcomplete integer
  DECLARE @lastUpdateFromClient integer
  DECLARE @lastStateChangeTime bigint
  DECLARE @noOfGUIMonitors integer
  DECLARE @isScheduledAlert integer
  DECLARE @jobBasedAlertId integer
  DECLARE @maxRestarts integer
  DECLARE @restartInterval integer
  DECLARE @rstTaskId integer
  DECLARE @rstattributes bigint
  DECLARE @taskId integer
  DECLARE @totReadBytes bigint
  DECLARE @totReadTime bigint
  DECLARE @totPhysicalWriteBytes bigint
  DECLARE @totPhysicalWriteTime bigint
  DECLARE @totNwTransTime bigint
  DECLARE @totSidbLookups bigint
  DECLARE @totSidbLookupTime bigint
  DECLARE @readCurrentThroughput float
  DECLARE @readAverageThroughput float
  DECLARE @writeCurrentThroughput float
  DECLARE @writeAverageThroughput float
  DECLARE @networkCurrentThroughput float
  DECLARE @networkAverageThroughput float
  DECLARE @sidbCurrentLookups float
  DECLARE @sidbAverageLookups float
  DECLARE @subTaskName NVARCHAR(256)
  DECLARE @taskName NVARCHAR(256)
  DECLARE @UserName varchar(max)
  DECLARE @alertName nvarchar(max)
  DECLARE @srcClientName nvarchar(max)
  DECLARE @destClientName nvarchar(max)
  DECLARE @appTypeName varchar(max)
  DECLARE @instanceName nvarchar(max)
  DECLARE @backupSetName nvarchar(max)
  DECLARE @libraryList nvarchar(max)
  DECLARE @driveList nvarchar(max)
  DECLARE @failureReason varchar(max)
  DECLARE @DelayReason nvarchar(max)
  DECLARE @foreignToken nvarchar(max)
  DECLARE @currentPhaseName varchar(max)
  DECLARE @curDatabase varchar(max)
  DECLARE @mediaAgent varchar(max)
  DECLARE @shortMediaAgent varchar(max)
  DECLARE @activeFile NVARCHAR(max)
  DECLARE @failureKBArticle nvarchar(max)
  DECLARE @jobDescription nvarchar(max)
  DECLARE @xmlJobInfo nvarchar(max)
  DECLARE @currentThroughput float
  DECLARE @averageThroughput float
  DECLARE @srcClientDisplayName nvarchar(255)
  DECLARE @destClientDisplayName nvarchar(255)
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
BEGIN
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @query NVARCHAR(2048) = '
	SELECT CASE WHEN '+CONVERT(VARCHAR(10),@i_userId)+' = 0 OR '+CONVERT(VARCHAR(10),@i_userId)+' = userId
		THEN 1
		ELSE dbo.isRstJobVisible('+CONVERT(VARCHAR(10),@i_userId)+',commCellId,srcClientid,destClientid,apptype,instanceid,bkpSetId)
		END	AS isVisible,
	jobID, opType, userId, commCellId, srcClientId, destClientId, appType, instanceID, bkpSetID, state, displayState, clientPriority, opPriority, appPriority, combPriority,
	currentPhase, jobStartTime, attemptStartTime, elapsedTime, jobElapsedTime, startAttempts, runAttempts, isPreemptable, totCompBytes, totUnCompBytes, totSuccess,totFailures,
	totSkipped, totFiles2Xfer, totBytes2Xfer, initFrom, pendingCause, errorType, guiAlertColorLevel, timeToComplete, percentcomplete, lastUpdateFromClient,lastStateChangeTime,
	noOfGUIMonitors, isScheduledAlert, jobBasedAlertId, maxRestarts, restartInterval, rstTaskId, rstattributes, taskId,totReadBytes,totReadTime,totPhysicalWriteBytes,
	totPhysicalWriteTime,totNwTransTime,totSidbLookups,totSidbLookupTime,readCurrentThroughput,readAverageThroughput,writeCurrentThroughput,writeAverageThroughput,networkCurrentThroughput,
	networkAverageThroughput,sidbCurrentLookups,sidbAverageLookups, subTaskName, taskName, UserName, alertName, srcClientName, destClientName, appTypeName, instanceName, backupSetName,
	libraryList, driveList, failureReason, DelayReason, foreignToken, currentPhaseName, curDatabase, mediaAgent, shortMediaAgent, activeFile, failureKBArticle, jobDescription, xmlJobInfo,
	currentThroughput, averageThroughput, srcClientDisplayName, destClientDisplayName
	FROM RunningRestores WHERE ' + @whereClause
	EXECUTE sp_executesql @query
	SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
END

IF EXISTS (select * from GxQscripts where name = 'JMGetRunningRestores')
	delete from GxQscripts where name = 'JMGetRunningRestores'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRunningRestores')
	delete from GXDBVersions where aliasname = 'JMGetRunningRestores'
GO

insert into GXDBVersions values(2, 'JMGetRunningRestores',  '00010001000200060000', 'JMGetRunningRestores', '00010001000200060000')
GO

