

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetRunningJobSummaryQSDK.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetRunningJobSummaryQSDK.sp,v $ $Id: JMGetRunningJobSummaryQSDK.sp,v 1.5.2.9 2020/04/02 18:52:26 gstoops Exp $";
--
--  +========================================================================+
--  |   Procedure:  JMGetRunningJobSummaryQSDK()
--  |
--  | Description:  Fetches running job details (to be called for qlist job cmd)
--  |				Can query the finished job also based on the input filter
--  |				This sp has been cloned from JMGetRunningJobSummary
--  |				This is just for 10.0 to have minimum regression
--  |				From 11.0 will modify this sp to return GalaxyUtilities_QGetJobsRespMsg xml
--  |
--  |
--  |		Input:  userId, inputXML (with filters set appropriately)
--  |
-- 	|		Output:  Job list response xml
--  |
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        jswaminathan					Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetRunningJobSummaryQSDK')
BEGIN
	print '>>> Drop Stored Procedure: JMGetRunningJobSummaryQSDK <<<'
	drop procedure JMGetRunningJobSummaryQSDK
END
IF EXISTS (select * from GxQscripts where name='JMGetRunningJobSummaryQSDK')
	delete from GxQscripts where name = 'JMGetRunningJobSummaryQSDK'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRunningJobSummaryQSDK')
	delete from GXDBVersions where aliasname = 'JMGetRunningJobSummaryQSDK'
GO
print '... Creating Procedure: JMGetRunningJobSummaryQSDK'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetRunningJobSummaryQSDK
  @i_userId INT,
  @i_xml XML,
  @o_xml XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	if OBJECT_ID('tempdb.dbo.#JobSummary') is not null
		drop table dbo.#JobSummary
	CREATE TABLE #JobSummary  (
		--id int DEFAULT 0,		-- column not used
		isVisible INT,
		userId INT,
		jobId int primary key,
		jobType int,								--opType
		srcClientName varchar(max),
		destClientName varchar(max),
		status varchar(max),						--state or status for running and completed jobs respectively
		currentPhaseName varchar(max),
		percentComplete varchar(max),
		pendingCause varchar(max),					--pending cause for running jobs and failure reason for completed jobs
		jobStartTime int,
		jobElapsedTime int,
		appTypeName varchar(max),
		instanceName varchar(max) DEFAULT NULL,
		backupsetName varchar(max) DEFAULT NULL,
		subclientName varchar(max) DEFAULT NULL,
		statusColor varchar(10) DEFAULT 'black',
		lastUpdateTime int,
		operationName varchar(max) DEFAULT null,
		sizeOfApplication bigint null,
        sizeOfMediaOnDisk bigint null,
        percentSavings float null,
        totalNumOfFiles bigint null,
        scanFileFailures int,
		scanFolderFailures int,
		backupFileFailures int,
		backupFolderFailures int,
		backupLevel int,
		appTypeId int,								--QSDK needs this because there are a couple of checks done based on appTypeId
		jobDescription varchar(max),
		jobCategory int									--BACKUP, RESTORE or ADMIN
	)
	DECLARE @i_startRowNum INT = 0
	DECLARE @i_endRowNum INT = 0
	DECLARE @i_limit INT = 0
	DECLARE @DELIMITER VARCHAR(1) = ' '
	DECLARE @JOB_REASON_DELIMITER VARCHAR(7) = '!#911#!'
	DECLARE @GRAPH_VAL_DELIMITER VARCHAR(7) = '!#100#!'
	--DECLARE @i_eventMessageId INT = 0
	DECLARE @i_defaultBkpSetId INT = 0
	DECLARE @i_defaultSubclientId INT = 0
	-- Perf: eliminated the ISNULL checks
	DECLARE @showSyncRestores INT = 0
	SELECT
		@showSyncRestores = CAST(value AS INT)
	FROM GXGlobalParam WITH(NOLOCK)
	WHERE
		name = 'JMShowSyncRestoreJobs'
		AND modified = 0
	DECLARE @tblVMJobIds	TABLE (id INT)
	if OBJECT_ID('tempdb.dbo.#JobIdFilter') is not null
		drop table dbo.#JobIdFilter
	create table #JobIdFilter(jobId integer);
	if OBJECT_ID('tempdb.dbo.#JobStatusFilter') is not null
		drop table dbo.#JobStatusFilter
	create table #JobStatusFilter(status varchar(max));
	if OBJECT_ID('tempdb.dbo.#JobTypeFilter') is not null
		drop table dbo.#JobTypeFilter
	create table #JobTypeFilter(jobType integer);
-- Get the input parameters
	INSERT INTO #JobIdFilter
		SELECT ref.value('@val', 'INT')
		FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/jobId') R(ref)
	INSERT INTO #JobStatusFilter
		SELECT ref.value('@val', 'varchar(max)')
		FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/statusList') R(ref)
	INSERT INTO #JobTypeFilter
		SELECT ref.value('@val', 'INT')
		FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/jobTypeList') R(ref)
	IF EXISTS(SELECT 1 FROM #JobTypeFilter WHERE jobType = 4/*BACKUP*/)
	BEGIN
		INSERT INTO #JobTypeFilter (jobType)
		VALUES(59/*SNAP BACKUP*/), (98/*TURBO ARCHIVE*/)
	END
	-- Perf: eliminated the ISNULL checks
	DECLARE @i_filterClientId INT = 0
	SELECT
		@i_filterClientId = ref.value('@clientId', 'INT')
	FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/client') R(ref)
	--We have new generic variable called entity. This variable overrides existing client variable.
	SELECT
		@i_filterClientId = ref.value('@clientId', 'INT')		-- if null will remain set to the above selected @i_filterClientId or default value
	FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/entity') R(ref)
	DECLARE @i_filterSubclientId INT = 0
	SELECT
		@i_filterSubclientId = ref.value('@subclientId', 'VARCHAR(MAX)')
	FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/entity') R(ref)
	DECLARE @i_backupSetId INT = 0
	SELECT
		@i_backupSetId = ref.value('@backupsetId', 'VARCHAR(MAX)')
	FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/entity') R(ref)
	DECLARE @i_apptypeId INT = 0
	SELECT
		@i_apptypeId = ref.value('@applicationId', 'VARCHAR(MAX)')
	FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/entity') R(ref)
	DECLARE @i_instanceId INT = 0
	SELECT
		@i_instanceId = ref.value('@instanceId', 'INT')
	FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/entity') R(ref)
	-- comment this out as @messageId not supported
	--INSERT INTO #JobIdFilter
	--	SELECT DISTINCT jobId
	--	FROM JMFailureReasonMsg  WITH (READUNCOMMITTED)
	--	WHERE messageId = @i_eventMessageId
	-- Perf: eliminated the ISNULL checks
	DECLARE @JobIdFilters INT = 0
	SELECT
		@JobIdFilters = COUNT(*)
	FROM #JobIdFilter
	DECLARE @JobTypeFilters INT = 0
	SELECT
		@JobTypeFilters = COUNT(*)
	FROM #JobTypeFilter
	WHERE @JobIdFilters = 0	-- If JobId filter is present, jobType filter is not effective
	-- Perf: created static tables for temp static data tables.
	-- Insert any new OperationNames
	insert into JMJobOperationNames
		select distinct operation, OpName, 0 from JMOpTable WITH (READUNCOMMITTED) where operation not in (select opType from JMJobOperationNames WITH (READUNCOMMITTED))
	DECLARE @lastCompletedTime INT = 300	--(5*60 SECONDS)
	SELECT
		@lastCompletedTime = ref.value('@completedJobLookupTime', 'INT')
	FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter') R(ref)
	DECLARE @graphJobFromTime INT = 0
	DECLARE @graphJobToTime INT = 0
	DECLARE @doNotSearch INT = 0
	SET @lastCompletedTime = dbo.GetUnixTime(GETUTCDATE()) - @lastCompletedTime
	IF EXISTS(SELECT 1 FROM APP_ClientProp WITH (READUNCOMMITTED) WHERE attrName = 'Virtual Machine GUID' AND modified = 0 AND componentNameId = @i_filterClientId)
	BEGIN
		INSERT INTO @tblVMJobIds
		SELECT jobId
		FROM JMQinetixUpdateStatus WITH (READUNCOMMITTED)
		WHERE clientId = @i_filterClientId
	END
	-- This is not needed for QSDK
	/*IF @i_scope = 1 AND @i_filterClientId <> 0
	BEGIN
		SELECT  @i_defaultBkpSetId = B.id, @i_defaultSubclientId = A.id FROM APP_Application A
		INNER JOIN APP_BackupSetName B ON A.backupSet = B.id
		WHERE A.clientId = @i_filterClientId AND A.appTypeId IN (SELECT appTypeId FROM APP_AppTypeGroupAssoc
												 WHERE appGroupId = 35) -- APPGRP_FileSystemIDA
		AND (B.status&8 = 8) AND (A.subclientStatus&8=8) -- Default
	END*/
	INSERT INTO #JobSummary
		SELECT
			--0,
			CASE
				WHEN ((@i_userId = 0) OR (@i_userId = userId)) THEN 1
				ELSE dbo.isAdminJobVisible(@i_userid,commCellId,archGrpID,jobID,opType,0)
			END,
			userId,
			jobID, opType, clientName, clientName,
			status = jsn.stateName,
			--status=(SELECT stateName FROM JMJobStateNames WITH (READUNCOMMITTED) WHERE stateType = state),
			currentPhaseName, percentcomplete,
			dbo.JMGetLocalizedMessageAndIDFunc(0,failureReason),
			jobStartTime, jobElapsedTime,
			appTypeName=ida.displayName,
			--appTypeName=(SELECT TOP 1 displayName FROM APP_IDAType WITH (READUNCOMMITTED) WHERE type = appType),
			instanceName,
			backupSetName,
			subclientName,
			'black',
			lastUpdateFromClient,
			null,
			uncompBytes,null,null,null,0,0,0,0,ER_BkpLevel,appType, jobDescription, 3			--CVJobCategory::ADMINCATEGORY
		FROM RunningAdminJobs
			INNER JOIN JMJobStateNames jsn WITH (READUNCOMMITTED) ON
				jsn.stateType = state
			INNER JOIN APP_IDAType ida WITH (READUNCOMMITTED) ON
				ida.type = appType
		WHERE
			(
				@i_filterSubclientId = 0
				OR (@i_filterSubclientId = appId)
			)
			AND (
				@i_filterClientId = 0
				OR (@i_filterClientId = clientId)
				OR (jobID in (SELECT id FROM @tblVMJobIds))
			)
			AND (
				@i_apptypeId = 0
				OR (appType = @i_apptypeId)
			) AND (
				@i_instanceId = 0
				OR (instance = @i_instanceId)
			) AND (
				@i_backupSetId = 0
				OR (backupset = @i_backupSetId)
			)
			--AND (@i_userId = 0 OR @i_userId = userId OR dbo.isAdminJobVisible(@i_userId,commCellId,archGrpID,jobID,opType,0)=1)
			AND (
				(@JobIdFilters = 0 AND @JobTypeFilters = 0) --No filters
				OR (@JobIdFilters > 0 AND jobID IN (SELECT jobId FROM #JobIdFilter)) --JobId filters
				OR (@JobTypeFilters > 0 AND optype IN (SELECT jobType FROM #JobTypeFilter)) --OpType filters
			)
		UNION ALL
		SELECT
			--0,
			CASE
				WHEN ((@i_userId = 0) OR (@i_userId = userId)) THEN 1
				ELSE dbo.isBkpJobVisible(@i_userId,commCellId,clientId,appTypeId,instance,backupSet,applicationId)
			END,
			userId,
			jobID, opType, clientName, clientName,
			status=jsn.stateName,
			--status=(SELECT stateName FROM JMJobStateNames WITH (READUNCOMMITTED) WHERE stateType = state),
			currentPhaseName, percentcomplete,
			dbo.JMGetLocalizedMessageAndIDFunc(0,failureReason),
			jobStartTime, jobElapsedTime,
			appTypeName=ida.displayName,
			--appTypeName=(SELECT TOP 1 displayName FROM APP_IDAType WITH (READUNCOMMITTED) WHERE type = appTypeId),
			instanceName,
			backupsetName,
			subclientName,
			'black',
			lastUpdateFromClient,
			null,
			uncompBytes,compBytes,null,filesXfered,ISNULL(scanFileFailures,0),ISNULL(scanFolderFailures,0),
			ISNULL(backupFileFailures,0), ISNULL(backupFolderFailures,0), bkpLevel, appTypeId, jobDescription, 1			--CVJobCategory::BACKUPCATEGORY
		FROM RunningBackups
			INNER JOIN JMJobStateNames jsn WITH (READUNCOMMITTED) ON
				jsn.stateType = state
			INNER JOIN APP_IDAType ida WITH (READUNCOMMITTED) ON
				ida.type = appTypeId
		WHERE
			(
				@i_filterSubclientId = 0
				OR (@i_filterSubclientId = applicationId)
			)
			AND (
				@i_filterClientId = 0
				OR (@i_filterClientId = clientId)
				OR (jobID in (SELECT id FROM @tblVMJobIds))
			)
			AND (
				@i_apptypeId = 0
				OR (appTypeId = @i_apptypeId)
			)
			AND (
				@i_instanceId = 0
				OR (instance = @i_instanceId)
			)
			AND (
				@i_backupSetId = 0
				OR (backupset = @i_backupSetId)
			)
			--AND (@i_userId = 0 OR @i_userId = userId OR dbo.isBkpJobVisible(@i_userId,commCellId,clientId,appTypeId,instance,backupSet,applicationId)=1)
			AND (
				(@JobIdFilters = 0 AND @JobTypeFilters =0 )--No filters
				 OR (@JobIdFilters > 0 AND jobID IN(SELECT jobId FROM #JobIdFilter)) --JobId filters
				 OR (@JobTypeFilters > 0 AND optype IN(SELECT jobType FROM #JobTypeFilter)) --OpType filters
			)
		UNION ALL
		SELECT
			--0,
			CASE
				WHEN ((@i_userId = 0) OR (@i_userId = userId)) THEN 1
				ELSE dbo.isRstJobVisible(@i_userId,commCellId,srcClientid,destClientid,apptype,instanceid,bkpSetId)
			END,
			userId,
			jobID, opType, srcClientName, srcClientName,
			status=jsn.stateName,
			--status=(SELECT stateName FROM JMJobStateNames WITH (READUNCOMMITTED) WHERE stateType = state),
			currentPhaseName, percentcomplete,
			dbo.JMGetLocalizedMessageAndIDFunc(0,failureReason),
			jobStartTime, jobElapsedTime,
			appTypeName=ida.displayName,
			--appTypeName=(SELECT TOP 1 displayName FROM APP_IDAType WITH (READUNCOMMITTED) WHERE type = appType),
			instanceName,
			backupSetName, NULL,'black',lastUpdateFromClient , null,
			totUnCompBytes,totCompBytes,null,totSuccess,0,0,0,0,0, appType, jobDescription, 2					--CVJobCategory::RESTORECATEGORY
		FROM RunningRestores
			INNER JOIN JMJobStateNames jsn WITH (READUNCOMMITTED) ON
				jsn.stateType = state
			INNER JOIN APP_IDAType ida WITH (READUNCOMMITTED) ON
				ida.type = appType
		WHERE
			(
				@i_filterClientId = 0
				OR (@i_filterClientId = srcClientId)
				OR (jobID in (SELECT id FROM @tblVMJobIds))
			)
			AND (
				@i_apptypeId = 0
				OR (appType = @i_apptypeId)
			)
			AND (
				@i_instanceId = 0
				OR (instanceID = @i_instanceId)
			)
			AND (
				@i_backupSetId = 0
				OR (bkpSetID = @i_backupSetId)
			)
			--AND (@i_userId = 0 OR @i_userId = userId OR dbo.isRstJobVisible(@i_userId,commCellId,srcClientid,destClientid,apptype,instanceid,bkpSetId)=1)
			AND ((rstattributes & 0x100 /*JMRST_SYNC_RESTORE*/) = 0) -- Need to exclude running Sync restores
			AND (
				(@JobIdFilters = 0 AND @JobTypeFilters =0) --No filters
				OR (@JobIdFilters > 0 AND jobID IN(SELECT jobId FROM #JobIdFilter)) --JobId filters
				OR (@JobTypeFilters > 0 AND optype IN(SELECT jobType FROM #JobTypeFilter)) --OpType filters
			)
IF @jobIdFilters > 0				-- Need to query Stats table ONLY if queried with jobId.
	INSERT INTO #JobSummary
		SELECT
			--0,
			CASE
				WHEN ((@i_userId = 0) OR (@i_userId = ISNULL((SELECT id FROM UMUsers WITH (READUNCOMMITTED) WHERE login = Username), 0))) THEN 1
				 ELSE dbo.isAdminJobVisible(@i_userId,commCellId,archGrpID,jobID,opType,0)
				END,
			(SELECT id FROM UMUsers WHERE login=UserName),
			jobID,
			opType,
			ISNULL(c.name, ''),
			ISNULL(c.name, ''),
			/*
			clientName = CASE
							WHEN JM.appID = 0 THEN ''
							ELSE ISNULL((SELECT name FROM APP_Client WITH (READUNCOMMITTED) WHERE id = AP.clientId),'')
						END,
			clientName = CASE
							WHEN JM.appID = 0 THEN ''
							ELSE ISNULL((SELECT name FROM APP_Client WITH (READUNCOMMITTED) WHERE id = AP.clientId),'')
						END,
			*/
			status=jsn.stateName,
			--status=(SELECT stateName FROM JMJobStatusNames WITH (READUNCOMMITTED) WHERE stateType = JM.status),
			'', --Current Phase
			100, -- percentComplete
			dbo.JMGetLocalizedMessageAndIDFunc(0, failureReason),	--delayReason
			servStart, --jobStartTime
			servEnd-servStart, --jobElapsedTime
			appTypeName = ISNULL(ida.displayName, ''),
			--appTypeName = CASE
			--				WHEN JM.appID = 0 THEN ''
			--				ELSE ISNULL((SELECT TOP 1 displayName FROM APP_IDAType WITH (READUNCOMMITTED) WHERE type = AP.appTypeId),'')
			--			END,
			instanceName = CASE
								WHEN JM.appID = 0 THEN ''
								ELSE ISNULL((SELECT TOP 1 name FROM APP_InstanceName WITH (READUNCOMMITTED) WHERE id = AP.instance),'')
							END,
			backupSetName = CASE
								WHEN JM.appID = 0 THEN ''
								ELSE ISNULL((SELECT name FROM APP_BackupSetName WITH (READUNCOMMITTED) WHERE id = AP.backupSet),'')
							END,
			subclientName = ISNULL(AP.subclientName,''),
			'black',servEnd, null,
			uncompBytes,
			sizeOnMedia = (select
								CASE
									WHEN ISNULL(SUM(sizeOnMedia),0) >0 THEN  SUM(sizeOnMedia)
									ELSE JM.totalBackupSize
								END
							from JMJobDataStats J WITH (READUNCOMMITTED)
								inner join archGroup AG  WITH (READUNCOMMITTED) on AG.id = J.archGrpId
							where j.jobId  = JM.jobId and j.commCellId = JM.commCellId and j.archGrpCopyId = AG.defaultCopy),
			null,null,0,0,0,0, ER_BkpLevel,
			CASE
				WHEN JM.appID = 0 THEN 0
				ELSE AP.appTypeId
			END,
			(SELECT JMJobStats.jobDescription FROM JMJobStats WITH (READUNCOMMITTED) WHERE JMJobStats.jobId = JM.jobId AND JMJobStats.commCellId = JM.commCellId),
			3					--CVJobCategory::ADMINCATEGORY
		FROM JMAdminJobStatsTable JM  WITH (READUNCOMMITTED)
			INNER JOIN JMJobStatusNames jsn WITH (READUNCOMMITTED) ON
				jsn.stateType = JM.status
			LEFT JOIN APP_Application AP WITH (READUNCOMMITTED) ON
				JM.appID = AP.id
			LEFT OUTER JOIN APP_IDAType ida WITH (READUNCOMMITTED) ON
				JM.appID <> 0
				AND ida.type = AP.appTypeId
			LEFT OUTER JOIN APP_Client c WITH (READUNCOMMITTED) ON
				JM.appID <> 0
				AND c.id = AP.clientId
			LEFT OUTER JOIN (
				SELECT jobId foundJobId
				FROM #JobSummary
			) notJS ON
				notJS.foundJobId = JM.JobId
				AND JM.commcellId = 2
		WHERE
			(JM.commcellId = 2)
			AND (JM.jobID IN(SELECT jobId FROM #JobIdFilter)) --JobId filters
			AND notJS.foundJobId IS NULL
		UNION ALL
		SELECT
			--0,
			CASE
				WHEN ((@i_userId = 0) OR (@i_userId = ISNULL((SELECT id FROM UMUsers WITH (READUNCOMMITTED) WHERE login = Username), 0))) THEN 1
				ELSE dbo.isBkpJobVisible(@i_userId,JM.commCellId,clientId,appTypeId,instance,backupSet,appId)
			END,
			(SELECT id FROM UMUsers WITH (READUNCOMMITTED) WHERE login=username),
			JM.jobID,
			case
				when subOpType > 0 then subOpType
				else JStats.opType
			end,
			ISNULL(c.name, ''),
			ISNULL(c.name, ''),
			/*
			clientName = (SELECT name FROM APP_Client WITH (READUNCOMMITTED) WHERE id = (CASE JM.bkpattributes & 0x100000000 WHEN 0x100000000 THEN JM.targetClientId ELSE AP.clientId END)),
			clientName = (SELECT name FROM APP_Client WITH (READUNCOMMITTED) WHERE id = (CASE JM.bkpattributes & 0x100000000 WHEN 0x100000000 THEN JM.targetClientId ELSE AP.clientId END)),
			*/
			status=jsn.stateName,
			--status=(SELECT stateName FROM JMJobStatusNames WITH (READUNCOMMITTED) WHERE stateType = JM.status),
			'', --Current Phase
			100, -- percentComplete
			dbo.JMGetLocalizedMessageAndIDFunc(0,failureReason),	--pending reason
			servStartDate, --jobStartTime
			servEndDate-servStartDate, --jobElapsedTime
			appTypeName = ISNULL(ida.displayName, ''),
			--appTypeName = (SELECT TOP 1 displayName FROM APP_IDAType WITH (READUNCOMMITTED) WHERE type = AP.appTypeId),
			instanceName = (SELECT name FROM APP_InstanceName WITH (READUNCOMMITTED) WHERE id = Ap.instance),
			backupSetName = (SELECT name FROM APP_BackupSetName WITH (READUNCOMMITTED) WHERE id = AP.backupSet),
			AP.subclientName,'black',servEndDate , null,
			totalUncompBytes,
			sizeOnMedia = (select
								CASE WHEN ISNULL(SUM(sizeOnMedia),0) >0
									THEN  SUM(sizeOnMedia)
									ELSE JM.totalBackupSize
								END
							from JMJobDataStats J WITH (READUNCOMMITTED)
							inner join archGroup AG WITH (READUNCOMMITTED) on AG.id = J.archGrpId
							where j.jobId  = JM.jobId and j.commCellId = JM.commCellId and j.archGrpCopyId = AG.defaultCopy),
			null,totalNumOfFiles,
			ISNULL(scanFileFailures,0),ISNULL(scanFolderFailures,0),ISNULL(backupFileFailures,0), ISNULL(backupFolderFailures,0), bkpLevel,
			AP.appTypeId,
			JStats.jobDescription,
			1				--CVJobCategory::BACKUPCATEGORY
		 FROM JMBkpStats JM  WITH (READUNCOMMITTED)
			INNER JOIN JMJobStatusNames jsn WITH (READUNCOMMITTED) ON
				jsn.stateType = JM.status
			INNER JOIN JMJobStats JStats  WITH (READUNCOMMITTED) ON
				JM.jobId = JStats.jobId
				And JM.CommcellId = JStats.CommcellId
			LEFT JOIN APP_Application AP WITH (READUNCOMMITTED) ON
				JM.appID = AP.id
			LEFT OUTER JOIN APP_IDAType ida WITH (READUNCOMMITTED) ON
				JM.appID <> 0
				AND ida.type = AP.appTypeId
			LEFT OUTER JOIN APP_Client c WITH (READUNCOMMITTED) ON
				c.id = (CASE (JM.bkpattributes & 0x100000000)
							WHEN 0x100000000 THEN JM.targetClientId
							ELSE AP.clientId
						END)
			LEFT OUTER JOIN (
				SELECT jobId foundJobId
				FROM #JobSummary
			) notJS ON
				notJS.foundJobId = JM.JobId
				AND JM.commcellId = 2
		 WHERE
			(JM.commcellId = 2)
			AND (JM.jobID IN(SELECT jobId FROM #JobIdFilter)) --JobId filters
			AND notJS.foundJobId IS NULL
		UNION ALL
		SELECT
			--0,
			CASE
				WHEN ((@i_userId = 0) OR (@i_userId = ISNULL((SELECT id FROM UMUsers WITH (READUNCOMMITTED) WHERE login = Username), 0))) THEN 1
				 ELSE dbo.isRstJobVisible(@i_userId,JM.commCellId,srcClientID,destClientID,appType,instanceID,bkpSetID)
			END,
			(SELECT id FROM UMUsers WITH (READUNCOMMITTED) WHERE login=username),
			JM.jobID,
			JM.opType,
			ISNULL(sc.name, ''),
			ISNULL(dc.name, ''),
			--srcClientName = (SELECT name FROM APP_Client WITH (READUNCOMMITTED) WHERE id = srcClientId),
			--destClientName = (SELECT name FROM APP_Client WITH (READUNCOMMITTED) WHERE id = destClientId),
			status=jsn.stateName,
			--status=(SELECT stateName FROM JMJobStatusNames WHERE stateType = JM.status),
			'', --Current Phase
			100, -- percentComplete
			dbo.JMGetLocalizedMessageAndIDFunc(0,failureReason),	-- delay reason
			servStartTime, --jobStartTime
			servEndTime-servStartTime, --jobElapsedTime
			appTypeName = ida.displayName,
			--appTypeName = (SELECT TOP 1 displayName FROM APP_IDAType WITH (READUNCOMMITTED) WHERE type = JM.appType),
			instanceName = (SELECT name FROM APP_InstanceName WITH (READUNCOMMITTED) WHERE id = JM.instanceId),
			backupSetName = (SELECT name FROM APP_BackupSetName WITH (READUNCOMMITTED) WHERE id = JM.bkpSetID),
			'','black',servEndTime ,
			CASE
				WHEN JM.rstAttributes & 0x100 = 0x100 THEN 'Sync Restore'
				ELSE null
			END,
			isnull(convert(bigint,totUncompBytes_h)*2147483648 + convert(bigint,totUncompBytes_l),0),isnull(convert(bigint,totCompBytes_h)*2147483648 + convert(bigint,totCompBytes_l),0),null,isnull(convert(bigint,totFiles2Xfer_h)*2147483648 + convert(bigint,totFiles2Xfer_l),0),
			0,0,0,0,0,
			JM.appType,
			JStats.jobDescription,
			2				--CVJobCategory::RESTORECATEGORY
		 FROM JMRestoreStats JM WITH (READUNCOMMITTED)
			INNER JOIN JMJobStatusNames jsn WITH (READUNCOMMITTED) ON
				jsn.stateType = JM.status
			INNER JOIN JMJobStats JStats WITH (READUNCOMMITTED) ON
				JM.jobId = JStats.jobId
				AND JM.commCellId = JStats.commCellId
			INNER JOIN APP_IDAType ida WITH (READUNCOMMITTED) ON
				ida.type = JM.appType
			LEFT OUTER JOIN APP_Client sc WITH (READUNCOMMITTED) ON
				sc.id = srcClientId
			LEFT OUTER JOIN APP_Client dc WITH (READUNCOMMITTED) ON
				dc.id = destClientId
			LEFT OUTER JOIN (
				SELECT jobId foundJobId
				FROM #JobSummary
			) notJS ON
				notJS.foundJobId = JM.JobId
				AND JM.commcellId = 2
		 WHERE
			(JM.commcellId = 2)
			AND (JM.jobID IN(SELECT jobId FROM #JobIdFilter)) --JobId filters
			AND notJS.foundJobId IS NULL
		ORDER BY jobID desc
	-- delete the jobs which are not visible
--	DELETE #JobSummary
--	WHERE isVisible = 0
    --FOR VM PROVISIONING JOBS, REMOVE JOBS NOT BELONGING TO USER
	IF ((@i_userId <> 0) AND EXISTS(SELECT 1 FROM #JobTypeFilter WHERE jobType=85))
	BEGIN
		DECLARE @isUserAdmin INT
        EXECUTE sec_isUserAdmin   @i_userId , @isUserAdmin  OUTPUT
		DELETE #JobSummary
		WHERE
			(
				userId <> @i_userId
				AND jobType IN (SELECT jobType FROM #JobTypeFilter WHERE jobType=85)
			)
			AND @isUserAdmin <> 1
	END
	-- This is not needed for QSDK
	/*UPDATE #JobSummary
	SET statusColor = ISNULL((SELECT color FROM JMJobStatusColors WITH (READUNCOMMITTED) WHERE jsStatus = status),'black')*/
	UPDATE js
		SET operationName = jon.opName
	FROM #JobSummary js
		INNER JOIN JMJobOperationNames jon WITH (READUNCOMMITTED) ON
			jon.opType = js.jobType
	WHERE js.operationName IS NULL
	--INSERT LogJobClientList(requesttime,inXml) VALUES(GETDATE(),@i_xml)
	--IF EXISTS (SELECT 1 FROM #JobIdFilter)
	--BEGIN
		--DELETE #JobSummary
		--WHERE jobID NOT IN (SELECT jobId FROM #JobIdFilter)
	--END
	IF EXISTS (SELECT 1 FROM #JobStatusFilter)
	BEGIN
		DELETE #JobSummary
		WHERE status NOT IN (SELECT status FROM #JobStatusFilter)
	END
	IF EXISTS (SELECT 1 FROM #JobTypeFilter)
	BEGIN
		DELETE #JobSummary
		WHERE jobType NOT IN (SELECT jobType FROM #JobTypeFilter)
	END
	/* This is not needed for QSDK
	IF (@i_startRowNUM >= 0 AND @i_endRowNum >0)
	BEGIN
		DELETE #JobSummary
		WHERE (id < @i_startRowNUM OR id >= @i_endRowNum)
	END*/
	-- Set percentsavings
	UPDATE #JobSummary
		SET percentSavings = (CAST ((sizeOfApplication - sizeOfMediaOnDisk) AS FLOAT) /sizeOfApplication) * 100
	where sizeOfApplication is not null and sizeOfMediaOnDisk is not null and sizeOfApplication <> 0
	UPDATE #JobSummary
		SET percentSavings = 0
	WHERE sizeOfMediaOnDisk = 0
	SET @o_xml =(
		ISNULL((SELECT(
					SELECT jobId AS '@jobID',
							operationName as '@opType',
							isVisible as '@isVisible',
							status as '@displayState',
							dbo.EncodeInvalidXMLChar(currentPhaseName) as '@currentPhaseName',
							srcClientName as '@srcClientName',
							ISNULL(apptypeName,'') as '@appTypeName',
							dbo.EncodeInvalidXMLChar(ISNULL(instanceName,'')) as '@instanceName',
							dbo.EncodeInvalidXMLChar(ISNULL(backupsetName,'')) as '@backupSetName',
							dbo.EncodeInvalidXMLChar(ISNULL(subclientName,''))as '@subclientName',
							percentComplete as '@percentComplete',
							backupLevel as '@bkpLevel',
							appTypeId as '@appType',
							dbo.EncodeInvalidXMLChar(ISNULL(pendingCause,'')) as '@failureReason',
							destClientName as '@destClientName',
							ISNULL(jobDescription,'') as '@jobDescription',
							jobCategory as '@jobCategory'
					FROM #JobSummary
					FOR XML PATH('jobs'), TYPE
				)
			FOR XML PATH(''), ROOT('GalaxyUtilities_JobListResponseQSDK')),'<GalaxyUtilities_JobListResponseQSDK/>')
	)
	SELECT @o_xml
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetRunningJobSummaryQSDK')
	delete from GxQscripts where name = 'JMGetRunningJobSummaryQSDK'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRunningJobSummaryQSDK')
	delete from GXDBVersions where aliasname = 'JMGetRunningJobSummaryQSDK'
GO

insert into GXDBVersions values(2, 'JMGetRunningJobSummaryQSDK',  '00010005000200090000', 'JMGetRunningJobSummaryQSDK', '00010005000200090000')
GO

