

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetRunningJobSummaryAsTable.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetRunningJobSummaryAsTable.sp,v $ $Id: JMGetRunningJobSummaryAsTable.sp,v 1.1.2.48.4.1 2021/03/29 15:29:18 sbonilla Exp $";
--
--  +========================================================================+
--  |   Procedure:  JMGetRunningJobSummaryAsTable()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output:
-- 	|
--  |      Return:  xxx
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMGetRunningJobSummaryAsTable')
BEGIN
	print '>>> Drop Stored Procedure: JMGetRunningJobSummaryAsTable <<<'
	drop procedure JMGetRunningJobSummaryAsTable
END
IF EXISTS (select * from GxQscripts where name='JMGetRunningJobSummaryAsTable')
	delete from GxQscripts where name = 'JMGetRunningJobSummaryAsTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRunningJobSummaryAsTable')
	delete from GXDBVersions where aliasname = 'JMGetRunningJobSummaryAsTable'
GO
print '... Creating Procedure: JMGetRunningJobSummaryAsTable'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMGetRunningJobSummaryAsTable
  @i_userId INT,
  @i_xml XML
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @DEFAULT_JOB_COMPLETED_TIME INT = 300
-- TroubleShooting
DECLARE @dynamicSQLPrint INT = 0
SELECT
	@dynamicSQLPrint = 1		-- ROW EXISTS
FROM GXGlobalParam WITH(NOLOCK)
WHERE
	name = 'JMSummaryTroubleShooting'
	AND modified = 0
if OBJECT_ID('tempdb.dbo.#JobSummary') is not null drop table dbo.#JobSummary
	CREATE TABLE #JobSummary  (
		id int,
		userId INT,
		jobId int,
		commcellID int,
		jobType int,
		destClientId int,
		destClientName nvarchar(512),
		clientId int,
		clientName nvarchar(512),
		state int,
		status int,
		statusName varchar(max),
		currentPhaseName varchar(256),
		percentComplete int,
		pendingCause varchar(max),
		jobStartTime int,
		jobElapsedTime int,
		appTypeId int,
		appTypeName nvarchar(256),
		backupSetId int,
		backupsetName nvarchar(256) DEFAULT NULL,
		subclientId int,
		subclientName nvarchar(256) DEFAULT NULL,
		statusColor varchar(10) DEFAULT 'black',
		lastUpdateTime int,
		operationName varchar(256) DEFAULT null,
		sizeOfApplication bigint null,
		sizeOfMediaOnDisk bigint null,
		percentSavings float null,
		totalNumOfFiles bigint null,
		scanFileFailures int,
		scanFolderFailures int,
		backupFileFailures int,
		backupFolderFailures int,
		pendingReason			nvarchar(max),
		backupLevel				int,
		backupLevelName			varchar(256),
		jobSubmitErrorCode		int,
		aged					int,
		pendingReasonErrorCode	varchar(max),
		instanceId				int,
		instanceName			nvarchar(256),
		localizedOperationName	nvarchar(256),
		localizedStatus			nvarchar(256),
		localizedBackupLevel	nvarchar(256),
		isPreemptable int,
		jobEndTime int,
		Username nvarchar(510),
		errorType INTEGER,
		alertColorLevel INTEGER,
		vsaParentJobID BIGINT,
		isAnomalous INT,
		thresholdTime INT,
		bkpAttributes BIGINT DEFAULT NULL,
		clientDisplayName nvarchar(512) DEFAULT NULL,
		destDisplayClientName nvarchar(512) DEFAULT NULL,
		storagePolicyName nvarchar(288) DEFAULT NULL,
		storagePolicyId int DEFAULT 0,
		dataSourceName nvarchar(288) DEFAULT NULL,
		dataSourceId int DEFAULT 0,
		phasePercentagesList nvarchar(512),
		phaseTimingsList nvarchar(512),
		currentPhase int,
		attemptStartTime int,
		stubDataSize BIGINT DEFAULT NULL,
		currentPhaseType bigint,
		totalClients int DEFAULT 0,
		successfullClients int DEFAULT 0,
		skippedClients int DEFAULT 0,
		pendingClients int DEFAULT 0,
		failedClients int DEFAULT 0,
		partialSuccessClients int DEFAULT 0,
		totalInProgressClients int DEFAULT 0,
		distributedAppsClusterType int,
		bkpAttributesEx BIGINT DEFAULT NULL
	)
	-- Paging Parameters
	DECLARE @i_startRowNum INT = 0
	DECLARE @i_endRowNum INT = 0
	DECLARE @i_limit INT = 0
	DECLARE @sortField VARCHAR(MAX) = 'jobId'
	DECLARE @sortDirection INT = 1
	-- Other filters
	DECLARE @DELIMITER VARCHAR(1) = ' '
	DECLARE @JOB_REASON_DELIMITER VARCHAR(7) = '!#911#!'
	DECLARE @GRAPH_VAL_DELIMITER VARCHAR(7) = '!#100#!'
	DECLARE @graphJobFromTime INT = 0
	DECLARE @graphJobToTime INT = 0
	DECLARE @doNotSearch INT = 0
	DECLARE @i_eventMessageId INT = 0
	DECLARE @i_filterClientId INT = 0
	DECLARE @i_filterSubclientId INT = 0
	DECLARE @i_backupSetId INT = 0
	DECLARE @i_apptypeId INT = 0
	DECLARE @i_instanceID INT = 0
	DECLARE @i_mediaAgentId INT = 0
	DECLARE @i_mediaAgentname NVARCHAR(MAX)
	-- change to use BIT instead of INT so that when count(*) > 1, this boolean will be set to 1
	DECLARE @JobIdFilters BIT = 0
	DECLARE @JobTypeFilters BIT = 0
	DECLARE @JobStatusFilters BIT = 0
	DECLARE @clientIdFilters BIT = 0
	DECLARE @dataSourceIdFilters BIT = 0
	DECLARE @backupLevelFilters BIT = 0
	DECLARE @appTypeFilters BIT = 0
	DECLARE @isWorkFlowFilterSet BIT = 0
	DECLARE @showAgedJobs INT = 0
	DECLARE @tblSubclientId	TABLE (bkpSetId INT, appId INT)
	DECLARE @startTimeRangefromTime INT = 0
	DECLARE @startTimeRangetoTime INT = 0
	DECLARE @endTimeRangefromTime INT = 0
	DECLARE @endTimeRangetoTime INT = 0
	DECLARE @scheduleId INT = 0
	DECLARE @hideAdminJobs INT = 0
	DECLARE @schedulePolicyId INT = 0
	DECLARE @entity_clientName VARCHAR(MAX)
	DECLARE @entity_instanceName VARCHAR(MAX)
	DECLARE @entity_backupSetName VARCHAR(MAX)
	DECLARE @entity_subclientName VARCHAR(MAX)
	DECLARE @entity_clientGroupNameFilter VARCHAR(MAX)
	DECLARE @ISclientGroupIdListFilterSet INT = 0
	DECLARE @lastCompletedTime INT
	DECLARE @showAnomalous INT = 0
	DECLARE @username NVARCHAR(150)
	DECLARE @i_scope INT = 0
	DECLARE @i_localeId INT = 0
	DECLARE @i_category INT = 0
	DECLARE @commcellName NVARCHAR(512) = (SELECT aliasName FROM APP_CommCell WHERE id = 2)
	DECLARE @vsaV2ParentJobAttr BIGINT = (CAST(0x40000000 AS BIGINT) | CAST(0x100000000000000 AS BIGINT)) -- JMBKP_EX_PSEUDO_PARENT_JOB | JMBKP_EX_VSA_PARENT_SYNTHFULL
	DECLARE @i_dataSourceId INT = 0
	DECLARE @showOnlyLaptopJobs INT = 0
	DECLARE @showOnlyArchiveBackupsetJobs INT = 0
	DECLARE @i_isActiveJobView INT = 0
	DECLARE @i_viewLevel INT = 0
	-- Global settings
	DECLARE @showSyncRestores INT = ISNULL((SELECT CAST(value AS INT)
										FROM GXGlobalParam WITH (NOLOCK)
										WHERE name = 'JMShowSyncRestoreJobs'
										AND modified = 0), 0)
	DECLARE @isTelstraOEM INT =	ISNULL((SELECT 1
										FROM GXGlobalParam WITH (NOLOCK)
										WHERE name = 'MSP Id'
										AND modified = 0
										AND value = '1'), 0)
	DECLARE @showIndexRestores INT = ISNULL((SELECT CAST(value AS INT)
										FROM GXGlobalParam WITH (NOLOCK)
										WHERE name = 'JMShowIndexRestoreJobs'
										AND modified = 0), 0)
	DECLARE @showPseudoVMJobs INT = ISNULL((SELECT CAST(value AS INT)
										FROM GXGlobalParam WITH (NOLOCK)
										WHERE name = 'JMShowPseudoVMJobs'
										AND modified = 0), 0)
	DECLARE @showPersistentRecoveryJobs INT = ISNULL((SELECT CAST(value AS INT)
										FROM GXGlobalParam WITH (NOLOCK)
										WHERE name = 'showPersistentRecoveryJobs'
										AND modified = 0), 0)
	DECLARE @maxJobsToReturn INT = 1000000 -- 1 million max for now.
	-- Temp tables definitions
	if OBJECT_ID('tempdb.dbo.#JobIdFilter') is not null drop table dbo.#JobIdFilter
	create table #JobIdFilter(jobId integer);
	if OBJECT_ID('tempdb.dbo.#JobStatusFilter') is not null drop table dbo.#JobStatusFilter
	create table #JobStatusFilter(status varchar(max));
	if OBJECT_ID('tempdb.dbo.#JobTypeFilter') is not null drop table dbo.#JobTypeFilter
	create table #JobTypeFilter(jobType integer);
	if OBJECT_ID('tempdb.dbo.#JobStatusIdFilter') is not null drop table dbo.#JobStatusIdFilter
	create table #JobStatusIdFilter(status INT);
	if OBJECT_ID('tempdb.dbo.#JobStateIdFilter') is not null drop table dbo.#JobStateIdFilter
	create table #JobStateIdFilter(state INT);
	if OBJECT_ID('tempdb.dbo.#backupLevelFilter') is not null drop table dbo.#backupLevelFilter
	create table #backupLevelFilter(backupLevel integer);
	if OBJECT_ID('tempdb.dbo.#appTypeFilter') is not null drop table dbo.#appTypeFilter
	create table #appTypeFilter(appType integer);
	if OBJECT_ID('tempdb.dbo.#clientIdFilter') is not null drop table dbo.#clientIdFilter
	create table #clientIdFilter(clientId integer);
	IF OBJECT_ID('tempdb.dbo.#clientGroupListFilter') is not null drop table dbo.#clientGroupListFilter
	create table #clientGroupListFilter(groupId integer PRIMARY KEY);
	IF OBJECT_ID('tempdb.dbo.#dataSourceFilter') is not null drop table dbo.#dataSourceFilter
	create table #dataSourceFilter(dataSourceId integer PRIMARY KEY);
	IF OBJECT_ID(N'tempdb.dbo.#WorkflowIdFilter') IS NOT NULL DROP TABLE #WorkflowIdFilter
	CREATE TABLE #WorkflowIdFilter (workFlowId INTEGER PRIMARY KEY);
	IF OBJECT_ID('tempdb.dbo.#clientGroupXMLListb') is not null drop table dbo.#clientGroupXMLListb
	create table #clientGroupXMLListb
	(
		clientid integer,
		clientGroupList xml
		PRIMARY KEY(clientid)
	);
	IF OBJECT_ID(N'tempdb.dbo.#TempOperationNames') IS NOT NULL
		DROP TABLE #TempOperationNames
	IF OBJECT_ID(N'tempdb.dbo.#TempBkpLevelNames') IS NOT NULL
		DROP TABLE #TempBkpLevelNames
	IF OBJECT_ID(N'tempdb.dbo.#TempStatusNames') IS NOT NULL
		DROP TABLE #TempStatusNames
	IF OBJECT_ID(N'tempdb.dbo.#TempStateNames') IS NOT NULL
		DROP TABLE #TempStateNames
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_Bkp') IS NOT NULL
		DROP TABLE #SecIDANodeAccessTemp_Bkp
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_VM') IS NOT NULL
		DROP TABLE #SecIDANodeAccessTemp_VM
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_Rst') IS NOT NULL
		DROP TABLE #SecIDANodeAccessTemp_Rst
	IF OBJECT_ID(N'tempdb.dbo.#JMCanManageJob_adminObject') IS NOT NULL
		DROP TABLE #JMCanManageJob_adminObject
	IF OBJECT_ID(N'tempdb.dbo.#sec_VMJobIDsList') IS NOT NULL
		DROP TABLE #sec_VMJobIDsList
	IF OBJECT_ID(N'tempdb.dbo.#JobIDsList') IS NOT NULL
		DROP TABLE #JobIDsList
	IF OBJECT_ID('tempdb.dbo.#JMCanManageJob_rstObject') IS NOT NULL
		DROP TABLE dbo.#JMCanManageJob_rstObject
	IF OBJECT_ID('tempdb.dbo.#JMCanManageJob_adminObject') IS NOT NULL
		DROP TABLE dbo.#JMCanManageJob_adminObject
	IF OBJECT_ID('tempdb.dbo.#EntityAssoc') IS NOT NULL
		DROP TABLE #EntityAssoc
	IF OBJECT_ID(N'tempdb.dbo.#AdminFinishedJobIDsList') IS NOT NULL
		DROP TABLE #AdminFinishedJobIDsList
	IF OBJECT_ID('tempdb.dbo.#getUsersInCompanyOutputTbl') IS NOT NULL
		DROP TABLE #getUsersInCompanyOutputTbl
	IF OBJECT_ID(N'tempdb.dbo.#VsaVmStats') IS NOT NULL
		DROP TABLE #VsaVmStats
	IF OBJECT_ID(N'tempdb.dbo.#VsaVmStatusCount') IS NOT NULL
		DROP TABLE #VsaVmStatusCount
	CREATE TABLE #JobIDsList	--Table to get list of jobs to build general view (any agent but not for VM jobs)
	(
		JobID INTEGER,
		commCellID INTEGER,
		PRIMARY KEY(JobID, commCellID)
	)
	CREATE TABLE #AdminFinishedJobIDsList
	(
		JobID INTEGER,
		commCellID INTEGER,
		servEndDate INTEGER,
		PRIMARY KEY(JobID, commCellID)
	)
	CREATE TABLE #sec_VMJobIDsList	--Table to get list of jobs to build VM level view and jobs that ran on VM parent
	(
		JobID INTEGER,
		commCellID INTEGER,
		PRIMARY KEY(JobID, commCellID)
	)
	CREATE TABLE #TempOperationNames
	(
		opType INTEGER,
		opName nvarchar(128)
		PRIMARY KEY(opType)
	)
	CREATE TABLE #TempBkpLevelNames
	(
		bkpLevel INTEGER,
		bkpLevelName nvarchar(128),
		PRIMARY KEY(bkpLevel)
	)
	CREATE TABLE #TempStatusNames
	(
		stateType INTEGER,
		stateName nvarchar(128),
		PRIMARY KEY(stateType)
	)
	CREATE TABLE #TempStateNames
	(
		stateType INTEGER,
		stateName nvarchar(128),
		PRIMARY KEY(stateType)
	)
	CREATE TABLE #SecIDANodeAccessTemp_Bkp
	(
		t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
	)
	CREATE NONCLUSTERED INDEX [#SecIDANodeAccessTemp_Bkp_ClientID] ON [#SecIDANodeAccessTemp_Bkp]([t_clientId] ASC)
	CREATE NONCLUSTERED INDEX [#SecIDANodeAccessTemp_Bkp_subclientId] ON [#SecIDANodeAccessTemp_Bkp]([t_subclientId] ASC)
	CREATE TABLE #SecIDANodeAccessTemp_VM
	(
		t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
	)
	CREATE NONCLUSTERED INDEX [#SecIDANodeAccessTemp_VM_ClientID] ON [#SecIDANodeAccessTemp_VM]([t_clientId] ASC)
create table  #JMCanManageJob_adminObject ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
create table  #JMCanManageJob_rstObject ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	CREATE TABLE #VsaVmStats
	(
		JobID INTEGER,
		commCellID INTEGER,
		totalClients INTEGER,
		successfullClients INTEGER,
		skippedClients INTEGER,
		pendingClients INTEGER,
		failedClients INTEGER,
		partialSuccessClients INTEGER,
		totalInProgressClients INTEGER,
		PRIMARY KEY(JobID, commCellID)
	)
	CREATE TABLE #VsaVmStatusCount
	(
		JobID INTEGER,
		commCellID INTEGER,
		status NVARCHAR(MAX) NOT NULL,
		statusCount INTEGER
	)
	-- Get the input parameters
	-- Global parameters
	SELECT
		@i_scope = ISNULL(ref.value('@scope', 'INT'), 1),
		@i_localeId = ISNULL(ref.value('@localeId', 'INT'), 0),
		@i_category = ISNULL(ref.value('@category', 'INT'), 0),
		@i_isActiveJobView  = ISNULL(ref.value('@isActiveJobView', 'INT'), 0)
	FROM
	@i_xml.nodes('/JobManager_JobListRequest') doc(ref)
	-- Read other input params like paging and sorting
	SELECT
		@i_startRowNum = ISNULL(ref.value('@offset', 'INT'), 0),
		@i_limit = ISNULL(ref.value('@limit', 'INT'), 0),
		@sortField = ISNULL(ref.value('@sortField', 'VARCHAR(64)'), 'jobId'),
		@sortDirection = ISNULL(ref.value('@sortDirection', 'INT'), 1)
	FROM
	@i_xml.nodes('JobManager_JobListRequest/pagingConfig') doc(ref)
	IF @i_limit <> 0
	BEGIN
		SET @i_startRowNum = @i_startRowNum + 1 -- This is done as GUI doesnt want to send 1 as the start :)
		SET @i_endRowNum = @i_startRowNum + @i_limit
	END
	-- To get around nested case statements for dynamic order by clause.
	IF @sortDirection = 1
		SET @sortField = @sortField + 'DESC'
	-- Now read all filters
	INSERT INTO #JobIdFilter
	SELECT ref.value('@val', 'INT')
	FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/jobId') R(ref)
	SELECT
		@i_eventMessageId = ISNULL(ref.value('@messageId', 'INT'), 0),
		@showAgedJobs = ISNULL(ref.value('@showAgedJobs', 'INT'), 1), -- Default is true
		@i_viewLevel = ISNULL(ref.value('@viewLevel', 'INT'), 0)
	FROM @i_xml.nodes('JobManager_JobListRequest/jobFilter') doc(ref)
	INSERT INTO #JobIdFilter
	SELECT DISTINCT jobId  FROM JMFailureReasonMsg
	WHERE messageId = @i_eventMessageId
	SET @JobIdFilters = (SELECT COUNT(*) FROM #JobIdFilter)
	-- If job Id filter is passed, no need to read any other filter
	IF @JobIdFilters = 0
	BEGIN
		INSERT INTO #JobStatusFilter
		SELECT ref.value('@val', 'varchar(256)')
		FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/statusList') R(ref)
		INSERT INTO #JobTypeFilter
		SELECT ref.value('@val', 'INT')
		FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/jobTypeList') R(ref)
		IF EXISTS(SELECT 1 FROM #JobTypeFilter WHERE jobType = 4/*BACKUP*/)
		BEGIN
			-- if calling from JMGetJobCompletedDetails, do not include backup copy
			INSERT INTO #JobTypeFilter VALUES(59), (60), (98), (43), (101), (18), (65), (144), (145), (146) /*SNAP BACKUP, BACKUP COPY,TURBO ARCHIVE, SYSRECOVERYBACKUP, OPEN BACKUP, BACKUP3RD, SNAPBACKUP3RD, BACKUP_ADMIN, SNAP_BACKUP_ADMIN, BACKUP_COPY_ADMIN */
		END
		INSERT INTO #backupLevelFilter
		SELECT ref.value('@val', 'INT')
		FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/backupLevel') R(ref)
		INSERT INTO #clientIdFilter
		SELECT ref.value('@clientId', 'INT')
		FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/clientList') R(ref)
		WHERE ref.value('@clientId', 'INT') IS NOT NULL
		INSERT INTO #appTypeFilter
		SELECT ref.value('@applicationId', 'INT')
		FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/appType') R(ref)
		INSERT INTO #clientGroupListFilter
		SELECT ref.value('@clientGroupId', 'INT')
		FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/clientGroupIdList') R(ref)
		WHERE ref.value('@clientGroupId', 'INT') IS NOT NULL
		SET @ISclientGroupIdListFilterSet = @@ROWCOUNT
		SET @i_filterClientId = ISNULL (( SELECT ref.value('@clientId', 'INT')
						FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/client') R(ref)), 0)
		SELECT
			@i_filterSubclientId = ISNULL(ref.value('@subclientId', 'INT'), 0),
			@i_backupSetId = ISNULL(ref.value('@backupsetId', 'INT'), 0),
			@i_apptypeId = ISNULL(ref.value('@applicationId', 'INT'), 0),
			@i_instanceID = ISNULL(ref.value('@instanceId', 'INT'), 0),
			@i_filterClientId = ISNULL(ref.value('@clientId', 'INT'), @i_filterClientId), --We have new generic variable called entity. This variable overrides existing client variable.
			@i_dataSourceId = ISNULL(ref.value('@dataSourceId', 'INT'), 0),
			@i_mediaAgentId = ISNULL(ref.value('@mediaAgentId', 'INT'), 0)
		FROM
		@i_xml.nodes('JobManager_JobListRequest/jobFilter/entity') doc(ref)
		IF @i_category <> 1	--ACTIVE. Media agent filter is available only for running jobs.
			SET @i_mediaAgentId = 0
		IF @i_mediaAgentId > 0
			SELECT @i_mediaAgentname = name FROM APP_Client WHERE id = @i_mediaAgentId
		IF @i_filterClientId > 0
		BEGIN
			INSERT INTO #clientIdFilter
			SELECT @i_filterClientId
		END
		IF @i_dataSourceId > 0
		BEGIN
			INSERT INTO #dataSourceFilter
			SELECT @i_dataSourceId
			-- datasourceid only apply to following optypes
			/* offline content indexing, data analytics 2, subclient content indexing, online crawl, solr index import, multi node content indexing  */
			INSERT INTO #JobTypeFilter VALUES(53), (112), (113), (130), (143), (124)
		END
		INSERT INTO #WorkflowIdFilter
		SELECT ref.value('@workflowId', 'INT')
		FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/workFlowList') R(ref)
		WHERE ref.value('@workflowId', 'INT') IS NOT NULL
		IF @@ROWCOUNT > 0
			SET @isWorkFlowFilterSet = 1
		SELECT
			@startTimeRangefromTime = ISNULL(ref.value('@fromTime', 'INT'), 0),
			@startTimeRangetoTime = ISNULL(ref.value('@toTime', 'INT'), 0)
		FROM
		@i_xml.nodes('JobManager_JobListRequest/jobFilter/startTimeRange') doc(ref)
		SELECT
			@endTimeRangefromTime = ISNULL(ref.value('@fromTime', 'INT'), 0),
			@endTimeRangetoTime = ISNULL(ref.value('@toTime', 'INT'), 0)
		FROM
		@i_xml.nodes('JobManager_JobListRequest/jobFilter/endTimeRange') doc(ref)
		SELECT
			@entity_clientName = ISNULL(ref.value('@clientName', 'NVARCHAR(256)'), ''),
			@entity_instanceName = ISNULL(ref.value('@instanceName', 'NVARCHAR(256)'), ''),
			@entity_backupSetName = ISNULL(ref.value('@backupSetName', 'NVARCHAR(256)'), ''),
			@entity_subclientName = ISNULL(ref.value('@subclientName', 'NVARCHAR(256)'), ''),
			@entity_clientGroupNameFilter = ISNULL(ref.value('@clientGroupName', 'NVARCHAR(256)'), '')
		FROM
		@i_xml.nodes('JobManager_JobListRequest/jobFilter/entityNamePattern') doc(ref)
		-- Other filters
		SELECT
			@lastCompletedTime = ISNULL(ref.value('@completedJobLookupTime', 'INT'), @DEFAULT_JOB_COMPLETED_TIME),
			@scheduleId = ISNULL (ref.value('@scheduleId', 'INT'), 0),
			@hideAdminJobs = ISNULL (ref.value('@hideAdminJobs', 'INT'), 0),
			@schedulePolicyId = ISNULL (ref.value('@schedulePolicyId', 'INT'), 0),
			@showAnomalous = ISNULL (ref.value('@showAnomalous', 'INT'), 0),
			@i_eventMessageId = ISNULL (ref.value('@messageId', 'INT'), 0),
			@showOnlyLaptopJobs = ISNULL (ref.value('@showOnlyLaptopJobs', 'INT'), 0),
			@showOnlyArchiveBackupsetJobs = ISNULL (ref.value('@showOnlyArchiveBackupsetJobs', 'INT'), 0)
		FROM
		@i_xml.nodes('JobManager_JobListRequest/jobFilter') doc(ref)
		-- Time adjustment
		IF @doNotSearch = 0 AND @endTimeRangefromTime = 0 AND @endTimeRangetoTime = 0
		BEGIN
			SET @endTimeRangetoTime = dbo.GetUnixTime(GETUTCDATE())
			SET @endTimeRangefromTime = @endTimeRangetoTime - @lastCompletedTime
		END
		-- Boolean type values to indicate if filters are present
		SET @clientIdFilters = (SELECT COUNT(*) FROM #clientIdFilter)
		SET @JobTypeFilters = (SELECT COUNT(*) FROM #JobTypeFilter)
		SET @JobStatusFilters = (SELECT COUNT(*) FROM #JobStatusFilter)
		SET @backupLevelFilters = (SELECT COUNT(*) FROM #backupLevelFilter)
		SET @appTypeFilters = (SELECT COUNT(*) FROM #appTypeFilter)
		SET @dataSourceIdFilters = (SELECT COUNT(*) FROM #dataSourceFilter)
	END
	ELSE
	BEGIN
		SET @showSyncRestores = 1 -- If queried by jobID, include sync restores also
	END
	-- Special case - @TODO - Remove such handling
	DECLARE @isUserAdmin INT = 0
	DECLARE @hasVMProvisioningFilter INT = 0
	EXECUTE sec_isUserAdmin   @i_userId , @isUserAdmin  OUTPUT
	--FOR VM PROVISIONING JOBS, REMOVE JOBS NOT BELONGING TO USER
	IF ((@i_userId <> 0) AND EXISTS(SELECT * FROM #JobTypeFilter WHERE jobType=85))
	BEGIN
		SET @hasVMProvisioningFilter = 1
	END
	-- Populate static helper tables
	insert into JMJobOperationNames select distinct operation, OpName, 0 from JMOpTable where operation not in (select optype from JMJobOperationNames)
	INSERT INTO #TempOperationNames
	SELECT opType,CASE WHEN messageId > 0 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId,messageId, 0, 2) ELSE opName END FROM JMJobOperationNames
	UPDATE #TempOperationNames
SET opName = dbo.fn_EvFormatEventMsgText(0, @i_localeId, (2309 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
	WHERE @isTelstraOEM = 1 AND opType = 4
	UPDATE #TempOperationNames
SET opName = dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1615 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
	WHERE opType = 29
	CREATE INDEX IXT ON #TempOperationNames(opType)
	INSERT INTO #TempBkpLevelNames
	SELECT bkpLevel,dbo.fn_EvFormatEventMsgText(0, @i_localeId,messageId, 0, 2) FROM JMBackupLevelNames
DECLARE @transLogLevelName nvarchar(max) = dbo.fn_EvFormatEventMsgText(0, @i_localeId, (774 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
DECLARE @logOnlyLevelName nvarchar(1024) = dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1707 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
	INSERT INTO #TempStatusNames
	SELECT stateType,dbo.fn_EvFormatEventMsgText(0, @i_localeId,messageId, 0, 2) FROM JMJobStatusNames
	INSERT INTO #TempStateNames
	SELECT stateType,dbo.fn_EvFormatEventMsgText(0, @i_localeId,messageId, 0, 2) FROM JMJobStateNames
	SET @username= ISNULL((SELECT TOP 1 [login] FROM UMUsers WHERE id = @i_userId),'')
	-- Filter the entity table based on above filters
	CREATE TABLE #EntityAssoc
	(	ClientID int
		,ClientName nvarchar(255)
		,displayName nvarchar(512)
		,ApptypeID int
		,ApptypeName nvarchar(255)
		,InstanceID int
		,InstanceName nvarchar(512)
		,Backupsetid int
		,BackupSetName nvarchar(128)
		,SubClientID int
		,SubclientName nvarchar(128) ,
		visibility INT
		PRIMARY KEY CLUSTERED (SubclientID))
	-- Optimize security check if jobId filters are used.
	-- Below query is optmized for job history page but not if called repeatedly based on jobids.
	IF @JobIdFilters = 1
	BEGIN
		-- This table is only needed for completed backup jobs to fetch entity names.
		-- In other cases it is also used to do security check and entity filtering but if explicit jobid is passed, this is skipped as an optimization
		-- as populating this table is costly for each job.
		INSERT #EntityAssoc(ClientID, ClientName, displayName, ApptypeID, ApptypeName, InstanceID, InstanceName, backupsetid, BackupSetName, SubClientID, SubclientName, visibility )
		SELECT DISTINCT C.id, C.name, C.displayName, IDA.type, IDA.displayName, INS.id, INS.name, BS.id, BS.name, APP.id, APP.subclientName, 1
		FROM #JobIdFilter JF
			JOIN JMBkpStats JM ON JM.jobId = JF.jobId
			JOIN App_Application APP ON APP.id = JM.appId
			JOIN App_Client C ON C.id = APP.clientId
			JOIN APP_iDAType IDA ON  IDA.type = APP.appTypeId
			JOIN APP_InstanceName INS ON INS.id = APP.instance
			JOIN APP_BackupSetName  BS ON  BS.id  = APP.backupset
	END
	ELSE
	BEGIN
		DECLARE @adminCap INTEGER
		SET @adminCap = POWER(2,1-1) | POWER(2,16-1) | POWER(2,4-1) | POWER(2,8-1) | POWER(2,31-1)
		--POWER(2,EV_SCHEDULE_ADMIN-1) | POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_MANAGE_ARCHIVES-1) | POWER(2,EV_MANAGE_LIBRARY-1) | POWER(2,EV_VISIBILITY-1)
		DECLARE @restoreCap INTEGER
		-- POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_RESTORE_IN_PLACE-1) | POWER(2,EV_RESTORE_OUTOF_PLACE-1) | POWER(2,EV_VISIBILITY-1)
		SET @restoreCap = POWER(2,16-1) | POWER(2,20-1) | POWER(2,22-1) | POWER(2,31-1)
		-- POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_BACKUP-1)| POWER(2,EV_RESTORE_IN_PLACE-1) | POWER(2,EV_RESTORE_OUTOF_PLACE-1) | POWER(2,EV_BROWSE-1)| POWER(2,EV_RUN_REPORTS-1) | POWER(2,EV_VISIBILITY-1)
		exec sec_getIdaObjectsForUser @i_userId,7,0,0,'#SecIDANodeAccessTemp_Bkp',0,'16,12,20,22,13,15,31',0
		-- This is causing VSA jobs to be shown in global views with only apptype filter.
		-- Skip the logic of bubbling up VM rights, if we are not even going to show VSA jobs.
		-- This will fix the bug and help with performance by eliminating this special logic.
		IF (
				@i_viewLevel <> 1  /*LevelView.VMGROUP*/
				AND
				(
					@i_apptypeId = 0 -- No filters
						OR
					@i_apptypeId = 106 -- VSA apptype filter
				)
				AND
				(
					@appTypeFilters = 0 -- No filter list passed
						OR
					EXISTS (SELECT 1 FROM #appTypeFilter WHERE appType = 106) -- VSA filter passed in list
				)
			)
		BEGIN
			-- POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_BACKUP-1)| POWER(2,EV_RESTORE_IN_PLACE-1) | POWER(2,EV_RESTORE_OUTOF_PLACE-1) | POWER(2,EV_BROWSE-1)| POWER(2,EV_RUN_REPORTS-1) | POWER(2,EV_VISIBILITY-1)
			exec sec_getIdaObjectsForUser @i_userId,3,0,0,'#SecIDANodeAccessTemp_VM',0,'16,12,20,22,13,15,31',0
			-- Delete the clients which are either not a VM or not V1
			DELETE SEC
			FROM #SecIDANodeAccessTemp_VM SEC
			LEFT JOIN App_ClientProp CP ON SEC.t_clientId = CP.componentNameId AND CP.attrName = 'Virtual Server Discovered Clients' AND CP.attrVal = '1' AND CP.modified = 0
			--LEFT JOIN App_ClientProp CP2 ON SEC.t_clientId = CP2.componentNameId AND CP2.attrName = 'IndexingV2_VSA' AND CP2.attrVal = '1' AND CP2.modified = 0
			LEFT JOIN APP_IDAName IDA ON IDA.clientId = SEC.t_clientId
			LEFT JOIN APP_IDAProp IPROP ON IPROP.componentNameId = IDA.id AND IPROP.attrName = 'Pseudo Apptype' AND IPROP.modified = 0 AND IPROP.attrVal = '1'
			WHERE CP.id IS NULL -- Not a VM
				  --OR CP2.id IS NOT NULL -- V2 enabled -- Also include V2 clients as they could have V1 jobs run at some point.
				  OR
				  (
						IPROP.id IS NOT NULL -- Is a Pseudo client - It means it is a discovered client that got converted to a VM. So don't count as a VM
						AND
						@i_viewLevel = 0 /*LevelView.NONE*/
				  )
		END
		exec sec_getUserObjects @i_userId,2013,0,'#JMCanManageJob_adminObject'
		exec sec_getUserObjects @i_userId,14033,0,'#JMCanManageJob_adminObject'
		exec sec_getUserObjects @i_userId,2231,0,'#JMCanManageJob_adminObject'
		exec sec_getUserObjects @i_userId,2012,0,'#JMCanManageJob_rstObject'
		DELETE FROM #JMCanManageJob_adminObject
			WHERE  (Capabilities & @adminCap) = 0
		DELETE FROM #JMCanManageJob_rstObject
			WHERE  (Capabilities & @restoreCap) = 0
		-- Convert names to IDs
		IF @JobStatusFilters <> 0
		BEGIN
			INSERT INTO #JobStateIdFilter
			SELECT S.stateType
			FROM JMJobStateNames S
			INNER JOIN #JobStatusFilter F
			ON S.stateName = F.status
			INSERT INTO #JobStatusIdFilter
			SELECT S.stateType
			FROM JMJobStatusNames S
			INNER JOIN #JobStatusFilter F
			ON S.stateName = F.status
		END
		IF @showOnlyLaptopJobs = 1
		BEGIN
			IF @clientIdFilters = 0
			BEGIN
				INSERT INTO #clientIdFilter
				SELECT CL.id FROM App_Client CL WITH (NOLOCK)
WHERE CL.status & CONVERT(INT,0x1000) <> 0
				SET @clientIdFilters = 1 -- Intentionally setting 1, If no entry in table, then return no result.
			END
			ELSE
			BEGIN
				DELETE CF FROM #clientIdFilter CF
				INNER JOIN APP_Client CL ON CF.clientId = CL.id
WHERE CL.status & CONVERT(INT,0x1000) = 0
			END
		END
		IF @showOnlyArchiveBackupsetJobs = 1 AND @clientIdFilters <> 0
    		BEGIN
			INSERT INTO @tblSubclientId
				SELECT DISTINCT APP.backupset, APP.id FROM APP_Application APP WITH(NOLOCK)
					INNER JOIN #clientIdFilter CIF ON CIF.clientId = APP.ClientID
					LEFT JOIN APP_BackupsetProp ABP WITH(NOLOCK) 				-- Get archive subclient.
						ON APP.backupset = ABP.componentNameId
						AND ABP.attrName = 'Is Archiving Enabled'
						AND ABP.attrVal = '1'
						AND ABP.modified = 0
					LEFT JOIN APP_SubclientProp SP WITH (NOLOCK)							-- Get one-pass subclient.
						ON APP.id = SP.componentNameId
						AND SP.attrName = N'Turbo Mode Enable Stubbing'
   					AND SP.cs_attrName = CHECKSUM(N'Turbo Mode Enable Stubbing')
						AND SP.attrVal = '1'
						AND SP.modified = 0
					WHERE ((@appTypeFilters = 0 OR (APP.appTypeId IN (SELECT appType FROM #appTypeFilter)))
							AND (ABP.componentNameId IS NOT NULL OR SP.componentNameId IS NOT NULL))
			UNION
				SELECT DISTINCT APP.backupset, APP.id FROM APP_Application APP WITH(NOLOCK)
					INNER JOIN #clientIdFilter CIF ON CIF.clientId = APP.ClientID
					INNER JOIN APP_SubclientProp SCP_ASP WITH (NOLOCK)				-- Get subclient which associated with subclient policy having archiving rules enabled.
						ON APP.id = SCP_ASP.componentNameId
						AND SCP_ASP.attrName = N'Associated subclient Policy'
   					AND SCP_ASP.cs_attrName = CHECKSUM(N'Associated subclient Policy')
						AND SCP_ASP.attrVal <> '0'
						AND SCP_ASP.modified = 0
					INNER JOIN APP_SubclientProp SP WITH (NOLOCK)
              			ON CAST(SCP_ASP.attrVal AS INT) = SP.componentNameId
              			AND SP.attrName = N'Turbo Mode Enable Stubbing'
              			AND SP.attrVal = '1'
              			AND SP.modified = 0
					LEFT JOIN APP_SubclientProp SCP_PLAN WITH (NOLOCK)
						ON APP.id = SCP_PLAN.componentNameId
						AND SCP_PLAN.attrName = N'Associated Plan'
						AND SCP_PLAN.cs_attrName = CHECKSUM(N'Associated Plan')
						AND SCP_PLAN.attrVal <> '0'
						AND SCP_PLAN.modified = 0
					WHERE ((@appTypeFilters = 0 OR (APP.appTypeId IN (SELECT appType FROM #appTypeFilter)))
							AND SCP_PLAN.componentNameId IS NULL)
    		END
		ELSE IF @i_scope = 1 AND @clientIdFilters <> 0
		BEGIN
			INSERT INTO @tblSubclientId
			SELECT A.backupSet, A.id
			FROM APP_Application A WITH (NOLOCK)
			WHERE A.clientId IN (select clientId from #clientIdFilter)
		END
		ELSE IF @ISclientGroupIdListFilterSet != 0
		BEGIN
			SET @clientIdFilters = @ISclientGroupIdListFilterSet
			INSERT INTO @tblSubclientId
			SELECT A.backupSet, A.id
			FROM APP_Application A WITH (NOLOCK)
			INNER JOIN
			APP_ClientGroupAssoc B WITH (NOLOCK)
			ON A.clientId = B.clientId
			WHERE B.clientgroupid IN (SELECT groupId FROM #clientGroupListFilter)
			INSERT INTO #clientIdFilter
			SELECT DISTINCT clientId
			FROM APP_ClientGroupAssoc
			WHERE clientgroupid IN (SELECT groupId FROM #clientGroupListFilter)
		END
		ELSE IF @entity_clientGroupNameFilter != ''
		BEGIN
			INSERT INTO #clientIdFilter
			SELECT distinct A.clientId
			FROM APP_ClientGroupAssoc A WITH(NOLOCK)
			INNER JOIN
			APP_ClientGroup B WITH(NOLOCK) ON A.clientgroupid = B.id
			WHERE(B.name LIKE '%' + @entity_clientGroupNameFilter + '%')
			SET @clientIdFilters = (SELECT COUNT(*) FROM #clientIdFilter)
			INSERT INTO @tblSubclientId
			SELECT A.backupSet, A.id
			FROM APP_Application A WITH (NOLOCK)
			WHERE A.clientId IN (select clientId from #clientIdFilter)
		END
		IF @clientIdFilters <> 0
		BEGIN
			-- Remove all VMs that are not part of filter.
			DELETE SEC
			FROM #SecIDANodeAccessTemp_VM SEC
			LEFT OUTER JOIN #clientIdFilter CF
								ON CF.clientId =  SEC.t_clientId
			WHERE CF.clientId IS NULL
		END
		-- Now populate the required VM jobs
		-- For VSA, even if user has rights on VM, we should show the VSA job. Only for V1
		IF EXISTS (SELECT 1 FROM #SecIDANodeAccessTemp_VM)
		BEGIN
			IF @i_category IN (0, 2) -- ALL, FINISHED
			BEGIN
				INSERT INTO #sec_VMJobIDsList
				SELECT DISTINCT Q.jobId, Q.commCellId
				FROM JMQinetixUpdateStatus Q
				INNER JOIN JMBkpStats JM ON Q.jobId = JM.jobId AND Q.commcellId = JM.commcellId
				INNER JOIN App_Application APP ON APP.id = JM.appID
				INNER JOIN #SecIDANodeAccessTemp_VM SEC ON Q.clientId = SEC.t_clientId
				WHERE (@clientIdFilters = 0 OR JM.bkpAttributesEx & @vsaV2ParentJobAttr = 0) -- Exclude V2 parents in VM level job history(client filters)
				AND (@i_backupSetId = 0 OR APP.backupset = @i_backupSetId)
				AND (@i_filterSubclientId = 0 OR APP.id = @i_filterSubclientId)
				-- For calendar, look at jobs based on start time and no need to lookup runningjobs or restore jobs
				AND (
						(@endTimeRangefromTime = 0 AND @endTimeRangetoTime = 0)
										OR
						(servEndDate BETWEEN @endTimeRangefromTime AND @endTimeRangetoTime)
					)
				UNION
				SELECT DISTINCT Q.jobId, Q.commCellId
				FROM JMQinetixUpdateStatus Q
				INNER JOIN JMRestoreStats JM ON Q.jobId = JM.jobId AND Q.commcellId = JM.commcellId
				INNER JOIN #SecIDANodeAccessTemp_VM SEC ON Q.clientId = SEC.t_clientId
				WHERE
					(
						(@endTimeRangefromTime = 0 AND @endTimeRangetoTime = 0)
										OR
						(servEndTime BETWEEN @endTimeRangefromTime AND @endTimeRangetoTime)
					)-- No need of other filters for restores as it is taken care in JMActivejobs.spb and JMFinishedJobs.spb
			END
			IF @i_category IN (0, 1) -- ALL, ACTIVE
			BEGIN
				INSERT INTO #sec_VMJobIDsList
				SELECT DISTINCT Q.jobId, Q.commCellId
				FROM JMQinetixUpdateStatus Q
				INNER JOIN RunningBackups JM ON Q.jobId = JM.jobId AND Q.commcellId = JM.commcellId
				INNER JOIN #SecIDANodeAccessTemp_VM SEC ON Q.clientId = SEC.t_clientId
				LEFT JOIN #sec_VMJobIDsList VMJ ON VMJ.jobId = Q.jobId aND VMJ.commcellID = Q.commcellId
				WHERE VMJ.jobId IS NULL
				AND (@i_instanceID = 0 OR JM.instance = @i_instanceID) -- No need of apptype or client filters as it is taken care above in populating #SecIDANodeAccessTemp_VM.
				AND (@i_backupSetId = 0 OR JM.backupset = @i_backupSetId)
				AND (@i_filterSubclientId = 0 OR JM.applicationId = @i_filterSubclientId)
				UNION
				SELECT DISTINCT Q.jobId, Q.commCellId
				FROM JMQinetixUpdateStatus Q
				INNER JOIN RunningRestores JM ON Q.jobId = JM.jobId AND Q.commcellId = JM.commcellId
				INNER JOIN #SecIDANodeAccessTemp_VM SEC ON Q.clientId = SEC.t_clientId
				LEFT JOIN #sec_VMJobIDsList VMJ ON VMJ.jobId = Q.jobId aND VMJ.commcellID = Q.commcellId
				WHERE VMJ.jobId IS NULL -- No need of other filters for restores as it is taken care in JMActivejobs.spb and JMFinishedJobs.spb
			END
		END
		-- Removed OR Clauses by using Dymanic SQL to improve performance by converting SCAN to SEEK Ops
		DECLARE @whereClause2 NVARCHAR(MAX) = ''
		DECLARE @wcAND NVARCHAR(10) = '	AND '
		IF (@clientIdFilters > 0)
		BEGIN
			SET @whereClause2 = '
				c.id in (select clientId from #clientIdFilter)
			'
		END
		IF (@i_apptypeId > 0)
		BEGIN
			IF (@whereClause2 <> '')
			BEGIN
				SET @whereClause2 += @wcAND
			END
			SET @whereClause2 += CAST(@i_apptypeId AS NVARCHAR(12)) + ' = t_appTypeId
			'
		END
		IF (@i_instanceID > 0)
		BEGIN
			IF (@whereClause2 <> '')
			BEGIN
				SET @whereClause2 += @wcAND
			END
			SET @whereClause2 += CAST(@i_instanceID AS NVARCHAR(12)) + ' = t_instanceId
			'
		END
		IF (@i_backupSetId > 0)
		BEGIN
			IF (@whereClause2 <> '')
			BEGIN
				SET @whereClause2 += @wcAND
			END
			SET @whereClause2 += CAST(@i_backupSetId AS NVARCHAR(12)) + ' = t_backupsetId
			'
		END
		IF (@i_filterSubclientId > 0)
		BEGIN
			IF (@whereClause2 <> '')
			BEGIN
				SET @whereClause2 += @wcAND
			END
			SET @whereClause2 += CAST(@i_filterSubclientId AS NVARCHAR(12)) + ' = t_subclientId
			'
		END
		IF (@whereClause2 = '')
		BEGIN
			SET @whereClause2 = ' 1 = 1 '
		END
		DECLARE @sqlCmd NVARCHAR(MAX) = '
			INSERT #EntityAssoc(ClientID,ClientName,displayName,ApptypeID ,ApptypeName ,InstanceID ,InstanceName ,backupsetid ,BackupSetName ,SubClientID ,SubclientName,visibility )
			SELECT DISTINCT
				C.id,C.name, C.displayName, sec.t_appTypeId ,ida.name ,sec.t_instanceId ,inst.name ,sec.t_backupsetId ,bs.name ,sec.t_subclientId ,app.subclientName, 1
			FROM #SecIDANodeAccessTemp_Bkp Sec
				JOIN App_Client C on c.id=sec.t_clientId
				JOIN APP_iDAType IDA on  ida.type =sec.t_appTypeId
				JOIN APP_InstanceName Inst on Inst.id =sec.t_instanceId
				JOIN APP_BackupSetName  BS on  bs.id  =sec.t_backupsetId
				JOIN app_application   app on  app.id  =sec.t_subclientId
			WHERE
		' + @whereClause2
		IF (@dynamicSQLPrint = 1)
		BEGIN
			PRINT 'JMJobSummaryPrologue: sqlCmd [
			' + @sqlCmd + '
			]'
		END
		EXEC(@sqlCmd)
		IF @appTypeFilters <> 0
			DELETE FROM #EntityAssoc WHERE  appTypeId NOT IN (SELECT appType FROM #appTypeFilter)
		IF @i_scope = 1 AND  @clientIdFilters = 1
			DELETE FROM #EntityAssoc  WHERE SubClientID NOT IN (SELECT appId FROM @tblSubclientId)
		IF EXISTS(SELECT 1 FROM #sec_VMJobIDsList)
		BEGIN
			-- Insert VSA clients for corresponding VM level clients also for jobs to show up
			-- All filtering is already applied on the table #sec_VMJobIDsList so we dont really need a where clause or join with VM entity table #SecIDANodeAccessTemp_VM.
			SET @sqlCmd = '
				INSERT #EntityAssoc(ClientID,ClientName, displayName, ApptypeID ,ApptypeName ,InstanceID ,InstanceName ,backupsetid ,BackupSetName ,SubClientID ,SubclientName,visibility )
				SELECT DISTINCT
					APP.clientId, C.name, C.displayName, APP.appTypeId, IDA.name ,APP.instance, Inst.name, APP.backupSet, BS.name, APP.id,APP.subclientName, 0
				FROM #sec_VMJobIDsList VM
					JOIN JMBkpStats JBS ON JBS.jobId = VM.jobId AND JBS.commcellId = VM.commcellId
					JOIN APP_Application APP ON APP.id = JBS.appId
					JOIN App_Client C on c.id=APP.clientId
					JOIN APP_iDAType IDA on  ida.type =APP.appTypeId
					JOIN APP_InstanceName Inst on Inst.id = APP.instance
					JOIN APP_BackupSetName  BS on  bs.id  = APP.backupSet
					LEFT JOIN #EntityAssoc Ea on Ea.SubClientID =app.id
				WHERE
					EA.SubClientID IS NULL
			'
			IF (@dynamicSQLPrint = 1)
			BEGIN
				PRINT 'JMJobSummaryPrologue: sqlCmd [
				' + @sqlCmd + '
				]'
			END
			EXEC(@sqlCmd)
		END
		IF @entity_clientName != ''
		BEGIN
			DELETE #EntityAssoc
			WHERE (clientName NOT LIKE '%' + @entity_clientName + '%')
		END
		IF @entity_instanceName != ''
		BEGIN
			DELETE #EntityAssoc
			WHERE (instanceName NOT LIKE '%' + @entity_instanceName + '%')
		END
		IF @entity_backupSetName != ''
		BEGIN
			DELETE #EntityAssoc
			WHERE (backupsetName NOT LIKE '%' + @entity_backupSetName + '%')
		END
		IF @entity_subclientName != ''
		BEGIN
			DELETE #EntityAssoc
			WHERE (subclientName NOT LIKE '%' + @entity_subclientName + '%')
		END
	END
	--Tenant admin should be able to view jobs submitted by other users in the company.
	CREATE TABLE #getUsersInCompanyOutputTbl (
		userId INTEGER,
		PRIMARY KEY(userId)
	)
	--Populates #getUsersInCompanyOutputTbl
	EXEC sec_getUsersInCompany @i_userId
	SET @maxJobsToReturn = ISNULL((SELECT CAST(value AS INT)
										FROM GXGlobalParam WITH (NOLOCK)
										WHERE name = 'JMLimitMaxJobsInJobHistory'
										AND modified = 0), 10000) -- Limit to ten thousand jobs in admin console.
	IF @i_category IN (0, 2) -- ALL, FINISHED
	BEGIN
		-- First check completed jobs
	DELETE FROM #JobIDsList
	DELETE FROM #AdminFinishedJobIDsList
	-- Populate the jobs in table first.
	IF @JobIdFilters = 1
	BEGIN
		-- If job ID filters are passed, do simple check to avoid loading all security entities in memory.
		-- Completed admin jobs
		INSERT INTO  #JobIDsList
		SELECT TOP (@maxJobsToReturn) jobId, commCellId
		FROM
		(
			SELECT DISTINCT TOP (@maxJobsToReturn) JM.jobId, JM.commCellId, JM.servEnd AS endTime
			FROM #JobIdFilter JF
			INNER JOIN JMAdminJobStatsTable JM ON JM.jobId = JF.jobId
			LEFT JOIN #getUsersInCompanyOutputTbl UIC ON UIC.userId = (SELECT id FROM UMUsers WHERE login=JM.UserName)
			LEFT JOIN JMQinetixUpdateStatus Q ON JM.jobId = Q.jobId and JM.commcellId = Q.commcellId
			WHERE (
					@username =UserName
					OR
					UIC.userId IS NOT NULL
					OR
					(dbo.isAdminJobVisible(@i_userId,JM.commCellId,archGrpID,JM.jobID,opType,
									CASE WHEN opType IN (35,67,68) THEN Q.clientId ELSE 0 END) = 1) -- Install jobs
					)
			ORDER BY JM.servEnd DESC
			UNION ALL
			SELECT DISTINCT TOP(@maxJobsToReturn) JM.jobId, JM.commCellId, JM.servEndDate AS endTime
			FROM #JobIdFilter JF
			INNER JOIN JMBkpStats JM ON JM.jobId = JF.jobId
			INNER JOIN App_Application APP ON JM.appId = APP.id
			LEFT JOIN JMQinetixUpdateStatus Q ON JM.jobId = Q.jobId and JM.commcellId = Q.commcellId
			WHERE (
					@username =UserName
					OR
					(dbo.isBkpJobVisible(@i_userId,JM.commCellId,APP.clientId,appType,instance,backupSet,appID) = 1)
					OR
					(dbo.isClientVisible(@i_userId,Q.clientId, 0, 0, 0, 0) = 1) -- For VSA V1 level rights
				  )
			ORDER BY JM.servEndDate DESC
			UNION ALL
			SELECT DISTINCT TOP (@maxJobsToReturn) JM.jobId, JM.commCellId, JM.servEndTime AS endTime
			FROM #JobIdFilter JF
			INNER JOIN JMRestoreStats JM ON JM.jobId = JF.jobId
			WHERE (
					@username =UserName
					OR
					(dbo.isRstJobVisible(@i_userId,commCellId,srcClientID,destClientID,appType,instanceID,bkpSetID) = 1)
				  )
			ORDER BY JM.servEndTime DESC
		)TMP
		ORDER BY endTime DESC
	END
	ELSE
	BEGIN
		-- Completed admin jobs
		IF (@hideAdminJobs = 0 )
		BEGIN
			INSERT INTO  #AdminFinishedJobIDsList
			SELECT DISTINCT TOP (@maxJobsToReturn) JM.jobId, JM.commCellId, JM.servEnd AS endTime
				FROM JMAdminJobStatsTable JM
				INNER JOIN JMJobStats JStats ON JM.jobId = JStats.jobId And JM.CommcellId = JStats.CommcellId
				LEFT JOIN APP_Application AP ON JM.appID = AP.id
				LEFT JOIN TM_SubTask ST ON ST.subTaskId = JM.subTaskId
				LEFT JOIN #getUsersInCompanyOutputTbl UIC ON UIC.userId = (SELECT id FROM UMUsers WHERE login=JM.UserName)
				LEFT OUTER JOIN JMQinetixUpdateStatus QUS ON QUS.jobId = JM.jobID AND QUS.commCellId = JM.commCellId
				WHERE  (
							(@endTimeRangefromTime = 0 AND @endTimeRangetoTime = 0)
										OR
							(servEnd BETWEEN @endTimeRangefromTime AND @endTimeRangetoTime)
					   )
				AND (@i_apptypeId = 0 OR @i_apptypeId = appTypeId )
				AND (@i_instanceID = 0 OR @i_instanceID = (CASE WHEN JM.appID = 0 THEN 0 ELSE AP.instance END))
				AND (@i_backupSetId = 0 OR @i_backupSetId = (CASE WHEN JM.appID = 0 THEN 0 ELSE AP.backupSet END) )
				AND (@i_filterSubclientId = 0 OR @i_filterSubclientId = AP.id)
				AND (
						@clientIdFilters = 0
									OR
						(AP.clientId IN (select clientId from #clientIdFilter) AND (@i_scope <> 1 OR JM.appID IN (SELECT appId FROM @tblSubclientId) OR JM.appID = 0))
									OR
						(QUS.clientId IN (SELECT clientId from #clientIdFilter))
					)
				AND (
						(@JobIdFilters = 0 AND @JobTypeFilters =0 AND @JobStatusFilters = 0) --No filters
														OR
						(
							(@JobTypeFilters = 0 OR (JStats.optype IN(SELECT jobType FROM #JobTypeFilter) AND JStats.subOpType = 0) OR JStats.subOpType IN(SELECT jobType FROM #JobTypeFilter))
														AND
							(@JobStatusFilters = 0 OR JM.status IN(SELECT status FROM #JobStatusIdFilter))
						)
				)
				AND
					(
						@i_userId = 0
						OR
						@i_userId = (SELECT id FROM UMUsers WHERE login=UserName)
						OR
						UIC.userId IS NOT NULL
						OR EXISTS
						(
							SELECT 1 FROM #JMCanManageJob_adminObject userObject
							WHERE
								(JM.opType = 85 AND (@hasVMProvisioningFilter = 1 AND @isUserAdmin = 1))
							UNION
							SELECT 1 FROM #JMCanManageJob_adminObject userObject
							WHERE
								(JM.opType = 90 AND JM.workFlowID <> 0 AND userObject.workflowId = JM.workFlowID)
							UNION
							SELECT 1 FROM #JMCanManageJob_adminObject userObject
							WHERE
								(JM.opType IN (104,13) AND JM.archGrpId <> 0 AND userObject.archGroupId = JM.archGrpId)
							UNION
							SELECT 1 FROM #JMCanManageJob_adminObject userObject
							WHERE
(userObject.commCellId=2 AND userObject.clientGroupId=0 AND userObject.clientId=0 AND userObject.appTypeId=0 AND userObject.instanceId=0 AND userObject.backupsetId=0 AND userObject.subClientId=0 AND userObject.mediaAgentId=0 AND userObject.libraryId=0 AND userObject.archGroupId=0 AND userObject.vtContainerId=0 AND userObject.vtPolicyId=0 AND userObject.vtShelfId=0 AND userObject.reviewSetId=0 AND userObject.querySetId=0 AND userObject.downloadSetId=0 AND userObject.ermId=0 AND userObject.legalHoldId=0 AND userObject.tagId=0 AND userObject.cdPolicyId=0 AND userObject.complianceReportId=0 AND userObject.taskId=0 AND userObject.workflowId=0 AND userObject.logMonitoringPolicyId=0 AND userObject.arrayId=0 AND userObject.cloudId=0 AND userObject.userGroupId=0 AND userObject.providerId=0 AND userObject.entityId1=0 AND userObject.entityId2=0 AND userObject.entityId3=0 AND userObject.entityId4=0 AND userObject.entityId5=0									AND userObject.entityId6=0 AND userObject.entityId7=0 AND userObject.entityId8=0 AND userObject.entityId9=0)
							UNION
							SELECT 1 FROM #JMCanManageJob_adminObject userObject
							WHERE
								(JM.opType IN (21,32,41,42,46,47)  AND (libraryId =-10 OR userObject.libraryId IN (SELECT attributeValueInt FROM JMJobOptions WITH(NOLOCK) WHERE jobId = JM.jobID AND commCellId = JM.commCellId AND attributeId = 10)))
							UNION
							-- For subclient level jobs, check for backup rights
							SELECT 1 FROM #EntityAssoc bkpObjects
							WHERE
								(JM.opType IN (134, 139, 113, 112, 130) AND bkpObjects.SubClientID = JM.appId)
						)
					)
				AND (@showAgedJobs = 1 OR (JM.dataStatus NOT IN (1, 2)) OR (JM.dataStatus IN (1, 2) AND JM.status IN (2, 4)))
				AND NOT EXISTS(Select 1 from #JobSummary T Where T.JobId = JM.JobId And 2 = JM.commcellId)
				AND (
					(@appTypeFilters = 0)
				)
				AND (
					(@scheduleId = 0)
									OR
				(JM.subTaskId = @scheduleId)
				)
				AND (
					(@schedulePolicyId = 0)
									OR
					(ST.taskId = @schedulePolicyId)
				)
				AND (
					(@dataSourceIdFilters = 0)
									OR
					( (JStats.optype IN(SELECT jobType FROM #JobTypeFilter) OR JStats.subOpType IN(SELECT jobType FROM #JobTypeFilter))
						AND JM.LibraryId in (SELECT dataSourceId FROM #dataSourceFilter))
				)
				AND (@isWorkFlowFilterSet = 0 OR JM.workFlowId IN (SELECT workFlowId FROM #WorkflowIdFilter))
				ORDER BY JM.servEnd DESC
		END
		INSERT INTO #JobIDsList
		SELECT TOP (@maxJobsToReturn) jobId, commCellId
		FROM
		(
			SELECT  AFJ.jobId, AFJ.commCellId, AFJ.servEndDate AS endTime
			FROM #AdminFinishedJobIDsList AFJ
		UNION ALL
			SELECT DISTINCT TOP(@maxJobsToReturn) JM.jobId, JM.commCellId, JM.servEndDate AS endTime
			FROM JMBkpStats JM
			INNER JOIN JMJobStats JStats ON JM.jobId = JStats.jobId And JM.CommcellId = JStats.CommcellId
			LEFT JOIN TM_SubTask ST ON ST.subTaskId = JM.subTaskId
			INNER JOIN #EntityAssoc EA ON EA.SubClientID =JM.appId
			LEFT OUTER JOIN #sec_VMJobIDsList SJ ON SJ.jobId = JM.jobId AND SJ.commcellId = JM.commcellId
			WHERE (
						(@endTimeRangefromTime = 0 AND @endTimeRangetoTime = 0)
									OR
						(servEndDate BETWEEN @endTimeRangefromTime AND @endTimeRangetoTime)
				   )
			AND (
					(@JobIdFilters = 0 AND @JobTypeFilters =0 AND @JobStatusFilters = 0) --No filters
													OR
					(
   						(@JobTypeFilters = 0 OR JStats.optype IN(SELECT jobType FROM #JobTypeFilter) OR JStats.subOpType IN(SELECT jobType FROM #JobTypeFilter))
													AND
						(@JobStatusFilters = 0 OR JM.status IN(SELECT status FROM #JobStatusIdFilter))
					)
				)
			AND (
					(JM.appType <> 106 AND username = @username) -- For VM level, V2 parent jobs end up showing for users as they have started it. So exclude VSA.
					OR
					EA.visibility = 1
					OR
					SJ.jobId IS NOT NULL -- VM level security
				)
			AND (@showAgedJobs = 1 OR (JM.dataStatus NOT IN (1, 2)) OR (JM.dataStatus IN (1, 2) AND JM.status IN (2, 4)))
			-- active job view, show VM Pseudo job only if key JMShowPseudoVMJobs was on
			AND (@showPseudoVMJobs = 1 OR @i_isActiveJobView = 0 OR ( @i_isActiveJobView = 1 AND bkpAttributesEx & 0x4000000 = 0)  )
			AND (
				(@scheduleId = 0)
								OR
				(JM.subTaskId = @scheduleId)
			)
			AND (
				(@schedulePolicyId = 0)
								OR
				(ST.taskId = @schedulePolicyId)
			)
			AND (@dataSourceIdFilters = 0) -- not applicable for backup jobs
			AND (@isWorkFlowFilterSet = 0)
			ORDER BY JM.servEndDate DESC
		UNION ALL
			SELECT DISTINCT TOP (@maxJobsToReturn) JM.jobId, JM.commCellId, JM.servEndTime AS endTime
			FROM JMRestoreStats JM
   			INNER JOIN JMJobStats JStats ON JM.jobId = JStats.jobId And JM.CommcellId = JStats.CommcellId
			LEFT JOIN TM_SubTask ST ON ST.subTaskId = JM.subTaskId
			WHERE (
					(@endTimeRangefromTime = 0 AND @endTimeRangetoTime = 0)
								OR
					(servEndTime BETWEEN @endTimeRangefromTime AND @endTimeRangetoTime)
				 )
			AND (@i_apptypeId = 0 OR @i_apptypeId = appType )
			AND (@i_instanceID = 0 OR @i_instanceID = JM.instanceID)
			AND (@i_backupSetId = 0 OR @i_backupSetId = bkpSetID )
			AND (
					@clientIdFilters = 0
							OR
					(JM.srcClientId IN (select clientId from #clientIdFilter) AND (@i_scope <> 1 OR bkpSetID IN (SELECT bkpSetId FROM @tblSubclientId) OR bkpSetID = 0))
							OR
					JM.jobID in (SELECT jobId FROM #sec_VMJobIDsList)
			)
			AND (
					(@JobIdFilters = 0 AND @JobTypeFilters =0 AND @JobStatusFilters = 0) --No filters
													OR
					(
   						(@JobTypeFilters = 0 OR JStats.optype IN(SELECT jobType FROM #JobTypeFilter) OR JStats.subOpType IN(SELECT jobType FROM #JobTypeFilter))
													AND
						(@JobStatusFilters = 0 OR JM.status IN(SELECT status FROM #JobStatusIdFilter))
					)
			)
			AND (@i_userId = 0 OR username = ISNULL((SELECT TOP 1 [login] FROM UMUsers WHERE id = @i_userId),'') OR
			EXISTS	(
					SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK)
					WHERE
rstUserObject.commCellId=2 AND rstUserObject.clientGroupId=0 AND rstUserObject.clientId=0 AND rstUserObject.appTypeId=0 AND rstUserObject.instanceId=0 AND rstUserObject.backupsetId=0 AND rstUserObject.subClientId=0 AND rstUserObject.mediaAgentId=0 AND rstUserObject.libraryId=0 AND rstUserObject.archGroupId=0 AND rstUserObject.vtContainerId=0 AND rstUserObject.vtPolicyId=0 AND rstUserObject.vtShelfId=0 AND rstUserObject.reviewSetId=0 AND rstUserObject.querySetId=0 AND rstUserObject.downloadSetId=0 AND rstUserObject.ermId=0 AND rstUserObject.legalHoldId=0 AND rstUserObject.tagId=0 AND rstUserObject.cdPolicyId=0 AND rstUserObject.complianceReportId=0 AND rstUserObject.taskId=0 AND rstUserObject.workflowId=0 AND rstUserObject.logMonitoringPolicyId=0 AND rstUserObject.arrayId=0 AND rstUserObject.cloudId=0 AND rstUserObject.userGroupId=0 AND rstUserObject.providerId=0 AND rstUserObject.entityId1=0 AND rstUserObject.entityId2=0 AND rstUserObject.entityId3=0 AND rstUserObject.entityId4=0 AND rstUserObject.entityId5=0									AND rstUserObject.entityId6=0 AND rstUserObject.entityId7=0 AND rstUserObject.entityId8=0 AND rstUserObject.entityId9=0
					UNION
					SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK)
					WHERE
						-- if you have the rights on the destination at any level then you will see the restore job
(rstUserObject.clientId=-10)
					UNION
					SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK)
					WHERE
					(rstUserObject.clientid=destClientID AND destClientID <> 0 AND appType <> 78)  -- For UNC restores from web console, destination client could be 0. Do not use it to check security. Ignore for share point CV_APPTYPE_MS_SHAREPOINTV2_DOC
					UNION
					SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK)
					WHERE
						(rstUserObject.clientid=srcClientID AND apptypeid=0)
					UNION
					SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK)
					WHERE
						(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=0)
					UNION
					SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK)
					WHERE
						(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=0)
					UNION
					SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK)
					WHERE
						(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=bkpSetID AND rstUserObject.subclientid=0) UNION
					SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK)
					WHERE
((rstUserObject.clientgroupid <> 0 AND EXISTS (SELECT TOP 1 1 FROM APP_ClientGroupAssoc WITH(NOLOCK) WHERE (APP_ClientGroupAssoc.clientGroupId = rstUserObject.clientGroupId  OR rstUserObject.clientGroupId=-10) AND (APP_ClientGroupAssoc.clientid=srcClientID OR APP_ClientGroupAssoc.clientid=destClientID))))
					)
			)
			AND ( (@showSyncRestores = 1) OR ((rstattributes & 0x100 /*JMRST_SYNC_RESTORE*/) = 0) ) -- Exclude completes sync restore jobs based on key
			AND ( (@isUserAdmin <> 0 AND @showIndexRestores = 1) OR JM.opType <> 12 /* INDEXRESTORE */ )  -- filter out index restore by default for non-admin
			AND ( @showPersistentRecoveryJobs = 1 OR JM.opType <> 29 /* QUICKDMRST */)	-- filter out presistent recovery jobs by default
			AND NOT EXISTS(Select 1 from #JobSummary T Where T.JobId = JM.JobId And 2 = JM.commcellId)
			AND (
				(@appTypeFilters = 0)
							OR
				(appType IN(SELECT appType FROM #appTypeFilter))
			)
			AND (
				(@scheduleId = 0)
								OR
				(JM.subTaskId = @scheduleId)
			)
			AND (
				(@schedulePolicyId = 0)
								OR
				(ST.taskId = @schedulePolicyId)
			)
			AND (@dataSourceIdFilters = 0) -- not applicable for restore jobs
			AND (@isWorkFlowFilterSet = 0)
			ORDER BY JM.servEndTime DESC
		)TMP
		ORDER BY endTime DESC
	END
		INSERT INTO #JobSummary
		SELECT
		0,
		userId=(SELECT id FROM UMUsers WHERE login=UserName),
		JM.jobID,JM.commcellId,
		case when subOpType > 0 then subOpType else JStats.opType end,
		destClientId = ISNULL((client.id),0),
		destClientName = ISNULL((client.name),''),
		clientId = ISNULL((client.id),0),
		clientName = ISNULL((client.name),''),
		state = 0,
		status = JM.status,
		statusName=(SELECT stateName FROM JMJobStatusNames WHERE stateType = JM.status),
		currentPhaseName='', --Current Phase
		percentComplete=100, -- percentComplete
		pendingCause= '', --dbo.JMGetLocalizedMessageFunc(@i_localeId,failureReason), -- delay reason
		servStart AS jobStartTime, --jobStartTime
		servEnd-servStart as jobElapsedTime, --jobElapsedTime - no separate value for admin jobs
		appTypeId = (CASE WHEN JM.appID = 0 THEN 0 ELSE AP.appTypeId END),
		appTypeName = CASE WHEN JM.appID = 0 THEN '' ELSE ISNULL((SELECT TOP 1 name FROM APP_IDAType WHERE type = AP.appTypeId),'') END,
		backupSetId = (CASE WHEN JM.appID = 0 THEN 0 ELSE AP.backupSet END),
		backupSetName = CASE WHEN JM.appID = 0 THEN '' ELSE ISNULL((SELECT name FROM APP_BackupSetName WITH (READUNCOMMITTED) WHERE id = AP.backupSet),'') END,
		subclientId = JM.appID,
		subclientName = ISNULL(AP.subclientName,''),statusColor ='black',servEnd,
		operationName=(SELECT CASE @isTelstraOEM
									WHEN 1 THEN (CASE WHEN JOP.opType <> 4 THEN JOP.opName ELSE 'Replication' END)
									ELSE (CASE
												WHEN JM.opType = 90 THEN JM.otheropname
												WHEN JM.opType IN (31, 106) AND (JM.ER_BkpLevel & 0x40 /*ARCHIVECHECKFLAGS_DDB_DEFRAG_WITH_DV2_SIMPLIFIED*/ <> 0)
													THEN 'DDB Space Reclamation'
												WHEN JM.opType IN (31, 106) AND JM.cloudid <> 0 THEN 'DDB Verification'
												ELSE JOP.opName
										  END)
							  END
					   FROM JMJobOperationNames JOP WHERE JOP.opType = (case when subOpType > 0 then subOpType else JStats.opType end)),
		sizeOfApplication = (CASE WHEN JM.opType = 104 THEN EX_TotalSuccess ELSE uncompBytes END),
		sizeOnMedia = 0, --(CASE WHEN jobOptions.attributeValueInt IS NULL THEN
								--(select CASE WHEN ISNULL(SUM(sizeOnMedia),0) >0
								--THEN  SUM(sizeOnMedia)
								--ELSE JM.totalBackupSize
								--END
								--from JMJobDataStats J
								--inner join archGroup AG on AG.id = J.archGrpId
								--where j.jobId  = JM.jobId and j.commCellId = JM.commCellId and j.archGrpCopyId = AG.defaultCopy)
							--ELSE jobOptions.attributeValueInt END),
		percentSavings=null,totalNumOfFiles=(CASE WHEN subOpType = 130 /*ONLINE_CRAWL*/ THEN JM.EX_TotalSuccess WHEN subOpType = 143 /*SOLR_INDEX_IMPORT*/ THEN JM.EX_TotalMedia ELSE JM.numFiles END),
					scanFileFailures=(CASE WHEN (subOpType = 130 /*ONLINE_CRAWL*/ OR subOpType = 143 /*SOLR_INDEX_IMPORT*/) THEN JM.EX_TotalFailures ELSE 0 END),
		scanFolderFailures=0,backupFileFailures=0,backupFolderFailures=0,
		pendingReason = failureReason, backupLevel = JM.ER_BkpLevel, backupLevelName = (SELECT bkpLevelName FROM JMBackupLevelNames BK WHERE BK.bkpLevel = JM.ER_BkpLevel), jobSubmitErrorCode = 0,
		aged = CASE
				WHEN JM.dataStatus IN (1, 2) THEN 1
				ELSE 0
			   END,
		pendingReasonErrorCode = '',
		instanceId = (CASE WHEN JM.appID = 0 THEN 0 ELSE AP.instance END),
		instanceName = CASE WHEN JM.appID = 0 THEN '' ELSE ISNULL((SELECT name FROM APP_InstanceName WITH (READUNCOMMITTED) WHERE id = AP.instance),'') END,
		localizedOperationName = CASE
									WHEN JM.opType = 90 THEN JM.otheropname
									WHEN JM.opType IN (31, 106) AND (JM.ER_BkpLevel & 0x40 /*ARCHIVECHECKFLAGS_DDB_DEFRAG_WITH_DV2_SIMPLIFIED*/ <> 0)
THEN (SELECT dbo.fn_EvFormatEventMsgText(0, @i_localeId, (4414 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2))
WHEN JM.opType IN (31, 106) AND JM.cloudid <> 0 THEN (SELECT dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3283 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2))
									ELSE COALESCE(opNamesT1.opName,opNamesT2.opName)
								 END,
		localizedStatus = (SELECT JS.stateName FROM #TempStatusNames JS WHERE JS.stateType = JM.status),
		localizedBackupLevel = (SELECT BK.bkpLevelName FROM #TempBkpLevelNames BK WHERE BK.bkpLevel = JM.ER_BkpLevel), isPreemptable = 0, jobEndTime = servEnd, UserName, errorType = 0,alertColorLevel=0,
		vsaParentJobID = 0,
		isAnomalous = CASE WHEN LongRunning.attributeValueInt IS NOT NULL AND LongRunning.attributeValueInt > 3600 AND  ((JM.servEnd - JM.servStart) > LongRunning.attributeValueInt) THEN 1 END,
		thresholdTime = CASE WHEN LongRunning.attributeValueInt IS NOT NULL AND LongRunning.attributeValueInt > 3600 THEN LongRunning.attributeValueInt END,
		bkpAttributes = NULL,
		clientDisplayName = ISNULL((client.displayName),''),
		destDisplayClientName = NULL,
		storagePolicyName = archGrpName,
		storagePolicyId = archGrpID,
		dataSourceName = NULL,
		dataSourceId = LibraryID,
		phasePercentagesList = NULL,
		phaseTimingsList = NULL,
		currentPhase = 0,
		attemptStartTime = 0,
		stubDataSize = stubSizeOption.attributeValueInt,
		currentPhaseType = NULL,
		totalClients = 0,
		successfullClients = 0,
		skippedClients = 0,
		pendingClients = 0,
		failedClients = 0,
		partialSuccessClients = 0,
		totalInProgressClients = 0,
		distributedAppsClusterType = 0,
		bkpAttributesEx = NULL
		FROM JMAdminJobStatsTable JM
			INNER JOIN JMJobStats JStats ON JM.jobId = JStats.jobId And JM.CommcellId = JStats.CommcellId
			INNER JOIN #JobIDsList JLIST ON JM.jobId = JLIST.jobId And JM.CommcellId = JLIST.CommcellId
			LEFT JOIN APP_Application AP ON JM.appID = AP.id
			LEFT JOIN TM_SubTask ST ON ST.subTaskId = JM.subTaskId
--LEFT OUTER JOIN JMJobOptions jobOptions WITH(NOLOCK) ON JM.jobId = jobOptions.jobId AND JM.commCellId = jobOptions.commCellId AND jobOptions.attributeId = 73
			LEFT OUTER JOIN #TempOperationNames opNamesT1 ON JStats.subOpType > 0 AND opNamesT1.opType = JStats.subOpType
			LEFT OUTER JOIN #TempOperationNames opNamesT2 ON opNamesT2.opType = JStats.opType
			LEFT OUTER JOIN APP_Client client WITH(NOLOCK) ON
				(CASE WHEN JM.opType IN (90, 108) THEN ISNULL(JM.cloudId,0)
					  WHEN JM.opType IN (35, 67, 68) THEN (
														CASE WHEN (select COUNT(0) from JMQinetixUpdateStatus where jobid = JM.jobId and commCellId = JM.commCellId) > 1 THEN 0
															 ELSE ISNULL((select clientId from JMQinetixUpdateStatus where jobid = JM.jobId and commCellId = JM.commCellId), 0)
														END)
					  ELSE ISNULL(AP.clientId,0)
				END) = client.id
LEFT OUTER JOIN JMJobOptions LongRunning ON JM.jobId = LongRunning.jobId AND attributeId = 76
LEFT OUTER JOIN JMJobOptions stubSizeOption WITH(NOLOCK) ON JM.jobId = stubSizeOption.jobId AND JM.commCellId = stubSizeOption.commCellId AND stubSizeOption.attributeId = 26 AND @showOnlyArchiveBackupsetJobs = 1
			WHERE @showAnomalous = 0 OR  (LongRunning.attributeValueInt IS NOT NULL AND (JM.servEnd - JM.servStart) > 3600 AND ((JM.servEnd - JM.servStart) > LongRunning.attributeValueInt)) --Jobs ran for more than 1 hour and exceeds threshold
		TRUNCATE TABLE #VsaVmStats
		TRUNCATE TABLE #VsaVmStatusCount
		-- populate VsaVmStatusCount
		INSERT INTO #VsaVmStatusCount
		SELECT p.jobid, p.commCellId, p.attrval, count(*)
		FROM APP_VMProp p
		INNER JOIN #JobIDsList JLIST ON JLIST.jobId = p.jobId AND JLIST.commcellid = p.commCellId
		WHERE p.attrName = 'vmStatus'
		GROUP BY p.commCellid, p.jobid, p.attrval
		-- populate VsaVmStats
		INSERT INTO #VsaVmStats
		SELECT
		JLIST.jobId,
		JLIST.CommcellId,
		totalClients = CASE WHEN (appType = 106)
			THEN ISNULL((SELECT SUM(statusCount) FROM #VsaVmStatusCount WHERE jobId = JLIST.jobID AND commCellId = JLIST.commcellId), 0)
			ELSE 0 END,
		successfullClients = CASE WHEN (appType = 106)
			THEN ISNULL((SELECT SUM(statusCount) FROM #VsaVmStatusCount WHERE jobId = JLIST.jobID AND commCellId = JLIST.commcellId AND status = '0'), 0)
			ELSE 0 END,
		skippedClients = CASE WHEN (appType = 106)
			THEN ISNULL((SELECT SUM(statusCount) FROM #VsaVmStatusCount WHERE jobId = JLIST.jobID AND commCellId = JLIST.commcellId AND status = '6'), 0)
			ELSE 0 END,
		pendingClients =  CASE WHEN (appType = 106)
			THEN ISNULL((SELECT SUM(statusCount) FROM #VsaVmStatusCount WHERE jobId = JLIST.jobID AND commCellId = JLIST.commcellId AND status IN ('4','5','7','8')), 0)
			ELSE 0 END,
		failedClients = CASE WHEN (appType = 106)
			THEN ISNULL((SELECT SUM(statusCount) FROM #VsaVmStatusCount WHERE jobId = JLIST.jobID AND commCellId = JLIST.commcellId AND status = '1'), 0)
			ELSE 0 END,
		partialSuccessClients = CASE WHEN (appType = 106)
			THEN ISNULL((SELECT SUM(statusCount) FROM #VsaVmStatusCount WHERE jobId = JLIST.jobID AND commCellId = JLIST.commcellId AND status = '3'), 0)
			ELSE 0 END,
		totalInProgressClients = CASE WHEN (appType = 106)
			THEN ISNULL((SELECT SUM(statusCount) FROM #VsaVmStatusCount WHERE jobId = JLIST.jobID AND commCellId = JLIST.commcellId AND status = '2'), 0)
			ELSE 0 END
		FROM #JobIDsList JLIST
		INNER JOIN JMBkpStats JM ON JM.jobId = JLIST.jobId And JM.CommcellId = JLIST.CommcellId
		INSERT INTO #JobSummary
		SELECT
				0,
				userId = username.id,
				JM.jobID, JM.commcellId,
				case when subOpType > 0 then subOpType else JStats.opType end,
				destClientId =   COALESCE(TargetClient.id, EA.clientId),
				destClientName = COALESCE(TargetClient.name,EA.ClientName),
				clientId =    COALESCE(TargetClient.id, EA.clientId),
				clientName = COALESCE(TargetClient.name, EA.ClientName),
				state = 0,
				status = JM.status,
				statusName=(SELECT stateName FROM JMJobStatusNames WHERE stateType = JM.displayStatus),
				currentPhaseName='', --Current Phase
				percentComplete=100, -- percentComplete
				pendingCause= '', --dbo.JMGetLocalizedMessageFunc(@i_localeId,failureReason),
				servStartDate, --jobStartTime
				duration, --jobElapsedTime
				appTypeId = EA.ApptypeID,
				appTypeName = EA.ApptypeName,
				backupSetId = EA.Backupsetid,
				backupSetName = EA.BackupsetName,
				subclientId = EA.SubclientID,
				EA.SubclientName,statusColor ='black',servEndDate ,
				operationName=(SELECT JOP.opName FROM JMJobOperationNames JOP WHERE JOP.opType = case when subOpType > 0 then subOpType else JStats.opType end),
				sizeOfApplication = totalUncompBytes,
				sizeOnMedia =0, --(CASE WHEN jobOptions.attributeValueInt IS NULL THEN
								--(select CASE WHEN ISNULL(SUM(sizeOnMedia),0) >0
								--THEN  SUM(sizeOnMedia)
								--ELSE JM.totalBackupSize
								--END
								--from JMJobDataStats J
								--inner join archGroup AG on AG.id = J.archGrpId
								--where j.jobId  = JM.jobId and j.commCellId = JM.commCellId and j.archGrpCopyId = AG.defaultCopy)
							--ELSE jobOptions.attributeValueInt END),
				percentSavings=null,totalNumOfFiles,
							ISNULL(scanFileFailures,0),ISNULL(scanFolderFailures,0),ISNULL(backupFileFailures,0), ISNULL(backupFolderFailures,0),
				pendingReason = failureReason,
				backupLevel = JM.bkpLevel,
				backupLevelName = (
						CASE WHEN JM.bkpLevel = 2 AND appTypeId IN (5, 81, 126) AND JStats.opType <> 98
							THEN @transLogLevelName
						WHEN JM.bkpLevel = 2 AND appTypeId IN (125) AND NOT (JStats.opType IN (59, 60) AND JM.bkpAttributesEx & 16 = 16) --JMBKP_EX_BLOCK_LEVEL_SNAP = 0x10
							THEN @logOnlyLevelName
						ELSE (SELECT bkpLevelName FROM JMBackupLevelNames BK WHERE BK.bkpLevel = JM.bkpLevel)
						END),
				jobSubmitErrorCode = JM.failureErrorCode,
				aged = CASE
						WHEN JM.dataStatus IN (1, 2) THEN 1
						ELSE 0
					   END,
				pendingReasonErrorCode = '',
				instanceId = EA.InstanceId,
				instanceName = EA.InstanceName,
				localizedOperationName = COALESCE(opNamesT1.opName,opNamesT2.opName),
				localizedStatus = (SELECT JS.stateName FROM #TempStatusNames JS WHERE JS.stateType = JM.status),
				localizedBackupLevel = (
						CASE WHEN JM.bkpLevel = 2 AND appTypeId IN (5, 81, 126) AND JStats.opType <> 98
							THEN @transLogLevelName
						WHEN JM.bkpLevel = 2 AND appTypeId IN (125) AND NOT (JStats.opType IN (59, 60) AND JM.bkpAttributesEx & 16 = 16) --JMBKP_EX_BLOCK_LEVEL_SNAP = 0x10
							THEN @logOnlyLevelName
						ELSE (SELECT BK.bkpLevelName FROM #TempBkpLevelNames BK WHERE BK.bkpLevel = JM.bkpLevel)
						END),
				isPreemptable = 0, jobEndTime = servEndDate, username,errorType = 0,alertColorLevel=0,
				vsaParentJobID = ISNULL(dataLink.parentJobId,0),
				isAnomalous = CASE WHEN THRES.attributeValueInt IS NOT NULL AND THRES.attributeValueInt > 3600 AND  ((JM.servEndDate - JM.servStartDate) > THRES.attributeValueInt) THEN 1 END,
				thresholdTime = CASE WHEN THRES.attributeValueInt IS NOT NULL AND THRES.attributeValueInt > 3600 THEN THRES.attributeValueInt END,
				bkpAttributes,
				clientDisplayName = EA.displayName,
				destDisplayClientName = NULL,
				storagePolicyName = archGroup.name,
				storagePolicyId = JM.dataArchGrpId,
				dataSourceName = NULL,
				dataSourceId = 0,
				phasePercentagesList = NULL,
				phaseTimingsList = NULL,
				currentPhase = 0,
				attemptStartTime = 0,
				stubDataSize = stubSizeOption.attributeValueInt,
				currentPhaseType = NULL,
				VMSTATS.totalClients,
				VMSTATS.successfullClients,
				VMSTATS.skippedClients,
				VMSTATS.pendingClients,
				VMSTATS.failedClients,
				VMSTATS.partialSuccessClients,
				VMSTATS.totalInProgressClients,
				distributedAppsClusterType = DISTCT.attrVal,
				bkpAttributesEx
		 FROM JMBkpStats JM
			INNER JOIN JMJobStats JStats ON JM.jobId = JStats.jobId And JM.CommcellId = JStats.CommcellId
			INNER JOIN #JobIDsList JLIST ON JM.jobId = JLIST.jobId And JM.CommcellId = JLIST.CommcellId
			INNER JOIN #VsaVmStats VMSTATS ON VMSTATS.jobId = JLIST.jobId And VMSTATS.CommcellId = JLIST.CommcellId
			LEFT JOIN TM_SubTask ST ON ST.subTaskId = JM.subTaskId
--LEFT OUTER JOIN JMJobOptions jobOptions WITH(NOLOCK) ON JM.jobId = jobOptions.jobId AND JM.commCellId = jobOptions.commCellId AND jobOptions.attributeId = 73
			LEFT OUTER JOIN #TempOperationNames opNamesT1 ON JStats.subOpType> 0 AND opNamesT1.opType = JStats.subOpType
			LEFT OUTER JOIN #TempOperationNames opNamesT2 ON opNamesT2.opType = JStats.opType
LEFT OUTER JOIN JMJobDataLink dataLink WITH(NOLOCK) ON dataLink.linkType = 7 AND dataLink.commCellId = JM.CommcellId AND dataLink.childJobId = JM.jobId
			LEFT OUTER JOIN (SELECT name, ID, displayName  FROM APP_Client) TargetClient ON TargetClient.id = JM.targetClientId AND  JM.bkpattributes & 0x100000000 = 0x100000000
			LEFT OUTER JOIN (SELECT id,login FROM UMUsers) UserName  ON Username.login = JM.username
			LEFT OUTER JOIN (SELECT id,name FROM archGroup) archGroup ON archGroup.id = JM.dataArchGrpId
			INNER JOIN #EntityAssoc EA ON EA.SubClientID =JM.appId
LEFT OUTER JOIN JMJobOptions THRES ON JM.jobId = THRES.jobId AND attributeId = 76
LEFT OUTER JOIN JMJobOptions stubSizeOption WITH(NOLOCK) ON JM.jobId = stubSizeOption.jobId AND JM.CommcellId = stubSizeOption.commCellId AND stubSizeOption.attributeId = 26 AND @showOnlyArchiveBackupsetJobs = 1
			LEFT OUTER JOIN APP_InstanceProp DISTCT (NOLOCK) ON DISTCT.componentNameId = EA.InstanceId AND DISTCT.attrName = 'Distributed Cluster Type' AND DISTCT.modified = 0
			WHERE @showAnomalous = 0 OR  (THRES.attributeValue IS NOT NULL AND (JM.servEndDate - JM.servStartDate) > 3600 AND ((JM.servEndDate - JM.servStartDate) > THRES.attributeValueInt)) --Jobs ran for more than 1 hour and exceeds threshold
			AND THRES.attributeValueInt > 0
		INSERT INTO #JobSummary
		SELECT
			0,
			userId=(SELECT id FROM UMUsers WHERE login=username),
			JM.jobID, JM.commcellId,
			case when subOpType > 0 then subOpType else JStats.opType end,
			destClientId = destClientId,
			destClientName = ISNULL((destClient.name),''),
			clientId = srcClientId,
			clientName = (SELECT name FROM APP_Client WITH (READUNCOMMITTED) WHERE id = srcClientId),
			state = 0,
			status = JM.status,
			statusName=(SELECT stateName FROM JMJobStatusNames WHERE stateType = JM.status),
			currentPhaseName='', --Current Phase
			percentComplete=100, -- percentComplete
			pendingCause='', --dbo.JMGetLocalizedMessageFunc(@i_localeId,failureReason), -- delay reason
			servStartTime, --jobStartTime
			duration, --jobElapsedTime
			appTypeId = JM.appType,
			appTypeName = CASE WHEN JM.appType = 0 THEN '' ELSE ISNULL((SELECT TOP 1 name FROM APP_IDAType WHERE type = JM.appType),'') END,
			backupSetId = JM.bkpSetID,
			backupSetName = (SELECT name FROM APP_BackupSetName WITH (READUNCOMMITTED) WHERE id = JM.bkpSetID),
			subclientId = 0,
			subclientName='',statusColor ='black',servEndTime ,
			operationName=
			(CASE
				WHEN JM.rstAttributes & 0x100 = 0x100 THEN 'Sync Restore'
				WHEN JM.rstAttributes & 0x1000 = 0x1000 THEN 'Sync Restore'
				WHEN JM.opType = 29 THEN 'Persistent Recovery'
				ELSE (SELECT CASE @isTelstraOEM WHEN 1 THEN (CASE WHEN JOP.opType <> 4 THEN JOP.opName ELSE 'Replication' END) ELSE JOP.opName END FROM JMJobOperationNames JOP WHERE JOP.opType = (case when subOpType > 0 then subOpType else JStats.opType end))
			END),
			sizeOfApplication=isnull(convert(bigint,totUncompBytes_h)*2147483648 + convert(bigint,totUncompBytes_l),0),isnull(convert(bigint,totCompBytes_h)*2147483648 + convert(bigint,totCompBytes_l),0),null,isnull(convert(bigint,totFiles2Xfer_h)*2147483648 + convert(bigint,totFiles2Xfer_l),0),
			scanFileFailures=0,scanFolderFailures=0,backupFileFailures=0,backupFolderFailures=0,
			pendingReason = failureReason, backupLevel = 0, backupLevelName = '', jobSubmitErrorCode = 0, aged = 0, pendingReasonErrorCode = '',
			instanceId = JM.instanceID,
			instanceName = (SELECT name FROM APP_InstanceName WITH (READUNCOMMITTED) WHERE id = JM.instanceID),
			localizedOperationName = (CASE
WHEN JM.rstAttributes & 0x100 = 0x100 THEN (SELECT dbo.fn_EvFormatEventMsgText(0, @i_localeId, (2071 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2))
WHEN JM.rstAttributes & 0x1000 = 0x1000 THEN (SELECT dbo.fn_EvFormatEventMsgText(0, @i_localeId, (2071 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2))
				ELSE COALESCE(opNamesT1.opName,opNamesT2.opName)
			END),
			localizedStatus = (SELECT JS.stateName FROM #TempStatusNames JS WHERE JS.stateType = JM.status),
			localizedBackupLevel = '', isPreemptable = 0, jobEndTime = servEndTime, username,errorType = 0,alertColorLevel=0,
			vsaParentJobID = 0,
			isAnomalous = NULL,
			thresholdTime = NULL,
			bkpAttributes = NULL,
			clientDisplayName = ISNULL((client.displayName),''),
			destDisplayClientName = ISNULL((destClient.displayName),''),
			storagePolicyName = NULL,
			storagePolicyId = 0,
			dataSourceName = NULL,
			dataSourceId = 0,
			phasePercentagesList = NULL,
			phaseTimingsList = NULL,
			currentPhase = 0,
			attemptStartTime = 0,
			stubDataSize = NULL,
			currentPhaseType = NULL,
			totalClients = 0,
			successfullClients = 0,
			skippedClients = 0,
			pendingClients = 0,
			failedClients = 0,
			partialSuccessClients = 0,
			totalInProgressClients = 0,
			distributedAppsClusterType = DISTCT.attrVal,
			bkpAttributesEx = NULL
	 FROM JMRestoreStats JM
		INNER JOIN JMJobStats JStats ON JM.jobId = JStats.jobId And JM.CommcellId = JStats.CommcellId
		INNER JOIN #JobIDsList JLIST ON JM.jobId = JLIST.jobId And JM.CommcellId = JLIST.CommcellId
		LEFT JOIN TM_SubTask ST ON ST.subTaskId = JM.subTaskId
		LEFT OUTER JOIN #TempOperationNames opNamesT1 ON JStats.subOpType > 0 AND opNamesT1.opType = JStats.subOpType
		LEFT OUTER JOIN #TempOperationNames opNamesT2 ON opNamesT2.opType = JStats.opType
		LEFT OUTER JOIN APP_Client client WITH(NOLOCK) ON srcClientId = client.id
		LEFT OUTER JOIN APP_Client destClient WITH(NOLOCK) ON destClientId = destClient.id
		LEFT OUTER JOIN APP_InstanceProp DISTCT (NOLOCK) ON DISTCT.componentNameId = (CASE WHEN JM.instanceID > 1 THEN JM.instanceID ELSE JM.destInstanceId END) AND DISTCT.attrName = 'Distributed Cluster Type' AND DISTCT.modified = 0
		WHERE @showAnomalous = 0
	END
	IF @i_category IN (0, 1) -- ALL, ACTIVE
	BEGIN
		-- Then check running jobs and avoid completed jobs
	DELETE FROM #JobIDsList
	-- Populate the jobs in table first.
	IF @JobIdFilters = 1
	BEGIN
		-- If job ID filters are passed, do simple check to avoid loading all security entities in memory.
		INSERT INTO #JobIDsList
		SELECT DISTINCT RA.jobId, RA.commCellId
		FROM #JobIdFilter JF
		INNER JOIN RunningAdminJobs RA ON JF.jobId = RA.jobId
		LEFT JOIN #getUsersInCompanyOutputTbl UIC ON UIC.userId = RA.userId
		LEFT JOIN JMQinetixUpdateStatus Q ON RA.jobId = Q.jobId and RA.commcellId = Q.commcellId
		WHERE(
				@i_userId = RA.userId
				OR
				UIC.userId IS NOT NULL
				OR
				(dbo.isAdminJobVisible(@i_userId,RA.commCellId,archGrpID,RA.jobID,opType,
						CASE WHEN opType IN (35,67,68) THEN Q.clientId ELSE 0 END) = 1) -- Install jobs
			)
		UNION ALL
		SELECT DISTINCT RB.jobId, RB.commCellId
		FROM #JobIdFilter JF
		INNER JOIN RunningBackups RB ON JF.jobId = RB.jobId
		LEFT JOIN JMQinetixUpdateStatus Q ON RB.jobId = Q.jobId and RB.commcellId = Q.commcellId
		WHERE (
					@i_userId = RB.userId
					OR
					(dbo.isBkpJobVisible(@i_userId,RB.commCellId,RB.clientId,appTypeId,instance,backupSet,applicationId) = 1)
					OR
					(dbo.isClientVisible(@i_userId, Q.clientId, 0, 0, 0, 0) = 1) -- For VSA V1 level rights
				)
		UNION ALL
		SELECT RR.jobId, RR.commcellId
		FROM #JobIdFilter JF
		INNER JOIN RunningRestores RR ON JF.jobId = RR.jobId
		WHERE (
				@i_userId = RR.userId
				OR
				(dbo.isRstJobVisible(@i_userId,commCellId,srcClientID,destClientID,appType,instanceID,bkpSetID) = 1)
			 )
	END
	ELSE
	BEGIN
		-- Running admin jobs
		IF (@hideAdminJobs = 0 )
		BEGIN
			INSERT INTO #JobIDsList
			SELECT DISTINCT RA.jobId, RA.commCellId
			FROM RunningAdminJobs RA
			INNER JOIN JMAdminJobInfoTable JMA ON RA.jobId = JMA.jobId AND RA.commCellId = JMA.commCellId
			INNER JOIN JMJobInfo JI ON RA.jobId = JI.jobId
			LEFT JOIN #getUsersInCompanyOutputTbl UIC ON UIC.userId = RA.userId
			WHERE (@i_apptypeId = 0 OR @i_apptypeId = appType )
			AND (@i_instanceID = 0 OR @i_instanceID = instance)
			AND (@i_backupSetId = 0 OR @i_backupSetId = backupset )
			AND (@i_filterSubclientId = 0 OR @i_filterSubclientId = RA.appId)
			AND (
					@clientIdFilters = 0
							OR
					(RA.clientId IN (select clientId from #clientIdFilter) AND (@i_scope <> 1 OR RA.appId IN (SELECT appId FROM @tblSubclientId) OR RA.appId = 0) )
			)
			AND (
					(@JobIdFilters = 0 AND @JobTypeFilters =0 AND @JobStatusFilters = 0) --No filters
													OR
					(
						(@JobTypeFilters = 0 OR RA.optype IN(SELECT jobType FROM #JobTypeFilter))
													AND
						(@JobStatusFilters = 0 OR RA.displayState IN(SELECT state FROM #JobStateIdFilter))
					)
			)
			AND(
						@i_userId = (SELECT id FROM UMUsers WHERE login=RA.UserName)
							OR
						UIC.userId IS NOT NULL
							OR
						EXISTS
						(
							SELECT 1 FROM #JMCanManageJob_adminObject userObject
							WHERE
								(RA.opType = 85 AND (@hasVMProvisioningFilter = 1 AND @isUserAdmin = 1))
							UNION
							SELECT 1 FROM #JMCanManageJob_adminObject userObject
							WHERE
								(RA.opType = 90 AND JMA.workFlowID <> 0 AND userObject.workflowId = JMA.workFlowID)
							UNION
							SELECT 1 FROM #JMCanManageJob_adminObject userObject
							WHERE
								(RA.opType IN (104,13) AND RA.archGrpId <> 0 AND userObject.archGroupId = RA.archGrpId)
							UNION
							SELECT 1 FROM #JMCanManageJob_adminObject userObject
							WHERE
(userObject.commCellId=2 AND userObject.clientGroupId=0 AND userObject.clientId=0 AND userObject.appTypeId=0 AND userObject.instanceId=0 AND userObject.backupsetId=0 AND userObject.subClientId=0 AND userObject.mediaAgentId=0 AND userObject.libraryId=0 AND userObject.archGroupId=0 AND userObject.vtContainerId=0 AND userObject.vtPolicyId=0 AND userObject.vtShelfId=0 AND userObject.reviewSetId=0 AND userObject.querySetId=0 AND userObject.downloadSetId=0 AND userObject.ermId=0 AND userObject.legalHoldId=0 AND userObject.tagId=0 AND userObject.cdPolicyId=0 AND userObject.complianceReportId=0 AND userObject.taskId=0 AND userObject.workflowId=0 AND userObject.logMonitoringPolicyId=0 AND userObject.arrayId=0 AND userObject.cloudId=0 AND userObject.userGroupId=0 AND userObject.providerId=0 AND userObject.entityId1=0 AND userObject.entityId2=0 AND userObject.entityId3=0 AND userObject.entityId4=0 AND userObject.entityId5=0									AND userObject.entityId6=0 AND userObject.entityId7=0 AND userObject.entityId8=0 AND userObject.entityId9=0)
							UNION
							SELECT 1 FROM #JMCanManageJob_adminObject userObject
							WHERE
								(RA.opType IN (21,32,41,42,46,47)  AND (libraryId =-10 OR userObject.libraryId IN (SELECT attributeValueInt FROM JMJobOptions WITH(NOLOCK) WHERE jobId = RA.jobID AND commCellId = RA.commCellId AND attributeId = 10)))
							UNION
							-- For subclient level jobs, check for backup rights
							SELECT 1 FROM #EntityAssoc bkpObjects
							WHERE
								(RA.opType IN (134, 139, 113, 112, 130) AND bkpObjects.SubClientID = RA.appId)
						)
				)
			AND (
				(@appTypeFilters = 0)
			)
			AND (
				(@scheduleId = 0)
								OR
				(RA.subTaskId = @scheduleId)
			)
			AND (
				(@schedulePolicyId = 0)
								OR
				(RA.taskId = @schedulePolicyId)
			)
			AND (@showAnomalous = 0 OR RA.guiAlertColorLevel >= 100000)
			AND (@i_mediaAgentId = 0 OR @i_mediaAgentname = CAST(RA.srcMediaAgent AS nvarchar) OR @i_mediaAgentname = CAST(RA.destMediaAgent AS nvarchar))
			AND (
				(@dataSourceIdFilters = 0)
								OR
				( (RA.optype  IN(SELECT jobType FROM #JobTypeFilter) )
					AND RA.LibraryId in (SELECT dataSourceId FROM #dataSourceFilter))
			)
			AND (@isWorkFlowFilterSet = 0 OR RA.workFlowId IN (SELECT workFlowId FROM #WorkflowIdFilter))
		END
		INSERT INTO #JobIDsList
		SELECT DISTINCT RB.jobId, RB.commCellId
		FROM RunningBackups RB
		INNER JOIN #EntityAssoc EA ON EA.SubClientID = RB.applicationId
		LEFT OUTER JOIN #sec_VMJobIDsList VMJ ON VMJ.jobId = RB.jobId AND VMJ.commcellId = RB.commcellId
		WHERE (
					(@JobIdFilters = 0 AND @JobTypeFilters =0 AND @JobStatusFilters = 0) --No filters
													OR
					(
						(@JobTypeFilters = 0 OR RB.optype IN(SELECT jobType FROM #JobTypeFilter))
													AND
						(@JobStatusFilters = 0 OR RB.displayState IN(SELECT state FROM #JobStateIdFilter))
					)
				)
			AND (
					(RB.appTypeId <> 106 AND @i_userId = RB.userId ) -- For VM level, V2 parent jobs end up showing for users as they have started it. So exclude VSA.
						OR
					 EA.visibility = 1
						OR
					 VMJ.jobId IS NOT NULL -- VM level client filter means VSA jobs to show up.
				)
			AND (
				(@scheduleId = 0)
								OR
				(backupTaskId = @scheduleId)
				)
			AND (
				(@schedulePolicyId = 0)
								OR
				(taskId = @schedulePolicyId)
			)
			AND (@showAnomalous = 0 OR RB.guiAlertColorLevel >= 100000)
			AND (@i_mediaAgentId = 0 OR @i_mediaAgentname = CAST(RB.mediaAgentName AS nvarchar))
			AND (@dataSourceIdFilters = 0) -- not applicable for backup jobs
			AND (@isWorkFlowFilterSet = 0)
		UNION ALL
		SELECT jobId, commcellId
		FROM RunningRestores RR
		WHERE (@i_apptypeId = 0 OR @i_apptypeId = appType ) AND (@i_instanceID = 0 OR @i_instanceID = RR.instanceID) AND (@i_backupSetId = 0 OR @i_backupSetId = bkpSetID )
				AND (
						@clientIdFilters = 0
							OR
						(srcClientId IN (select clientId from #clientIdFilter) AND (@i_scope <> 1 OR bkpSetID IN (SELECT bkpSetId FROM @tblSubclientId) OR bkpSetID=0))
							OR
						RR.jobID in (SELECT jobId FROM #sec_VMJobIDsList)
				)
				AND (
						(@JobIdFilters = 0 AND @JobTypeFilters =0 AND @JobStatusFilters = 0) --No filters
														OR
						(
							(@JobTypeFilters = 0 OR RR.optype IN(SELECT jobType FROM #JobTypeFilter))
														AND
							(@JobStatusFilters = 0 OR RR.displayState IN(SELECT state FROM #JobStateIdFilter))
						)
				)
				AND (@i_userId = 0 OR @i_userId = RR.userId OR
					EXISTS	(
							SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK)
							WHERE
rstUserObject.commCellId=2 AND rstUserObject.clientGroupId=0 AND rstUserObject.clientId=0 AND rstUserObject.appTypeId=0 AND rstUserObject.instanceId=0 AND rstUserObject.backupsetId=0 AND rstUserObject.subClientId=0 AND rstUserObject.mediaAgentId=0 AND rstUserObject.libraryId=0 AND rstUserObject.archGroupId=0 AND rstUserObject.vtContainerId=0 AND rstUserObject.vtPolicyId=0 AND rstUserObject.vtShelfId=0 AND rstUserObject.reviewSetId=0 AND rstUserObject.querySetId=0 AND rstUserObject.downloadSetId=0 AND rstUserObject.ermId=0 AND rstUserObject.legalHoldId=0 AND rstUserObject.tagId=0 AND rstUserObject.cdPolicyId=0 AND rstUserObject.complianceReportId=0 AND rstUserObject.taskId=0 AND rstUserObject.workflowId=0 AND rstUserObject.logMonitoringPolicyId=0 AND rstUserObject.arrayId=0 AND rstUserObject.cloudId=0 AND rstUserObject.userGroupId=0 AND rstUserObject.providerId=0 AND rstUserObject.entityId1=0 AND rstUserObject.entityId2=0 AND rstUserObject.entityId3=0 AND rstUserObject.entityId4=0 AND rstUserObject.entityId5=0									AND rstUserObject.entityId6=0 AND rstUserObject.entityId7=0 AND rstUserObject.entityId8=0 AND rstUserObject.entityId9=0
							UNION
							SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK)
							WHERE
								-- if you have the rights on the destination at any level then you will see the restore job
(rstUserObject.clientId=-10)
							UNION
							SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK)
							WHERE
								(rstUserObject.clientid=destClientID AND RR.destClientID <> 0 AND RR.appType<>78)  -- For UNC restores from web console, destination client could be 0. Do not use it to check security. Ignore for share point CV_APPTYPE_MS_SHAREPOINTV2_DOC
							UNION
							SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK)
							WHERE
								(rstUserObject.clientid=srcClientID AND apptypeid=0)
							UNION
							SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK)
							WHERE
								(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=0)
							UNION
							SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK)
							WHERE
								(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=0)
							UNION
							SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK)
							WHERE
								(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=bkpSetID AND rstUserObject.subclientid=0) UNION
							SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK)
							WHERE
((rstUserObject.clientgroupid <> 0 AND EXISTS (SELECT TOP 1 1 FROM APP_ClientGroupAssoc WITH(NOLOCK) WHERE (APP_ClientGroupAssoc.clientGroupId = rstUserObject.clientGroupId  OR rstUserObject.clientGroupId=-10) AND (APP_ClientGroupAssoc.clientid=srcClientID OR APP_ClientGroupAssoc.clientid=destClientID))))
							)
					)
				AND ( (@showSyncRestores = 1) OR ((rstattributes & 0x100 /*JMRST_SYNC_RESTORE*/) = 0) ) -- Need to exclude running Sync restores
				AND ( (@isUserAdmin <> 0 AND @showIndexRestores = 1) OR RR.opType <> 12 /* INDEXRESTORE */ )  -- filter out index restore by default for non-admin
				AND (
					(@appTypeFilters = 0)
								OR
					(appType IN(SELECT appType FROM #appTypeFilter))
				)
				AND (
					(@scheduleId = 0)
									OR
					(rstTaskID = @scheduleId)
				)
			AND (
				(@schedulePolicyId = 0)
								OR
				(taskId = @schedulePolicyId)
			)
			AND (@showAnomalous = 0 OR RR.guiAlertColorLevel >= 100000)
			AND (@i_mediaAgentId = 0 OR @i_mediaAgentname = CAST(RR.mediaAgent AS nvarchar))
			AND (@dataSourceIdFilters = 0) -- not applicable for restore jobs
			AND (@isWorkFlowFilterSet = 0)
	END
	INSERT INTO #JobSummary
	SELECT
		0,
		runningAdmins.userId,
		runningAdmins.jobID, runningAdmins.commcellId, runningAdmins.opType, destClientId = runningAdmins.clientId, destClientName = runningAdmins.clientName, runningAdmins.clientId, runningAdmins.clientName,
		state = runningAdmins.displayState,
		status = 0,
		statusName =(SELECT stateName FROM JMJobStateNames WHERE stateType = runningAdmins.displayState),
		runningAdmins.currentPhaseName, runningAdmins.percentcomplete, DelayReason, runningAdmins.jobStartTime, runningAdmins.jobElapsedTime,
		appTypeId =  appType,
		appTypeName = CASE WHEN appType = 0 THEN '' ELSE ISNULL((SELECT TOP 1 name FROM APP_IDAType WHERE type = appType),'') END,
		backupSetId = backupset, runningAdmins.backupSetName,
		subclientId = runningAdmins.appId, runningAdmins.subclientName,statusColor ='black', runningAdmins.lastUpdateFromClient,
		operationName=(SELECT CASE @isTelstraOEM
								   WHEN 1 THEN (CASE WHEN JOP.opType <> 4 THEN JOP.opName ELSE 'Replication' END)
								   ELSE (CASE
											WHEN runningAdmins.opType = 90 THEN runningAdmins.workflowname
											WHEN runningAdmins.opType IN (31, 106) AND (runningAdmins.ER_BkpLevel & 0x40 /*ARCHIVECHECKFLAGS_DDB_DEFRAG_WITH_DV2_SIMPLIFIED*/ <> 0)
												THEN 'DDB Space Reclamation'
											WHEN runningAdmins.opType IN (31, 106) AND runningAdmins.cloudid <> 0 THEN 'DDB Verification'
											ELSE JOP.opName
										 END)
							   END
						FROM JMJobOperationNames JOP WHERE JOP.opType = runningAdmins.opType),
		sizeOfApplication = (CASE WHEN runningAdmins.opType = 104 THEN runningAdmins.ObjectsDone ELSE runningAdmins.uncompBytes END),
		sizeOfMediaOnDisk=null,percentSavings=null,totalNumOfFiles=(CASE WHEN runningAdmins.opType = 130 /*ONLINE_CRAWL*/ THEN runningAdmins.ObjectsDone WHEN runningAdmins.opType = 143 /*SOLR_INDEX_IMPORT*/ THEN runningAdmins.TotalObjects ELSE runningAdmins.numFiles END),
		scanFileFailures=(CASE WHEN (runningAdmins.opType = 130 /*ONLINE_CRAWL*/ OR runningAdmins.opType = 143 /*SOLR_INDEX_IMPORT*/) THEN runningAdmins.ObjectsFailed ELSE 0 END),scanFolderFailures=0,backupFileFailures=0,backupFolderFailures=0,
		pendingReason = runningAdmins.failureReason, backupLevel = ER_BkpLevel, backupLevelName = (SELECT bkpLevelName FROM JMBackupLevelNames BK WHERE BK.bkpLevel = ER_BkpLevel), jobSubmitErrorCode = 0, aged = 0, pendingReasonErrorCode = '',
		instanceId = instance, instanceName = (SELECT TOP 1 name FROM APP_InstanceName WHERE id = instance),
		localizedOperationName = CASE
									WHEN runningAdmins.opType = 90 THEN runningAdmins.workflowname
									WHEN runningAdmins.opType IN (31, 106) AND (runningAdmins.ER_BkpLevel & 0x40 /*ARCHIVECHECKFLAGS_DDB_DEFRAG_WITH_DV2_SIMPLIFIED*/ <> 0)
THEN (SELECT dbo.fn_EvFormatEventMsgText(0, @i_localeId, (4414 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2))
WHEN runningAdmins.opType IN (31, 106) AND runningAdmins.cloudid <> 0 THEN (SELECT dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3283 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2))
									ELSE opNamesT1.opName
								 END,
		localizedStatus = (SELECT TSN.stateName FROM #TempStateNames TSN WHERE TSN.stateType = runningAdmins.displayState),
		localizedBackupLevel = (SELECT Bk.bkpLevelName FROM #TempBkpLevelNames BK WHERE BK.bkpLevel = ER_BkpLevel), runningAdmins.isPreemptable, jobEndTime = (CASE WHEN JMJobInfo.serverEndTime > 0 THEN JMJobInfo.serverEndTime ELSE 0 END), runningAdmins.UserName,
		errorType = CASE runningAdmins.errorType WHEN -1 THEN 650 ELSE runningAdmins.errorType END, -- MULTIPLEERRORS -1 to 650
		alertColorLevel= (CASE WHEN runningAdmins.guiAlertColorLevel > 0 THEN (CASE runningAdmins.guiAlertColorLevel % 100000 WHEN 20 THEN 2 WHEN 40 THEN 4 WHEN 60 THEN 8 ELSE 0 END) ELSE 0 END)
							+ (CASE WHEN runningAdmins.guiAlertColorLevel >= 100000 THEN 16 ELSE 0 END),
		vsaParentJobID = 0,
		isAnomalous = CASE WHEN runningAdmins.guiAlertColorLevel >= 100000 THEN 1 END,
		thresholdTime = CASE WHEN LongRunning.attributeValueInt IS NOT NULL AND LongRunning.attributeValueInt > 0 THEN LongRunning.attributeValueInt END,
		bkpAttributes = NULL,
		clientDisplayName = runningAdmins.clientDisplayName,
		destDisplayClientName = NULL,
		storagePolicyName = runningAdmins.storagePolicyName,
		storagePolicyId = runningAdmins.archGrpID,
		dataSourceName = NULL,
		dataSourceId = runningAdmins.dataSourceId,
		phasePercentagesList = NULL,
		phaseTimingsList = NULL,
		runningAdmins.currentPhase,
		runningAdmins.attemptStartTime,
		stubDataSize = stubSizeOption.attributeValueInt,
		currentPhaseType = NULL,
		totalClients = 0,
		successfullClients = 0,
		skippedClients = 0,
		pendingClients = 0,
		failedClients = 0,
		partialSuccessClients = 0,
		totalInProgressClients = 0,
		distributedAppsClusterType = 0,
		bkpAttributesEx = 0
		FROM RunningAdminJobs runningAdmins
		INNER JOIN JMJobInfo ON runningAdmins.jobId = JMJobInfo.jobId
		INNER JOIN #JobIDsList JLIST ON runningAdmins.jobId = JLIST.jobId And runningAdmins.CommcellId = JLIST.CommcellId
		LEFT OUTER JOIN #TempOperationNames opNamesT1 ON opNamesT1.opType = runningAdmins.opType
		LEFT OUTER JOIN #JobSummary JS ON JS.jobId = runningAdmins.jobId AND runningAdmins.commCellId = 2
LEFT OUTER JOIN JmJobOptions LongRunning ON LongRunning.attributeId = 76 AND runningAdmins.jobId =  LongRunning.jobId
LEFT OUTER JOIN JMJobOptions stubSizeOption WITH(NOLOCK) ON runningAdmins.jobId = stubSizeOption.jobId AND runningAdmins.CommcellId = stubSizeOption.commCellId AND stubSizeOption.attributeId = 26 AND @showOnlyArchiveBackupsetJobs = 1
		WHERE JS.jobId IS NULL
		TRUNCATE TABLE #VsaVmStats
		-- populate VsaVmStats
		INSERT INTO #VsaVmStats
		SELECT
		JLIST.jobId,
		JLIST.CommcellId,
totalClients = CASE WHEN (RunningBackups.appTypeId = 106 AND (RunningBackups.bkpAttributesEx & 0x40000000 = 0x40000000 OR RunningBackups.bkpAttributesEx & 0x100000000000000 = 0x100000000000000)) --JMBKP_EX_VSA_PARENT_SYNTHFULL
			THEN (SELECT COUNT(*) FROM JMQinetixUpdateStatus WHERE jobId = JLIST.jobID AND commCellId = JLIST.commcellId)
			ELSE 0 END,
successfullClients = CASE WHEN (RunningBackups.appTypeId = 106 AND (RunningBackups.bkpAttributesEx & 0x40000000 = 0x40000000 OR RunningBackups.bkpAttributesEx & 0x100000000000000  = 0x100000000000000 )) --JMBKP_EX_VSA_PARENT_SYNTHFULL
			THEN (SELECT COUNT(*) FROM JMQinetixUpdateStatus WHERE jobId = JLIST.jobID AND commCellId = JLIST.commcellId AND status = 0)
			ELSE 0 END,
skippedClients = CASE WHEN (RunningBackups.appTypeId = 106 AND (RunningBackups.bkpAttributesEx & 0x40000000 = 0x40000000 OR RunningBackups.bkpAttributesEx & 0x100000000000000  = 0x100000000000000 )) --JMBKP_EX_VSA_PARENT_SYNTHFULL
			THEN (SELECT COUNT(*) FROM JMQinetixUpdateStatus WHERE jobId = JLIST.jobID AND commCellId = JLIST.commcellId AND status = 6)
			ELSE 0 END,
pendingClients =  CASE WHEN (RunningBackups.appTypeId = 106 AND (RunningBackups.bkpAttributesEx & 0x40000000 = 0x40000000 OR RunningBackups.bkpAttributesEx & 0x100000000000000  = 0x100000000000000 )) --JMBKP_EX_VSA_PARENT_SYNTHFULL
			THEN (SELECT COUNT(*) FROM JMQinetixUpdateStatus WHERE jobId = JLIST.jobID AND commCellId = JLIST.commcellId AND status IN (4,5,7,8))
			ELSE 0 END,
failedClients = CASE WHEN (RunningBackups.appTypeId = 106 AND (RunningBackups.bkpAttributesEx & 0x40000000 = 0x40000000 OR RunningBackups.bkpAttributesEx & 0x100000000000000  = 0x100000000000000 )) --JMBKP_EX_VSA_PARENT_SYNTHFULL
			THEN (SELECT COUNT(*) FROM JMQinetixUpdateStatus WHERE jobId = JLIST.jobID AND commCellId = JLIST.commcellId AND status = 1)
			ELSE 0 END,
partialSuccessClients = CASE WHEN (RunningBackups.appTypeId = 106 AND (RunningBackups.bkpAttributesEx & 0x40000000 = 0x40000000 OR RunningBackups.bkpAttributesEx & 0x100000000000000  = 0x100000000000000 )) --JMBKP_EX_VSA_PARENT_SYNTHFULL
			THEN (SELECT COUNT(*) FROM JMQinetixUpdateStatus WHERE jobId = JLIST.jobID AND commCellId = JLIST.commcellId AND status = 3)
			ELSE 0 END,
totalInProgressClients = CASE WHEN (RunningBackups.appTypeId = 106 AND (RunningBackups.bkpAttributesEx & 0x40000000 = 0x40000000 OR RunningBackups.bkpAttributesEx & 0x100000000000000  = 0x100000000000000 )) --JMBKP_EX_VSA_PARENT_SYNTHFULL
			THEN (SELECT COUNT(*) FROM JMQinetixUpdateStatus WHERE jobId = JLIST.jobID AND commCellId = JLIST.commcellId AND status = 2)
			ELSE 0 END
		FROM #JobIDsList JLIST
		INNER JOIN RunningBackups ON RunningBackups.jobId = JLIST.jobId And RunningBackups.CommcellId = JLIST.CommcellId
		INSERT INTO #JobSummary
		SELECT
		0,
		RunningBackups.userId,
		RunningBackups.jobID, RunningBackups.commcellId, RunningBackups.opType, destClientId = RunningBackups.clientId, destClientName = RunningBackups.clientName, RunningBackups.clientId, RunningBackups.clientName,
		state = RunningBackups.displayState,
		status = 0,
		statusName=(SELECT stateName FROM JMJobStateNames WHERE stateType = RunningBackups.displayState), RunningBackups.currentPhaseName, RunningBackups.percentcomplete, DelayReason, RunningBackups.jobStartTime, RunningBackups.jobElapsedTime,
		appTypeId = RunningBackups.appTypeId,
		appTypeName = RunningBackups.ApptypeName,
		backupSetId = backupSet, RunningBackups.backupsetName,
		subclientId = applicationId , RunningBackups.subclientName,statusColor ='black',RunningBackups.lastUpdateFromClient,
		operationName=(SELECT JOP.opName FROM JMJobOperationNames JOP WHERE JOP.opType = RunningBackups.opType),
		sizeOfApplication = uncompBytes,compBytes,percentSavings=null,totalNumOfFiles=filesXfered,scanFileFailures=ISNULL(RunningBackups.scanFileFailures,0),scanFolderFailures=ISNULL(RunningBackups.scanFolderFailures,0),
		backupFileFailures=ISNULL(RunningBackups.backupFileFailures,0), backupFolderFailures=ISNULL(RunningBackups.backupFolderFailures,0),
		pendingReason = RunningBackups.failureReason,
		backupLevel = bkpLevel,
		backupLevelName = (
				CASE WHEN bkpLevel = 2 AND RunningBackups.appTypeId IN (5, 81, 126) AND RunningBackups.opType <> 98
					THEN @transLogLevelName
				WHEN bkpLevel = 2 AND RunningBackups.appTypeId IN (125) AND NOT (RunningBackups.opType IN (59, 60) AND RunningBackups.bkpAttributesEx & 16 = 16) --JMBKP_EX_BLOCK_LEVEL_SNAP = 0x10
					THEN @logOnlyLevelName
				ELSE (SELECT bkpLevelName FROM JMBackupLevelNames BK WHERE BK.bkpLevel = RunningBackups.bkpLevel)
				END),
		jobSubmitErrorCode = 0, aged = 0, pendingReasonErrorCode = '',
		instanceId = instance, instanceName = RunningBackups.InstanceName,
		localizedOperationName = opNamesT1.opName,
		localizedStatus = (SELECT TSN.stateName FROM #TempStateNames TSN WHERE TSN.stateType = RunningBackups.displayState),
		localizedBackupLevel = (
				CASE WHEN bkpLevel = 2 AND RunningBackups.appTypeId IN (5, 81, 126) AND RunningBackups.opType <> 98
					THEN @transLogLevelName
				WHEN bkpLevel = 2 AND RunningBackups.appTypeId IN (125) AND NOT (RunningBackups.opType IN (59, 60) AND RunningBackups.bkpAttributesEx & 16 = 16) --JMBKP_EX_BLOCK_LEVEL_SNAP = 0x10
					THEN @logOnlyLevelName
				ELSE (SELECT Bk.bkpLevelName FROM #TempBkpLevelNames BK WHERE BK.bkpLevel = RunningBackups.bkpLevel)
				END),
		RunningBackups.isPreemptable, jobEndTime = (CASE WHEN JMJobInfo.serverEndTime > 0 THEN JMJobInfo.serverEndTime ELSE 0 END), RunningBackups.UserName,
		errorType = CASE RunningBackups.errorType WHEN -1 THEN 650 ELSE RunningBackups.errorType END, -- MULTIPLEERRORS -1 to 650
		alertColorLevel= (CASE WHEN RunningBackups.guiAlertColorLevel > 0 THEN (CASE RunningBackups.guiAlertColorLevel % 100000 WHEN 20 THEN 2 WHEN 40 THEN 4 WHEN 60 THEN 8 ELSE 0 END) ELSE 0 END)
							+ (CASE WHEN RunningBackups.guiAlertColorLevel >= 100000 THEN 16 ELSE 0 END),
        vsaParentJobID = ISNULL(dataLink.parentJobId,0),
        isAnomalous = CASE WHEN RunningBackups.guiAlertColorLevel >= 100000 THEN 1 END,
		thresholdTime = CASE WHEN foreCast.attributeValueInt IS NOT NULL AND foreCast.attributeValueInt > 0 THEN foreCast.attributeValueInt + (foreCast.attributeValueInt * 0.05) END,
		RunningBackups.bkpAttributes,
		clientDisplayName = RunningBackups.clientDisplayName,
		destDisplayClientName = NULL,
		storagePolicyName = RunningBackups.currentPolicyName,
		storagePolicyId = RunningBackups.currentPolicy,
		dataSourceName = NULL,
		dataSourceId = 0,
		phasePercentagesList = RunningBackups.phasePercentagesList,
		phaseTimingsList = RunningBackups.phaseTimingsList,
		RunningBackups.currentPhase,
		RunningBackups.attemptStartTime,
		stubDataSize = stubSizeOption.attributeValueInt,
		RunningBackups.currentPhaseType,
		VMSTATS.totalClients,
		VMSTATS.successfullClients,
		VMSTATS.skippedClients,
		VMSTATS.pendingClients,
		VMSTATS.failedClients,
		VMSTATS.partialSuccessClients,
		VMSTATS.totalInProgressClients,
		distributedAppsClusterType = DISTCT.attrVal,
		RunningBackups.bkpAttributesEx
		FROM RunningBackups
		INNER JOIN JMJobInfo ON RunningBackups.jobId = JMJobInfo.jobId
		INNER JOIN #JobIDsList JLIST ON RunningBackups.jobId = JLIST.jobId And RunningBackups.CommcellId = JLIST.CommcellId
		INNER JOIN #VsaVmStats VMSTATS ON VMSTATS.jobId = JLIST.jobId And VMSTATS.CommcellId = JLIST.CommcellId
		LEFT OUTER JOIN #TempOperationNames opNamesT1 ON opNamesT1.opType = RunningBackups.opType
LEFT OUTER JOIN JMJobDataLink dataLink WITH(NOLOCK) ON dataLink.linkType = 7 AND dataLink.commCellId = RunningBackups.CommcellId AND dataLink.childJobId = RunningBackups.jobId
LEFT OUTER JOIN JmJobOptions forecast WITH (NOLOCK) ON forecast.attributeId = 76 AND RunningBackups.jobId = forecast.jobId AND RunningBackups.commCellId = forecast.commCellId
		LEFT OUTER JOIN #JobSummary JS ON JS.jobId = RunningBackups.jobId AND RunningBackups.commCellId = 2
LEFT OUTER JOIN JMJobOptions stubSizeOption WITH(NOLOCK) ON RunningBackups.jobId = stubSizeOption.jobId AND RunningBackups.CommcellId = stubSizeOption.commCellId AND stubSizeOption.attributeId = 26 AND @showOnlyArchiveBackupsetJobs = 1
		LEFT OUTER JOIN APP_InstanceProp DISTCT (NOLOCK) ON DISTCT.componentNameId = RunningBackups.instance AND DISTCT.attrName = 'Distributed Cluster Type' AND DISTCT.modified = 0
		WHERE JS.jobId IS NULL
		INSERT INTO #JobSummary
		SELECT
		0,
		RunningRestores.userId,
		RunningRestores.jobID, RunningRestores.commcellId, RunningRestores.opType, RunningRestores.destClientId, RunningRestores.destClientName, srcClientId, srcClientName,
		state = RunningRestores.displayState,
		status = 0,
		statusName=(SELECT stateName FROM JMJobStateNames WHERE stateType = RunningRestores.displayState), RunningRestores.currentPhaseName, RunningRestores.percentcomplete, DelayReason, RunningRestores.jobStartTime, RunningRestores.jobElapsedTime,
		appTypeId = appType,
		appTypeName = CASE WHEN appType = 0 THEN '' ELSE ISNULL((SELECT TOP 1 name FROM APP_IDAType WHERE type = appType),'') END,
		backupSetId = bkpSetID, RunningRestores.backupSetName,
		subclientId = 0, subclientName = '',statusColor ='black',RunningRestores.lastUpdateFromClient ,
		operationName = (CASE
					WHEN RunningRestores.rstAttributes & 0x100 = 0x100 THEN 'Sync Restore'
					WHEN RunningRestores.rstAttributes & 0x1000 = 0x1000 THEN 'Sync Restore'
					WHEN RunningRestores.opType = 29 THEN 'Persistent Recovery'
					ELSE (SELECT CASE @isTelstraOEM WHEN 1 THEN (CASE WHEN JOP.opType <> 4 THEN JOP.opName ELSE 'Replication' END) ELSE JOP.opName END FROM JMJobOperationNames JOP WHERE JOP.opType = RunningRestores.opType)
				END),
		sizeOfApplication = totUnCompBytes,totCompBytes,percentSavings=null,totSuccess,scanFileFailures=0,scanFolderFailures=0,backupFileFailures=0,backupFolderFailures=0,
		pendingReason = RunningRestores.failureReason, backupLevel = 0, backupLevelName = '', jobSubmitErrorCode = 0, aged = 0, pendingReasonErrorCode = '',
		instanceId = RunningRestores.instanceID, instanceName = (SELECT TOP 1 name FROM APP_InstanceName WHERE id = RunningRestores.instanceID),
		localizedOperationName = (CASE
WHEN RunningRestores.rstAttributes & 0x100 = 0x100 THEN (SELECT dbo.fn_EvFormatEventMsgText(0, @i_localeId, (2071 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2))
WHEN RunningRestores.rstAttributes & 0x1000 = 0x1000 THEN (SELECT dbo.fn_EvFormatEventMsgText(0, @i_localeId, (2071 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2))
					ELSE opNamesT1.opName
				END),
		localizedStatus = (SELECT TSN.stateName FROM #TempStateNames TSN WHERE TSN.stateType = RunningRestores.displayState),
		localizedBackupLevel = '', RunningRestores.isPreemptable, jobEndTime = (CASE WHEN JMJobInfo.serverEndTime > 0 THEN JMJobInfo.serverEndTime ELSE 0 END), RunningRestores.UserName,
		errorType = CASE RunningRestores.errorType WHEN -1 THEN 650 ELSE RunningRestores.errorType END, --MULTIPLEERRORS -1 to 650
		alertColorLevel= (CASE WHEN RunningRestores.guiAlertColorLevel > 0 THEN (CASE RunningRestores.guiAlertColorLevel % 100000 WHEN 20 THEN 2 WHEN 40 THEN 4 WHEN 60 THEN 8 ELSE 0 END) ELSE 0 END)
							+ (CASE WHEN RunningRestores.guiAlertColorLevel >= 100000 THEN 16 ELSE 0 END),
	 	vsaParentJobID = 0,
		isAnomalous = NULL,
		thresholdTime = NULL,
		bkpAttributes = NULL,
		clientDisplayName = ISNULL((client.displayName),''),
		destDisplayClientName = ISNULL((dclient.displayName),''),
		storagePolicyName = NULL,
		storagePolicyId = 0,
		dataSourceName = NULL,
		dataSourceId = 0,
		phasePercentagesList = NULL,
		phaseTimingsList = NULL,
		RunningRestores.currentPhase,
		RunningRestores.attemptStartTime,
		stubDataSize = NULL,
		currentPhaseType = NULL,
		totalClients = 0,
		successfullClients = 0,
		skippedClients = 0,
		pendingClients = 0,
		failedClients = 0,
		partialSuccessClients = 0,
		totalInProgressClients = 0,
		distributedAppsClusterType = DISTCT.attrVal,
		bkpAttributesEx = NULL
		FROM RunningRestores
		INNER JOIN JMJobInfo ON RunningRestores.jobId = JMJobInfo.jobId
		INNER JOIN #JobIDsList JLIST ON RunningRestores.jobId = JLIST.jobId And RunningRestores.CommcellId = JLIST.CommcellId
		LEFT OUTER JOIN #TempOperationNames opNamesT1 ON opNamesT1.opType = RunningRestores.opType
		LEFT OUTER JOIN APP_Client dclient WITH(NOLOCK) ON destClientId = dclient.id
		LEFT OUTER JOIN APP_Client client WITH(NOLOCK) ON srcClientId = client.id
		LEFT OUTER JOIN #JobSummary JS ON JS.jobId = RunningRestores.jobId AND RunningRestores.commCellId = 2
		LEFT OUTER JOIN APP_InstanceProp DISTCT (NOLOCK) ON DISTCT.componentNameId = (CASE WHEN RunningRestores.instanceID > 1 THEN RunningRestores.instanceID ELSE RunningRestores.destInstanceId END)
																AND DISTCT.attrName = 'Distributed Cluster Type' AND DISTCT.modified = 0
		WHERE JS.jobId IS NULL
	END
IF @JobIdFilters = 0
	BEGIN
		IF @backupLevelFilters != 0
		BEGIN
			DELETE #JobSummary
			WHERE (backupLevel NOT IN(SELECT backupLevel FROM #backupLevelFilter))
		END
		IF @startTimeRangefromTime != 0 OR @startTimeRangetoTime != 0
		BEGIN
			DELETE #JobSummary
			WHERE (jobStartTime NOT BETWEEN @startTimeRangefromTime AND @startTimeRangetoTime)
		END
	END
	INSERT INTO #clientGroupXMLListb
	(clientid, clientGroupList)
	SELECT JS.clientId,
	clientGroupList = (SELECT A.clientgroupid '@clientGroupId', B.name '@clientGroupName'
	                   FROM APP_ClientGroupAssoc A WITH (NOLOCK) INNER JOIN
					   APP_ClientGroup B WITH (NOLOCK)
					   ON A.clientgroupid  = B.id
					   WHERE (@ISclientGroupIdListFilterSet = 0  OR A.clientgroupid IN (select distinct groupId from #clientGroupListFilter))
					   AND A.clientId =JS.clientid
					   FOR XML PATH('clientGroups'), TYPE)
	FROM #JobSummary JS
	WHERE clientid is not NULL
	GROUP BY JS.clientid
	DECLARE @totalRecords INT = (SELECT COUNT(*) FROM #JobSummary)
	-- Compute error code string
	UPDATE #JobSummary
	SET pendingReasonErrorCode = (
									SELECT CAST(EV.SubsystemID AS NVARCHAR(256)) + ':' + CAST(EV.MessageNum AS NVARCHAR(256))
									FROM JMFailureReasonMsg JMF WITH (NOLOCK)
									INNER JOIN EvLocaleMsgs EV WITH (NOLOCK) ON JMF.messageId = EV.MessageID AND EV.LocaleID = 0
									AND JMF.id = CAST(SUBSTRING(pendingReason, 0, CHARINDEX(',', pendingReason, 0)) AS INT)
								 )
	WHERE pendingReason <> '' AND pendingReason IS NOT NULL
	UPDATE #JobSummary
	SET clientDisplayName = SEDataSource.DataSourceName
	FROM SEDataSource (NOLOCK)
	JOIN #JobSummary
	ON SEDataSource.DataSourceId = #JobSummary.dataSourceId
	BEGIN
		IF @sortField IS NOT NULL AND @sortField <> ''
		BEGIN
			-- Update rownumbers once we have the final set.
			;WITH RowNumbers AS (
			SELECT  jobId, ROW_NUMBER() OVER (ORDER BY
												CASE @sortField WHEN 'jobId' THEN jobID END,
												CASE @sortField WHEN 'jobIdDESC' THEN jobID END DESC,
												CASE @sortField WHEN 'jobType' THEN operationName END,
												CASE @sortField WHEN 'jobTypeDESC' THEN operationName END DESC,
												CASE @sortField WHEN 'jobStartTime' THEN jobStartTime END,
												CASE @sortField WHEN 'jobStartTimeDESC' THEN jobStartTime END DESC,
												CASE @sortField WHEN 'jobElapsedTime' THEN jobElapsedTime END,
												CASE @sortField WHEN 'jobElapsedTimeDESC' THEN jobElapsedTime END DESC,
												CASE @sortField WHEN 'status' THEN status END,
												CASE @sortField WHEN 'statusDESC' THEN status END DESC,
												CASE @sortField WHEN 'localizedStatus' THEN localizedStatus END,
												CASE @sortField WHEN 'localizedStatusDESC' THEN localizedStatus END DESC,
												CASE @sortField WHEN 'totalNumOfFiles' THEN totalNumOfFiles END,
												CASE @sortField WHEN 'totalNumOfFilesDESC' THEN totalNumOfFiles END DESC,
												CASE @sortField WHEN 'sizeOfApplication' THEN sizeOfApplication END,
												CASE @sortField WHEN 'sizeOfApplicationDESC' THEN sizeOfApplication END DESC,
												CASE @sortField WHEN 'localizedOperationName' THEN localizedOperationName END,
												CASE @sortField WHEN 'localizedOperationNameDESC' THEN localizedOperationName END DESC,
												CASE @sortField WHEN 'destClientName' THEN destClientName END,
												CASE @sortField WHEN 'destClientNameDESC' THEN destClientName END DESC,
												CASE @sortField WHEN 'subclientName' THEN subclientName END,
												CASE @sortField WHEN 'subclientNameDESC' THEN subclientName END DESC,
												CASE @sortField WHEN 'backupLevelName' THEN backupLevelName END,
												CASE @sortField WHEN 'backupLevelNameDESC' THEN backupLevelName END DESC,
												CASE @sortField WHEN 'pendingReasonErrorCode' THEN pendingReasonErrorCode END,
												CASE @sortField WHEN 'pendingReasonErrorCodeDESC' THEN pendingReasonErrorCode END DESC,
												CASE @sortField WHEN 'appTypeName' THEN appTypeName END,
												CASE @sortField WHEN 'appTypeNameDESC' THEN appTypeName END DESC
							  ) AS rowNumber
			FROM    #JobSummary
			)
			UPDATE  #JobSummary
			SET    id = R.rowNumber
			FROM    #JobSummary J
			JOIN RowNumbers R ON J.jobId = R.jobId
			IF (@i_startRowNUM >= 0 AND @i_endRowNum >0)
			BEGIN
				DELETE #JobSummary
				WHERE (id < @i_startRowNUM OR id >= @i_endRowNum)
			END
		END
	END
	-- Compute JPR string
	IF @i_localeId = 0
	BEGIN
		UPDATE JS
		SET pendingCause = C.localisedMessage
		FROM #JobSummary JS
		JOIN JMFailureReasonLocaleMsgCache C ON C.jobId = JS.jobId AND C.commcellId = JS.commcellId AND C.reasonCode = JS.pendingReason
		WHERE pendingCause = ''
		AND pendingReason <> ''
	END
	ELSE
	BEGIN
		UPDATE JS
		SET pendingCause = dbo.JMGetLocalizedMessageFunc(@i_localeId, pendingReason)
		FROM #JobSummary JS
		WHERE pendingCause = ''
		AND pendingReason <> ''
	END
	-- Fix job status for completed VM jobs
	IF EXISTS(SELECT 1 FROM #sec_VMJobIDsList)
	   AND @clientIdFilters = 1
	BEGIN
		UPDATE J
		SET		clientId = VM.clientId,
				clientName = VM.clientName,
				status =	VM.status,
				statusName = (SELECT stateName FROM JMJobStatusNames WHERE stateType = VM.status),
				localizedStatus = (SELECT JS.stateName FROM #TempStatusNames JS WHERE JS.stateType = VM.status)
		FROM #JobSummary J
		INNER JOIN (SELECT VJ.jobId, VJ.commCellId, JQ.clientId, JQ.clientName, CASE VMP.attrVal
																						WHEN '0' THEN 1
																						WHEN '3' THEN 3
																						ELSE 2
																				END AS status
					FROM #sec_VMJobIDsList VJ
					INNER JOIN JMQinetixUpdateStatus JQ ON JQ.jobId = VJ.jobId AND JQ.commcellId = VJ.commcellId
					INNER JOIN #clientIdFilter CF On CF.clientId = JQ.clientId
					INNER JOIN APP_VMProp  VMP ON VMP.jobId = VJ.jobId AND VMP.commcellId = VJ.commcellId AND VMP.vmClientId= JQ.clientID AND VMP.attrName = 'vmStatus'
					)VM ON VM.jobId = J.jobId
		WHERE J.status IN (1, 3, 16) --JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
	END
	SELECT
		jobId AS 'jobId' ,
		destClientName AS 'destClientName',
		jobType AS 'opType',
		J.statusName AS 'status',
		currentPhaseName AS 'currentPhaseName',
		percentcomplete AS 'percentComplete',
		pendingCause AS 'pendingReason',
		jobStartTime AS 'jobStartTime',
		jobElapsedTime AS 'jobElapsedTime',
		ISNULL(apptypeName,'') AS 'appTypeName',
		ISNULL(backupSetName,'') AS 'backupSetName',
		ISNULL(subclientName,'') AS 'subclientName',
		lastUpdateTime AS 'lastUpdateTime',
		isPreemptable AS 'isPreemptable',
		jobEndTime AS 'jobEndTime',
		ISNULL(sizeOfApplication,0) AS 'sizeOfApplication',
		ISNULL(totalNumOfFiles,0) AS 'totalNumOfFiles',
		scanFileFailures + backupFileFailures AS 'totalFailedFiles',
		scanFolderFailures + backupFolderFailures AS 'totalFailedFolders',
		backupLevel AS 'backupLevel',
		backupLevelName AS 'backupLevelName',
		jobSubmitErrorCode AS 'jobSubmitErrorCode',
		aged AS 'isAged',
		pendingReasonErrorCode AS 'pendingReasonErrorCode',
		localizedOperationName AS 'localizedOperationName',
		localizedBackupLevel AS 'localizedBackupLevelName',
		localizedStatus AS 'localizedStatus',
		errorType AS 'errorType',
		vsaParentJobID AS 'vsaParentJobID',
		J.isAnomalous  AS 'isAnomalous',
		J.thresholdTime AS 'thresholdTime',
		-- Return the subclient entity - Below entity should be used always to get the correct client information.
		J.clientId AS 'clientId',
		clientName AS 'clientName',
		appTypeId AS 'applicationId',
		instanceId AS 'instanceId',
		instanceName AS 'instanceName',
		backupsetId AS 'backupsetId',
		subclientId AS 'subclientId',
		ISNULL(clientDisplayName,'') AS 'displayName',
		destClientId AS 'clientId',
		CG.clientGroupList AS 'clientGroupList',
	    storagePolicyName AS 'storagePolicy',
		storagePolicyId AS 'storagePolicyId',
		commcellId AS 'commcellId',
		dataSourceName AS 'dataSourceName',
		dataSourceId AS 'dataSourceId',
		phasePercentagesList AS 'phasePercentagesList',
		phaseTimingsList AS 'phaseTimingsList',
		currentPhase AS 'currentPhase',
		attemptStartTime AS 'attemptStartTime',
		ISNULL(stubDataSize, 0) AS 'stubDataSize',
		totalClients AS 'totalClients',
		successfullClients AS 'successfullClients',
		skippedClients AS 'skippedClients',
		pendingClients AS 'pendingClients',
		failedClients AS 'failedClients',
		partialSuccessClients AS 'partialSuccessClients',
		totalInProgressClients AS 'totalInProgressClients',
		ISNULL(distributedAppsClusterType, 0) as 'distributedAppsClusterType',
		ISNULL(bkpAttributes, 0) as 'jobAttributes',
		ISNULL(bkpAttributesEx, 0) as 'jobAttributesEx'
	FROM #JobSummary J
	LEFT JOIN #clientGroupXMLListb CG ON CG.clientid = J.clientId
	IF OBJECT_ID(N'tempdb.dbo.#TempOperationNames') IS NOT NULL
		DROP TABLE #TempOperationNames
	IF OBJECT_ID(N'tempdb.dbo.#TempBkpLevelNames') IS NOT NULL
		DROP TABLE #TempBkpLevelNames
	IF OBJECT_ID(N'tempdb.dbo.#TempStatusNames') IS NOT NULL
		DROP TABLE #TempStatusNames
	IF OBJECT_ID(N'tempdb.dbo.#TempStateNames') IS NOT NULL
		DROP TABLE #TempStateNames
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_Bkp') IS NOT NULL
		DROP TABLE #SecIDANodeAccessTemp_Bkp
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_Rst') IS NOT NULL
		DROP TABLE #SecIDANodeAccessTemp_Rst
	IF OBJECT_ID(N'tempdb.dbo.#JMCanManageJob_adminObject') IS NOT NULL
		DROP TABLE #JMCanManageJob_adminObject
	IF OBJECT_ID('tempdb.dbo.#clientGroupListFilter') IS NOT NULL
		DROP TABLE dbo.#clientGroupListFilter
	IF OBJECT_ID('tempdb.dbo.#dataSourceFilter') IS NOT NULL
		DROP TABLE dbo.#dataSourceFilter
	IF OBJECT_ID('tempdb.dbo.#clientGroupXMLListb') IS NOT NULL
		DROP TABLE dbo.#clientGroupXMLListb
	IF OBJECT_ID('tempdb.dbo.#AdminFinishedJobIDsList') IS NOT NULL
		DROP TABLE #AdminFinishedJobIDsList
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetRunningJobSummaryAsTable')
	delete from GxQscripts where name = 'JMGetRunningJobSummaryAsTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRunningJobSummaryAsTable')
	delete from GXDBVersions where aliasname = 'JMGetRunningJobSummaryAsTable'
GO

insert into GXDBVersions values(2, 'JMGetRunningJobSummaryAsTable',  'v1.1.2.48.4.1', 'JMGetRunningJobSummaryAsTable', 'v1.1.2.48.4.1')
GO

