

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetRunningJobDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetRunningJobDetails.sp,v $ $Id: JMGetRunningJobDetails.sp,v 1.18.2.90.4.2 2021/05/15 17:37:05 jragunathan Exp $";
--
--  +========================================================================+
--  |   Procedure:  JMGetRunningJobDetails()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output:
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Bhavyan Mehta	   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMGetRunningJobDetails')
BEGIN
	print '>>> Drop Stored Procedure: JMGetRunningJobDetails <<<'
	drop procedure JMGetRunningJobDetails
END
IF EXISTS (select * from GxQscripts where name='JMGetRunningJobDetails')
	delete from GxQscripts where name = 'JMGetRunningJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRunningJobDetails')
	delete from GXDBVersions where aliasname = 'JMGetRunningJobDetails'
GO
print '... Creating Procedure: JMGetRunningJobDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMGetRunningJobDetails
  @i_userId INT,
  @i_xml XML,
  @o_xml XML OUTPUT
AS
SET NOCOUNT ON
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @JobDetails TABLE (
		jobId int,
		optype int,
		backupType int,
		priority int,
		totalNumOfFiles bigint,
		startTime int,
		subclientId int,
		subclientName	nvarchar(256),
		clientId int,
		clientName nvarchar(510),
		displayClientName nvarchar(255),
		destinationClient nvarchar(510),
        destinationClientDisplayName nvarchar(255),
		destinationclientId int,
	    instanceId int,
		instanceName nvarchar(1024),
		backupsetId int,
		backupsetName nvarchar(256),
	    appTypeId int,
		appTypeName nvarchar(255),
		mediaAgentName nvarchar(256),
	    storagePolicyName nvarchar(288),
		storagePolicyId int,
	    jobStartedBy nvarchar(510),
	    currentPhaseName nvarchar(256),
	    currentstate	int,
		elapsedTime int,
		filesXfered bigint,
		uncompBytes bigint,
		sizeOnMedia bigint,
		totalMediaUsageTime int,
		timeToComplete int,
		lastUpdateFromClient int,
		percentcomplete int,
		currentThroughput DECIMAL (32, 2),
		averageThroughput float, --DECIMAL (10, 2),
		DelayReason varchar(max),
		jobStartedFrom int,
		jobAttributes bigint,
		numOfStreams int,
		jobEndTime int,
		totalCompBytes bigint,
		dataXferedNetwork bigint,
		transferTime int,
		scanTypeChangeReason nvarchar(max),
		scanFileFailures bigint,
		scanFolderFailures bigint,
		backupFileFailures bigint,
		backupFolderFailures bigint,
		xmlJobInfo XML,
		status int,
		throughput DECIMAL (32, 2),
		totSkipped   bigint,
		storagePolicyCopyName nvarchar(128),
		isVisible INT,
		scheduleName nvarchar(510),
		schedulePolicyName nvarchar(510),
		subTaskId int,
		taskId int,
		ER_Destination nvarchar(max),
		compressionRatio DECIMAL (10, 2),
		encrypted nvarchar(256),
		activeFile nvarchar(max),
		attemptStartTime int,
		ER_DbName  nvarchar(256),
		srcMediaAgent nvarchar(256),
		destMediaAgent nvarchar(256),
		LibraryID  int,
		LibraryName nvarchar(256),
		MI_InventoryType int,
		cloudId  int,
		cloudName  nvarchar(256),
		scanType int,
		jobAttributesEx bigint,
		jobIdActedOn int,
		vsaParentJobID BIGINT,
		isAnomalous INT,
		thresholdTime INT,
		possibleReasonForDelay nvarchar(MAX),
		commcellId INT,
		totReadBytes BIGINT,
		totReadTime BIGINT,
		totPhysicalWriteBytes BIGINT,
		totPhysicalWriteTime BIGINT,
		nwTransBytes BIGINT,
		totNwTransTime BIGINT,
		totSidbLookups BIGINT,
		totSidbLookupTime BIGINT,
		readCurrentThroughput DECIMAL (32, 2),
		readAverageThroughput DECIMAL (32, 2),
		writeCurrentThroughput DECIMAL (32, 2),
		writeAverageThroughput DECIMAL (32, 2),
		ntwkCurrentThroughput DECIMAL (32, 2),
		ntwkAverageThroughput DECIMAL (32, 2),
		sidbCurrentLookups DECIMAL (32, 2),
		sidbAverageLookups DECIMAL (32, 2),
		phasePercentagesList nvarchar(512),
		phaseTimingsList nvarchar(512),
		currentPhase int,
		selectiveVMClientDisplayName nvarchar(510),
		oraBackupRefTimeAndLsn nvarchar(1024),
		jobThroughPut			nvarchar(1024),
		timeThroughPut			nvarchar(1024),
		totalThroughputTime BIGINT,
		readPercentageTime DECIMAL (32, 2),
		writePercentageTime DECIMAL (32, 2),
		networkPercentageTime DECIMAL (32, 2),
		sidbPercentageTime DECIMAL (32, 2),
		stubDataSize BIGINT,
		destInstanceId int,
		destInstanceName nvarchar(1024),
		objectsFailed BIGINT,
		currentPhaseType bigint,
		distributedAppsClusterType INT
	)
	-- List of visible clients
	IF OBJECT_ID('tempdb.dbo.#ClientList') IS NOT NULL
		DROP TABLE #ClientList
	CREATE TABLE #ClientList (
		clientId		INT PRIMARY KEY
	)
	--Tenant admin should be able to view jobs submitted by other users in the company.
	IF OBJECT_ID('tempdb.dbo.#getUsersInCompanyOutputTbl') IS NOT NULL
		DROP TABLE #getUsersInCompanyOutputTbl
	CREATE TABLE #getUsersInCompanyOutputTbl (
		userId INTEGER,
		PRIMARY KEY(userId)
	)
	--Populates #getUsersInCompanyOutputTbl
	EXEC sec_getUsersInCompany @i_userId
	DECLARE @i_localeId INT = 0
	DECLARE @clientStatusXML XML
	DECLARE @isTelstraOEM INT =	ISNULL((SELECT 1
										FROM GXGlobalParam WITH (NOLOCK)
										WHERE name = 'MSP Id'
										AND modified = 0
										AND value = '1'), 0)
	DECLARE @i_jobId BIGINT = 0
DECLARE @i_commcellId INT = 2
	DECLARE @OneHr FLOAT = 3600.0
	DECLARE @oneKB FLOAT = 1024.0
	DECLARE @oneGB FLOAT = (@oneKB * @oneKB* @oneKB)
	DECLARE @isVisible INT = 0
	DECLARE @i_showAttempt INT = 0
	DECLARE @i_selectOutput INT = 0
DECLARE @showSPNameAttributesEx BIGINT = CAST(0x2 AS BIGINT) |  CAST(0x40000000 AS BIGINT)
	IF OBJECT_ID('tempdb.dbo.#throughputJobs')  IS NOT NULL DROP TABLE #throughputJobs
	CREATE TABLE #throughputJobs (t_jobID int, t_commCellId int, timeThroughPut varchar(1024));
	CREATE INDEX IDX_throughputJobs_JOBID on #throughputJobs (t_jobID, t_commCellId);
-- Get the input parameters
SELECT @i_jobId = ISNULL(ref.value('@jobId', 'BIGINT'), 0), @i_commcellId = ISNULL(ref.value('commcell[1]/@commCellId', 'INT'), 2),
			@i_showAttempt = ISNULL(ref.value('@showAttempt', 'INT'), 0), @i_selectOutput = ISNULL(ref.value('@selectOutput', 'INT'), 0),
			@i_localeId = ISNULL(ref.value('@locale','INT'),0)
					  FROM  @i_xml.nodes ('JobManager_JobDetailRequest') R(ref)
	DECLARE @userName NVARCHAR(MAX) = ''
	SET @userName =  ISNULL((SELECT [login] FROM UMUsers WHERE id = @i_userId),'')
	DECLARE @jobCompleted INT = 0
		INSERT INTO #throughputJobs
		(t_jobID, t_commCellId, timeThroughPut)
		SELECT JMBkpStats.jobId, JMBkpStats.commCellId,
			CASE WHEN JMBkpStats.bkpAttributesEx & 0x40000000 <> 0 THEN
			(SELECT CAST(X.totReadTime AS VARCHAR(10))+':'+ CAST(X.totPhysicalWriteTime AS VARCHAR(10))+':'+ CAST(X.totNwTransTime AS VARCHAR(10))+':'+ CAST(X.totSidbLookupTime AS VARCHAR(10))
				FROM
				(
					SELECT SUM(CAST(T.totReadTime AS INT)) totReadTime, SUM(CAST(T.totPhysicalWriteTime AS INT)) totPhysicalWriteTime, SUM(CAST(T.totNwTransTime AS INT)) totNwTransTime, SUM(CAST(T.totSidbLookupTime AS INT)) totSidbLookupTime
					FROM
					(
						SELECT [1] AS totReadTime, [2] AS totPhysicalWriteTime, [3] AS totNwTransTime, [4] AS totSidbLookupTime
							FROM
							(
								SELECT S.Id, SUM(CAST(S.Data AS INT)) Data
								FROM JMJobDataLink JL (NOLOCK)
								JOIN JMBkpStats B ON B.jobId = JL.parentJobId
									AND JL.parentJobId = @i_jobId
									AND JL.commCellId = @i_commcellId
									AND B.bkpAttributesEx & 0x40000000 <> 0
								JOIN JMJobOptions O (NOLOCK) ON O.jobId = JL.childJobId
AND O.attributeId = 91
								OUTER APPLY dbo.SplitString(O.attributeValue, ':') S
								WHERE O.attributeValue IS NOT NULL
								GROUP BY S.Id
							) AS P
							PIVOT(MAX([Data]) FOR [id] IN([1], [2], [3], [4])) AS PivotTable
					) T
				) X
			)
				ELSE throughPutTimeOptions.attributeValue
			END
		FROM JMBkpStats (NOLOCK)
LEFT OUTER JOIN JMJobOptions throughPutTimeOptions WITH(NOLOCK) ON JMBkpStats.jobId = throughPutTimeOptions.jobId AND JMBkpStats.commCellId = throughPutTimeOptions.commCellId AND throughPutTimeOptions.attributeId = 91
		WHERE JMBkpStats.jobId = @i_jobId AND JMBkpStats.commCellId = @i_commcellId
	--INSERT LogJobClientList(requesttime,inXml) VALUES(GETDATE(),@i_xml)
    INSERT INTO @JobDetails(jobId, optype, backupType,priority,totalNumOfFiles,startTime,subclientId,subclientName,clientId,clientName,displayClientName,destinationClient,destinationClientDisplayName,destinationclientId,instanceId,instanceName,backupsetId,backupsetName,appTypeId,appTypeName,
	    mediaAgentName, storagePolicyName, storagePolicyId, jobStartedBy,currentPhaseName,currentstate,elapsedTime,filesXfered,uncompBytes, sizeOnMedia, totalMediaUsageTime,
		timeToComplete,lastUpdateFromClient,percentcomplete,currentThroughput,averageThroughput,DelayReason, jobStartedFrom, jobAttributes,numOfStreams,
		jobEndTime, totalCompBytes, dataXferedNetwork, transferTime, scanTypeChangeReason,
		scanFileFailures,scanFolderFailures, backupFileFailures, backupFolderFailures, xmlJobInfo, status, throughput, totSkipped, storagePolicyCopyName, isVisible, scheduleName, schedulePolicyName, subTaskId, taskId, ER_Destination, compressionRatio, encrypted, activeFile, attemptStartTime, ER_DbName, srcMediaAgent, destMediaAgent,
		LibraryID, LibraryName, MI_InventoryType, cloudId, cloudName, scanType, jobAttributesEx, jobIdActedOn,vsaParentJobID, commcellId, selectiveVMClientDisplayName, oraBackupRefTimeAndLsn, jobThroughPut, timeThroughPut, stubDataSize,destInstanceId,destInstanceName, objectsFailed, currentPhaseType, distributedAppsClusterType)
	SELECT
	jobId = JMBkpStats.jobId,
    optype = (CASE WHEN JMJobStats.subOpType>0 THEN JMJobStats.subOpType ELSE JMBkpStats.opType END),
	backupType = bkplevel,
	priority,
	totalNumOfFiles = NULL,
	startTime = servStartDate,
	subclientId = app_application.id,
	subclientName,
	clientId = client.id,
	clientName = client.name,
	displayClientName = client.displayName,
	destinationClient = NULL,
    destinationClientDisplayName = NULL,
	destinationclientId = 0,
	instanceId = APP_Application.instance,
	instanceName = (SELECT name FROM APP_InstanceName WITH (READUNCOMMITTED) WHERE id = APP_Application.instance),
	backupsetId = APP_Application.backupSet,
	backupsetName = (SELECT name FROM APP_BackupSetName WITH (READUNCOMMITTED) WHERE id = APP_Application.backupSet),
	appTypeId = APP_Application.appTypeId,
	appTypeName = (SELECT name FROM APP_iDAType WITH (READUNCOMMITTED) WHERE type = APP_Application.appTypeId),
	mediaAgentName = NULL,
	storagePolicyName = CASE
            WHEN APP_Application.appTypeId = 47 OR APP_Application.appTypeId = 50 THEN ISNULL((SELECT name FROM QRPolicy WITH (READUNCOMMITTED) WHERE id = JMBkpStats.dataArchGrpId),'Unavailable')
            WHEN (JMBkpStats.dataBackedUp = 1 AND JMBkpStats.logsBackedUp = 0)
			OR JMBkpStats.opType = 96 --DELAYEDCATALOG
			OR JMBkpStats.bkpAttributesEx&@showSPNameAttributesEx != 0
			THEN
				CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN ''
	            ELSE ISNULL((SELECT name FROM archGroup WITH (READUNCOMMITTED) WHERE id = JMBkpStats.dataArchGrpId),'Unavailable')
				END
            WHEN JMBkpStats.dataBackedUp = 0 AND JMBkpStats.logsBackedUp = 1 THEN
				CASE WHEN JMBkpStats.logArchGrpId = 0 THEN ''
				ELSE ISNULL((SELECT name FROM archGroup WITH (READUNCOMMITTED) WHERE id = JMBkpStats.logArchGrpId), 'Unavailable')
				END
            WHEN JMBkpStats.dataBackedUp = 1 AND JMBkpStats.logsBackedUp = 1 THEN
				CASE WHEN JMBkpStats.dataArchGrpId = 0 THEN  ISNULL((SELECT name FROM archGroup WITH (READUNCOMMITTED) WHERE id = JMBkpStats.logArchGrpId), 'Unavailable')
	            ELSE ISNULL((SELECT name FROM archGroup WITH (READUNCOMMITTED) WHERE id = JMBkpStats.dataArchGrpId),'Unavailable')
				END
			ELSE ''
            END,
	storagePolicyId = CASE
            WHEN APP_Application.appTypeId = 47 OR APP_Application.appTypeId = 50 THEN JMBkpStats.dataArchGrpId
            WHEN (JMBkpStats.dataBackedUp = 1 AND JMBkpStats.logsBackedUp = 0)
			OR JMBkpStats.opType = 96 --DELAYEDCATALOG = 96
			OR JMBkpStats.bkpAttributesEx&@showSPNameAttributesEx != 0
			THEN
				JMBkpStats.dataArchGrpId
            WHEN JMBkpStats.dataBackedUp = 0 AND JMBkpStats.logsBackedUp = 1
			THEN
				JMBkpStats.logArchGrpId
            WHEN JMBkpStats.dataBackedUp = 1 AND JMBkpStats.logsBackedUp = 1 THEN
				CASE WHEN  JMBkpStats.dataArchGrpId = 0 THEN JMBkpStats.logArchGrpId
				ELSE JMBkpStats.dataArchGrpId
				END
			ELSE 0
            END,
	jobStartedBy = UserName,
	currentPhaseName = NULL,
	currentstate = NULL,
	elapsedTime = NULL,
	filesXfered = totalNumOfFiles,
	uncompBytes = totalUncompBytes,
	sizeOnMedia = SM.attributeValueInt,
	totalMediaUsageTime = NULL,
	timeToComplete = NULL,
	lastUpdateFromClient = NULL,
	percentcomplete = NULL,
	currentThroughput = NULL,
	averageThroughput = NULL,
	dbo.JMGetLocalizedMessageFunc(0,failureReason) AS [DelayReason],
    initfrom,
	jobAttributes = bkpattributes,
	numOfStreams = numStreamsRequested,
	jobEndTime = servEndDate,
	totalCompBytes,
	dataXferedNetwork = nwTransBytes,
	transferTime = totalWriteTime,
	scanTypeChangeReason = dbo.JMGetLocalizedMessageFunc(0,scanTypeChangeReason),
	scanFileFailures = ISNULL(scanFileFailures,0),
	scanFolderFailures = ISNULL(scanFolderFailures,0),
	backupFileFailures = ISNULL(backupFileFailures,0),
	backupFolderFailures = ISNULL(backupFolderFailures,0),
	xmlJobInfo = CASE WHEN ((CHARINDEX('UTF-8',JMJobStats.xmlJobInfo) > 0) and (CHARINDEX('<?xml',JMJobStats.xmlJobInfo) > 0) and (CHARINDEX('UTF-8',JMJobStats.xmlJobInfo) < CHARINDEX('?>',JMJobStats.xmlJobInfo) )) THEN
	CAST(STUFF(JMJobStats.xmlJobInfo,CHARINDEX('UTF-8',JMJobStats.xmlJobInfo),LEN('UTF-8'),'UTF-16')  AS XML)
	ELSE
	CAST(JMJobStats.xmlJobInfo AS XML)
	END,
	status = displayStatus,
	throughput = 0,
	totSkipped = JMBkpStats.totSkippedObjects,
	storagePolicyCopyName = NULL,
	isVisible = (CASE WHEN @userName = JMBkpStats.username THEN 1
					  ELSE dbo.isBkpJobVisible(@i_userId,JMBkpStats.commCellId,clientId,appType,instance,backupSet,JMBkpStats.appID)
				 END),
	scheduleName = TM_SubTask.subTaskName,
	schedulePolicyName = TM_Task.taskName,
	subTaskId = TM_SubTask.subTaskId,
	taskId = TM_SubTask.taskId,
	ER_Destination = NULL,
	compressionRatio = 0,
	encrypted = (
				    CASE
                         WHEN JOBAF.encKeyType IS NULL THEN 'Unavailable'
                         WHEN JOBAF.encKeyType > 0 THEN 'Yes'
                         ELSE 'No'
                    END
			    ),
	activeFile = NULL,
	attemptStartTime = 0,
	ER_DbName = NULL,
	srcMediaAgent = NULL,
	destMediaAgent = NULL,
	LibraryID = 0,
	LibraryName = NULL,
	MI_InventoryType = 0,
	cloudId = 0,
	cloudName = NULL,
	scanType = scantype,
	jobAttributesEx = bkpAttributesEx,
	--To be fixed properly in SP13 by adding new field
	jobIdActedOn = jobIdActedOn,
	vsaParentJobID = ISNULL(dataLink.parentJobId,0),
	commcellId = JMJobStats.commCellId,
	selectiveVMClient.displayName,
	oraBackupRefTimeAndLsn = refTimeAndLsn.attributeValue,
	jobThroughPut = throughPutOptions.attributeValue,
	timeThroughPut = throughPutTimeOptions.timeThroughPut,
	stubDataSize = stubSizeOption.attributeValueInt,
	destInstanceId = 0,
	destInstanceName = NULL,
	objectsFailed = NULL,
	currentPhaseType = NULL,
	distributedAppsClusterType = DISTCT.attrVal
	FROM JMBkpStats INNER JOIN APP_Application ON JMBkpStats.appId = APP_Application.id
	INNER JOIN JMJobStats ON  JMBkpStats.jobId = JMJobStats.jobId AND JMBkpStats.commCellId = JMJobStats.commcellId
LEFT OUTER JOIN JMJobOptions SM WITH(NOLOCK) ON JMBkpStats.jobId = SM.jobId AND JMBkpStats.commCellId = SM.commCellId AND SM.attributeId = 73
	LEFT OUTER JOIN TM_SubTask ON TM_SubTask.subTaskId=JMBkpStats.subTaskId
	LEFT OUTER JOIN TM_Task ON TM_Task.taskId= TM_SubTask.taskId
	LEFT OUTER JOIN (SELECT AF.jobId, AF.commCellId, encKeyType = MAX(AFC.encKeyType) FROM archFile AF WITH (NOLOCK) INNER JOIN archFileCopy AFC WITH (NOLOCK) ON AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId WHERE AF.isValid = 1 GROUP BY AF.jobId, AF.commCellId) JOBAF ON JMBkpStats.jobId = JOBAF.jobId AND JMBkpStats.commCellId = JOBAF.commCellId
LEFT OUTER JOIN JMJobDataLink dataLink WITH(NOLOCK) ON dataLink.childJobId = JMBkpStats.jobId AND dataLink.commCellId = JMBkpStats.commCellId AND dataLink.linkType = 7
	LEFT OUTER JOIN APP_Client client WITH(NOLOCK) ON (CASE bkpattributes & 0x100000000 WHEN 0x100000000 THEN targetClientId ELSE APP_Application.clientId END) = client.id
LEFT OUTER JOIN JMMisc selectiveVMClientMisc WITH(NOLOCK) on selectiveVMClientMisc.jobId = JMBkpStats.jobId AND selectiveVMClientMisc.commcellId = JMBkpStats.commCellId AND selectiveVMClientMisc.itemType = 81 --JM_SELECTIVE_VM_CLIENT_ID
	LEFT OUTER JOIN APP_Client selectiveVMClient WITH(NOLOCK) ON selectiveVMClient.id = selectiveVMClientMisc.intData
LEFT OUTER JOIN JMJobOptions throughPutOptions WITH(NOLOCK) ON JMBkpStats.jobId = throughPutOptions.jobId AND JMBkpStats.commCellId = throughPutOptions.commCellId AND throughPutOptions.attributeId = 86
	LEFT OUTER JOIN #throughputJobs throughPutTimeOptions WITH(NOLOCK) ON JMBkpStats.jobId = throughPutTimeOptions.t_jobID AND JMBkpStats.commCellId = throughPutTimeOptions.t_commCellId
LEFT OUTER JOIN JMJobOptions refTimeAndLsn WITH(NOLOCK) ON JMBkpStats.jobId = refTimeAndLsn.jobId AND JMBkpStats.commCellId = refTimeAndLsn.commCellId AND refTimeAndLsn.attributeId = 1 --JM_ORACLE_BACKUP_TIME
LEFT OUTER JOIN JMJobOptions stubSizeOption WITH(NOLOCK) ON JMBkpStats.jobId = stubSizeOption.jobId AND JMBkpStats.commCellId = stubSizeOption.commCellId AND stubSizeOption.attributeId = 26
	LEFT OUTER JOIN APP_InstanceProp DISTCT (NOLOCK) ON DISTCT.componentNameId = APP_Application.instance AND DISTCT.attrName = 'Distributed Cluster Type' AND DISTCT.modified = 0
	WHERE JMBkpStats.jobId = @i_jobId AND JMBkpStats.commCellId = @i_commcellId
UNION ALL
	SELECT
	jobId = JMRestoreStats.jobId,
	optype = (CASE WHEN JMJobStats.subOpType>0 THEN JMJobStats.subOpType ELSE JMRestoreStats.opType END),
	backupType = NULL,
	priority,
	totalNumOfFiles = isnull(convert(bigint,totFiles2Xfer_h)*2147483648 + convert(bigint,totFiles2Xfer_l),0),
	startTime = servStartTime,
	subclientId = 0,
	subclientName = NULL,
	clientId = client.id,
	clientName = client.name,
	displayClientName = client.displayName,
	destinationClient = (SELECT name FROM APP_Client WITH (READUNCOMMITTED) WHERE id = destClientId),
    destinationClientDisplayName= (SELECT displayname FROM APP_Client WITH (READUNCOMMITTED) WHERE id = destClientId),
	destinationclientId = destClientId,
	instanceId = instanceID,
	instanceName = (SELECT name FROM APP_InstanceName WITH (READUNCOMMITTED) WHERE id = instanceID),
	backupsetId = JMRestoreStats.bkpSetID,
	backupsetName = '',
	appTypeId = JMRestoreStats.appType ,
	appTypeName = '',
	mediaAgentName = ISNULL((SUBSTRING((SELECT ',' + RTRIM(LTRIM(CL.name)) AS [text()]
								 FROM  JMJobOptions JO
								 INNER JOIN APP_Client CL ON JO.attributeValue = CL.id
WHERE JO.jobId = JMRestoreStats.jobId AND JO.commCellId = @i_commcellId AND JO.attributeId = 46
								 ORDER BY CL.name ASC
								 FOR XML PATH('')
								 ),2,1024)
							 ), 'N/A'),
	storagePolicyName = NULL,
	storagePolicyId = 0,
	jobStartedBy = UserName,
	currentPhaseName = NULL,
	currentstate = NULL,
	elapsedTime = NULL,
	filesXfered = isnull(convert(bigint,totSuccess_h)*2147483648 + convert(bigint,totSuccess_l),0),
	uncompBytes = isnull(convert(bigint,totUncompBytes_h)*2147483648 + convert(bigint,totUncompBytes_l),0),
	sizeOnMedia = isnull(convert(bigint,totCompBytes_h)*2147483648 + convert(bigint,totCompBytes_l),0),
	totalMediaUsageTime = NULL,
	timeToComplete = NULL,
	lastUpdateFromClient = NULL,
	percentcomplete = NULL,
	currentThroughput = null,
	averageThroughput = null,
	dbo.JMGetLocalizedMessageFunc(0,failureReason) AS [DelayReason],
	jobStartedFrom = initfrom,
	jobAttributes = rstattributes,
	numOfStreams = null,
	jobEndTime = servEndTime,
	totalCompBytes = isnull(convert(bigint,totCompBytes_h)*2147483648 + convert(bigint,totCompBytes_l),0),
	dataXferedNetwork = 0,
	transferTime = JMRestoreStats.duration,
	scanTypeChangeReason = '',
	scanFileFailures = JMRestoreStats.totFailed,
	scanFolderFailures = 0,
	backupFileFailures = 0,
	backupFolderFailures = 0,
	xmlJobInfo = CASE WHEN ((CHARINDEX('UTF-8',JMJobStats.xmlJobInfo) > 0) and (CHARINDEX('<?xml',JMJobStats.xmlJobInfo) > 0) and (CHARINDEX('UTF-8',JMJobStats.xmlJobInfo) < CHARINDEX('?>',JMJobStats.xmlJobInfo) )) THEN
	CAST(STUFF(JMJobStats.xmlJobInfo,CHARINDEX('UTF-8',JMJobStats.xmlJobInfo),LEN('UTF-8'),'UTF-16')  AS XML)
	ELSE
	CAST(JMJobStats.xmlJobInfo AS XML)
	END,
	status = JMRestoreStats.status,
	throughput = 0,
	totSkipped = JMRestoreStats.totSkipped,
	storagePolicyCopyName = NULL,
	isVisible = (CASE WHEN @userName = JMRestoreStats.username THEN 1
					  ELSE dbo.isRstJobVisible(@i_userId,JMRestoreStats.commCellId,srcClientID,destClientID,appType,instanceID,bkpSetID)
				 END),
	scheduleName = TM_SubTask.subTaskName,
	schedulePolicyName = TM_Task.taskName,
	subTaskId = TM_SubTask.subTaskId,
	taskId = TM_SubTask.taskId,
	ER_Destination = NULL,
	compressionRatio = 0,
	encrypted = NULL,
	activeFile = NULL,
	attemptStartTime = 0,
	ER_DbName = NULL,
	srcMediaAgent = NULL,
	destMediaAgent = NULL,
	LibraryID = 0,
	LibraryName = NULL,
	MI_InventoryType = 0,
	cloudId = 0,
	cloudName = NULL,
	scanType = 0,
	jobAttributesEx = 0,
	jobIdActedOn = 0,
	vsaParentJobID = 0,
	commcellId = JMJobStats.commCellId,
	selectiveVMClientDisplayName = NULL,
	oraBackupRefTimeAndLsn = NULL,
	jobThroughPut = NULL,
	timeThroughPut = throughPutTimeOptions.attributeValue,
	stubDataSize = NULL,
	destInstanceId = destInstanceId,
	destInstanceName = (SELECT name FROM APP_InstanceName WITH (READUNCOMMITTED) WHERE id = destInstanceId),
	objectsFailed = NULL,
	currentPhaseType = NULL,
	distributedAppsClusterType = DISTCT.attrVal
	FROM JMRestoreStats
	INNER JOIN JMJobStats ON  JMRestoreStats.jobId = JMJobStats.jobId
		AND JMRestoreStats.commCellId = JMJobStats.commCellId
		AND JMRestoreStats.jobId = @i_jobId
		AND JMRestoreStats.commCellId = @i_commcellId
	LEFT OUTER JOIN TM_SubTask ON TM_SubTask.subTaskId = JMRestoreStats.subTaskId
	LEFT OUTER JOIN TM_Task ON TM_Task.taskId = TM_SubTask.taskId
	LEFT OUTER JOIN APP_Client client WITH(NOLOCK) ON srcClientId = client.id
LEFT OUTER JOIN JMJobOptions throughPutTimeOptions WITH(NOLOCK) ON JMRestoreStats.jobId = throughPutTimeOptions.jobId AND JMRestoreStats.commCellId = throughPutTimeOptions.commCellId AND throughPutTimeOptions.attributeId = 91
	LEFT OUTER JOIN APP_InstanceProp DISTCT (NOLOCK) ON DISTCT.componentNameId = (CASE WHEN JMRestoreStats.instanceID > 1 THEN JMRestoreStats.instanceID ELSE JMRestoreStats.destInstanceId END) AND DISTCT.attrName = 'Distributed Cluster Type' AND DISTCT.modified = 0
UNION ALL
	SELECT
	jobId = JMA.jobId,
	optype = (CASE WHEN JMJobStats.subOpType>0 THEN  JMJobStats.subOpType ELSE JMA.opType END),
	backupType = JMA.ER_BkpLevel,
	priority = JMA.priority,
	totalNumOfFiles = (CASE WHEN JMJobStats.subOpType = 143 THEN JMA.EX_TotalMedia
						ELSE JMA.numFiles
						END),
	startTime = JMA.servStart,
	subclientId = APP.id,
	subclientName = APP.subclientName,
	clientId = client.id,
	clientName = client.name,
	displayClientName = client.displayName,
	destinationClient = NULL,
    destinationClientDisplayName = NULL,
	destinationclientId = 0,
	instanceId = APP.instance,
	instanceName = (SELECT name FROM APP_InstanceName WITH (READUNCOMMITTED) WHERE id = APP.instance),
	backupsetId = APP.backupSet,
	backupsetName = (SELECT name FROM APP_BackupSetName WITH (READUNCOMMITTED) WHERE id = APP.backupSet),
	appTypeId = APP.appTypeId,
	appTypeName = (SELECT name FROM APP_iDAType WITH (READUNCOMMITTED) WHERE type = APP.appTypeId),
	mediaAgentName = NULL,
	storagePolicyName = CASE
						WHEN JMA.archGrpName IS NULL OR len(cast(JMA.archGrpName as nvarchar(max)))=0 THEN (SELECT name FROM archGroup WITH (READUNCOMMITTED) WHERE id = JMA.ArchGrpId)
						ELSE  JMA.archGrpName
					    END,
	storagePolicyId = JMA.ArchGrpId,
	jobStartedBy = UserName,
	currentPhaseName = NULL,
	currentstate = NULL,
	elapsedTime = NULL,
	filesXfered = JMA.EX_TotalSuccess,
	uncompBytes = JMA.uncompBytes,
	sizeOnMedia = SM.attributeValueInt,
	totalMediaUsageTime = JMA.totalWriteTime,
	timeToComplete = NULL,
	lastUpdateFromClient = NULL,
	percentcomplete = NULL,
	currentThroughput = null,
	averageThroughput = null,
	dbo.JMGetLocalizedMessageFunc(0,failureReason) AS [DelayReason],
	jobStartedFrom = initfrom,
	jobAttributes = null,
	numOfStreams = JMA.noOfStreams,
	jobEndTime = JMA.servEnd,
	totalCompBytes = JMA.TotalSize,
	dataXferedNetwork = nwTransBytes,
	transferTime = JMA.totalWriteTime,
	scanTypeChangeReason = NULL,
	scanFileFailures = null,
	scanFolderFailures = null,
	backupFileFailures = NULL,
	backupFolderFailures = NULL,
	xmlJobInfo = CASE WHEN ((CHARINDEX('UTF-8',JMJobStats.xmlJobInfo) > 0) and (CHARINDEX('<?xml',JMJobStats.xmlJobInfo) > 0) and (CHARINDEX('UTF-8',JMJobStats.xmlJobInfo) < CHARINDEX('?>',JMJobStats.xmlJobInfo) )) THEN
	CAST(STUFF(JMJobStats.xmlJobInfo,CHARINDEX('UTF-8',JMJobStats.xmlJobInfo),LEN('UTF-8'),'UTF-16')  AS XML)
	ELSE
	CAST(JMJobStats.xmlJobInfo AS XML)
	END,
	status = JMA.status,
	throughput = 0,
	totSkipped = JMA.skippedItems,
	storagePolicyCopyName = CASE
            WHEN archGrpCopyID = 0 THEN 'All Copies'
            ELSE ISNULL((SELECT name FROM archGroupCopy WITH (READUNCOMMITTED) WHERE id = archGrpCopyID),'Unavailable')
            END,
	isVisible = (CASE WHEN @userName = JMA.username THEN 1
					  WHEN UIC.userId IS NOT NULL THEN 1
					  ELSE dbo.isAdminJobVisible(@i_userId,JMA.commcellId,archGrpID,JMA.jobId,JMA.opType, 0)
				 END),
	scheduleName = TM_SubTask.subTaskName,
	schedulePolicyName = TM_Task.taskName,
	subTaskId = TM_SubTask.subTaskId,
	taskId = TM_SubTask.taskId,
	ER_Destination = JMA.ER_Destination,
	compressionRatio = 0,
	encrypted = NULL,
	activeFile = NULL,
	attemptStartTime = 0,
	ER_DbName = ER_DbName,
	srcMediaAgent = NULL,
	destMediaAgent = NULL,
	LibraryID = LibraryID,
	LibraryName = CASE
			WHEN LibraryID = 0 THEN ''
            ELSE ISNULL((SELECT AliasName FROM MMLibrary WITH (READUNCOMMITTED) WHERE MMLibrary.LibraryId = JMA.LibraryID),'Unavailable')
            END,
	MI_InventoryType = MI_InventoryType,
	cloudId = JMA.cloudId,
	cloudName = (CASE
            WHEN JMA.cloudId = 0 THEN ''
            WHEN JMJobStats.opType IN(89,90,108,113,134) THEN ISNULL((SELECT name FROM APP_Client WITH (READUNCOMMITTED) where id = JMA.cloudId),'')
            WHEN JMJobStats.opType = 31 THEN ISNULL((SELECT SIDBStoreAliasName FROM IdxSIDBStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = JMA.cloudId AND SIDBStoreId <> 0), '')
            WHEN JMJobStats.subOpType IN ( 103,112) THEN ISNULL(( DC.name),'')
            ELSE ISNULL((cp.stringVal ),'')
            END),
	scanType = 0,
	jobAttributesEx = 0,
	jobIdActedOn = 0,
	vsaParentJobID = 0,
	commcellId = JMJobStats.commCellId,
	selectiveVMClientDisplayName = NULL,
	oraBackupRefTimeAndLsn = NULL,
	jobThroughPut = NULL,
	timeThroughPut = NULL,
	stubDataSize = stubSizeOption.attributeValueInt,
	destInstanceId = 0,
	destInstanceName = NULL,
	objectsFailed = EX_TotalFailures,
	currentPhaseType = NULL,
	distributedAppsClusterType = 0
	FROM JMAdminJobStatsTable JMA
	INNER JOIN JMJobStats ON JMA.jobId = JMJobStats.jobId
		AND JMA.commCellId = JMJobStats.commCellId
		AND JMA.jobId = @i_jobId
		AND JMA.commCellId = @i_commcellId
	LEFT OUTER JOIN APP_Application APP ON JMA.appId = APP.id
LEFT OUTER JOIN JMJobOptions SM WITH(NOLOCK) ON JMA.jobId = SM.jobId AND JMA.commCellId = SM.commCellId AND SM.attributeId = 73
	LEFT OUTER JOIN TM_SubTask ON TM_SubTask.subTaskId = JMA.subTaskId
	LEFT OUTER JOIN TM_Task ON TM_Task.taskId = TM_SubTask.taskId
	LEFT OUTER JOIN DM2Cloud DC ON DC.cloudId = JMA.cloudId
	LEFT OUTER JOIN app_componentProp CP ON CP.ID = JMA.cloudId and CP.componentId=2 AND CP.propertyTypeId=1 AND CP.modified=0
	LEFT OUTER JOIN APP_Client client WITH(NOLOCK) ON APP.clientId = client.id
	LEFT OUTER JOIN #getUsersInCompanyOutputTbl UIC ON UIC.userId = (SELECT id FROM UMUsers WHERE login=JMA.UserName)
LEFT OUTER JOIN JMJobOptions stubSizeOption WITH(NOLOCK) ON JMA.jobId = stubSizeOption.jobId AND JMA.commCellId = stubSizeOption.commCellId AND stubSizeOption.attributeId = 26
	IF @@ROWCOUNT > 0
	BEGIN
		SET @jobCompleted = 1
		UPDATE @JobDetails
		SET
			appTypeId = (CASE appTypeId
							WHEN 0 THEN T.aptId
							ELSE appTypeId
						END),
			appTypeName = (SELECT name FROM APP_iDAType WITH (READUNCOMMITTED) WHERE type = (CASE appTypeId
							WHEN 0 THEN T.aptId
							ELSE appTypeId
						END)),
			backupsetId = bkSetId,
			backupsetName = bkSetName
		FROM
		(
			SELECT APP_iDAType.name appTypeName, APP_Application.appTypeId aptId, APP_Application.backupSet bkSetId, APP_BackupSetName.name bkSetName
			FROM @jobDetails D
			JOIN APP_Application (NOLOCK) ON D.backupsetId = APP_Application.backupSet
AND subclientStatus & 0x00008 = 0x00008 -- Get the default subclient and remove distinct
				AND subclientStatus & (16 | 32 | 512) = 0 -- (CV_STATUS_DUMMY, CV_STATUS_HIDDEN, Index subclient)
			JOIN APP_BackupSetName (READUNCOMMITTED) ON APP_BackupSetName.id = APP_Application.backupSet
			JOIN APP_iDAType WITH (READUNCOMMITTED) ON APP_iDAType.type = (CASE D.appTypeId
					WHEN 0 THEN APP_Application.appTypeId
					ELSE D.appTypeId
				END)
		) T
	END
	ELSE
	BEGIN
        INSERT INTO @JobDetails(jobId, optype, backupType,priority,totalNumOfFiles,startTime,subclientId,subclientName,clientId,clientName, displayClientName,destinationClient, destinationClientDisplayName, destinationclientId, instanceId,instanceName,backupsetId,backupsetName,appTypeId,appTypeName,
			mediaAgentName, storagePolicyName, storagePolicyId, jobStartedBy,currentPhaseName,currentstate,elapsedTime,filesXfered,uncompBytes, sizeOnMedia, totalMediaUsageTime,
			timeToComplete,lastUpdateFromClient,percentcomplete,currentThroughput,averageThroughput,DelayReason, jobStartedFrom, jobAttributes,numOfStreams,
			jobEndTime, totalCompBytes, dataXferedNetwork, transferTime, scanTypeChangeReason,
			scanFileFailures,scanFolderFailures, backupFileFailures, backupFolderFailures, xmlJobInfo, status, throughput, totSkipped, storagePolicyCopyName, isVisible, scheduleName, schedulePolicyName, subTaskId, taskId, ER_Destination, compressionRatio, encrypted, activeFile, attemptStartTime, ER_DbName, srcMediaAgent, destMediaAgent,
			LibraryID, LibraryName, MI_InventoryType, cloudId, cloudName, scanType, jobAttributesEx, jobIdActedOn,vsaParentJobID, isAnomalous, thresholdTime, possibleReasonForDelay, commcellId, totReadBytes, totReadTime, totPhysicalWriteBytes, totPhysicalWriteTime, nwTransBytes, totNwTransTime, totSidbLookups, totSidbLookupTime,
			readCurrentThroughput, readAverageThroughput, writeCurrentThroughput, writeAverageThroughput, ntwkCurrentThroughput, ntwkAverageThroughput, sidbCurrentLookups, sidbAverageLookups, phasePercentagesList, phaseTimingsList, currentPhase, selectiveVMClientDisplayName,
			totalThroughputTime, readPercentageTime, writePercentageTime, networkPercentageTime, sidbPercentageTime, stubDataSize, destInstanceId, destInstanceName, objectsFailed, currentPhaseType, distributedAppsClusterType)
		SELECT
		RunningBackups.jobId,
		opType,
		backupType = bkpLevel,
		priority = combPriority,
		totalNumOfFiles = filesToXfer,
		startTime = jobStartTime,
		subclientId = applicationId,
		subclientName = subclientName,
		clientId = clientId,
		clientName = clientName,
		displayClientName = clientDisplayName,
		destinationClient = NULL,
        destinationClientDisplayName = NULL,
		destinationclientId = 0,
		instanceId = instance,
		instanceName = instanceName,
		backupsetId = backupSet,
		backupsetName = backupsetName,
		appTypeId = appTypeId,
		appTypeName = appTypeName,
		mediaAgentName = shortMediaAgent,
		storagePolicyName = currentPolicyName,
		storagePolicyId = currentPolicy,
		jobStartedBy = UserName,
		currentPhaseName,
		currentstate = displayState,
		elapsedTime,
		filesXfered = filesXfered,
		uncompBytes = uncompBytes,
		sizeOnMedia = NULL,
		totalMediaUsageTime,
		timeToComplete,
		lastUpdateFromClient,
		percentcomplete,
		currentThroughput,
		averageThroughput,
		DelayReason,
		jobStartedFrom = initFrom,
		jobAttributes = bkpattributes,
		numOfStreams = numStreams,
		jobEndTime = null,
		totalCompBytes = compBytes,
		dataXferedNetwork = nwTransBytes,
		transferTime = totalMediaUsageTime,
		scanTypeChangeReason,
		scanFileFailures = ISNULL(scanFileFailures,0),
		scanFolderFailures = ISNULL(scanFolderFailures,0),
		backupFileFailures = ISNULL(backupFileFailures,0),
		backupFolderFailures = ISNULL(backupFolderFailures,0),
		xmlJobInfo =  CASE WHEN ((CHARINDEX('UTF-8',xmlJobInfo) > 0) and (CHARINDEX('<?xml',xmlJobInfo) > 0) and (CHARINDEX('UTF-8',xmlJobInfo) < CHARINDEX('?>',xmlJobInfo) )) THEN
		CAST(STUFF(xmlJobInfo,CHARINDEX('UTF-8',xmlJobInfo),LEN('UTF-8'),'UTF-16')  AS XML)
		ELSE
		CAST(xmlJobInfo AS XML)
		END,
		status = null,
		throughput = 0,
		totSkipped = totSkippedObjects,
		storagePolicyCopyName = NULL,
		isVisible = (CASE WHEN @i_userId = userId THEN 1
						  ELSE dbo.isBkpJobVisible(@i_userId,RunningBackups.commCellId,clientId,appTypeId,instance,backupSet,applicationId)
					END),
		scheduleName = subTaskName,
		schedulePolicyName = taskName,
		subTaskId = backupTaskId,
		taskId = taskId,
		ER_Destination = NULL,
		compressionRatio = CASE uncompBytes
								WHEN 0 THEN 0
								ELSE (CAST((uncompBytes - compBytes) AS float) * 100) / CAST(uncompBytes as float)
								END,
		encrypted = encrypted,
		activeFile = activeFile,
		attemptStartTime = attemptStartTime,
		ER_DbName = NULL,
		srcMediaAgent = NULL,
		destMediaAgent = NULL,
		LibraryID = 0,
		LibraryName = NULL,
		MI_InventoryType = 0,
		cloudId = 0,
		cloudName = NULL,
		scanType = scantype,
		jobAttributesEx = bkpAttributesEx,
		--To be fixed properly in SP13 by adding new field
		jobIdActedOn =jobIdActedOn,
		vsaParentJobID = ISNULL(dataLink.parentJobId,0),
		isAnomalous = CASE WHEN RunningBackups.guiAlertColorLevel >= 100000 THEN 1 END,
		thresholdTime = CASE WHEN forecast.attributeValueInt IS NOT NULL AND forecast.attributeValueInt > 0 THEN forecast.attributeValueInt + (forecast.attributeValueInt * 0.05) END,
		possibleReasonForDelay = CASE WHEN RunningBackups.guiAlertColorLevel >= 100000 THEN dbo.NTGetPossibleCausesForLongRunTime(RunningBackups.jobId, 0, @i_localeId) END,
		commcellId = RunningBackups.commCellId,
		totReadBytes = totReadBytes,
		totReadTime = totReadTime,
		totPhysicalWriteBytes = totPhysicalWriteBytes,
		totPhysicalWriteTime = totPhysicalWriteTime,
		nwTransBytes = nwTransBytes,
		totNwTransTime = totNwTransTime,
		totSidbLookups = totSidbLookups,
		totSidbLookupTime = totSidbLookupTime,
		readCurrentThroughput = readCurrentThroughput,
		readAverageThroughput = readAverageThroughput,
		writeCurrentThroughput = writeCurrentThroughput,
		writeAverageThroughput = writeAverageThroughput,
		ntwkCurrentThroughput = networkCurrentThroughput,
		ntwkAverageThroughput = networkAverageThroughput,
		sidbCurrentLookups = sidbCurrentLookups,
		sidbAverageLookups = sidbAverageLookups,
		phasePercentagesList,
		phaseTimingsList,
		currentPhase,
		selectiveVMClientDisplayName,
		totalThroughputTime = NULL,
		readPercentageTime = NULL,
		writePercentageTime = NULL,
		networkPercentageTime = NULL,
		sidbPercentageTime = NULL,
		stubDataSize = stubSizeOption.attributeValueInt,
		destInstanceId = 0,
		destInstanceName = NULL,
		objectsFailed = NULL,
		currentPhaseType,
		distributedAppsClusterType = DISTCT.attrVal
		FROM RunningBackups
LEFT OUTER JOIN JMJobDataLink dataLink WITH(NOLOCK) ON dataLink.childJobId = RunningBackups.jobId AND dataLink.commCellId = RunningBackups.commCellId AND dataLink.linkType = 7
LEFT OUTER JOIN JMJobOptions stubSizeOption WITH(NOLOCK) ON RunningBackups.jobId = stubSizeOption.jobId AND RunningBackups.commCellId = stubSizeOption.commCellId AND stubSizeOption.attributeId = 26
LEFT OUTER JOIN JmJobOptions forecast WITH(NOLOCK) ON forecast.jobId = RunningBackups.jobId AND forecast.attributeId = 76 AND forecast.commcellId = RunningBackups.commCellId
		LEFT OUTER JOIN APP_InstanceProp DISTCT (NOLOCK) ON DISTCT.componentNameId = RunningBackups.instance AND DISTCT.attrName = 'Distributed Cluster Type' AND DISTCT.modified = 0
		WHERE RunningBackups.jobID = @i_jobId AND RunningBackups.commCellId = @i_commcellId
	UNION ALL
		SELECT
		jobId,
		opType,
		backupType = NULL,
		priority = combPriority,
		totalNumOfFiles = totFiles2Xfer,
		startTime = jobStartTime,
		subclientId = 0,
		subclientName = backupSetName,
		clientId = srcClientId,
		clientName = srcClientName,
		displayClientName = srcClientDisplayName,
		destClientName,
        destinationClientDisplayName = destClientDisplayName,
		destinationclientId = destClientId,
		instanceId = instanceId,
		instanceName = instanceName,
		backupsetId = bkpSetId,
		backupsetName = backupsetName,
		appTypeId = appType,
		appTypeName = appTypeName,
		mediaAgentName = shortMediaAgent,
		storagePolicyName = '',
		storagePolicyId = 0,
		jobStartedBy = UserName,
		currentPhaseName = currentPhaseName,
		currentstate = displayState,
		elapsedTime,
		filesXfered = totSuccess,
		uncompBytes = totUnCompBytes,
		sizeOnMedia = totCompBytes,
		totalMediaUsageTime = 0,
		timeToComplete = timeToComplete,
		lastUpdateFromClient = lastUpdateFromClient,
		percentcomplete = percentcomplete,
		currentThroughput = currentThroughput,
		averageThroughput = averageThroughput,
		DelayReason,
		jobStartedFrom = initFrom,
		jobAttributes = rstattributes,
		numOfStreams = null,
		jobEndTime = null,
		totalCompBytes = null,
		dataXferedNetwork = null,
		transferTime = null,
		scanTypeChangeReason = null,
		scanFileFailures = totFailures,
		scanFolderFailures = 0,
		backupFileFailures = 0,
		backupFolderFailures = 0,
		xmlJobInfo =  CASE WHEN ((CHARINDEX('UTF-8',xmlJobInfo) > 0) and (CHARINDEX('<?xml',xmlJobInfo) > 0) and (CHARINDEX('UTF-8',xmlJobInfo) < CHARINDEX('?>',xmlJobInfo) )) THEN
		CAST(STUFF(xmlJobInfo,CHARINDEX('UTF-8',xmlJobInfo),LEN('UTF-8'),'UTF-16')  AS XML)
		ELSE
		CAST(xmlJobInfo AS XML)
		END,
		status = null,
		throughput = 0,
		totSkipped = totSkipped,
		storagePolicyCopyName = NULL,
		isVisible = (CASE WHEN @i_userId = userId THEN 1
						  ELSE dbo.isRstJobVisible(@i_userId,commCellId,srcClientid,destClientid,apptype,instanceid,bkpSetId)
					 END),
		scheduleName = subTaskName,
		schedulePolicyName = taskName,
		subTaskId = rstTaskID,
		taskId = taskId,
		ER_Destination = NULL,
		compressionRatio = 0,
		encrypted = NULL,
		activeFile = NULL,
		attemptStartTime = attemptStartTime,
		ER_DbName = NULL,
		srcMediaAgent = NULL,
		destMediaAgent = NULL,
		LibraryID = 0,
		LibraryName = NULL,
		MI_InventoryType = 0,
		cloudId = 0,
		cloudName = NULL,
		scanType = 0,
		jobAttributesEx = 0,
		jobIdActedOn = 0,
		vsaParentJobID = 0,
		isAnomalous = NULL,
		thresholdTime = NULL,
		possibleReasonForDelay = NULL,
		commcellId = commCellId,
		totReadBytes = totReadBytes,
		totReadTime = totReadTime,
		totPhysicalWriteBytes = totPhysicalWriteBytes,
		totPhysicalWriteTime = totPhysicalWriteTime,
		nwTransBytes = totNwTransBytes,
		totNwTransTime = totNwTransTime,
		totSidbLookups = totSidbLookups,
		totSidbLookupTime = totSidbLookupTime,
		readCurrentThroughput = readCurrentThroughput,
		readAverageThroughput = readAverageThroughput,
		writeCurrentThroughput = writeCurrentThroughput,
		writeAverageThroughput = writeAverageThroughput,
		ntwkCurrentThroughput = networkCurrentThroughput,
		ntwkAverageThroughput = networkAverageThroughput,
		sidbCurrentLookups = sidbCurrentLookups,
		sidbAverageLookups = sidbAverageLookups,
		phasePercentagesList = NULL,
		phaseTimingsList = NULL,
		currentPhase = NULL,
		selectiveVMClientDisplayName = NULL,
		totalThroughputTime = NULL,
		readPercentageTime = NULL,
		writePercentageTime = NULL,
		networkPercentageTime = NULL,
		sidbPercentageTime = NULL,
		stubDataSize = NULL,
		destInstanceId = destInstanceId,
		destInstanceName = destInstanceName,
		objectsFailed = NULL,
		currentPhaseType = NULL,
		distributedAppsClusterType = DISTCT.attrVal
		FROM RunningRestores
		LEFT OUTER JOIN APP_InstanceProp DISTCT (NOLOCK) ON DISTCT.componentNameId = (CASE WHEN RunningRestores.instanceID > 1 THEN RunningRestores.instanceID ELSE RunningRestores.destInstanceId END)
																AND DISTCT.attrName = 'Distributed Cluster Type' AND DISTCT.modified = 0
		WHERE jobID = @i_jobId
		AND RunningRestores.commCellId = @i_commcellId
	UNION ALL
		SELECT
		jobId = RA.jobId,
		optype = RA.opType,
		backupType = RA.ER_BkpLevel,
		priority = RA.combPriority,
		totalNumOfFiles = (CASE RA.opType
							  WHEN 36 THEN RA.TotalObjects
							  WHEN 31 THEN RA.TotalObjects
							  WHEN 143 THEN RA.TotalObjects
		                      ELSE RA.numFiles
						   END),
		startTime = RA.jobStartTime,
		subclientId = RA.appId,
		subclientName = RA.subclientName,
		clientId = RA.clientId,
		clientName = RA.clientName,
		displayClientName = RA.clientDisplayName,
		destinationClient = NULL,
        destinationClientDisplayName = NULL,
		destinationclientId = 0,
		instanceId = RA.instance,
		instanceName = RA.instanceName,
		backupsetId = RA.backupSet,
		backupsetName = RA.backupsetName,
		appTypeId = RA.appType,
		appTypeName = RA.appTypeName,
		mediaAgentName = NULL,
		storagePolicyName = RA.storagePolicyName,
		storagePolicyId = RA.archGrpID,
		jobStartedBy = UserName,
		currentPhaseName = RA.currentPhaseName,
		currentstate = RA.displayState,
		elapsedTime = RA.elapsedTime,
		filesXfered = RA.ObjectsDone,
		uncompBytes = RA.uncompBytes,
		sizeOnMedia = NULL,
		totalMediaUsageTime = RA.writeTime,
		timeToComplete = RA.timeToComplete,
		lastUpdateFromClient = RA.lastUpdateFromClient,
		percentcomplete = RA.percentcomplete,
		currentThroughput = RA.currentThroughput,
		averageThroughput = CASE WHEN RA.averageThroughput > 0 THEN (RA.averageThroughput * 60.0 * 60.0)/(1024 * 1024 * 1024) ELSE 0.0 END, --Converting to GB/Hr
		dbo.JMGetLocalizedMessageFunc(0,failureReason) AS [DelayReason],
		jobStartedFrom = initfrom,
		jobAttributes = 0,
		numOfStreams = RA.noOfStreams,
		jobEndTime = NULL,
		totalCompBytes = RA.TotalSize,
		dataXferedNetwork = nwTransBytes,
		transferTime = RA.writeTime,
		scanTypeChangeReason = NULL,
		scanFileFailures = NULL,
		scanFolderFailures = NULL,
		backupFileFailures = NULL,
		backupFolderFailures = NULL,
		xmlJobInfo =  CASE WHEN ((CHARINDEX('UTF-8',xmlJobInfo) > 0) and (CHARINDEX('<?xml',xmlJobInfo) > 0) and (CHARINDEX('UTF-8',xmlJobInfo) < CHARINDEX('?>',xmlJobInfo) )) THEN
		CAST(STUFF(xmlJobInfo,CHARINDEX('UTF-8',xmlJobInfo),LEN('UTF-8'),'UTF-16')  AS XML)
		ELSE
		CAST(xmlJobInfo AS XML)
		END,
		status = NULL,
		throughput = 0,
		totSkipped = RA.skippedItems,
		storagePolicyCopyName = CopyName,
		isVisible = (CASE WHEN @i_userId = RA.userId THEN 1
						  WHEN UIC.userId IS NOT NULL THEN 1
						  ELSE dbo.isAdminJobVisible(@i_userId,RA.commCellId,archGrpID,RA.jobID,opType,0)
					 END),
		scheduleName = subTaskName,
		schedulePolicyName = taskName,
		subTaskId = subTaskId,
		taskId = taskId,
		ER_Destination = RA.ER_Destination,
		compressionRatio = 0,
		encrypted = NULL,
		activeFile = activeFile,
		attemptStartTime = attemptStartTime,
		ER_DbName = ER_DbName,
		srcMediaAgent = srcMediaAgent,
		destMediaAgent = destMediaAgent,
		LibraryID = LibraryID,
		LibraryName = LibraryName,
		MI_InventoryType = MI_InventoryType,
		cloudId = cloudId,
		cloudName = cloudName,
		scanType = 0,
		jobAttributesEx = 0,
		jobIdActedOn = 0,
		vsaParentJobID = 0,
		isAnomalous = CASE WHEN RA.guiAlertColorLevel >= 100000 THEN 1 END,
		thresholdTime = CASE WHEN LongRunning.attributeValueInt IS NOT NULL AND LongRunning.attributeValueInt > 0 THEN LongRunning.attributeValueInt END,
		possibleReasonForDelay = NULL,
		commcellId = RA.commCellId,
		totReadBytes = NULL,
		totReadTime = NULL,
		totPhysicalWriteBytes = NULL,
		totPhysicalWriteTime = NULL,
		nwTransBytes = NULL,
		totNwTransTime = NULL,
		totSidbLookups = NULL,
		totSidbLookupTime = NULL,
		readCurrentThroughput = NULL,
		readAverageThroughput = NULL,
		writeCurrentThroughput = NULL,
		writeAverageThroughput = NULL,
		ntwkCurrentThroughput = NULL,
		ntwkAverageThroughput = NULL,
		sidbCurrentLookups = NULL,
		sidbAverageLookups = NULL,
		phasePercentagesList = NULL,
		phaseTimingsList = NULL,
		currentPhase = NULL,
		selectiveVMClientDisplayName = NULL,
		totalThroughputTime = NULL,
		readPercentageTime = NULL,
		writePercentageTime = NULL,
		networkPercentageTime = NULL,
		sidbPercentageTime = NULL,
		stubDataSize = stubSizeOption.attributeValueInt,
		destInstanceId = 0,
		destInstanceName = NULL,
		objectsFailed,
		currentPhaseType = NULL,
		distributedAppsClusterType = 0
		FROM RunningAdminJobs RA
LEFT OUTER JOIN JmJobOptions LongRunning ON LongRunning.jobId = @i_jobId AND LongRunning.attributeId = 76
		LEFT OUTER JOIN #getUsersInCompanyOutputTbl UIC ON UIC.userId = RA.userId
LEFT OUTER JOIN JMJobOptions stubSizeOption WITH(NOLOCK) ON @i_jobId = stubSizeOption.jobId AND @i_commcellId = stubSizeOption.commCellId AND stubSizeOption.attributeId = 26
		WHERE RA.jobId = @i_jobId
		AND RA.commCellId = @i_commcellId
	END
	SET @isVisible = (SELECT TOP 1 isVisible FROM @jobDetails)
	-- Populate client list only for VSA backups and Client level admin jobs
	IF EXISTS (SELECT 1 FROM @JobDetails
WHERE (@isVisible = 0 AND appTypeId = 106) -- Virtual Server - check only if VSA level rights is not present
			   OR optype IN (35, 53, 67, 68, 86, 92) -- Install Updates, Upgrade, Install/Uninstall Software
			   )
	BEGIN
		IF (@i_userId IS NOT NULL AND @i_userId > 0)
		BEGIN
			-- Get list of clients the user can see.
			IF OBJECT_ID('tempdb.dbo.#JMGetRunningJobDetails_ClientList') IS NOT NULL
				DROP TABLE #JMGetRunningJobDetails_ClientList
			CREATE TABLE #JMGetRunningJobDetails_ClientList (
				clientId INT,
				t_appTypeId INT,
				t_instanceId INT,
				t_backupsetId INT,
				t_subclientId INT
			)
			CREATE CLUSTERED INDEX JMGetRunningJobDetails_ClientList_idx ON #JMGetRunningJobDetails_ClientList (clientId)
			EXEC sec_getIdaObjectsForUser @i_userId, 3  /*CLIENT_ENTITY */ , 0 /*View*/, 0, '#JMGetRunningJobDetails_ClientList'
			INSERT INTO #ClientList(clientId)
				SELECT
					c.clientId
				FROM #JMGetRunningJobDetails_ClientList c
				GROUP BY c.clientId
		END
		-- This means user does not have rights to view the job
		IF @isVisible = 0 -- Job is not visible
		BEGIN
			IF NOT EXISTS(SELECT 1 FROM #ClientList) -- Associated VM client is also not visible
				GOTO PROC_EXIT
			-- Associated VM client is not visible
			IF NOT EXISTS(SELECT 1 FROM @JobDetails D
					JOIN JMQinetixUpdateStatus Q ON Q.jobId = D.jobId AND Q.commCellId = D.commcellId
					JOIN #ClientList C ON C.clientId = Q.clientId
						)
				GOTO PROC_EXIT
		END
	END
	ELSE IF @isVisible = 0 -- Job is not visible
		GOTO PROC_EXIT
	UPDATE @jobDetails
	SET throughput = CASE WHEN transferTime > 0 THEN (CAST((uncompBytes * @OneHr) AS FLOAT)/ CAST((@oneGB * transferTime) AS FLOAT)) ELSE 0 END
	-- Data Verification
	DECLARE @verificationType  INT = 2
	DECLARE @dataVerificationType  INT = 3
	--WorkFlow jobs --> Workflow Name
	DECLARE @otheropname  NVARCHAR(MAX) = ''
	DECLARE @workFlowInputsInfoxml NVARCHAR(MAX) = ''
	-- Data Aging
	DECLARE @agingOn  INT = 0
	--Download Software
	DECLARE @totalFilesToDownload  INT = 0
	--Storage Validation
	DECLARE @libName  NVARCHAR(MAX)
	DECLARE @driveName  NVARCHAR(MAX)
	DECLARE @dataSize  INT = 0
	DECLARE @readThroughput  INT = 0
	DECLARE @writeThroughput  INT = 0
	--Move Partition
	DECLARE @srcPartitionPath  NVARCHAR(MAX)
	DECLARE @destPartitionPath  NVARCHAR(MAX)
	DECLARE @srcPartition  NVARCHAR(MAX)
	DECLARE @destPartition  NVARCHAR(MAX)
	DECLARE @srcMAName  NVARCHAR(MAX)
	DECLARE @srcMAId  INT = 0
	DECLARE @destMAName  NVARCHAR(MAX)
	DECLARE @destMAId  INT = 0
	DECLARE @sizeOfAppMovePar INT = 0
	--AUXCOPY Progressinfo Details
	DECLARE @gacpName  NVARCHAR(MAX)
	DECLARE @auxCopyProgressInfoxml xml = ''
	DECLARE @archGrpID INT = 0
	DECLARE @archGrpCopyID INT = 0
	--SNAP_TO_TAPE Jobs Details
	DECLARE @snapToTapeStatus INT = 0
	DECLARE @snapDeferredCatalogStatus INT = 0
	DECLARE @backupOption INT = 0
	--SEND LOG FILE
	DECLARE @sendLogFilesOptionsXML  XML  = ''
	--LOG MONITORING CLIENT STATUS
	DECLARE @logMonitoringClientStatusXML  XML  = ''
	DECLARE @AuxCopyProgressInfo TABLE (
			jobId int,
			srcCopyId int,
			srcCopyName NVARCHAR(256),
			destCopyId int,
			destCopyName TEXT,
			BytesXferred bigint,
			mediaUsageTime int,
			dataToCopy bigint,
			muxFactor int,
			destCombinedStreams int,
			failureReason varchar(max)
	)
	-- MOVE PARTITION
	IF EXISTS(SELECT TOP 1 * FROM @JobDetails WHERE optype = 99) /*AND @jobCompleted = 1*/
	BEGIN
		SELECT @srcMAId = MMDTS.SourceMAClientId, @destMAId = MMDTS.targetMAClientId, @sizeOfAppMovePar = (MMDTS.DataToCopyMB * 1024 *1024), @srcPartitionPath = MMDTSF.DDBSourcePath, @destPartitionPath = MMDTSF.DDBTargetPath
		FROM MMDataTransferRequest  MMDTR
		INNER JOIN MMDataTransferStreams MMDTS ON MMDTS.transferid = MMDTR.Transferid
		INNER JOIN MMDataTransferStreamToFiles MMDTSF ON MMDTSF.TransferStreamId = MMDTS.TransferStreamId
		WHERE jobid = @i_jobId
		SELECT @srcMAName = name FROM APP_CLIENT WHERE id=@srcMAId
		SELECT @destMAName = name FROM APP_CLIENT WHERE id=@destMAId
		SET @srcPartition = @srcMAName + '[' + @srcPartitionPath + ']'
		SET @destPartition = @destMAName + '[' + @destPartitionPath + ']'
		UPDATE @JobDetails
		SET uncompBytes = @sizeOfAppMovePar
		WHERE jobid = @i_jobId
	END
	IF @jobCompleted = 1
	BEGIN
		SELECT @archGrpID = archGrpID, @archGrpCopyID = archGrpCopyID FROM JMAdminJobStatsTable WHERE jobId = @i_jobId AND commCellId = @i_commcellId
		SELECT @otheropname = otheropname FROM JMAdminJobStatsTable WHERE jobId = @i_jobId AND commCellId = @i_commcellId AND opType = 90
		SELECT @totalFilesToDownload = ex_totalmedia FROM JMAdminJobStatsTable WHERE jobId = @i_jobId AND commCellId = @i_commcellId AND opType = 36
	END
	ELSE
	BEGIN
		SELECT @archGrpID = archGrpID, @archGrpCopyID = archGrpCopyID FROM RunningAdminJobs WHERE jobId = @i_jobId AND commCellId = @i_commcellId
		SELECT @otheropname = workflowname FROM RunningAdminJobs WHERE jobId = @i_jobId AND commCellId = @i_commcellId AND opType = 90
	END
	--WorkFlow Jobs
	IF EXISTS(SELECT TOP 1 * FROM @JobDetails WHERE optype = 90 /*Workflow Management*/)
	BEGIN
		DECLARE @tmp xml = (SELECT TOP 1 xmljobinfo FROM @JobDetails WHERE optype = 90 /*Workflow Management*/)
		SET @workFlowInputsInfoxml = (select n.c.value('@options', 'nvarchar(max)') from @tmp.nodes('Workflow_StartWorkflow') n(c))
	END
	IF EXISTS(SELECT TOP 1 * FROM @JobDetails WHERE optype = 29 /*QUICKDMRST*/)
	BEGIN
		IF EXISTS(SELECT TOP 1 * FROM @JobDetails WHERE optype = 29 and ((jobAttributes & 0x100 = 0x100) OR(jobAttributes & 0x1000 = 0x1000)))
SET @otheropname = dbo.fn_EvFormatEventMsgText(0, @i_localeId, (2071 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
		ELSE
SET @otheropname = dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1615 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
	END
	IF EXISTS(SELECT TOP 1 * FROM @JobDetails WHERE optype IN (13, 31, 104) /*AUXCOPY, AUXCOPY2 (Auxiliary Copy(Dash))*/)
	BEGIN
		IF @archGrpCopyID <> 0
		BEGIN
			(SELECT @gacpName=COALESCE(@gacpName+',' ,'') + name FROM archGroup WHERE defaultCopy in (SELECT destMediaCopyId FROM archGroupCopy WHERE archGroupId = @archGrpID AND id = @archGrpCopyID AND destMediaCopyId <> 0))
		END
	    ELSE --ALL COPIES
		BEGIN
			(SELECT @gacpName=COALESCE(@gacpName+',' ,'') + name FROM archGroup WHERE defaultCopy in (SELECT destMediaCopyId FROM archGroupCopy where archGroupId = @archGrpID and destMediaCopyId <> 0 ))
		END
	END
	IF /*@jobCompleted = 0 AND*/ EXISTS(SELECT TOP 1 * FROM @JobDetails WHERE optype IN (13, 31, 35, 53, 67, 68, 74, 92, 104))
	BEGIN
		INSERT INTO @AuxCopyProgressInfo(jobId, srcCopyId, srcCopyName,destCopyId, destCopyName,BytesXferred,mediaUsageTime,dataToCopy,muxFactor,destCombinedStreams, failureReason)
		SELECT JMDC.jobId, JMDC.srcCopyId, AGC.name, JMDC.archGrpCopyID, JMDC.copyName, JMDC.BytesXferred, JMDC.mediaUsageTime,
			   JMDC.dataToCopy, JMDC.muxFactor, JMDC.destCombinedStreams, dbo.JMGetLocalizedMessageFunc(0,JMDC.failureReason)
		FROM JMDataCopiedStatsTable JMDC
		INNER JOIN archGroupCopy AGC
		ON AGC.id = JMDC.srcCopyId
		WHERE JMDC.jobid = @i_jobId and JMDC.commCellId = @i_commcellId
		SET @auxCopyProgressInfoxml = (SELECT
											BytesXferred AS '@BytesXferred',
											mediaUsageTime AS '@mediaUsageTime',
											dataToCopy AS '@dataToCopy',
											muxFactor AS '@muxFactor',
											destCombinedStreams AS '@destCombinedStreams',
											failureReason AS '@failureReason',
											srcCopyName AS 'srcCopy/@copyName',
											srcCopyId AS 'srcCopy/@copyId',
											destCopyName AS 'destCopy/@copyName',
											destCopyId AS 'destCopy/@copyId'
									FROM @AuxCopyProgressInfo
									FOR XML PATH('dataCopiedInfo'), TYPE)
	END
	IF EXISTS(SELECT TOP 1 * FROM @JobDetails WHERE optype = 10)
	BEGIN
		DECLARE @val INT = 0
		SELECT @val=value FROM dbo.getalljoboptions(@i_jobId) WHERE optionid=1157719732 /*DATAAGINGOPTION_IS_GRANULAR*/
		IF @val = 1
			SET	@agingOn = 1
		ELSE
			SET	@agingOn = 2
	END
	IF EXISTS(SELECT TOP 1 * FROM @JobDetails WHERE optype = 41)
	BEGIN
		SELECT
			@libName = LibraryName,
			@driveName = DriveName,
			@dataSize = DataSizeInMB,
			@readThroughput = ReadThroughtputInMBPerSec,
			@writeThroughput = WriteThroughtputInMBPerSec
		FROM MMStorageValidationHistory
		WHERE jobid=@i_jobId and CommCellId=@i_commcellId
	END
	IF EXISTS(SELECT TOP 1 * FROM @JobDetails WHERE optype = 31)
	BEGIN
		DECLARE @backupType  INT = 0
		SELECT @backupType = backupType FROM @JobDetails WHERE optype in (31, 106) and cloudid <>0
		IF (@backupType & 0x1) > 0
			SET @verificationType = 1
		IF (@backupType & 0x4) > 0
			SET @dataVerificationType = 1
		ELSE IF (@backupType & 0x8) > 0
			SET @dataVerificationType = 2
		ELSE IF (@backupType & 0x20) > 0
			SET @dataVerificationType = 5
	END
	--SNAP_TO_TAPE Jobs Details
	IF EXISTS(SELECT TOP 1 * FROM @JobDetails WHERE optype IN (59, 65))
	BEGIN
		DECLARE @deferredCatalogStatusFlag INT = -1
		DECLARE @snapToTapeStatusFlag INT = -1
		DECLARE @appTypeId INT = 0
		DECLARE @bkpAttributesEx BIGINT = 0
		SELECT @appTypeId = appTypeId, @bkpAttributesEx = jobAttributesEx FROM @JobDetails WHERE jobId = @i_jobId
		IF dbo.IsDeferredCatalogSupported(@appTypeId) = 1
		BEGIN
			SET @deferredCatalogStatusFlag = (SELECT (CASE
												WHEN (JMJobSnapDeferredCatalogStats.disabled = 0 OR JMJobSnapDeferredCatalogStats.catalogStatus = 100)
													THEN JMJobSnapDeferredCatalogStats.catalogStatus
												ELSE 0
												END)
												FROM  JMJobSnapDeferredCatalogStats
												WHERE JMJobSnapDeferredCatalogStats.jobId = @i_jobId AND JMJobSnapDeferredCatalogStats.commCellId = @i_commcellId)
		END
		SET @snapToTapeStatusFlag = (SELECT
										(CASE
											WHEN (JMJobSnapshotStats.disabled = 0 OR JMJobSnapshotStats.materializationStatus = 100)
												THEN JMJobSnapshotStats.materializationStatus
											ELSE 0
										 END
										)
										FROM JMJobSnapshotStats WHERE JMJobSnapshotStats.jobId = @i_jobId AND JMJobSnapshotStats.commCellId = @i_commcellId
									)
        IF @deferredCatalogStatusFlag = -1
			SET @snapDeferredCatalogStatus = 0
		ELSE IF (((@deferredCatalogStatusFlag & 102) = 102) OR ((@deferredCatalogStatusFlag & 103) = 103))
			SET @snapDeferredCatalogStatus = 1
		ELSE IF ((@deferredCatalogStatusFlag & 101) = 101)
			SET @snapDeferredCatalogStatus = 2
		ELSE IF ((@deferredCatalogStatusFlag & 100) = 100)
			SET @snapDeferredCatalogStatus = 3
		ELSE
			SET @snapDeferredCatalogStatus = 4
        IF @snapToTapeStatusFlag = -1
			SET @snapToTapeStatus = 0
        ELSE IF (((@snapToTapeStatusFlag & 102) = 102) OR ((@snapToTapeStatusFlag & 103) = 103))
			SET @snapToTapeStatus = 1
        ELSE IF ((@snapToTapeStatusFlag & 101) = 101)
			SET @snapToTapeStatus = 2
        ELSE IF ((@snapToTapeStatusFlag & 100) = 100)
			SET @snapToTapeStatus = 3
        ELSE
			SET @snapToTapeStatus = 4
		IF (((@bkpAttributesEx & 0x10) =  0x10) AND ((@bkpAttributesEx & 0x40) =  0x40))
			SET @backupOption = 1
		ELSE IF ((@bkpAttributesEx & 0x10) =  0x10)
			SET @backupOption = 2
	END
	--SEND LOG FILE Jobs Details
	IF EXISTS(SELECT TOP 1 * FROM @JobDetails WHERE optype = 92)
	BEGIN
		DECLARE @sendLogFilesOptionsXMLtmp  XML
		SET @sendLogFilesOptionsXMLtmp = dbo.GetXMLJobOptions(@i_jobId ).query('TMMsg_JobOption/adminOpts/sendLogFilesOption')
						SET @sendLogFilesOptionsXML = (SELECT
									ref.value('@csDatabase', 'INT') AS '@csDatabase',
									ref.value('@databaseLogs', 'INT') AS '@databaseLogs',
									ref.value('@galaxyLogs', 'INT') AS '@galaxyLogs',
									ref.value('@machineInformation', 'INT') AS '@machineInformation',
									ref.value('@osLogs', 'INT') AS '@osLogs',
									ref.value('@crashDump', 'INT')  AS '@crashDump',
									ref.value('@includeJobResults', 'INT') AS '@includeJobResults',
									ref.value('@includeIndex', 'INT') AS '@includeIndex',
								    ref.value('@useFTP', 'INT') AS '@useFTP',
								    ref.value('@useHTTP', 'INT') AS '@useHTTP',
								    ref.value('@usePassiveFTP', 'INT') AS '@usePassiveFTP',
									ref.value('@useDefaultUploadOption', 'INT') AS '@useDefaultUploadOption',
						            ref.value('@doNotIncludeLogs', 'INT') AS '@doNotIncludeLogs',
								    ref.value('@emailSelected', 'INT') AS '@emailSelected',
								    ref.value('@collectEsxLogsByJob', 'INT') AS '@collectEsxLogsByJob',
									ref.query('clients')
									FROM  @sendLogFilesOptionsXMLtmp.nodes ('sendLogFilesOption') R(ref)
									FOR XML PATH('sendLogFilesOption'),TYPE)
	END
	IF EXISTS(SELECT TOP 1 * FROM @JobDetails WHERE optype = 86)
	BEGIN
		SET @logMonitoringClientStatusXML = (SELECT xmlJobInfo.query('JobManager_AdminJobDetailsXml/patchUpdateInfo/lmClientStatus')from @JobDetails where jobid=@i_jobId)
	END
	DECLARE @JobAttempts TABLE (
		number int,
		phase  int,
		phaseName nvarchar(64),
		status int,
		startTime int,
		endTime int,
		elapsedTime int,
		writeTime int,
		nwtransbytes bigint,
		uncompBytes bigint,
		compBytes bigint,
		archGrpId int,
		archGrpName nvarchar(128),
		copyId	int,
		copyName nvarchar(128),
		numObjects bigint,
		numFolders bigint,
		mediaAgent nvarchar(510),
        libraryName nvarchar(256),
        drivePoolName nvarchar(128),
		numSuccess bigint,
		numSkipped bigint,
		numFailures bigint,
		embeddedObjects bigint,
		totalAllocationTime int,
        totalWaitTimeBeforeAllocation int,
		maxStreamsUsed int,
		failureReason varchar(max),
		totReadBytes BIGINT,
		totReadTime BIGINT,
		totPhysicalWriteBytes BIGINT,
		totPhysicalWriteTime BIGINT,
		totNwTransTime BIGINT,
		totSidbLookups BIGINT,
		totSidbLookupTime BIGINT
	)
	IF (@i_showAttempt = 1)
	BEGIN
		IF @jobCompleted = 1
		BEGIN
			INSERT INTO @JobAttempts(number, phase, phaseName,status, startTime,endTime,elapsedTime,writeTime,nwtransbytes,uncompBytes, compBytes, archGrpId, archGrpName, copyId, copyName, numObjects, numFolders, mediaAgent, libraryName, drivePoolName, numSuccess, numSkipped, numFailures, embeddedObjects, totalAllocationTime, totalWaitTimeBeforeAllocation, maxStreamsUsed, failureReason, totReadBytes, totReadTime, totPhysicalWriteBytes, totPhysicalWriteTime, totNwTransTime, totSidbLookups, totSidbLookupTime)
			SELECT
			DISTINCT JA.number,
			phase = JA.phase,
			phaseName = (select name from JMPhase where phase = JA.phase AND
                opTableId = (select id from JMOpTable where operation = JM.opType AND appTypeType = JM.appType)),
			status = JA.status,
			startTime =JA.servStartDate ,
			endTime = JA.servEndDate,
			elapsedTime = JA.elapsedTime,
			writeTime = JA.writeTime,
			nwtransbytes = JA.nwtransbytes,
			uncompBytes = JA.unCompBytes,
			compBytes = JA.compBytes,
			archGrpId = JA.archGrpId,
			archGrpName = CASE JA.archGrpId
							    WHEN 0 THEN ''
								ELSE ISNULL((SELECT name FROM archGroup WITH (READUNCOMMITTED) WHERE id = JA.archGrpId),'')
						  END,
			copyId = JA.copyId,
			copyName = CASE JA.copyId
							WHEN 0 THEN ''
							ELSE ISNULL((SELECT name FROM archGroupCopy WITH (READUNCOMMITTED) WHERE id = JA.copyId),'')
						END,
			numObjects = JA.numObjects,
			numFolders = JA.numFolders,
			mediaAgent = ISNULL(APP_Client.name,''),
			libraryName = ISNULL(MMLibrary.AliasName,''),
			drivePoolName = CASE MMDrivePool.DrivePoolType
								WHEN 10001 THEN ''
								ELSE ISNULL(MMDrivePool.DrivePoolName,'')
							END,
			numSuccess = 0,
			numSkipped = 0,
			numFailures = 0,
			embeddedObjects = 0,
		    totalAllocationTime = 0,
			totalWaitTimeBeforeAllocation = 0,
			maxStreamsUsed = JA.maxStreamsUsed,
			failureReason = dbo.JMGetLocalizedMessageFunc(0, JA.failureReason),
			totReadBytes = NULL,
			totReadTime = NULL,
			totPhysicalWriteBytes = NULL,
			totPhysicalWriteTime = NULL,
			totNwTransTime = NULL,
			totSidbLookups = NULL,
			totSidbLookupTime = NULL
			FROM JMBkpAtmptStats JA INNER JOIN JMBkpStats JM ON JA.jobId = JM.jobId AND JA.commcellId = JM.commcellId
			LEFT OUTER JOIN JMJobResourceHistory WITH (READUNCOMMITTED)
				ON JMJobResourceHistory.jobId = JA.jobId
				AND JMJobResourceHistory.commcellId = JA.commcellId
				AND JMJobResourceHistory.phasenum = JA.phase
				AND JMJobResourceHistory.attemptNum = JA.number
				AND JMJobResourceHistory.copyId = JA.copyId
			LEFT OUTER JOIN MMDrivePool WITH (READUNCOMMITTED)
				ON JMJobResourceHistory.DrivePoolId = MMDrivePool.DrivePoolId
			LEFT OUTER JOIN MMHost WITH (READUNCOMMITTED)
				ON MMHost.Clientid = JMJobResourceHistory.Clientid
			LEFT OUTER JOIN APP_Client WITH (READUNCOMMITTED)
				ON MMHost.clientid = APP_Client.id
			LEFT OUTER JOIN MMMasterPool WITH (READUNCOMMITTED)
				ON JMJobResourceHistory.MasterPoolId = MMMasterPool.MasterPoolId
			LEFT OUTER JOIN MMLibrary WITH (READUNCOMMITTED)
				ON MMLibrary.LibraryId = MMMasterPool.LibraryId
			WHERE JA.jobId = @i_jobId AND JA.commcellId = @i_commcellId
			-- AND JA.commCellId = @commcellId AND JA.status <> 8
			UNION ALL
			SELECT
			number = JA.attemptNum,
			phase = JA.phase,
			phaseName = (select name from JMPhase where phase = JA.phase and
                opTableId = (
                    select id from JMOpTable where operation = JM.opType
                AND appTypeType = JM.appType)),
			status = JA.status,
			startTime = JA.servStart,
			endTime = JA.servEnd,
			elapsedTime = JA.elapsedTime,
			writeTime = JA.modifiedTime,
			nwtransbytes = JA.compBytes_l,
			uncompBytes = JA.uncompBytes_l,
			compBytes = JA.compBytes_l,
			archGrpId = 0,
			archGrpName = NULL,
			copyId = 0,
			copyName = NULL,
			numObjects = 0,
			numFolders = 0,
			mediaAgent = NULL,
			libraryName = NULL,
			drivePoolName = NULL,
			numSuccess = JA.numSuccess_l,
			numSkipped = JA.numSkipped,
			numFailures = JA.numFailures_l,
			embeddedObjects = 0,
			totalAllocationTime = 0,
			totalWaitTimeBeforeAllocation = 0,
			maxStreamsUsed = 0,
			failureReason = dbo.JMGetLocalizedMessageFunc(0, JA.failureReason),
			totReadBytes = NULL,
			totReadTime = NULL,
			totPhysicalWriteBytes = NULL,
			totPhysicalWriteTime = NULL,
			totNwTransTime = NULL,
			totSidbLookups = NULL,
			totSidbLookupTime = NULL
			FROM JMRestoreAtmptStats JA INNER JOIN JMRestoreStats JM ON JA.jobId = JM.jobId AND JA.commcellId = JM.commcellId
			WHERE JA.jobId = @i_jobId AND JA.commcellId = @i_commcellId
			UNION ALL
			SELECT
			number =  JA.attemptNum,
			phase =  JA.phaseNum,
			phaseName = CASE WHEN JM.opType = 90 THEN (SELECT TOP 1 JMJobOptions.attributeValue
                                                FROM JMJobOptions
                                                WHERE JMJobOptions.jobId = @i_jobId
                                                AND JMJobOptions.commCellId = JM.commCellID
                                                AND JMJobOptions.attributeId = JA.phaseNum)
                    WHEN JM.opType = 85 OR JM.opType = 53 THEN ISNULL((SELECT TOP 1 JMJobOptions.attributeValue
                                                        FROM JMJobOptions
                                                        WHERE JMJobOptions.jobId = @i_jobId
                                                        AND JMJobOptions.commCellId = JM.commCellID
                                                        AND JMJobOptions.attributeId = 44
                                                        AND JMJobOptions.attributeValueInt = JA.phaseNum),
                                                        (select name from JMPhase where phase = phaseNum AND opTableId = (select TOP 1 id from JMOpTable where operation = JM.opType)))
                    ELSE (select name from JMPhase where phase = phaseNum AND opTableId = (select TOP 1 id from JMOpTable where operation = JM.opType))
                    END,
			status = JA.status,
			startTime = JA.startTime,
			endTime = JA.endTime,
			elapsedTime = JA.elapsedTime,
			writeTime = JA.writeTime,
			nwtransbytes = JA.nwtransbytes,
			uncompBytes = JA.unCompBytes,
			compBytes = 0,
			archGrpId = 0,
			archGrpName = NULL,
			copyId = 0,
			copyName = NULL,
			numObjects = 0,
			numFolders = JA.numFiles,
			mediaAgent = NULL,
			libraryName = NULL,
			drivePoolName = NULL,
			numSuccess = 0,
			numSkipped = JA.skippedItems,
			numFailures = 0,
			embeddedObjects = JA.embeddedObjects,
			totalAllocationTime = JA.totalAllocationTime,
			totalWaitTimeBeforeAllocation = JA.totalWaitTimeBeforeAllocation,
			maxStreamsUsed = 0,
			failureReason = dbo.JMGetLocalizedMessageFunc(0, JA.failureReason),
			totReadBytes = NULL,
			totReadTime = NULL,
			totPhysicalWriteBytes = NULL,
			totPhysicalWriteTime = NULL,
			totNwTransTime = NULL,
			totSidbLookups = NULL,
			totSidbLookupTime = NULL
			FROM JMAdminJobAttemptStatsTable JA INNER JOIN JMAdminJobStatsTable JM ON JA.jobId = JM.jobId AND JA.jobId = @i_jobId
		END
		ELSE
		BEGIN
			INSERT INTO @JobAttempts(number, phase, phaseName,status, startTime,endTime,elapsedTime,writeTime,nwtransbytes,uncompBytes, compBytes, archGrpId, archGrpName, copyId, copyName, numObjects, numFolders, mediaAgent, libraryName, drivePoolName, numSuccess, numSkipped, numFailures, embeddedObjects, totalAllocationTime, totalWaitTimeBeforeAllocation, maxStreamsUsed, failureReason, totReadBytes, totReadTime, totPhysicalWriteBytes, totPhysicalWriteTime, totNwTransTime, totSidbLookups, totSidbLookupTime)
			SELECT
				number = attemptNum,
				phase  = phaseNum,
				phaseName = phaseName,
				status = status,
				startTime = startTime,
				endTime = endTime,
				elapsedTime = elapsedTime,
				writeTime = writeTime,
				nwtransbytes = nwTransBytes,
				uncompBytes = unCompBytes,
				compBytes = compBytes,
				archGrpId = archGrpId,
				archGrpName = archGroupName,
				copyId	= copyId,
				copyName = copyName,
				numObjects = numFiles,
				numFolders = numFolders,
				mediaAgent = mediaAgent,
				libraryName = libraryName,
				drivePoolName = drivePoolName,
				numSuccess = 0,
				numSkipped = 0,
				numFailures = 0,
				embeddedObjects = 0,
				totalAllocationTime = totalAllocationTime,
				totalWaitTimeBeforeAllocation = totalWaitTimeBeforeAllocation,
				maxStreamsUsed = maxStreamsUsed,
				failureReason = dbo.JMGetLocalizedMessageFunc(0, JM.failureReason),
				totReadBytes = readBytes,
				totReadTime = readTime,
				totPhysicalWriteBytes = physicalWriteBytes,
				totPhysicalWriteTime = physicalWriteTime,
				totNwTransTime = nwTransTime,
				totSidbLookups = sidbLookups,
				totSidbLookupTime = sidbLookupTime
			FROM JMBkpAttemptInfo JM
			WHERE JM.jobId = @i_jobId
			and JM.commCellId = @i_commcellId
			UNION ALL
			SELECT
				number = attemptNum,
				phase  = phaseNum,
				phaseName = phaseName,
				status = status,
				startTime = startTime,
				endTime = endTime,
				elapsedTime = elapsedTime,
				writeTime = 0,
				nwtransbytes = compBytes_l,
				uncompBytes = uCompBytes_l,
				compBytes = compBytes_l,
				archGrpId = 0,
				archGrpName = NULL,
				copyId	= 0,
				copyName = NULL,
				numObjects = 0,
				numFolders = 0,
				mediaAgent = NULL,
				libraryName = NULL,
				drivePoolName = NULL,
				numSuccess = numSuccess_l,
				numSkipped = numSkipped,
				numFailures = numFailures_l,
				embeddedObjects = 0,
				totalAllocationTime = totalAllocationTime,
				totalWaitTimeBeforeAllocation = totalWaitTimeBeforeAllocation,
				maxStreamsUsed = 0,
				failureReason = dbo.JMGetLocalizedMessageFunc(0, JM.failureReason),
				totReadBytes = NULL,
				totReadTime = NULL,
				totPhysicalWriteBytes = NULL,
				totPhysicalWriteTime = NULL,
				totNwTransTime = NULL,
				totSidbLookups = NULL,
				totSidbLookupTime = NULL
			FROM JMRstAttemptInfo JM
			WHERE JM.jobId = @i_jobId
			and JM.commCellId = @i_commcellId
			UNION ALL
			SELECT
				number = attemptNum,
				phase  = phaseNum,
				phaseName = phaseName,
				status = status,
				startTime = startTime,
				endTime = endTime,
				elapsedTime = elapsedTime,
				writeTime = writeTime,
				nwtransbytes = nwTransBytes,
				uncompBytes = uncompBytes,
				compBytes = 0,
				archGrpId = 0,
				archGrpName = NULL,
				copyId	= 0,
				copyName = NULL,
				numObjects = 0,
				numFolders = numFiles,
				mediaAgent = NULL,
				libraryName = NULL,
				drivePoolName = NULL,
				numSuccess = 0,
				numSkipped = skippedItems,
				numFailures = 0,
				embeddedObjects = embeddedObjects,
				totalAllocationTime = totalAllocationTime,
				totalWaitTimeBeforeAllocation = totalWaitTimeBeforeAllocation,
				maxStreamsUsed = 0,
				failureReason = dbo.JMGetLocalizedMessageFunc(0, JM.failureReason),
				totReadBytes = NULL,
				totReadTime = NULL,
				totPhysicalWriteBytes = NULL,
				totPhysicalWriteTime = NULL,
				totNwTransTime = NULL,
				totSidbLookups = NULL,
				totSidbLookupTime = NULL
			FROM JMAdminJobAttemptInfoTable JM
			WHERE JM.jobId = @i_jobId
			and JM.commCellId = @i_commcellId
		END
	END
	-- VM details for vWeb.
	DECLARE @JMQinetixUpdateStatusTbl TABLE
	(
		clientId		INT,
		clientName		NVARCHAR(510),
		status			INT,
		reason			INT,
		installedUpdates NVARCHAR(MAX),
		failureReason	NVARCHAR(MAX),
		hardwareVersion NVARCHAR(MAX),
		backupType		INT,
		transportMode	NVARCHAR(MAX),
		CBTStatus		NVARCHAR(MAX),
		operatingSystem NVARCHAR(MAX),
		size			BIGINT,
		backupStartTime	INT,
		backupEndTime	INT,
		usedSpace		BIGINT,
		stubStatus		INT,
		GUID			NVARCHAR(MAX),
		agent			NVARCHAR(MAX),
		poweredOffSince BIGINT,
		archivedByCurrentJob	INT,
		poweredOffByCurrentJob	INT,
		host			NVARCHAR(MAX),
		toolsVersion	NVARCHAR(MAX),
		guestSize		BIGINT,
		restoredSize	BIGINT,
		syncStatus			INT,
		lastSyncedBkpJob		BIGINT,
		destinationVM			NVARCHAR(MAX),
		remoteCacheclientId		INT,
		remoteCacheclientName	NVARCHAR(MAX),
		pseudoVMJobId				INT,
		totalFiles				BIGINT,
		successfulCIedFiles		BIGINT,
		failedCIedFiles			BIGINT,
		currentThroughput		FLOAT,
		averageThroughput		FLOAT,
		backupLevel			INT,
		projectId	NVARCHAR(MAX)
	)
	DECLARE @JMTempVMTbl TABLE
	(
		clientId		INT Primary Key,
		hardwareVersion NVARCHAR(MAX),
		operatingSystem NVARCHAR(MAX),
		toolsVersion	NVARCHAR(MAX),
		projectId		NVARCHAR(MAX)
	)
IF (EXISTS(SELECT 1 FROM @JobDetails WHERE appTypeId=106 OR optype = 135 /*BLOCK_LEVEL_OPERATION*/))
	BEGIN
		INSERT INTO @JMQinetixUpdateStatusTbl
		SELECT
				clientId, clientName,
				ISNULL([vmStatus], 0) AS status,
				0 AS reason,
				installedUpdates = NULL,
				ISNULL([vmFailureReason], '') AS failureReason,
				'' AS hardwareVersion,
				ISNULL([vmBackupType], 0) AS backupType,
				ISNULL([vmTransportMode], '') AS transportMode,
				ISNULL([vmCBTStatus], '') AS CBTStatus,
				'' AS operatingSystem,
				ISNULL([vmSize], 0) AS size,
				ISNULL([vmBackupStartTime], 0) AS backupStartTime,
				ISNULL([vmBackupEndTime], 0) AS backupEndTime,
				ISNULL([vmUsedSpace], 0) AS usedSpace,
				ISNULL([vmStubStatus], 0) AS stubStatus,
				ISNULL([vmGUID], '') AS GUID,
				ISNULL([vmAgent], '') AS agent,
				ISNULL([vmPowerState], 0) AS poweredOffSince,
				ISNULL([vmIsArchivedByCurrJob], 0) AS archivedByCurrentJob,
				ISNULL([vmIsPoweredOffByCurrJob], 0) AS poweredOffByCurrentJob,
				ISNULL([vmHost], '') AS host,
				'' AS toolsVersion,
				ISNULL([vmGuestSize], 0) AS guestSize,
				ISNULL([vmRestoredSize], 0) AS restoredSize,
				ISNULL([vmSyncStatus], 0) AS syncStatus,
				ISNULL([vmLastSyncedBkpJob], 0) AS lastSyncedBkpJob,
				ISNULL([vmDestinationVM], 0) AS destinationVM,
				0, NULL,
				ISNULL([vmPseudoJobID], 0) AS pseudoVMJobId,
				ISNULL([vmTotalFiles], 0) AS totalFiles,
				ISNULL([vmSuccessfulCIedFiles], 0) AS successfulCIedFiles,
				ISNULL([vmFailedCIedFiles], 0) AS failedCIedFiles,
				ISNULL([vmCurrentThroughput], 0) AS currentThroughput,
				ISNULL([vmAverageThroughput], 0) AS averageThroughput,
				ISNULL([vmBkpLevel], 0) AS backupLevel,
				'' AS projectId
		FROM
		(
			SELECT JQ.clientId, (CASE WHEN appcl.displayname IS NULL THEN appcl.name ELSE appcl.displayname END) as clientName, VM.attrName, VM.attrVal
			FROM APP_VMProp VM WITH(NOLOCK)
			INNER JOIN JMQinetixUpdateStatus JQ WITH(NOLOCK) ON JQ.clientId = VM.VMclientId  AND JQ.jobId = VM.jobId AND JQ.commCellId = VM.commCellId
			LEFT JOIN #ClientList cl ON
				cl.clientId = JQ.clientId
			INNER JOIN APP_CLIENT appcl WITH(NOLOCK) ON JQ.clientId = appcl.id
			WHERE VM.jobId = @i_jobId AND VM.commCellId = @i_commcellId
			AND (cl.clientId IS NOT NULL OR @isVisible = 1)
			UNION
			SELECT JQ.clientId, (CASE WHEN appcl.displayname IS NULL THEN appcl.name ELSE appcl.displayname END) as clientName, VM.attrName, VM.attrVal
			FROM JMJobDataLink DL WITH(NOLOCK)
			JOIN APP_VMProp VM (NOLOCK) ON DL.parentJobId = @i_jobId AND VM.jobId = DL.childJobId AND VM.commCellId = @i_commcellId
			INNER JOIN JMQinetixUpdateStatus JQ WITH(NOLOCK) ON JQ.clientId = VM.VMclientId  AND JQ.jobId = DL.childJobId AND JQ.commCellId = VM.commCellId
			LEFT JOIN #ClientList cl ON
				cl.clientId = JQ.clientId
			INNER JOIN APP_CLIENT appcl WITH(NOLOCK) ON JQ.clientId = appcl.id
			WHERE (cl.clientId IS NOT NULL OR @isVisible = 1) AND DL.linkType = 7  -- LINK_TYPE_FOR_VSA_V2_PARENT_CHILD
		) AS clients
		PIVOT
		(
			MAX(attrVal) -- Workaround for Pivot aggregate.
			FOR attrName IN
			(
			[vmTransportMode],
			[vmCBTStatus],
			[vmBackupType],
			[vmSize],
			[vmBackupStartTime],
			[vmBackupEndTime],
			[vmFailureReason],
			[vmStatus],
			[vmUsedSpace],
			[vmStubStatus],
			[vmGUID],
			[vmAgent],
			[vmPowerState],
			[vmHost],
			[vmGuestSize],
			[vmIsArchivedByCurrJob],
			[vmIsPoweredOffByCurrJob],
			[vmRestoredSize],
			[vmSyncStatus],
			[vmLastSyncedBkpJob],
			[vmDestinationVM],
			[vmPseudoJobID],
			[vmTotalFiles],
			[vmSuccessfulCIedFiles],
			[vmFailedCIedFiles],
			[vmCurrentThroughput],
			[vmAverageThroughput],
			[vmBkpLevel]
			)
		) AS pvt
		INSERT INTO @JMTempVMTbl
		SELECT
					clientId,
					ISNULL([Virtual Machine Hardware Version], '') AS hardwareVersion,
					ISNULL([Operating System Name], '') AS operatingSystem,
					ISNULL([Virtual Machine Tools Version], '') AS toolsVersion,
					ISNULL([VSA Project Id], '') AS projectId
			FROM
			(
				SELECT VM.componentNameId AS clientId, VM.attrName, VM.attrVal
				FROM APP_ClientProp VM WITH(NOLOCK)
				INNER JOIN @JMQinetixUpdateStatusTbl JM
					ON JM.clientId=VM.componentNameId AND VM.modified = 0 AND VM.attrName IN ('Virtual Machine Tools Version','Operating System Name','Virtual Machine Hardware Version', 'VSA Project Id')
			) AS clients
			PIVOT
			(
				MAX(attrVal) -- Workaround for Pivot aggregate.
				FOR attrName IN
				(
				[Operating System Name],
				[Virtual Machine Tools Version],
				[Virtual Machine Hardware Version],
				[VSA Project Id]
				)
			) AS pvt
		-- Final Update to main table
		UPDATE JMQ
			SET
				JMQ.hardwareVersion=T.hardwareVersion,
				JMQ.operatingSystem=T.operatingSystem,
				JMQ.toolsVersion=T.toolsVersion,
				JMQ.projectId=T.projectId
		FROM @JMQinetixUpdateStatusTbl JMQ
		INNER JOIN @JMTempVMTbl T
		ON T.clientId=JMQ.clientId
	SET @clientStatusXML = (
							SELECT
								(SELECT COUNT(*) FROM @JMQinetixUpdateStatusTbl) AS '@totalClients',
								(SELECT COUNT(*) FROM @JMQinetixUpdateStatusTbl WHERE status = 0) AS '@successfullClients',
								(SELECT COUNT(*) FROM @JMQinetixUpdateStatusTbl WHERE status = 6) AS '@skippedClients',
								(SELECT COUNT(*) FROM @JMQinetixUpdateStatusTbl WHERE status IN (4,5,7,8)) AS '@pendingClients',
								(SELECT COUNT(*) FROM @JMQinetixUpdateStatusTbl WHERE status = 1) AS '@failedClients',
								(SELECT COUNT(*) FROM @JMQinetixUpdateStatusTbl WHERE status = 3) AS '@partialSuccessClients',
								(SELECT COUNT(*) FROM @JMQinetixUpdateStatusTbl WHERE status = 2) AS '@totalInProgressClients',
								(SELECT SUM(size) FROM @JMQinetixUpdateStatusTbl) AS '@totalVMSize',
								(
									SELECT
											clientId AS '@clientId',
											clientName AS '@vmName',
											status AS '@Status',
											hardwareVersion AS '@HardwareVersion',
											backupType		AS '@BackupType',
											transportMode	AS '@TransportMode',
											CBTStatus		AS '@CBTStatus',
											failureReason	AS '@FailureReason',
											operatingSystem AS '@OperatingSystem',
											size			AS '@Size',
											backupStartTime	AS '@BackupStartTime',
											backupEndTime	AS '@BackupEndTime',
											usedSpace		AS '@UsedSpace',
											stubStatus		AS '@StubStatus',
											GUID			AS '@GUID',
											agent			AS '@Agent',
											poweredOffSince AS '@PoweredOffSince',
											archivedByCurrentJob AS '@ArchivedByCurrentJob',
											poweredOffByCurrentJob AS '@PoweredOffByCurrentJob',
											host AS '@Host',
											toolsVersion AS '@ToolsVersion',
											guestSize AS '@GuestSize',
											restoredSize AS '@restoredSize',
											syncStatus AS '@syncStatus',
											lastSyncedBkpJob AS '@lastSyncedBkpJob',
											destinationVM AS '@destinationVMName',
											pseudoVMJobId AS '@jobID',
											totalFiles AS '@totalFiles',
											successfulCIedFiles AS '@successfulCIedFiles',
											failedCIedFiles AS '@failedCIedFiles',
											currentThroughput AS '@CurrentThroughput',
											averageThroughput AS '@AverageThroughput',
											backupLevel	AS '@backupLevel',
											projectId AS '@projectId'
									FROM @JMQinetixUpdateStatusTbl
									FOR XML PATH ('vmStatus'), TYPE
								)
							FOR XML PATH('clientStatusInfo')
						)
	END
	ELSE IF EXISTS (SELECT 1 FROM @JobDetails JM
					WHERE optype IN (35, 53, 67, 68, 92)
					) -- Install Updates, Upgrade, Install/Uninstall Software
	BEGIN
		INSERT INTO @JMQinetixUpdateStatusTbl(clientId, clientName, status, reason, installedUpdates, failureReason, remoteCacheclientId, remoteCacheclientName)
		SELECT JMQ.clientId, JMQ.clientName, JMQ.category, JMQ.status, JMQ.installedUpdates, dbo.JMGetLocalizedMessageMsgOnlyFunc(0, statusMessage), puainfo.clientid, APC.name
		FROM JMQinetixUpdateStatus JMQ
		INNER JOIN #ClientList cl ON
				cl.clientId = JMQ.clientId
		LEFT OUTER JOIN app_clientprop CP ON CP.componentNameId = JMQ.clientid AND attrname = 'UPDATE CACHE AGENT ID' AND modified=0
		LEFT OUTER JOIN PatchUpdateAgentInfo puainfo ON puainfo.id = CAST(CP.attrVal AS INT)
		LEFT OUTER JOIN APP_CLIENT APC ON APC.id = puainfo.clientid
		WHERE JMQ.jobId = @i_jobId AND JMQ.commcellId = @i_commcellId
		UNION
		SELECT JMQ.clientId, JMQ.clientName, JMQ.category, JMQ.status, JMQ.installedUpdates, dbo.JMGetLocalizedMessageMsgOnlyFunc(0, statusMessage), NULL, NULL
		FROM JMQinetixUpdateStatus JMQ
		WHERE JMQ.jobId = @i_jobId AND JMQ.commcellId = @i_commcellId AND JMQ.clientId <= 0
		SET @clientStatusXML = (
									SELECT
											(SELECT COUNT(*) FROM @JMQinetixUpdateStatusTbl) AS '@totalClients',
											(SELECT COUNT(*) FROM @JMQinetixUpdateStatusTbl WHERE status = 9) AS '@skippedClients',
											(SELECT COUNT(*) FROM @JMQinetixUpdateStatusTbl WHERE status = 4) AS '@clientsAlreadyUpdated',
											(SELECT COUNT(*) FROM @JMQinetixUpdateStatusTbl WHERE status = 1) AS '@successfullClients',
											(SELECT COUNT(*) FROM @JMQinetixUpdateStatusTbl WHERE status = 2) AS '@pendingClients',
											(SELECT COUNT(*) FROM @JMQinetixUpdateStatusTbl WHERE status IN (3, 6)) AS '@failedClients',
											(SELECT COUNT(*) FROM @JMQinetixUpdateStatusTbl WHERE status = 8) AS '@partialSuccessClients',
											(SELECT COUNT(*) FROM @JMQinetixUpdateStatusTbl WHERE status IN(7, 5)) AS '@totalInProgressClients',
											(SELECT SUM(size) FROM @JMQinetixUpdateStatusTbl) AS '@totalVMSize',
											(
											SELECT
													clientId AS '@clientId',
													clientName AS '@clientName',
													status AS '@Status',
													reason AS '@Reason',
													installedUpdates AS '@installedUpdates',
													failureReason AS '@jMFailureReasonStatus',
													remoteCacheclientId AS '@remotecacheClientId',
													remoteCacheclientName AS '@remotecacheClientName'
											FROM @JMQinetixUpdateStatusTbl JMQ
											FOR XML PATH ('clientStatus'), TYPE
										)
									FOR XML PATH('clientStatusInfo')
								)
	END
	DECLARE @streamsInfoxml xml = ''
	DECLARE @maxNumOfReaders INT = 0
	DECLARE @numOfReadersInUse INT = 0
	IF @jobCompleted = 0
	BEGIN
		SELECT @numOfReadersInUse= noOfStreamsAllocated,@maxNumOfReaders = noOfStreams FROM runningadminjobs WHERE jobid = @i_jobId
		SET @streamsInfoxml = (
		                SELECT
									status AS '@Status',
									unCompBytes AS '@sizeOfApplication',
									compBytes AS '@compressedData',
									writeTime AS '@transferTime',
									dbo.EncodeInvalidXMLChar(activeFile) AS '@currentlyBackingUp',
									throughput AS '@throughput',
									streamNum AS '@srcStreamNum',
									numFiles AS '@numFiles',
								    numFailures AS '@numFailures',
								    totalToCopy AS '@totalToCopy',
								    nwTransBytes AS '@nwTransBytes',
									compscheme AS '@compressionScheme',
						            destStreamNum AS '@destStreamNum',
								    srcBarCode AS '@srcBarCode',
								    destBarCode AS '@destBarCode',
									dbo.JMGetLocalizedMessageFunc(0, failurereason) AS '@failureReason',
									destMedAgent AS 'mediaAgent/@mediaAgentName',
									archGrpId AS 'storagePolicy/@storagePolicyId',
									(CASE
										WHEN datalength(archgrpname) <=0 THEN (SELECT name from archgroup where id=archGrpId)
										ELSE archgrpname
									END) AS 'storagePolicy/@storagePolicyName',
									(CASE
										WHEN (EXISTS(SELECT TOP 1 * FROM archGroupCopy WHERE id = JS.destCopyId AND (extendedFlags&1) > 0))
										THEN (SELECT name FROM archGroupCopy where destMediaCopyId = JS.destCopyId and archGroupId = (SELECT archGroupId from archGroupCopy where id = JS.srcCopyId))
										ELSE JS.destcopyname
								     END) AS 'destCopy/@copyName',
									(CASE
										WHEN (EXISTS(SELECT TOP 1 * FROM archGroupCopy WHERE id = JS.destCopyId AND (extendedFlags&1) > 0))
											THEN (SELECT id FROM archGroupCopy where destMediaCopyId = JS.destCopyId and archGroupId = (SELECT archGroupId from archGroupCopy where id = JS.srcCopyId))
										ELSE JS.destCopyId
									END) AS 'destCopy/@copyId',
									srcCopyName AS 'srcCopy/@copyName',
									srcCopyId AS 'srcCopy/@copyId',
									destdrivename AS 'destDriveName/@driveName',
									srcdrivename AS 'srcDriveName/@driveName',
									readThroughput AS 'detailThroughput/readThroughPut/@currentThroughput',
									writeThroughput AS 'detailThroughput/writeThroughPut/@currentThroughput',
									networkThroughput AS 'detailThroughput/networkThroughPut/@currentThroughput',
									calcSidbLookups AS 'detailThroughput/sidbLookupInfo/@currentLookups'
									FROM JMJobStreams JS where jobId = @i_jobId
									FOR XML PATH('streams'),TYPE
								)
	END
	UPDATE @JobDetails
	SET totReadTime = CASE WHEN T.totReadTime = '0' THEN NULL ELSE T.totReadTime END,
	totPhysicalWriteTime = CASE WHEN T.totPhysicalWriteTime = '0' THEN NULL ELSE T.totPhysicalWriteTime END,
	totNwTransTime = CASE WHEN T.totNwTransTime = '0' THEN NULL ELSE T.totNwTransTime END,
	totSidbLookupTime = CASE WHEN T.totSidbLookupTime = '0' THEN NULL ELSE T.totSidbLookupTime END
	FROM
	(
		SELECT jobId AS jId, [1] AS totReadTime, [2] AS totPhysicalWriteTime, [3] AS totNwTransTime, [4] AS totSidbLookupTime
		FROM
		(
			SELECT S.Id, S.Data, jobId
			FROM @JobDetails O
			OUTER APPLY dbo.SplitString(O.timeThroughPut, ':') S
			WHERE O.timeThroughPut IS NOT NULL
		) AS P
		PIVOT(MAX([Data]) FOR [id] IN([1], [2], [3], [4])) AS PivotTable
	) T
	WHERE jobId = T.jId
	UPDATE @JobDetails
	SET totalThroughputTime = ISNULL(totReadTime, 0) + ISNULL(totPhysicalWriteTime, 0) + ISNULL(totNwTransTime, 0) + ISNULL(totSidbLookupTime, 0)
	UPDATE @JobDetails
	SET readPercentageTime = CASE WHEN totReadTime = 0 OR totalThroughputTime = 0 THEN NULL ELSE ROUND(100 * (CAST(totReadTime AS FLOAT) / CAST(totalThroughputTime AS FLOAT)), 2, 1) END,
	writePercentageTime = CASE WHEN totPhysicalWriteTime = 0 OR totalThroughputTime = 0 THEN NULL ELSE ROUND(100 * (CAST(totPhysicalWriteTime AS FLOAT) / CAST(totalThroughputTime AS FLOAT)), 2, 1) END,
	networkPercentageTime = CASE WHEN totNwTransTime = 0 OR totalThroughputTime = 0 THEN NULL ELSE ROUND(100 * (CAST(totNwTransTime AS FLOAT) / CAST(totalThroughputTime AS FLOAT)), 2, 1) END,
	sidbPercentageTime = CASE WHEN totSidbLookupTime = 0 OR totalThroughputTime = 0 THEN NULL ELSE ROUND(100 * (CAST(totSidbLookupTime AS FLOAT) / CAST(totalThroughputTime AS FLOAT)), 2, 1) END
	IF @i_showAttempt = 0
	BEGIN
	IF @jobCompleted = 0
	BEGIN
	SET @o_xml =
	(
		SELECT (
		SELECT(
				  SELECT
										@maxNumOfReaders 'streamsInfo/@maxNumOfReaders',
										@numOfReadersInUse 'streamsInfo/@numReadersInUse',
										@streamsInfoxml 'streamsInfo',
									   J.jobId 'generalInfo/@jobId' ,
									   (SELECT dbo.GetJobBackupTypeDisplay(backupType)) 'generalInfo/@backupType',
									   priority 'generalInfo/@priority',
									   scanType 'generalInfo/@scanType',
									   @snapToTapeStatus 'generalInfo/@snapToTapeStatus',
									   @snapDeferredCatalogStatus 'generalInfo/@snapDeferredCatalogStatus',
									   @backupOption 'generalInfo/@backupOption',
									   totalNumOfFiles 'generalInfo/@totalNumOfFiles',
									   J.startTime 'generalInfo/@startTime',
									   jobStartedBy 'generalInfo/@jobStartedBy',
									   (SELECT CASE @isTelstraOEM
													WHEN 1 THEN (CASE
																	WHEN JOP.opType <> 4 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, JOP.messageId, 0, 2)
ELSE dbo.fn_EvFormatEventMsgText(0, @i_localeId, (2309 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
																 END)
														ELSE (CASE
																WHEN J.opType IN (29, 90) THEN @otheropname
																WHEN J.opType IN(31, 106) AND (J.backupType & 0x40 /*ARCHIVECHECKFLAGS_DDB_DEFRAG_WITH_DV2_SIMPLIFIED*/ <> 0)
THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, (4414 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
WHEN J.opType IN(31, 106) AND J.cloudid <> 0 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3283 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
																WHEN J.opType = 35 THEN (
																						CASE J.backupType
WHEN 1 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1623 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
WHEN 2 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1624 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
WHEN 3 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1898 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
ELSE dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1567 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
																						END
																						)
																WHEN J.opType = 36 THEN (
																						CASE J.backupType
WHEN 1 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1625 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
ELSE dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1568 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
																						END
																						)
																WHEN J.opType = 38 THEN (
																						CASE J.appTypeId
WHEN 58 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1570 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
ELSE dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1570 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
																						END
																						)
																ELSE dbo.fn_EvFormatEventMsgText(0, @i_localeId, JOP.messageId, 0, 2)
														  END)
												END
										FROM JMJobOperationNames JOP WHERE JOP.opType = J.opType) 'generalInfo/@operationType',
									   J.opType 'generalInfo/@opType',
									   CASE jobStartedFrom
									   WHEN 1 THEN 'Third Party'
									   WHEN 2 THEN 'Interactive'
									   WHEN 3 THEN 'Scheduled'
									   WHEN 4 THEN 'System'
									   ELSE 'Unknown'
									   END 'generalInfo/@jobStartedFrom',
									   scheduleName 'generalInfo/@scheduleName',
									   CASE  WHEN (jobAttributes & 0x100000) > 0 THEN 'Yes' ELSE 'No' END 'generalInfo/@systemState',
									   scanTypeChangeReason 'generalInfo/@scanChangeReason',
									   CASE ISNULL(xmlJobInfo.value('(JobManager_BkpJobDetailsXml/@compType)[1]', 'int'), 4)
											   WHEN 0 THEN 'Client'
											   WHEN 1 THEN 'Media Agent'
											   WHEN 2 THEN 'Storage Policy'
											   WHEN 4 THEN 'Off'
											   ELSE 'Unknown'
									   END  'generalInfo/@softwareCompression',
									   ER_Destination 'generalInfo/@destinationLocation',
									   ER_DbName 'generalInfo/@DRDatabase',
									   encrypted 'generalInfo/@encrypted',
									   CASE J.optype
									           WHEN 13 THEN 'No'
											   WHEN 104 THEN 'Yes'
											   ELSE 'No'
									   END  'generalInfo/@useScalableResourceAllocation',
									   @gacpName 'generalInfo/@gacpName',
									   xmlJobInfo.value('(JobManager_AdminJobDetailsXml/srmReportJobInfo/@srmReportName)[1]', 'varchar(max)') 'generalInfo/@srmReportType',
									   xmlJobInfo.value('(JobManager_AdminJobDetailsXml/patchUpdateInfo/@monitoringPolicyName)[1]', 'varchar(max)') 'generalInfo/@monitoringPolicyName',
									   MI_InventoryType 'generalInfo/@mediaInventoryType',
									   @verificationType 'generalInfo/@verificationType',
									   @dataVerificationType 'generalInfo/@dataVerificationType',
									   @srcPartition 'generalInfo/@srcPartition',
									   @destPartition 'generalInfo/@destPartition',
									   jobIdActedOn 'generalInfo/@jobIdActedOn',
									   vsaParentJobID 'generalInfo/@vsaParentJobID',
									   @agingOn 'generalInfo/@agingOn',
									   @libName 'generalInfo/@libraryName',
									   @driveName 'generalInfo/@driveName',
									   @dataSize 'generalInfo/@dataSizeInMB',
									   @readThroughput 'generalInfo/@readThroughtputInMBPerSec',
									   @writeThroughput 'generalInfo/@writeThroughtputInMBPerSec',
									   distributedAppsClusterType 'generalInfo/@distributedAppsClusterType',
									   jobAttributes 'generalInfo/@jobAttributes',
									   jobAttributesEx 'generalInfo/@jobAttributesEx',
									   subclientId	'generalInfo/subclient/@subclientId',
									   subclientName	'generalInfo/subclient/@subclientName',
									   clientId 'generalInfo/subclient/@clientId',
									   clientName 'generalInfo/subclient/@clientName',
									   ISNULL(displayClientName,'') 'generalInfo/subclient/@displayName',
									   instanceId 'generalInfo/subclient/@instanceId',
									   dbo.EncodeInvalidXMLChar(instanceName) 'generalInfo/subclient/@instanceName',
									   backupsetId 'generalInfo/subclient/@backupsetId',
									   backupsetName 'generalInfo/subclient/@backupsetName',
									   appTypeId 'generalInfo/subclient/@applicationId',
									   appTypeName 'generalInfo/subclient/@appName',
									   destinationClient 'generalInfo/destinationClient/@clientName',
                                       destinationClientDisplayName 'generalInfo/destinationClient/@displayName',
									   destinationclientId 'generalInfo/destinationClient/@clientId',
									   mediaAgentName 'generalInfo/mediaAgent/@mediaAgentName',
									   storagePolicyName 'generalInfo/storagePolicy/@storagePolicyName',
									   storagePolicyId 'generalInfo/storagePolicy/@storagePolicyId',
									   scheduleName 'generalInfo/taskData/@subtaskName',
									   subTaskId 'generalInfo/taskData/@subtaskId',
									   schedulePolicyName 'generalInfo/taskData/@taskName',
                                       taskId 'generalInfo/taskData/@taskId',
									   srcMediaAgent 'generalInfo/sourceMediaAgent/@mediaAgentName',
									   destMediaAgent 'generalInfo/destMediaAgent/@mediaAgentName',
									   LibraryID 'generalInfo/mediaLibrary/@libraryId',
									   LibraryName 'generalInfo/mediaLibrary/@libraryName',
									   cloudId 'generalInfo/DDBdetails/@sidbStoreId',
									   cloudName 'generalInfo/DDBdetails/@sidbStoreName',
									   @otheropname 'generalInfo/workflow/@workflowName',
									   commcellId 'generalInfo/commcell/@commCellId',
									   selectiveVMClientDisplayName 'generalInfo/selectiveVMClient/@vmName',
									   destInstanceId 'generalInfo/destInstance/@instanceId',
									   dbo.EncodeInvalidXMLChar(destInstanceName) 'generalInfo/destInstance/@instanceName',
									   @sendLogFilesOptionsXML 'generalInfo',
									   currentPhaseName 'progressInfo/@currentPhase',
									   (SELECT stateName FROM JMJobStateNames WHERE stateType = currentstate) 'progressInfo/@state',
									   J.elapsedTime 'progressInfo/@elapsedTime',
									   filesXfered 'progressInfo/@numOfFilesTransferred',
									   J.uncompBytes 'progressInfo/@sizeOfApplication',
									   totalMediaUsageTime 'progressInfo/@transferTime',
									   timeToComplete 'progressInfo/@estimatedCompletionTime',
									   lastUpdateFromClient 'progressInfo/@lastJobUpdateTime',
									   percentcomplete 'progressInfo/@percentComplete',
									   currentThroughput 'progressInfo/@currentAttemptThroughput',
									   averageThroughput 'progressInfo/@averageThroughput',
									   DelayReason 'progressInfo/@reasonForJobDelay',
									   dataXferedNetwork 'progressInfo/@dataXferedNetwork',
									   totSkipped 'progressInfo/@skippedItems',
									   objectsFailed 'progressInfo/@failedItems',
									   compressionRatio 'progressInfo/@compressionRatio',
									   dbo.EncodeInvalidXMLChar(activeFile) 'progressInfo/@activeFile',
									   attemptStartTime 'progressInfo/@attemptStartTime',
									   phasePercentagesList 'progressInfo/@phasePercentagesList',
									   phaseTimingsList 'progressInfo/@phaseTimingsList',
									   currentPhase 'progressInfo/@currentPhaseNum',
									   currentPhaseType 'progressInfo/@currentPhaseType',
									   ( SELECT CAST(scanFolderFailures+backupFolderFailures AS VARCHAR(MAX))+ ' Folders, ' + CAST(scanFileFailures + backupFileFailures AS VARCHAR(MAX))+ ' Files' ) 'progressInfo/@failures',
									   xmlJobInfo.value('(JobManager_RstJobDetailsXml/genericJobDetails/restoreDetails/@restoreType)[1]', 'int') 'progressInfo/@restoreType',
									   readCurrentThroughput 'progressInfo/detailThroughput/readThroughPut/@currentThroughput',
									   readAverageThroughput 'progressInfo/detailThroughput/readThroughPut/@averageThroughput',
									   writeCurrentThroughput 'progressInfo/detailThroughput/writeThroughPut/@currentThroughput',
									   writeAverageThroughput 'progressInfo/detailThroughput/writeThroughPut/@averageThroughput',
									   ntwkCurrentThroughput 'progressInfo/detailThroughput/networkThroughPut/@currentThroughput',
									   ntwkAverageThroughput 'progressInfo/detailThroughput/networkThroughPut/@averageThroughput',
									   sidbCurrentLookups 'progressInfo/detailThroughput/sidbLookupInfo/@currentLookups',
									   sidbAverageLookups 'progressInfo/detailThroughput/sidbLookupInfo/@averageLookups',
									   readPercentageTime 'progressInfo/detailThroughput/readThroughPut/@percentageTime',
									   writePercentageTime 'progressInfo/detailThroughput/writeThroughPut/@percentageTime',
									   networkPercentageTime 'progressInfo/detailThroughput/networkThroughPut/@percentageTime',
									   sidbPercentageTime 'progressInfo/detailThroughput/sidbLookupInfo/@percentageTime',
									   @auxCopyProgressInfoxml 'progressInfo',
									   sizeOnMedia 'detailInfo/@sizeOfMediaOnDisk',
									   totalCompBytes 'detailInfo/@compressedBytes',
									   @workFlowInputsInfoxml 'detailInfo/@workflowInputsXml',
									   stubDataSize 'detailInfo/@stubDataSize',
									   storagePolicyCopyName 'detailInfo/copy/@copyName',
									 --  (SELECT TOP 1 startTime FROM JMBkpAttemptInfo where jobId = @i_jobId ORDER BY startTime Desc)
									  -- 'progressInfo/@attemptStartTimeString'
									  @clientStatusXML,
									  @logMonitoringClientStatusXML,
									  xmlJobInfo.value('(JobManager_BkpJobDetailsXml/@logicalSize)[1]', 'bigint') AS 'detailInfo/xmlJobInfo/bkpJobInfo/@logicalSize',
									  xmlJobInfo.query('JobManager_BkpJobDetailsXml/*') as 'detailInfo/xmlJobInfo/bkpJobInfo',
									  xmlJobInfo.query('JobManager_RstJobDetailsXml/*') as 'detailInfo/xmlJobInfo/rstJobInfo',
									  xmlJobInfo.query('JobManager_AdminJobDetailsXml/*') as 'detailInfo/xmlJobInfo/adminJobInfo'
								FROM @JobDetails J
								FOR XML PATH('jobDetail'), TYPE
								),
							   		[jobSummary/@isAnomalous] = isAnomalous,
							   		[jobSummary/@thresholdTime] = thresholdTime,
									[jobSummary/@possibleReasonForDelay] = possibleReasonForDelay
								FOR XML PATH('job'), TYPE
					)
		FROM @JobDetails
		FOR XML PATH('JobManager_JobDetailResponse'), TYPE
	)
	END
	ELSE
	BEGIN
	DECLARE @uncompBytes bigint = ISNULL((select uncompBytes from @JobDetails),0)
	DECLARE @savingsPercent DECIMAL(10, 2) = 0
	IF @uncompBytes <> 0
	BEGIN
		SET @savingsPercent = (SELECT (CAST((uncompBytes-sizeOnMedia) AS float) *100)/CAST(uncompBytes AS float) from @JobDetails)
		IF @savingsPercent < 0
			SET @savingsPercent =  0
	END
	UPDATE @JobDetails
	SET readAverageThroughput = CASE WHEN T.readThroughput = '0' THEN NULL ELSE T.readThroughput END,
	writeAverageThroughput = CASE WHEN T.writeThroughput = '0' THEN NULL ELSE T.writeThroughput END,
	ntwkAverageThroughput = CASE WHEN T.networkThroughput = '0' THEN NULL ELSE T.networkThroughput END,
	sidbAverageLookups = CASE WHEN T.sidbLookups = '0' THEN NULL ELSE T.sidbLookups END
	FROM
	(
		SELECT jobId AS jId, [1] AS readThroughput, [2] AS writeThroughput, [3] AS networkThroughput, [4] AS sidbLookups
		FROM
		(
			SELECT S.Id, S.Data, jobId
			FROM @JobDetails O
			OUTER APPLY dbo.SplitString(O.jobThroughPut, ':') S
			WHERE O.jobThroughPut IS NOT NULL
		) AS P
		PIVOT(MAX([Data]) FOR [id] IN([1], [2], [3], [4])) AS PivotTable
	) T
	WHERE jobId = T.jId
	SET @o_xml =
	(
		SELECT (
		SELECT(
				  SELECT
									   J.jobId 'generalInfo/@jobId' ,
									   (SELECT dbo.GetJobBackupTypeDisplay(backupType)) 'generalInfo/@backupType',
									   priority 'generalInfo/@priority', --sending this number as GUI is not able to make it null
									   scanType 'generalInfo/@scanType',
									   @snapToTapeStatus 'generalInfo/@snapToTapeStatus',
									   @snapDeferredCatalogStatus 'generalInfo/@snapDeferredCatalogStatus',
									   @backupOption 'generalInfo/@backupOption',
									   totalNumOfFiles 'generalInfo/@totalNumOfFiles', --sending this number as GUI is not able to make it null
									   J.startTime 'generalInfo/@startTime',
									   jobStartedBy 'generalInfo/@jobStartedBy',
									   scheduleName 'generalInfo/@scheduleName',
									   (SELECT CASE @isTelstraOEM
													WHEN 1 THEN (CASE
																	WHEN JOP.opType <> 4 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, JOP.messageId, 0, 2)
ELSE dbo.fn_EvFormatEventMsgText(0, @i_localeId, (2309 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
																 END)
														   ELSE (CASE
																WHEN J.opType IN (29, 90) THEN @otheropname
																WHEN J.opType IN(31, 106) AND (J.backupType & 0x40 /*ARCHIVECHECKFLAGS_DDB_DEFRAG_WITH_DV2_SIMPLIFIED*/ <> 0)
THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, (4414 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
WHEN J.opType IN (31, 106) AND J.cloudid <> 0 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, (3283 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
WHEN J.opType = 112 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, (4406 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
WHEN J.opType = 71 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1603 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
WHEN J.opType = 72 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1604 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
WHEN J.opType = 99 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, (2007 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
WHEN J.opType = 10 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1375 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
																WHEN J.opType = 35 THEN(
																						CASE J.backupType
WHEN 1 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1623 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
WHEN 2 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1624 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
WHEN 3 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1898 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
ELSE dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1567 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
	                                                                                    END
																						)
	                                                            WHEN J.opType = 36 THEN(
																						CASE J.backupType
WHEN 1 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1625 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
ELSE dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1568 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
	                                                                                    END
	                                                                                    )
	                                                            WHEN J.opType = 38 THEN(
	                                                                                    CASE J.appTypeId
WHEN 58 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1570 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
ELSE dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1570 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
	                                                                                    END
	                                                                                    )
	                                                            ELSE dbo.fn_EvFormatEventMsgText(0, @i_localeId, JOP.messageId, 0, 2)
														  END)
												END
										FROM JMJobOperationNames JOP WHERE JOP.opType = J.opType) 'generalInfo/@operationType',
									   J.opType 'generalInfo/@opType',
									   CASE jobStartedFrom
									   WHEN 1 THEN 'Third Party'
									   WHEN 2 THEN 'Interactive'
									   WHEN 3 THEN 'Scheduled'
									   WHEN 4 THEN 'System'
									   ELSE 'Unknown'
									   END 'generalInfo/@jobStartedFrom',
									   CASE  WHEN (jobAttributes & 0x100000) > 0 THEN 'Yes' ELSE 'No' END 'generalInfo/@systemState',
									   CASE ISNULL(xmlJobInfo.value('(JobManager_BkpJobDetailsXml/@compType)[1]', 'int'), 4)
									   		   WHEN 0 THEN 'Client'
									   		   WHEN 1 THEN 'Media Agent'
											   WHEN 2 THEN 'Storage Policy'
											   WHEN 4 THEN 'Off'
									   		   ELSE 'Unknown'
									   END  'generalInfo/@softwareCompression',
									   ER_Destination 'generalInfo/@destinationLocation',
									   ER_DbName 'generalInfo/@DRDatabase',
									   encrypted 'generalInfo/@encrypted',
									   CASE J.optype
											WHEN 13 THEN 'No'
											WHEN 104 THEN 'Yes'
											ELSE 'No'
									   END  'generalInfo/@useScalableResourceAllocation',
									   @gacpName 'generalInfo/@gacpName',
									   xmlJobInfo.value('(JobManager_AdminJobDetailsXml/srmReportJobInfo/@srmReportName)[1]', 'varchar(max)') 'generalInfo/@srmReportType',
									   xmlJobInfo.value('(JobManager_AdminJobDetailsXml/patchUpdateInfo/@monitoringPolicyName)[1]', 'varchar(max)') 'generalInfo/@monitoringPolicyName',
									   MI_InventoryType 'generalInfo/@mediaInventoryType',
									   @verificationType 'generalInfo/@verificationType',
									   @dataVerificationType 'generalInfo/@dataVerificationType',
									   @srcPartition 'generalInfo/@srcPartition',
									   @destPartition 'generalInfo/@destPartition',
									   jobIdActedOn 'generalInfo/@jobIdActedOn',
									   vsaParentJobID 'generalInfo/@vsaParentJobID',
									   @agingOn 'generalInfo/@agingOn',
									   @totalFilesToDownload 'generalInfo/@totalFilesToDownload',
									   @libName 'generalInfo/@libraryName',
									   @driveName 'generalInfo/@driveName',
									   @dataSize 'generalInfo/@dataSizeInMB',
									   @readThroughput 'generalInfo/@readThroughtputInMBPerSec',
									   @writeThroughput 'generalInfo/@writeThroughtputInMBPerSec',
									   distributedAppsClusterType 'generalInfo/@distributedAppsClusterType',
                                       jobAttributes 'generalInfo/@jobAttributes',
									   jobAttributesEx 'generalInfo/@jobAttributesEx',
									   subclientId	'generalInfo/subclient/@subclientId',
									   subclientName	'generalInfo/subclient/@subclientName',
									   clientId 'generalInfo/subclient/@clientId',
									   clientName 'generalInfo/subclient/@clientName',
									   ISNULL(displayClientName,'') 'generalInfo/subclient/@displayName',
									   instanceId 'generalInfo/subclient/@instanceId',
									   dbo.EncodeInvalidXMLChar(instanceName) 'generalInfo/subclient/@instanceName',
									   backupsetId 'generalInfo/subclient/@backupsetId',
									   backupsetName 'generalInfo/subclient/@backupsetName',
									   appTypeId 'generalInfo/subclient/@applicationId',
									   appTypeName 'generalInfo/subclient/@appName',
									   destinationClient 'generalInfo/destinationClient/@clientName',
                                       destinationClientDisplayName 'generalInfo/destinationClient/@displayName',
									   destinationclientId 'generalInfo/destinationClient/@clientId',
									   mediaAgentName 'generalInfo/mediaAgent/@mediaAgentName',
									   storagePolicyId 'generalInfo/storagePolicy/@storagePolicyId',
									   storagePolicyName 'generalInfo/storagePolicy/@storagePolicyName',
									   scheduleName 'generalInfo/taskData/@subtaskName',
									   subTaskId 'generalInfo/taskData/@subtaskId',
									   schedulePolicyName 'generalInfo/taskData/@taskName',
									   taskId 'generalInfo/taskData/@taskId',
									   srcMediaAgent 'generalInfo/sourceMediaAgent/@mediaAgentName',
									   destMediaAgent 'generalInfo/destMediaAgent/@mediaAgentName',
									   LibraryID 'generalInfo/mediaLibrary/@libraryId',
									   LibraryName 'generalInfo/mediaLibrary/@libraryName',
									   cloudId 'generalInfo/DDBdetails/@sidbStoreId',
									   cloudName 'generalInfo/DDBdetails/@sidbStoreName',
									   commcellId 'generalInfo/commcell/@commCellId',
									   @otheropname 'generalInfo/workflow/@workflowName',
									   selectiveVMClientDisplayName 'generalInfo/selectiveVMClient/@vmName',
									   destInstanceId 'generalInfo/destInstance/@instanceId',
									   dbo.EncodeInvalidXMLChar(destInstanceName) 'generalInfo/destInstance/@instanceName',
									   @sendLogFilesOptionsXML 'generalInfo',
									   (SELECT stateName FROM JMJobStatusNames WHERE stateType = status) 'progressInfo/@state',
									   DelayReason 'progressInfo/@reasonForJobDelay',
									   filesXfered 'progressInfo/@numOfFilesTransferred',
									   @auxCopyProgressInfoxml 'progressInfo',
									   numOfStreams 'detailInfo/@numOfStreams',
									   startTime 'detailInfo/@startTime',
									   jobEndTime 'detailInfo/@endTime',
									   uncompBytes 'detailInfo/@sizeOfApplication',
									   totalCompBytes 'detailInfo/@compressedBytes',
									   uncompBytes 'detailInfo/@unCompressedBytes',
									   sizeOnMedia 'detailInfo/@dataWritten',
									   @savingsPercent 'detailInfo/@savingsPercent',
									   dataXferedNetwork 'detailInfo/@dataXferedNetwork',
									   totSkipped 'detailInfo/@skippedItems',
									   objectsFailed 'detailInfo/@failedItems',
									   transferTime 'detailInfo/@transferTime',
									   filesXfered 'detailInfo/@numOfObjects',
									   sizeOnMedia 'detailInfo/@sizeOfMediaOnDisk',
									   throughPut 'detailInfo/@throughPut',
									   stubDataSize 'detailInfo/@stubDataSize',
									   @workFlowInputsInfoxml 'detailInfo/@workflowInputsXml',
									   REPLACE((oraBackupRefTimeAndLsn), char(0x0012), char(0x0009)) 'detailInfo/@oraBackupRefTimeAndLsn',
									   xmlJobInfo.value('(JobManager_RstJobDetailsXml/genericJobDetails/restoreDetails/@restoreType)[1]', 'int') 'detailInfo/@restoreType',
									   ( SELECT CAST(scanFolderFailures+backupFolderFailures AS VARCHAR(MAX))+ ' Folders, ' + CAST(scanFileFailures + backupFileFailures AS VARCHAR(MAX))+ ' Files' ) 'detailInfo/@failures',
									   storagePolicyCopyName 'detailInfo/copy/@copyName',
									   readAverageThroughput 'detailInfo/detailThroughput/readThroughPut/@averageThroughput',
									   writeAverageThroughput 'detailInfo/detailThroughput/writeThroughPut/@averageThroughput',
									   ntwkAverageThroughput 'detailInfo/detailThroughput/networkThroughPut/@averageThroughput',
									   sidbAverageLookups 'detailInfo/detailThroughput/sidbLookupInfo/@averageLookups',
									   readPercentageTime 'detailInfo/detailThroughput/readThroughPut/@percentageTime',
									   writePercentageTime 'detailInfo/detailThroughput/writeThroughPut/@percentageTime',
									   networkPercentageTime 'detailInfo/detailThroughput/networkThroughPut/@percentageTime',
									   sidbPercentageTime 'detailInfo/detailThroughput/sidbLookupInfo/@percentageTime',
									  @clientStatusXML,
									  @logMonitoringClientStatusXML,
									  xmlJobInfo.value('(JobManager_BkpJobDetailsXml/@logicalSize)[1]', 'bigint') AS 'detailInfo/xmlJobInfo/bkpJobInfo/@logicalSize',
									  xmlJobInfo.query('JobManager_BkpJobDetailsXml/*') as 'detailInfo/xmlJobInfo/bkpJobInfo',
									  xmlJobInfo.query('JobManager_RstJobDetailsXml/*') as 'detailInfo/xmlJobInfo/rstJobInfo',
									  xmlJobInfo.query('JobManager_AdminJobDetailsXml/*') as 'detailInfo/xmlJobInfo/adminJobInfo'
								FROM @JobDetails J
								FOR XML PATH('jobDetail'), TYPE
								)
								FOR XML PATH('job'), TYPE
					)
		FROM @JobDetails
		FOR XML PATH('JobManager_JobDetailResponse'), TYPE
	)
	END
	END
	ELSE IF (@i_showAttempt = 1)
	BEGIN
		IF @jobCompleted = 1
		BEGIN
		SET @o_xml =
		(
			SELECT (
			SELECT(
					  SELECT
						  (SELECT
											phase AS '@phase',
                                            phaseName AS '@phaseName',
                                            JM.startTime AS '@startTime',
                                            endTime AS '@endTime',
                                            JM.elapsedTime AS '@elapsedTime',
                                            writeTime AS '@transferTime',
                                            nwtransbytes AS '@dataWritten',
                                            ISNULL((SELECT stateName FROM JMJobStatusNames WHERE stateType = JM.status),'') AS '@status',
                                            uncompBytes AS '@uncompBytes',
                                            compBytes AS '@compBytes',
                                            numObjects AS '@numObjects',
                                            numFolders AS '@numFolders',
                                            numSuccess AS '@numSuccess',
                                            numSkipped AS '@numSkipped',
                                            numFailures AS '@numFailures',
                                            embeddedObjects AS '@embeddedObjects',
                                            totalAllocationTime AS '@totalAllocationTime',
                                            totalWaitTimeBeforeAllocation AS '@totalWaitTimeBeforeAllocation',
                                            maxStreamsUsed AS '@maxStreamsUsed',
                                            failureReason AS '@failureReason',
                                            SUBSTRING((
                                                    SELECT ',' + RTRIM(LTRIM(tAttmp1.libraryName))  AS [text()]
                                                    FROM  @JobAttempts tAttmp1
                                                    WHERE tAttmp1.number = JM.number
                                                          AND tAttmp1.phase = JM.phase
                                                        --  AND tAttmp1.appType = JM.appType
                                                        --  AND tAttmp1.opType = JM.opType
                                                          AND tAttmp1.copyid = JM.copyid
                                                    ORDER BY J.startTime ASC
                                                    FOR XML PATH('')
                                                    ),2,4000) AS 'library/@libraryName',
                                            SUBSTRING((
                                                    SELECT ',' + RTRIM(LTRIM(tAttmp1.libraryName))  AS [text()]
                                                    FROM  @JobAttempts tAttmp1
                                                    WHERE tAttmp1.number = JM.number
                                                          AND tAttmp1.phase = JM.phase
                                                          --AND tAttmp1.appType = JM.appType
                                                          --AND tAttmp1.opType = JM.opType
                                                          AND tAttmp1.copyid = JM.copyid
                                                    ORDER BY J.startTime ASC
                                                    FOR XML PATH('')
                                                    ),2,4000) AS 'mediaAgent/@mediaAgentName',
                                      drivePoolName AS 'drivePool/@drivePoolName',
                                      archGrpId AS 'storagePolicy/@storagePolicyId',
                                      archGrpName AS 'storagePolicy/@storagePolicyName',
                                      copyId AS 'copy/@copyId',
                                      copyName AS 'copy/@copyName',
									  readCurrentThroughput 'detailThroughput/readThroughPut/@currentThroughput',
									  readAverageThroughput 'detailThroughput/readThroughPut/@averageThroughput',
									  writeCurrentThroughput 'detailThroughput/writeThroughPut/@currentThroughput',
									  writeAverageThroughput 'detailThroughput/writeThroughPut/@averageThroughput',
									  ntwkCurrentThroughput 'detailThroughput/networkThroughPut/@currentThroughput',
									  ntwkAverageThroughput 'detailThroughput/networkThroughPut/@averageThroughput',
									  sidbCurrentLookups 'detailThroughput/sidbLookupInfo/@currentLookups',
									  sidbAverageLookups 'detailThroughput/sidbLookupInfo/@averageLookups',
									  readPercentageTime 'detailThroughput/readThroughPut/@percentageTime',
									  writePercentageTime 'detailThroughput/writeThroughPut/@percentageTime',
									  networkPercentageTime 'detailThroughput/networkThroughPut/@percentageTime',
									  sidbPercentageTime 'detailThroughput/sidbLookupInfo/@percentageTime'
						  FROM @JobAttempts JM
						  FOR XML PATH('attemptsInfo'), TYPE)
						  FROM @JobDetails J
						  FOR XML PATH('jobDetail'), TYPE
						  )
						FOR XML PATH('job'), TYPE
					)
			FROM @JobDetails
			FOR XML PATH('JobManager_JobDetailResponse'), TYPE
		)
		END
		ELSE
		BEGIN
		SET @o_xml =
		(
			SELECT (
			SELECT(
					  SELECT
						  (SELECT
									  phase AS '@phase',
									  phaseName AS '@phaseName',
									  JM.startTime AS '@startTime',
									  endTime AS '@endTime',
									  JM.elapsedTime AS '@elapsedTime',
									  writeTime AS '@transferTime',
									  nwtransbytes AS '@dataWritten',
									  ISNULL((SELECT stateName FROM JMJobStatusNames WHERE stateType = JM.status),'') AS '@status',
									  uncompBytes AS '@uncompBytes',
									  compBytes AS '@compBytes',
									  numObjects AS '@numObjects',
									  numFolders AS '@numFolders',
									  numSuccess AS '@numSuccess',
									  numSkipped AS '@numSkipped',
									  numFailures AS '@numFailures',
									  embeddedObjects AS '@embeddedObjects',
									  totalAllocationTime AS '@totalAllocationTime',
									  totalWaitTimeBeforeAllocation AS '@totalWaitTimeBeforeAllocation',
									  maxStreamsUsed AS '@maxStreamsUsed',
									  failureReason AS '@failureReason',
									  libraryName AS 'library/@libraryName',
									  mediaAgent AS 'mediaAgent/@mediaAgentName',
									  drivePoolName AS 'drivePool/@drivePoolName',
									  archGrpId AS 'storagePolicy/@storagePolicyId',
									  archGrpName AS 'storagePolicy/@storagePolicyName',
									  copyId AS 'copy/@copyId',
									  copyName AS 'copy/@copyName',
									  readCurrentThroughput 'detailThroughput/readThroughPut/@currentThroughput',
									  readAverageThroughput 'detailThroughput/readThroughPut/@averageThroughput',
									  writeCurrentThroughput 'detailThroughput/writeThroughPut/@currentThroughput',
									  writeAverageThroughput 'detailThroughput/writeThroughPut/@averageThroughput',
									  ntwkCurrentThroughput 'detailThroughput/networkThroughPut/@currentThroughput',
									  ntwkAverageThroughput 'detailThroughput/networkThroughPut/@averageThroughput',
									  sidbCurrentLookups 'detailThroughput/sidbLookupInfo/@currentLookups',
									  sidbAverageLookups 'detailThroughput/sidbLookupInfo/@averageLookups',
									  readPercentageTime 'detailThroughput/readThroughPut/@percentageTime',
									  writePercentageTime 'detailThroughput/writeThroughPut/@percentageTime',
									  networkPercentageTime 'detailThroughput/networkThroughPut/@percentageTime',
									  sidbPercentageTime 'detailThroughput/sidbLookupInfo/@percentageTime'
						  FROM @JobAttempts JM
						  FOR XML PATH('attemptsInfo'), TYPE)
						  FROM @JobDetails J
						  FOR XML PATH('jobDetail'), TYPE
						  ),
							[jobSummary/@isAnomalous] = isAnomalous,
							[jobSummary/@thresholdTime] = thresholdTime,
							[jobSummary/@possibleReasonForDelay] = possibleReasonForDelay
						FOR XML PATH('job'), TYPE
					)
			FROM @JobDetails
			FOR XML PATH('JobManager_JobDetailResponse'), TYPE
		)
		END
	END
PROC_EXIT:
	IF ( @o_xml IS null )
		SET @o_xml = '<JobManager_JobDetailResponse />'
	IF (@i_selectOutput = 1)
		SELECT @o_xml
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetRunningJobDetails')
	delete from GxQscripts where name = 'JMGetRunningJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRunningJobDetails')
	delete from GXDBVersions where aliasname = 'JMGetRunningJobDetails'
GO

insert into GXDBVersions values(2, 'JMGetRunningJobDetails',  'v1.18.2.90.4.2', 'JMGetRunningJobDetails', 'v1.18.2.90.4.2')
GO

