

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetRunningJobCount.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetRunningJobCount.sp,v $ $Id: JMGetRunningJobCount.sp,v 1.1.4.6 2019/11/16 23:14:52 jragunathan Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "JMGetRunningJobCount"
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetRunningJobCount')
BEGIN
	print '>>> Drop Stored Procedure: JMGetRunningJobCount <<<'
	drop procedure JMGetRunningJobCount
END
IF EXISTS (select * from GxQscripts where name='JMGetRunningJobCount')
	delete from GxQscripts where name = 'JMGetRunningJobCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRunningJobCount')
	delete from GXDBVersions where aliasname = 'JMGetRunningJobCount'
GO
print '... Creating Procedure: JMGetRunningJobCount'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetRunningJobCount
-- Input arguments
  @i_userId INT
AS
  DECLARE @jobCount INT
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @bkpJobs int
	DECLARE @adminJobs int
	DECLARE @restoreJobs int
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_Bkp') IS NOT NULL
		DROP TABLE #SecIDANodeAccessTemp_Bkp
	IF OBJECT_ID(N'tempdb.dbo.#JMCanManageJob_rstObject') IS NOT NULL
		DROP TABLE #JMCanManageJob_rstObject
	IF OBJECT_ID(N'tempdb.dbo.#JMCanManageJob_adminObject') IS NOT NULL
		DROP TABLE #JMCanManageJob_adminObject
	DECLARE @showSyncRestores INT = ISNULL((SELECT CAST(value AS INT)
										FROM GXGlobalParam WITH (NOLOCK)
										WHERE name = 'JMShowSyncRestoreJobs'
										AND modified = 0), 0)
	CREATE TABLE #SecIDANodeAccessTemp_Bkp
	(
		t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
	)
	CREATE CLUSTERED INDEX [#SecIDANodeAccessTemp_Bkp_subclientId] ON [#SecIDANodeAccessTemp_Bkp]([t_subclientId] ASC)
create table  #JMCanManageJob_adminObject ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
create table  #JMCanManageJob_rstObject ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	DECLARE @adminCap INTEGER
    SET @adminCap = POWER(2,1-1) | POWER(2,16-1) | POWER(2,4-1) | POWER(2,8-1) | POWER(2,31-1)
    --POWER(2,EV_SCHEDULE_ADMIN-1) | POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_MANAGE_ARCHIVES-1) | POWER(2,EV_MANAGE_LIBRARY-1) | POWER(2,EV_VISIBILITY-1)
    DECLARE @restoreCap INTEGER
    -- POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_RESTORE_IN_PLACE-1) | POWER(2,EV_RESTORE_OUTOF_PLACE-1) | POWER(2,EV_VISIBILITY-1)
    SET @restoreCap = POWER(2,16-1) | POWER(2,20-1) | POWER(2,22-1) | POWER(2,31-1)
    -- POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_BACKUP-1)| POWER(2,EV_RESTORE_IN_PLACE-1) | POWER(2,EV_RESTORE_OUTOF_PLACE-1) | POWER(2,EV_BROWSE-1)| POWER(2,EV_RUN_REPORTS-1) | POWER(2,EV_VISIBILITY-1)
    exec sec_getIdaObjectsForUser @i_userId,7,0,0,'#SecIDANodeAccessTemp_Bkp',0,'16,12,20,22,13,15,31',0
    exec sec_getUserObjects @i_userId,2013,0,'#JMCanManageJob_adminObject'
    exec sec_getUserObjects @i_userId,14033,0,'#JMCanManageJob_adminObject'
    exec sec_getUserObjects @i_userId,2231,0,'#JMCanManageJob_adminObject'
    exec sec_getUserObjects @i_userId,2012,0,'#JMCanManageJob_rstObject'
    DELETE FROM #JMCanManageJob_adminObject
        WHERE  (Capabilities & @adminCap) = 0
    DELETE FROM #JMCanManageJob_rstObject
        WHERE  (Capabilities & @restoreCap) = 0
	--Tenant admin should be able to view jobs submitted by other users in the company.
	IF OBJECT_ID('tempdb.dbo.#getUsersInCompanyOutputTbl') IS NOT NULL
		DROP TABLE #getUsersInCompanyOutputTbl
	CREATE TABLE #getUsersInCompanyOutputTbl (
		userId INTEGER,
		PRIMARY KEY(userId)
	)
	--Populates #getUsersInCompanyOutputTbl
	EXEC sec_getUsersInCompany @i_userId
	DECLARE @isCSLevelAssociatedAdmin INT = (SELECT TOP 1 1 FROM #JMCanManageJob_adminObject rstUserObject WITH(NOLOCK) WHERE
							   (rstUserObject.commCellId=2 AND rstUserObject.clientGroupId=0 AND rstUserObject.clientId=0 AND rstUserObject.appTypeId=0 AND rstUserObject.instanceId=0 AND rstUserObject.backupsetId=0 AND rstUserObject.subClientId=0 AND rstUserObject.mediaAgentId=0 AND rstUserObject.libraryId=0 AND rstUserObject.archGroupId=0 AND rstUserObject.vtContainerId=0 AND rstUserObject.vtPolicyId=0 AND rstUserObject.vtShelfId=0 AND rstUserObject.reviewSetId=0 AND rstUserObject.querySetId=0 AND rstUserObject.downloadSetId=0 AND rstUserObject.ermId=0 AND rstUserObject.legalHoldId=0 AND rstUserObject.tagId=0 AND rstUserObject.cdPolicyId=0 AND rstUserObject.complianceReportId=0 AND rstUserObject.taskId=0 AND rstUserObject.workflowId=0 AND rstUserObject.logMonitoringPolicyId=0 AND rstUserObject.arrayId=0 AND rstUserObject.cloudId=0 AND rstUserObject.userGroupId=0 AND rstUserObject.providerId=0 AND rstUserObject.entityId1=0 AND rstUserObject.entityId2=0 AND rstUserObject.entityId3=0 AND rstUserObject.entityId4=0 AND rstUserObject.entityId5=0									AND rstUserObject.entityId6=0 AND rstUserObject.entityId7=0 AND rstUserObject.entityId8=0 AND rstUserObject.entityId9=0)
							   OR (rstUserObject.clientId=-10))
	DECLARE @isCSLevelAssociatedRst INT = (SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK) WHERE
							   (rstUserObject.commCellId=2 AND rstUserObject.clientGroupId=0 AND rstUserObject.clientId=0 AND rstUserObject.appTypeId=0 AND rstUserObject.instanceId=0 AND rstUserObject.backupsetId=0 AND rstUserObject.subClientId=0 AND rstUserObject.mediaAgentId=0 AND rstUserObject.libraryId=0 AND rstUserObject.archGroupId=0 AND rstUserObject.vtContainerId=0 AND rstUserObject.vtPolicyId=0 AND rstUserObject.vtShelfId=0 AND rstUserObject.reviewSetId=0 AND rstUserObject.querySetId=0 AND rstUserObject.downloadSetId=0 AND rstUserObject.ermId=0 AND rstUserObject.legalHoldId=0 AND rstUserObject.tagId=0 AND rstUserObject.cdPolicyId=0 AND rstUserObject.complianceReportId=0 AND rstUserObject.taskId=0 AND rstUserObject.workflowId=0 AND rstUserObject.logMonitoringPolicyId=0 AND rstUserObject.arrayId=0 AND rstUserObject.cloudId=0 AND rstUserObject.userGroupId=0 AND rstUserObject.providerId=0 AND rstUserObject.entityId1=0 AND rstUserObject.entityId2=0 AND rstUserObject.entityId3=0 AND rstUserObject.entityId4=0 AND rstUserObject.entityId5=0									AND rstUserObject.entityId6=0 AND rstUserObject.entityId7=0 AND rstUserObject.entityId8=0 AND rstUserObject.entityId9=0)
							   OR (rstUserObject.clientId=-10))
	SELECT @bkpJobs = count(*)
		   FROM JMBkpJobInfo JM WITH(READUNCOMMITTED)
		   INNER JOIN APP_Application A ON JM.applicationId = A.id
		   INNER JOIN JMJobInfo JI on JM.jobid = JI.jobId AND JM.commcellId = JI.commcellId
		   LEFT OUTER JOIN #SecIDANodeAccessTemp_Bkp secIDANode ON secIDANode.t_subclientId = JM.applicationId
		   WHERE  --dbo.isBkpJobVisible(@i_userId,commCellId,clientId,a.appTypeId,instance,backupSet, applicationId) = 1
		   JI.userId = @i_userId OR secIDANode.t_subclientId IS NOT NULL
	IF @isCSLevelAssociatedAdmin = 1
	BEGIN
		SELECT @adminJobs = count(*)
			FROM JMAdminJobInfoTable JM WITH(READUNCOMMITTED)
	END
	ELSE
	BEGIN
		SELECT @adminJobs = count(*)
			   FROM JMAdminJobInfoTable JM WITH(READUNCOMMITTED)
			   INNER JOIN JMJobInfo JI on JM.jobid = JI.jobId AND JM.commcellId = JI.commcellId
			   LEFT JOIN #getUsersInCompanyOutputTbl UIC ON UIC.userId = JI.userId
			   WHERE -- dbo.isAdminJobVisible(@i_userId, J.commCellId, J.archGrpID, J.jobId, J.opType,0) =1
			   JI.userId = @i_userId OR
			   UIC.userId IS NOT NULL OR
				EXISTS
				(
					SELECT 1 FROM #JMCanManageJob_adminObject userObject
					WHERE
						(JM.opType = 90 AND JM.workFlowID <> 0 AND userObject.workflowId = JM.workFlowID)
					OR
						(JM.opType IN (104,13) AND JM.archGrpId <> 0 AND userObject.archGroupId = JM.archGrpId)
					OR
						(JM.opType IN (21,32,41,42,46,47)  AND (libraryId =-10 OR userObject.libraryId IN (SELECT attributeValueInt FROM JMJobOptions jOption WITH(NOLOCK) WHERE jOption.jobId = JM.jobID AND jOption.commCellId = JM.commCellId AND jOption.attributeId = 10)))
				)
	END
	IF @isCSLevelAssociatedRst = 1
	BEGIN
		SELECT @restoreJobs = count(*)
		   FROM JMRstJobInfo JM WITH(READUNCOMMITTED)
		   WHERE ((@showSyncRestores = 1) OR ((rstattributes & 0x100 /*JMRST_SYNC_RESTORE*/) = 0))
	END
	ELSE
	BEGIN
		MERGE #JMCanManageJob_rstObject DST
		USING (SELECT dbo.BitWiseOR(SEC.capabilities) AS capabilities, CGA.clientId
			   FROM #JMCanManageJob_rstObject SEC
			   INNER JOIN App_ClientGroupAssoc CGA ON SEC.clientGroupId = CGA.clientGroupId
			   GROUP BY CGA.clientId ) SRC
		ON SRC.clientId = DST.clientId
		WHEN MATCHED THEN
			UPDATE SET DST.capabilities = DST.capabilities | SRC.capabilities
		WHEN NOT MATCHED THEN
			INSERT (capabilities, clientId)
            VALUES( SRC.capabilities, SRC.clientId);
		SELECT @restoreJobs = count(*)
		   FROM JMRstJobInfo JM WITH(READUNCOMMITTED)
		   INNER JOIN JMJobInfo JI on JM.jobid = JI.jobId AND JM.commcellId = JI.commcellId
		   WHERE --dbo.isRstJobVisible(@i_userId, J.commCellId, J.srcClientId, J.destClientId,  J.appType, J.instanceID, J.bkpSetID) =1
		   ((@showSyncRestores = 1) OR ((rstattributes & 0x100 /*JMRST_SYNC_RESTORE*/) = 0))
		   AND
		   (
		   JI.userId = @i_userId OR
		   EXISTS(
						SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK) WHERE
						-- if you have the rights on the destination at any level then you will see the restore job
						(rstUserObject.clientid=destClientID) OR
						(rstUserObject.clientid=srcClientID AND apptypeid=0) OR
						(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=0) OR
						(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=0) OR
						(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=bkpSetID AND rstUserObject.subclientid=0) --OR
						-- Not needed because we expand it above
						--((rstUserObject.clientgroupid <> 0 AND EXISTS (SELECT TOP 1 1 FROM APP_ClientGroupAssoc WITH(NOLOCK) WHERE (APP_ClientGroupAssoc.clientGroupId = rstUserObject.clientGroupId  OR rstUserObject.clientGroupId=-10) AND (APP_ClientGroupAssoc.clientid=srcClientID OR APP_ClientGroupAssoc.clientid=destClientID))))
						)
			)
	END
	SELECT ISNULL(@bkpJobs,0) + ISNULL(@adminJobs,0) + ISNULL(@restoreJobs, 0) as [Job Count]
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetRunningJobCount')
	delete from GxQscripts where name = 'JMGetRunningJobCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRunningJobCount')
	delete from GXDBVersions where aliasname = 'JMGetRunningJobCount'
GO

insert into GXDBVersions values(2, 'JMGetRunningJobCount',  '00010001000400060000', 'JMGetRunningJobCount', '00010001000400060000')
GO

