

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetRunningBackups.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetRunningBackups.sp,v $ $Id: JMGetRunningBackups.sp,v 1.1.2.11.16.1 2021/03/20 06:09:05 jragunathan Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 				Cursor: "JMGetRunningBackups"							|
--	|	Select from GetRunningBackups.view to return information about		|
--	|	running backups for Job Controller window.							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMGetRunningBackups')
BEGIN
	print '>>> Drop Stored Procedure: JMGetRunningBackups <<<'
	drop procedure JMGetRunningBackups
END
IF EXISTS (select * from GxQscripts where name='JMGetRunningBackups')
	delete from GxQscripts where name = 'JMGetRunningBackups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRunningBackups')
	delete from GXDBVersions where aliasname = 'JMGetRunningBackups'
GO
print '... Creating Procedure: JMGetRunningBackups'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMGetRunningBackups
  @i_userId INT,
  @i_whereClause VARCHAR(512)
--	The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
--************************************************************************
--	NEW ITEMS MAY ONLY BE ADDED AT THE END OF THE :DECLARE LIST!!!!!!!!!!!!!!
--	This is because some code (myIndicator) uses a hardcoded index # into
--	this list for certain items, so if an item is inserted before them,
--	the index # will reference the wrong item and we will get the wrong
--	data to send to the GUI!
--************************************************************************
AS
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET FORCEPLAN ON
	DECLARE @nTryCount	INT = 0
	DECLARE @exception	INT = 0
	DECLARE @tranCnt INT = @@TRANCOUNT
	IF (@tranCnt > 0)
	BEGIN
		-- only try once since transaction is trashed by exception
		SET @nTryCount = 3
	END
	IF OBJECT_ID('tempdb.dbo.#tmpRunningBackups') IS NOT NULL DROP TABLE #tmpRunningBackups
	CREATE TABLE #tmpRunningBackups (
		isVisible				integer
		,jobID					integer
		,opType					integer
		,userId					integer
		,commCellId				integer
		,clientId				integer
		,appTypeId				integer
		,instance				integer
		,backupSet				integer
		,applicationId			integer
		,bkpLevel				integer
		,secondaryBkpLevel		integer
		,jobIdActedOn			integer
		,fromTime				integer
		,toTime					integer
		,state					integer
		,displayState			integer
		,clientPriority			integer
		,opPriority				integer
		,appPriority				integer
		,combPriority			integer
		,currentPhase			integer
		,jobStartTime			integer
		,attemptStartTime		integer
		,elapsedTime				integer
		,jobElapsedTime			integer
		,startAttempts			integer
		,runAttempts				integer
		,initFrom				integer
		,pendingCause			integer
		,errorType				integer
		,guiAlertColorLevel		integer
		,numStreams				integer
		,numStreamsAllocated		integer
		,maxRestarts				integer
		,restartInterval			integer
		,currentPolicy			integer
		,filesToXfer				bigint
		,filesXfered				bigint
		,uncompBytes				bigint
		,compBytes				bigint
		,unCompBytesToXfer		bigint
		,isPreemptable			integer
		,percentcomplete			integer
		,bkpOptions				integer
		,bkpattributes			bigint
		,scanType				integer
		,scanFileFailures		integer
		,scanFolderFailures		integer
		,backupFileFailures		integer
		,backupFolderFailures	integer
		,oraSubLevel				integer
		,lastUpdateFromClient	integer
		,lastStateChangeTime		bigint
		,noOfGUIMonitors			integer
		,isScheduledAlert		integer
		,jobBasedAlertId			integer
		,totalMediaUsageTime		bigint
		,currentThroughput		float
		,averageThroughput		float
		,filesIndexed			bigint
		,filesFailedToIndex		bigint
		,filesSkippedForIndex	bigint
		,contentIndexDBSize		bigint
		,timeToComplete			integer
		,backupTaskId			integer
		,cloudId					integer
		,retentionFlags			integer
		,snapJobID				integer
		,snapWFJobID				integer
		,currentContext			integer
		,nwTransBytes			bigint
		,totSkippedObjects		bigint
		,bkpAttributesEx			bigint
		,jobReferenceTime		integer
		,sidbStoreId				integer
		,taskId					integer
		,targetClientId			integer
		,totReadBytes			bigint
		,totReadTime			bigint
		,totPhysicalWriteBytes	bigint
		,totPhysicalWriteTime	bigint
		,totNwTransTime			bigint
		,totSidbLookups			bigint
		,totSidbLookupTime		bigint
		,readCurrentThroughput	float
		,readAverageThroughput	float
		,writeCurrentThroughput	float
		,writeAverageThroughput	float
		,networkCurrentThroughput	float
		,networkAverageThroughput	float
		,sidbCurrentLookups	float
		,sidbAverageLookups	float
		,parentJobId integer
        ,currentPhaseType bigint
		,subTaskName nvarchar(256)
		,taskName nvarchar(256)
		,sidbStoreName nvarchar(256)
		,currentPolicyName  varchar(144)
		,UserName   varchar(255)
		,alertName  nvarchar(256)
		,clientName nvarchar(510)
		,appTypeName    varchar(255)
		,instanceName   nvarchar(1024)
		,backupSetName  nvarchar(256)
		,subclientName  nvarchar(256)
		,libraryList    nvarchar(max)
		,driveList  nvarchar(max)
		,failureReason  varchar(256)
		,DelayReason    nvarchar(2048)
		,scanTypeChangeReasonId varchar(24)
		,scanTypeChangeReason   nvarchar(2048)
		,currentPhaseName		varchar(max)
		,mediaAgentName			varchar(max)
		,shortMediaAgent		varchar(max)
		,activeFile			nvarchar(max)
		,cloudName  nvarchar(255)
		,foreignToken   nvarchar(2048)
		,failureKBArticle		nvarchar(max)
		,jobDescription			nvarchar(max)
		,xmlJobInfo			nvarchar(max)
		,encrypted nvarchar(256)
		,clientDisplayName  nvarchar(510)
		,phasePercentagesList  nvarchar(512)
		,phaseTimingsList  nvarchar(512)
	)
DO_QUERY:
	BEGIN TRY
		SET @exception = 0
		DECLARE @sqlQuery NVARCHAR(MAX) = N' DECLARE @in_userId INT = '
		SET @sqlQuery =  @sqlQuery + CAST(@i_userId AS NVARCHAR(10))
		SET @sqlQuery = @sqlQuery + N'
			INSERT INTO #tmpRunningBackups
				(isVisible,jobID,opType,userId,commCellId,clientId,appTypeId,instance,backupSet,applicationId,bkpLevel,secondaryBkpLevel,jobIdActedOn,fromTime,toTime,state,displayState,
				clientPriority,opPriority,appPriority,combPriority,currentPhase,jobStartTime,attemptStartTime,elapsedTime,jobElapsedTime,startAttempts,runAttempts,initFrom,pendingCause,errorType,
				guiAlertColorLevel,numStreams,numStreamsAllocated,maxRestarts,restartInterval,currentPolicy,filesToXfer,filesXfered,uncompBytes,compBytes,unCompBytesToXfer,isPreemptable,percentcomplete,
				bkpOptions,bkpattributes,scanType,scanFileFailures,scanFolderFailures,backupFileFailures,backupFolderFailures,oraSubLevel,lastUpdateFromClient,lastStateChangeTime,noOfGUIMonitors,
				isScheduledAlert,jobBasedAlertId,totalMediaUsageTime,currentThroughput,averageThroughput,filesIndexed,filesFailedToIndex,filesSkippedForIndex,contentIndexDBSize,timeToComplete,backupTaskId,
				cloudId,retentionFlags,snapJobID,snapWFJobID,currentContext,nwTransBytes,totSkippedObjects,bkpAttributesEx,jobReferenceTime,sidbStoreId,taskId,targetClientId,subTaskName,taskName,sidbStoreName,
				currentPolicyName,UserName,alertName,clientName,appTypeName,instanceName,backupSetName,subclientName,libraryList,driveList,failureReason,DelayReason,scanTypeChangeReasonId,ScanTypeChangeReason,
				currentPhaseName,mediaAgentName,shortMediaAgent,activeFile,cloudName,foreignToken,failureKBArticle,jobDescription,xmlJobInfo,encrypted,clientDisplayName,phasePercentagesList,phaseTimingsList,
				totReadBytes,totReadTime,totPhysicalWriteBytes,totPhysicalWriteTime,totNwTransTime,totSidbLookups,totSidbLookupTime,readCurrentThroughput,readAverageThroughput,writeCurrentThroughput,writeAverageThroughput,
				networkCurrentThroughput,networkAverageThroughput,sidbCurrentLookups,sidbAverageLookups,parentJobId,currentPhaseType)
			SELECT CASE WHEN @in_userId = 0 OR @in_userId = userId
				THEN 1
				ELSE dbo.isBkpJobVisible(@in_userId, commCellId, clientId, appTypeId, instance, backupSet, applicationId)
				END	AS isVisible,jobID,opType,userId,commCellId,clientId,appTypeId,instance,backupSet,applicationId,bkpLevel,secondaryBkpLevel,jobIdActedOn,fromTime,toTime,state,displayState,
				clientPriority,opPriority,appPriority,combPriority,currentPhase,jobStartTime,attemptStartTime,elapsedTime,jobElapsedTime,startAttempts,runAttempts,initFrom,pendingCause,errorType,
				guiAlertColorLevel,numStreams,numStreamsAllocated,maxRestarts,restartInterval,currentPolicy,filesToXfer,filesXfered,uncompBytes,compBytes,unCompBytesToXfer,isPreemptable,percentcomplete,
				bkpOptions,bkpattributes,scanType,scanFileFailures,scanFolderFailures,backupFileFailures,backupFolderFailures,oraSubLevel,lastUpdateFromClient,lastStateChangeTime,noOfGUIMonitors,
				isScheduledAlert,jobBasedAlertId,totalMediaUsageTime,currentThroughput,averageThroughput,filesIndexed,filesFailedToIndex,filesSkippedForIndex,contentIndexDBSize,timeToComplete,backupTaskId,
				cloudId,retentionFlags,snapJobID,snapWFJobID,currentContext,nwTransBytes,totSkippedObjects,bkpAttributesEx,jobReferenceTime,sidbStoreId,taskId,targetClientId,subTaskName,taskName,sidbStoreName,
				currentPolicyName,UserName,alertName,clientName,appTypeName,instanceName,backupSetName,subclientName,libraryList,driveList,failureReason,DelayReason,scanTypeChangeReasonId,ScanTypeChangeReason,
				currentPhaseName,mediaAgentName,shortMediaAgent,activeFile,cloudName,foreignToken,failureKBArticle,jobDescription,xmlJobInfo,encrypted,clientDisplayName,phasePercentagesList,phaseTimingsList,
				totReadBytes,totReadTime,totPhysicalWriteBytes,totPhysicalWriteTime,totNwTransTime,totSidbLookups,totSidbLookupTime,readCurrentThroughput,readAverageThroughput,writeCurrentThroughput,writeAverageThroughput,
				networkCurrentThroughput,networkAverageThroughput,sidbCurrentLookups,sidbAverageLookups,parentJobId,currentPhaseType
			FROM RunningBackups WHERE '
		SET @sqlQuery = @sqlQuery + @i_whereClause
		EXECUTE SP_EXECUTESQL @statement = @sqlQuery
	END TRY
	BEGIN CATCH
		DECLARE @errCode INT = ERROR_NUMBER()
		DECLARE @ErrorMessage NVARCHAR(4000) = ERROR_MESSAGE()
		DECLARE @ErrorSeverity INT = ERROR_SEVERITY()
		DECLARE @ErrorState INT = ERROR_STATE();
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		IF @nTryCount < 3 AND (@errCode = 7886 OR @errCode = 601)
		BEGIN
			SET @nTryCount = @nTryCount + 1
			SET @exception = 1
			TRUNCATE TABLE #tmpRunningBackups
		END
		ELSE
		BEGIN
		    RAISERROR (@ErrorMessage, -- Message text.
	               @ErrorSeverity, -- Severity.
        	       @ErrorState -- State.
	               );
		END
	END CATCH
	IF @exception = 1
		GOTO DO_QUERY
	SELECT isVisible,jobID,opType,userId,commCellId,clientId,appTypeId,instance,backupSet,applicationId,bkpLevel,secondaryBkpLevel,jobIdActedOn,fromTime,toTime,state,displayState,
			clientPriority,opPriority,appPriority,combPriority,currentPhase,jobStartTime,attemptStartTime,elapsedTime,jobElapsedTime,startAttempts,runAttempts,initFrom,pendingCause,errorType,
			guiAlertColorLevel,numStreams,numStreamsAllocated,maxRestarts,restartInterval,currentPolicy,filesToXfer,filesXfered,uncompBytes,compBytes,unCompBytesToXfer,isPreemptable,percentcomplete,
			bkpOptions,bkpattributes,scanType,scanFileFailures,scanFolderFailures,backupFileFailures,backupFolderFailures,oraSubLevel,lastUpdateFromClient,lastStateChangeTime,noOfGUIMonitors,
			isScheduledAlert,jobBasedAlertId,totalMediaUsageTime,currentThroughput,averageThroughput,filesIndexed,filesFailedToIndex,filesSkippedForIndex,contentIndexDBSize,timeToComplete,backupTaskId,
			cloudId,retentionFlags,snapJobID,snapWFJobID,currentContext,nwTransBytes,totSkippedObjects,bkpAttributesEx,jobReferenceTime,sidbStoreId,taskId,targetClientId,totReadBytes,totReadTime,totPhysicalWriteBytes,
			totPhysicalWriteTime,totNwTransTime,totSidbLookups,totSidbLookupTime,readCurrentThroughput,readAverageThroughput,writeCurrentThroughput,writeAverageThroughput,networkCurrentThroughput,
			networkAverageThroughput,sidbCurrentLookups,sidbAverageLookups,parentJobId,currentPhaseType,subTaskName,taskName,sidbStoreName,currentPolicyName,UserName,alertName,clientName,appTypeName,instanceName,backupSetName,subclientName,
			libraryList,driveList,failureReason,DelayReason,scanTypeChangeReasonId,ScanTypeChangeReason,currentPhaseName,mediaAgentName,shortMediaAgent,activeFile,cloudName,foreignToken,failureKBArticle,jobDescription,
			xmlJobInfo,encrypted,clientDisplayName,phasePercentagesList,phaseTimingsList
	FROM #tmpRunningBackups
	IF OBJECT_ID('tempdb.dbo.#tmpRunningBackups') IS NOT NULL DROP TABLE #tmpRunningBackups
	SET FORCEPLAN OFF
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetRunningBackups')
	delete from GxQscripts where name = 'JMGetRunningBackups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRunningBackups')
	delete from GXDBVersions where aliasname = 'JMGetRunningBackups'
GO

insert into GXDBVersions values(2, 'JMGetRunningBackups',  'v1.1.2.11.16.1', 'JMGetRunningBackups', 'v1.1.2.11.16.1')
GO

