

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetRunningAdmins.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetRunningAdmins.sp,v $ $Id: JMGetRunningAdmins.sp,v 1.1.2.2 2020/01/07 06:15:26 sbonilla Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 				Cursor: "JMGetRunningAdmins"							|
--	|	Select from GetRunningBackups.view to return information about		|
--	|	running backups for Job Controller window.							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetRunningAdmins')
BEGIN
	print '>>> Drop Stored Procedure: JMGetRunningAdmins <<<'
	drop procedure JMGetRunningAdmins
END
IF EXISTS (select * from GxQscripts where name='JMGetRunningAdmins')
	delete from GxQscripts where name = 'JMGetRunningAdmins'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRunningAdmins')
	delete from GXDBVersions where aliasname = 'JMGetRunningAdmins'
GO
print '... Creating Procedure: JMGetRunningAdmins'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetRunningAdmins
  @i_userId INT,
  @i_whereClause VARCHAR(512)
--	The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
--************************************************************************
--	NEW ITEMS MAY ONLY BE ADDED AT THE END OF THE :DECLARE LIST!!!!!!!!!!!!!!
--	This is because some code (myIndicator) uses a hardcoded index # into
--	this list for certain items, so if an item is inserted before them,
--	the index # will reference the wrong item and we will get the wrong
--	data to send to the GUI!
--************************************************************************
AS
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET FORCEPLAN ON
	DECLARE @nTryCount	INT = 0
	DECLARE @exception	INT = 0
	DECLARE @tranCnt INT = @@TRANCOUNT
	IF (@tranCnt > 0)
	BEGIN
               -- only try once since transaction is trashed by exception
	   SET @nTryCount = 3
	END
	IF OBJECT_ID('tempdb.dbo.#tmpRunningAdmins') IS NOT NULL DROP TABLE #tmpRunningAdmins
	CREATE TABLE #tmpRunningAdmins (
		isVisible				integer
		,jobID					integer
		,opType					integer
		,userId					integer
		,commCellId				integer
		,clientId				integer
		,appType					integer
		,instance				integer
		,backupset				integer
		,appId					integer
		,archGrpID				integer
		,archGrpCopyID			integer
		,state					integer
		,displayState			integer
		,clientPriority			integer
		,opPriority				integer
		,appPriority				integer
		,combPriority			integer
		,currentPhase			integer
		,jobStartTime			integer
		,attemptStartTime		integer
		,elapsedTime				integer
		,jobElapsedTime			integer
		,startAttempts			integer
		,runAttempts				integer
		,initFrom				integer
		,pendingCause			integer
		,errorType				integer
		,guiAlertColorLevel		integer
		,isPreemptable			integer
		,percentcomplete			integer
		,timeToComplete			integer
		,lastUpdateFromClient	integer
		,lastStateChangeTime		bigint
		,noOfGUIMonitors			integer
		,isScheduledAlert		integer
		,jobBasedAlertId			integer
		,AP_NumDays				integer
		,AP_IsForecast			integer
		,AP_SeqNum				integer
		,ER_BkpLevel				integer
		,ER_SendCount			integer
		,TotalObjects			bigint
		,ObjectsDone				bigint
		,ObjectsFailed			bigint
		,TotalSize			bigint
		,LibraryID				integer
		,MI_InventoryType		integer
		,currentWriteTime		integer
		,noOfStreams				integer
		,noOfStreamsAllocated		integer
		,maxRestarts			integer
		,restartInterval			integer
		,embeddedObjects	bigint
		,uncompBytes	bigint
		,nwTransBytes	bigint
		,numFiles				bigint
		,skippedItems	bigint
		,writeTime	integer
		,drivePoolId				integer
		,mediaId					integer
		,sourceJobId				bigint
		,reportType				integer
		,reportSetId				integer
		,cloudId					integer
		,fromTime				integer
		,toTime					integer
		,subTaskId				integer
		,currentThroughput		float
		,averageThroughput		float
		,taskId					integer
		,dataSourceId			integer
		,subTaskName				NVARCHAR(256)
		,taskName				NVARCHAR(256)
		,storagePolicyName		NVARCHAR(144)
		,CopyName				NVARCHAR(64)
		,LibraryName				NVARCHAR(128)
		,DrivePoolName			NVARCHAR(64)
		,UserName				varchar(max)
		,alertName				nvarchar(max)
		,libraryList				nvarchar(max)
		,driveList				nvarchar(max)
		,clientName 				nvarchar(max)
		,appTypeName 			varchar(max)
		,instanceName 			nvarchar(max)
		,backupSetName 			nvarchar(max)
		,subclientName 			nvarchar(max)
		,MediaName				varchar(max)
		,MediaUniqueId			varchar(max)
		,ER_DbName				nvarchar(max)
		,ER_Destination			nvarchar(max)
		,ER_MediasUsed			nvarchar(max)
		,failureReason			varchar(max)
		,DelayReason				nvarchar(max)
		,currentPhaseName		varchar(max)
		,srcMediaAgent			varchar(max)
		,destMediaAgent			varchar(max)
		,shortMediaAgent			varchar(max)
		,cloudName				nvarchar(max)
		,foreignToken			nvarchar(max)
		,failureKBArticle		nvarchar(max)
		,reportName				varchar(max)
		,reportSetName			varchar(max)
		,jobDescription			nvarchar(max)
		,xmlJobInfo				nvarchar(max)
		,activeFile				NVARCHAR(max)
		,workflowName			nvarchar(max)
		,currentActivityMsg		varchar(max)
		,clientDisplayName       nvarchar(max)
		,dataSourceName			nvarchar(1024)
	)
DO_QUERY:
	BEGIN TRY
	SET @exception = 0
	DECLARE @sqlQuery NVARCHAR(MAX) = N'
	DECLARE @in_userId INT = ' + CAST(@i_userId AS NVARCHAR(10)) + N'
		INSERT INTO #tmpRunningAdmins
		(isVisible,jobID,opType,userId,commCellId,clientId,appType,instance,backupset,appId,archGrpID,archGrpCopyID,state,displayState,clientPriority,opPriority,appPriority,combPriority
		,currentPhase,jobStartTime,attemptStartTime,elapsedTime,jobElapsedTime,startAttempts,runAttempts,initFrom,pendingCause,errorType,guiAlertColorLevel,isPreemptable,percentcomplete
		,timeToComplete,lastUpdateFromClient,lastStateChangeTime,noOfGUIMonitors,isScheduledAlert,jobBasedAlertId,AP_NumDays,AP_IsForecast,AP_SeqNum,ER_BkpLevel,ER_SendCount,TotalObjects
		,ObjectsDone,ObjectsFailed,TotalSize,LibraryID,MI_InventoryType,currentWriteTime,noOfStreams,noOfStreamsAllocated,maxRestarts,restartInterval,embeddedObjects,uncompBytes,nwTransBytes
		,numFiles,skippedItems,writeTime,drivePoolId,mediaId,sourceJobId,reportType,reportSetId,cloudId,fromTime,toTime,subTaskId,currentThroughput,averageThroughput,taskId,dataSourceId
		,subTaskName,taskName,storagePolicyName,CopyName,LibraryName,DrivePoolName,UserName,alertName,libraryList,driveList,clientName,appTypeName,instanceName,backupSetName,subclientName
		,MediaName,MediaUniqueId,ER_DbName,ER_Destination, ER_MediasUsed,failureReason,DelayReason,currentPhaseName,srcMediaAgent,destMediaAgent,shortMediaAgent,cloudName,foreignToken,failureKBArticle
		,reportName,reportSetName,jobDescription,xmlJobInfo,activeFile,workflowName,currentActivityMsg,clientDisplayName,dataSourceName
		)
		SELECT CASE WHEN @in_userId = 0 OR @in_userId = userId
			THEN 1
			ELSE dbo.isAdminJobVisible(@in_userId,commCellId,archGrpID,jobID,opType,
				CASE WHEN opType IN (35,67,68) THEN clientId ELSE 0 END) -- Install jobs
			END	AS isVisible,jobID,opType,userId,commCellId,clientId,appType,instance,backupset,appId,archGrpID,archGrpCopyID,state,displayState,clientPriority,opPriority,appPriority,combPriority
		,currentPhase,jobStartTime,attemptStartTime,elapsedTime,jobElapsedTime,startAttempts,runAttempts,initFrom,pendingCause,errorType,guiAlertColorLevel,isPreemptable,percentcomplete
		,timeToComplete,lastUpdateFromClient,lastStateChangeTime,noOfGUIMonitors,isScheduledAlert,jobBasedAlertId,AP_NumDays,AP_IsForecast,AP_SeqNum,ER_BkpLevel,ER_SendCount,TotalObjects
		,ObjectsDone,ObjectsFailed,TotalSize,LibraryID,MI_InventoryType,currentWriteTime,noOfStreams,noOfStreamsAllocated,maxRestarts,restartInterval,embeddedObjects,uncompBytes,nwTransBytes
		,numFiles,skippedItems,writeTime,drivePoolId,mediaId,sourceJobId,reportType,reportSetId,cloudId,fromTime,toTime,subTaskId,currentThroughput,averageThroughput,taskId,dataSourceId
		,subTaskName,taskName,storagePolicyName,CopyName,LibraryName,DrivePoolName,UserName,alertName,libraryList,driveList,clientName,appTypeName,instanceName,backupSetName,subclientName
		,MediaName,MediaUniqueId,ER_DbName,ER_Destination, ER_MediasUsed,failureReason,DelayReason,currentPhaseName,srcMediaAgent,destMediaAgent,shortMediaAgent,cloudName,foreignToken,failureKBArticle
		,reportName,reportSetName,jobDescription,xmlJobInfo,activeFile,workflowName,currentActivityMsg,clientDisplayName,dataSourceName
		FROM RunningAdminJobs WHERE '+ @i_whereClause
		EXECUTE SP_EXECUTESQL @statement = @sqlQuery
	END TRY
	BEGIN CATCH
		DECLARE @errCode INT = ERROR_NUMBER()
		DECLARE @ErrorMessage NVARCHAR(4000) = ERROR_MESSAGE()
		DECLARE @ErrorSeverity INT = ERROR_SEVERITY()
		DECLARE @ErrorState INT = ERROR_STATE();
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		IF @nTryCount < 3 AND @errCode = 7886
		BEGIN
			SET @nTryCount = @nTryCount + 1
			SET @exception = 1
			TRUNCATE TABLE #tmpRunningAdmins
		END
		ELSE
		BEGIN
		    RAISERROR (@ErrorMessage, -- Message text.
	               @ErrorSeverity, -- Severity.
        	       @ErrorState -- State.
	               );
		END
	END CATCH
	IF @exception = 1
		GOTO DO_QUERY
	SELECT isVisible,jobID,opType,userId,commCellId,clientId,appType,instance,backupset,appId,archGrpID,archGrpCopyID,state,displayState,clientPriority,opPriority,appPriority,combPriority
		,currentPhase,jobStartTime,attemptStartTime,elapsedTime,jobElapsedTime,startAttempts,runAttempts,initFrom,pendingCause,errorType,guiAlertColorLevel,isPreemptable,percentcomplete
		,timeToComplete,lastUpdateFromClient,lastStateChangeTime,noOfGUIMonitors,isScheduledAlert,jobBasedAlertId,AP_NumDays,AP_IsForecast,AP_SeqNum,ER_BkpLevel,ER_SendCount,TotalObjects
		,ObjectsDone,ObjectsFailed,TotalSize,LibraryID,MI_InventoryType,currentWriteTime,noOfStreams,noOfStreamsAllocated,maxRestarts,restartInterval,embeddedObjects,uncompBytes,nwTransBytes
		,numFiles,skippedItems,writeTime,drivePoolId,mediaId,sourceJobId,reportType,reportSetId,cloudId,fromTime,toTime,subTaskId,currentThroughput,averageThroughput,taskId,dataSourceId
		,subTaskName,taskName,storagePolicyName,CopyName,LibraryName,DrivePoolName,UserName,alertName,libraryList,driveList,clientName,appTypeName,instanceName,backupSetName,subclientName
		,MediaName,MediaUniqueId,ER_DbName,ER_Destination, ER_MediasUsed,failureReason,DelayReason,currentPhaseName,srcMediaAgent,destMediaAgent,shortMediaAgent,cloudName,foreignToken,failureKBArticle
		,reportName,reportSetName,jobDescription,xmlJobInfo,activeFile,workflowName,currentActivityMsg,clientDisplayName,dataSourceName
	FROM #tmpRunningAdmins
	IF OBJECT_ID('tempdb.dbo.#tmpRunningAdmins') IS NOT NULL DROP TABLE #tmpRunningAdmins
	SET FORCEPLAN OFF
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetRunningAdmins')
	delete from GxQscripts where name = 'JMGetRunningAdmins'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRunningAdmins')
	delete from GXDBVersions where aliasname = 'JMGetRunningAdmins'
GO

insert into GXDBVersions values(2, 'JMGetRunningAdmins',  '00010001000200020000', 'JMGetRunningAdmins', '00010001000200020000')
GO

