

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetRstStats.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetRstStats.sp,v $ $Id: JMGetRstStats.sp,v 1.1.2.8 2020/09/28 21:33:03 sbonilla Exp $";
--
--  +========================================================================+
--  |      Cursor:  JMGetRstStats()
--  |
--  | Description:  Retrieves the Restore Statistics from the database
--  |
--  |      Input:   ???
--  |
--  |      Output:  Returns rows that match input criteria
--  |
--  |      Notes:
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        madeira 	Initial release
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetRstStats')
BEGIN
	print '>>> Drop Stored Procedure: JMGetRstStats <<<'
	drop procedure JMGetRstStats
END
IF EXISTS (select * from GxQscripts where name='JMGetRstStats')
	delete from GxQscripts where name = 'JMGetRstStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRstStats')
	delete from GXDBVersions where aliasname = 'JMGetRstStats'
GO
print '... Creating Procedure: JMGetRstStats'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetRstStats
  @userId integer,
  @localeId integer,
  @topClause char(32),
  @whereClause char(512)
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- .. :PARAM input lines
--			FETCH ALL THE ALERT ACTION ROWS FOR WHICH THERE IS A USER ASSOCIATION
AS
SET NOCOUNT ON
BEGIN
	DECLARE @userName nvarchar(255)
	IF @userId = 0
	BEGIN
		SET @userName = ''
	END
	ELSE
	BEGIN
		SET @userName = ISNULL((SELECT [login] FROM UMUsers WHERE id = @userId),'')
	END
--			--------------------------------------------------------------------------
	--sp_executesql HAS LIMIT OF 4000 CHARACTERS
	DECLARE @sqlQuery NVARCHAR(MAX) = N'
	DECLARE @in_userId INT = ' + CAST(@userId AS NVARCHAR(10)) + N'
	SELECT ' +  @topClause + N' jobID = JR.jobId,
JR.commCellId, commcellName =  CC.aliasName,
CASE WHEN JS.subOpType > 0 THEN JS.subOpType ELSE JS.opType END,
srcClientID, srcClientName=SRC.name,
srcClientDisplayName=SRC.displayName,
destClientID, destClientName=DST.name,
destClientDisplayName=DST.displayName,
dataSrcClientID,dataSrcClientName=DAT.name,
dataSrcClientDisplayName=DAT.displayName,
appType, appTypeName=IDA.name,
bkpSetID, bkpSetName=BS.name,
instanceID, instanceName=I.name,
JR.status,duration,servStartTime,servEndTime,
totUncompBytes=isnull(convert(bigint,totUncompBytes_h)*2147483648 + convert(bigint,totUncompBytes_l),0),
totCompBytes=isnull(convert(bigint,totCompBytes_h)*2147483648 + convert(bigint,totCompBytes_l),0),
totFiles2Xfer=isnull(convert(bigint,totFiles2Xfer_h)*2147483648 + convert(bigint,totFiles2Xfer_l),0),
totSuccess=isnull(convert(bigint,totSuccess_h)*2147483648 + convert(bigint,totSuccess_l),0),
totFailed,totSkipped,restoreOptions,initFrom,JR.version,
JR.subTaskId,rstattributes,failureErrorCode,
taskId = (ISNULL(TASK.taskId,0)),
readAverageThroughput,writeAverageThroughput,networkAverageThroughput,sidbAverageLookups,
subTaskName = (ISNULL(STASK.subTaskName,'''')),
taskName = (ISNULL(TASK.taskName,'''')),
dbo.JMGetLocalizedMessageFunc(' + CAST(@localeId AS NVARCHAR(4)) + ',failureReason),
JR.username,
CASE JR.opType
 WHEN 29 THEN ISNULL((SELECT TOP 1 attributeValue FROM JMJobOptions WHERE JMJobOptions.jobId = JR.jobId AND attributeName = ''Destination Path''),'''')
 ELSE ''''
END,
JS.foreignToken,
dbo.JMGetKBArticlesForFailures(failureReason, 0) AS [failureKBArticle],
JS.jobDescription,JS.xmlJobInfo,
timeThroughPut=TJO.attributeValue,
destInstanceId, destInstanceName=DI.name
FROM JMRestoreStats AS JR
JOIN APP_CommCell CC (NOLOCK) ON CC.id=JR.commCellId
JOIN JMJobStats JS (NOLOCK) ON JS.jobid=JR.jobId and JS.commcellId=JR.commCellId
LEFT OUTER JOIN TM_SubTask STASK (NOLOCK) ON JR.subTaskId = STASK.subTaskId
LEFT OUTER JOIN TM_Task TASK WITH(NOLOCK) ON STASK.taskId = TASK.taskId
LEFT OUTER JOIN APP_Client SRC (NOLOCK) ON SRC.id=JR.srcClientId
LEFT OUTER JOIN APP_Client DST (NOLOCK) ON DST.id=JR.destClientId
LEFT OUTER JOIN APP_Client DAT (NOLOCK) ON DAT.id=JR.dataSrcClientId
LEFT OUTER JOIN APP_iDAType IDA (NOLOCK) ON IDA.type = JR.appType
LEFT OUTER JOIN APP_BackupSetName BS (NOLOCK) ON BS.id = JR.bkpSetID
LEFT OUTER JOIN APP_InstanceName I (NOLOCK) ON I.id = JR.instanceID
LEFT OUTER JOIN APP_InstanceName DI (NOLOCK) ON DI.id = JR.destInstanceId
LEFT OUTER JOIN JMJobOptions TJO WITH(NOLOCK) ON JR.jobId=TJO.jobId AND JR.commCellId=TJO.commCellId AND TJO.attributeId=91
WHERE ' + LTRIM(RTRIM(@whereClause)) + N' AND (@in_userId=0 OR JR.username=''' + @userName + ''' OR dbo.isRstJobVisible(@in_userId, JR.commCellId,srcClientID,destClientID,appType,instanceID,bkpSetID) = 1)
  AND NOT Exists(select 1 from JMPreparedJob where JMPreparedJob.jobId=JR.jobId and JMPreparedJob.commCellId=JR.commCellId and JMPreparedJob.status=3)
  AND (JS.opType <> 29 /*QUICKDMRST*/ OR ISNULL((SELECT CAST(value AS INT) FROM GXGlobalParam WITH (NOLOCK) WHERE name = N''showPersistentRecoveryJobs''), 0) = 1) --Hide persistent restore jobs from UI
ORDER BY servStartTime DESC'
	 SET @sqlQuery = LTRIM(RTRIM(@sqlQuery))
	 EXECUTE sp_executesql @sqlQuery
-- Tell the AWK processor that there are no more input lines to scan
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetRstStats')
	delete from GxQscripts where name = 'JMGetRstStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRstStats')
	delete from GXDBVersions where aliasname = 'JMGetRstStats'
GO

insert into GXDBVersions values(2, 'JMGetRstStats',  '00010001000200080000', 'JMGetRstStats', '00010001000200080000')
GO

