

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetRstAtmptStats.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetRstAtmptStats.sp,v $ $Id: JMGetRstAtmptStats.sp,v 1.1.2.1 2020/01/08 20:47:24 sbonilla Exp $";
--
--  +========================================================================+
--  |      Cursor:  JMGetRstAtmptStats()
--  |
--  | Description:  Retrieves the Restore Attempt Statistics from the database
--  |
--  |      Input:   ???
--  |
--  |      Output:  Returns rows that match input criteria
--  |
--  |      Notes:
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        madeira 	Initial release
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetRstAtmptStats')
BEGIN
	print '>>> Drop Stored Procedure: JMGetRstAtmptStats <<<'
	drop procedure JMGetRstAtmptStats
END
IF EXISTS (select * from GxQscripts where name='JMGetRstAtmptStats')
	delete from GxQscripts where name = 'JMGetRstAtmptStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRstAtmptStats')
	delete from GXDBVersions where aliasname = 'JMGetRstAtmptStats'
GO
print '... Creating Procedure: JMGetRstAtmptStats'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetRstAtmptStats
  @localeId integer,
  @jobID integer
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
AS
SET NOCOUNT ON
BEGIN
	DECLARE @appType integer
	DECLARE @opType integer
	SET @appType = (select appType from JMRestoreStats where jobId = @jobID)
	SET @opType = (select opType from JMRestoreStats where jobId = @jobID)
	SELECT	attemptNum,
		appType = @appType,
		opType = @opType,
		JMRestoreAtmptStats.phase,
		phaseName = JMPhase.name,
		JMRestoreAtmptStats.status,
		elapsedTime,
		servStart,
		servEnd,
		uncompBytes = isnull(convert(bigint,uncompbytes_h)*2147483648+convert(bigint,uncompbytes_l),0),
		compBytes = isnull(convert(bigint,compbytes_h)*2147483648+convert(bigint,compbytes_l),0),
		numSuccess = isnull(convert(bigint,numSuccess_h)*2147483648+convert(bigint,numSuccess_l),0),
		numSkipped,
		numFailures = isnull(convert(bigint,numFailures_h)*2147483648+convert(bigint,numFailures_l),0),
		readThroughput = readThroughput,
		writeThroughput = writeThroughput,
		networkThroughput = networkThroughput,
		sidbLookups = sidbLookups,
		dbo.JMGetLocalizedMessageFunc(@localeId, JMRestoreAtmptStats.failureReason),
		dbo.JMGetKBArticlesForFailures(JMRestoreAtmptStats.failureReason, 0) AS [failureKBArticle]
	FROM JMRestoreAtmptStats
	JOIN JMRestoreStats (NOLOCK) ON JMRestoreStats.jobId = @jobID AND JMRestoreAtmptStats.commCellId = JMRestoreStats.commCellId
	JOIN JMPhase (NOLOCK) ON JMPhase.phase = JMRestoreAtmptStats.phase
	JOIN JMOpTable (NOLOCK) ON JMOpTable.operation = @opType AND JMOpTable.id = JMPhase.opTableId AND JMOpTable.appTypeType = JMRestoreStats.appType
	WHERE JMRestoreAtmptStats.jobId = @jobID and
		JMRestoreAtmptStats.status <> 8
	ORDER BY servStart ASC
-- Tell the AWK processor that there are no more input lines to scan
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetRstAtmptStats')
	delete from GxQscripts where name = 'JMGetRstAtmptStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRstAtmptStats')
	delete from GXDBVersions where aliasname = 'JMGetRstAtmptStats'
GO

insert into GXDBVersions values(2, 'JMGetRstAtmptStats',  '00010001000200010000', 'JMGetRstAtmptStats', '00010001000200010000')
GO

