

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetRestoreSummaryCounts.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetRestoreSummaryCounts.sp,v $ $Id: JMGetRestoreSummaryCounts.sp,v 1.1.4.6 2020/09/28 21:33:10 sbonilla Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "JMGetRestoreSummaryCounts"
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetRestoreSummaryCounts')
BEGIN
	print '>>> Drop Stored Procedure: JMGetRestoreSummaryCounts <<<'
	drop procedure JMGetRestoreSummaryCounts
END
IF EXISTS (select * from GxQscripts where name='JMGetRestoreSummaryCounts')
	delete from GxQscripts where name = 'JMGetRestoreSummaryCounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRestoreSummaryCounts')
	delete from GXDBVersions where aliasname = 'JMGetRestoreSummaryCounts'
GO
print '... Creating Procedure: JMGetRestoreSummaryCounts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetRestoreSummaryCounts
-- Input arguments
  @i_userId INT,
  @i_NumberOfDays INT,
  @i_DashboardType NVARCHAR(128) = 'Server',
  @i_AppTypes NVARCHAR(MAX) = ''
AS
  DECLARE @JobStatus INT
  DECLARE @JobCount INT
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @startTime INT =dbo.getunixtime(dateadd(day, -@i_NumberOfDays, getutcdate()))
    DECLARE @endTime INT =dbo.getunixtime(getutcdate())
    DECLARE @successCount             INTEGER
    DECLARE @failedCount       INTEGER
    DECLARE @killedCount       INTEGER
	DECLARE @showPersistentRecoveryJobs INTEGER = 0
	SELECT @showPersistentRecoveryJobs = ISNULL(CAST(value AS INT), 0)
	FROM GXGlobalParam WITH (NOLOCK)
	WHERE name = N'showPersistentRecoveryJobs'
	IF OBJECT_ID('tempdb.dbo.#rstJobs')       IS NOT null DROP TABLE #rstJobs
    -- Table for restore jobs
    CREATE TABLE #rstJobs
    (
            jobId         INTEGER,
            endTime       INTEGER,
            jobStatus     INTEGER,
			opType        INTEGER
    )
	CREATE CLUSTERED INDEX rstJobs_jobStatus ON #rstJobs(jobStatus)
	IF OBJECT_ID('tempdb.dbo.#appTypes')       IS NOT null DROP TABLE #appTypes
    -- Table for apptypes if any
    CREATE TABLE #appTypes (apptypeId INTEGER PRIMARY KEY)
	IF @i_AppTypes IS NOT NULL AND @i_AppTypes <> ''
	BEGIN
		INSERT INTO #appTypes
		SELECT DISTINCT CAST(_ID AS INT)
		FROM dbo.SplitIDString(@i_AppTypes)
	END
	DECLARE @restoreCap INTEGER
    -- POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_RESTORE_IN_PLACE-1) | POWER(2,EV_RESTORE_OUTOF_PLACE-1) | POWER(2,EV_VISIBILITY-1)
    SET @restoreCap = POWER(2,16-1) | POWER(2,20-1) | POWER(2,22-1) | POWER(2,31-1)
create table  #JMCanManageJob_rstObject ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	exec sec_getUserObjects @i_userId,2012,0,'#JMCanManageJob_rstObject'
	DELETE FROM #JMCanManageJob_rstObject
    WHERE  (Capabilities & @restoreCap) = 0
    DECLARE @isAllAssoc INT = (SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK) WHERE
							   (rstUserObject.commCellId=2 AND rstUserObject.clientGroupId=0 AND rstUserObject.clientId=0 AND rstUserObject.appTypeId=0 AND rstUserObject.instanceId=0 AND rstUserObject.backupsetId=0 AND rstUserObject.subClientId=0 AND rstUserObject.mediaAgentId=0 AND rstUserObject.libraryId=0 AND rstUserObject.archGroupId=0 AND rstUserObject.vtContainerId=0 AND rstUserObject.vtPolicyId=0 AND rstUserObject.vtShelfId=0 AND rstUserObject.reviewSetId=0 AND rstUserObject.querySetId=0 AND rstUserObject.downloadSetId=0 AND rstUserObject.ermId=0 AND rstUserObject.legalHoldId=0 AND rstUserObject.tagId=0 AND rstUserObject.cdPolicyId=0 AND rstUserObject.complianceReportId=0 AND rstUserObject.taskId=0 AND rstUserObject.workflowId=0 AND rstUserObject.logMonitoringPolicyId=0 AND rstUserObject.arrayId=0 AND rstUserObject.cloudId=0 AND rstUserObject.userGroupId=0 AND rstUserObject.providerId=0 AND rstUserObject.entityId1=0 AND rstUserObject.entityId2=0 AND rstUserObject.entityId3=0 AND rstUserObject.entityId4=0 AND rstUserObject.entityId5=0									AND rstUserObject.entityId6=0 AND rstUserObject.entityId7=0 AND rstUserObject.entityId8=0 AND rstUserObject.entityId9=0)
							   OR (rstUserObject.clientId=-10))
	IF @isAllAssoc = 1
	BEGIN
		IF @i_DashboardType = 'Server'
		BEGIN
			INSERT INTO #rstJobs
			(jobId, endTime, jobStatus, opType)
			SELECT DISTINCT jobId, servEndTime, status, opType
			FROM JMRestoreStats WITH(READUNCOMMITTED)
			WHERE
			servEndTime >= @startTime
			AND servEndTime <= @endTime
		END
		ELSE IF @i_DashboardType = 'Endpoint'
		BEGIN
		INSERT INTO #rstJobs
			(jobId, endTime, jobStatus, opType)
			SELECT DISTINCT jobId, servEndTime, RS.status, RS.opType
			FROM JMRestoreStats RS WITH(READUNCOMMITTED)
			INNER JOIN APP_Client CL ON CL.id = RS.srcClientId
			WHERE
			servEndTime >= @startTime
			AND servEndTime <= @endTime
			AND CL.status & 0x1000 = 0x1000 --Laptops only
		END
		ELSE -- Virtualization, DB, Cloud Apps
		BEGIN
			INSERT INTO #rstJobs
			(jobId, endTime, jobStatus, opType)
			SELECT DISTINCT jobId, servEndTime, RS.status, RS.opType
			FROM JMRestoreStats RS WITH(READUNCOMMITTED)
			INNER JOIN APP_Application APP ON APP.backupSet = RS.bkpSetID
			INNER JOIN #appTypes AT ON APP.appTypeId = AT.apptypeId
			WHERE
			servEndTime >= @startTime
			AND servEndTime <= @endTime
		END
	END
	ELSE
	BEGIN
		MERGE #JMCanManageJob_rstObject DST
		USING (SELECT dbo.BitWiseOR(SEC.capabilities) AS capabilities, CGA.clientId
			   FROM #JMCanManageJob_rstObject SEC
			   INNER JOIN App_ClientGroupAssoc CGA ON SEC.clientGroupId = CGA.clientGroupId
			   GROUP BY CGA.clientId ) SRC
		ON SRC.clientId = DST.clientId
		WHEN MATCHED THEN
			UPDATE SET DST.capabilities = DST.capabilities | SRC.capabilities
		WHEN NOT MATCHED THEN
			INSERT (capabilities, clientId)
            VALUES( SRC.capabilities, SRC.clientId);
		IF @i_DashboardType = 'Server'
		BEGIN
			INSERT INTO #rstJobs
			(jobId, endTime, jobStatus, opType)
			SELECT DISTINCT jobId, servEndTime, RS.status, RS.opType
			FROM JMRestoreStats RS WITH(READUNCOMMITTED)
			WHERE
			servEndTime >= @startTime
			AND servEndTime <= @endTime
			AND EXISTS(
							SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK) WHERE
							-- if you have the rights on the destination at any level then you will see the restore job
							(rstUserObject.clientid=destClientID) OR
							(rstUserObject.clientid=srcClientID AND apptypeid=0) OR
							(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=0) OR
							(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=0) OR
							(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=bkpSetID AND rstUserObject.subclientid=0) --OR
							-- Not needed because we expand it above
							--((rstUserObject.clientgroupid <> 0 AND EXISTS (SELECT TOP 1 1 FROM APP_ClientGroupAssoc WITH(NOLOCK) WHERE (APP_ClientGroupAssoc.clientGroupId = rstUserObject.clientGroupId  OR rstUserObject.clientGroupId=-10) AND (APP_ClientGroupAssoc.clientid=srcClientID OR APP_ClientGroupAssoc.clientid=destClientID))))
							)
			--AND  dbo.isRstJobVisible(@i_userId,commCellId,srcClientID,destClientID,appType,instanceID,bkpSetID) = 1
		END
		ELSE IF @i_DashboardType = 'EndPoint'
		BEGIN
			INSERT INTO #rstJobs
			(jobId, endTime, jobStatus, opType)
			SELECT DISTINCT jobId, servEndTime, RS.status, RS.opType
			FROM JMRestoreStats RS WITH(READUNCOMMITTED)
			INNER JOIN APP_Client CL ON CL.id = RS.srcClientId
			WHERE
			CL.status & 0x1000 = 0x1000  -- Laptops only
			AND servEndTime >= @startTime
			AND servEndTime <= @endTime
			AND EXISTS(
							SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK) WHERE
							-- if you have the rights on the destination at any level then you will see the restore job
							(rstUserObject.clientid=destClientID) OR
							(rstUserObject.clientid=srcClientID AND apptypeid=0) OR
							(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=0) OR
							(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=0) OR
							(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=bkpSetID AND rstUserObject.subclientid=0) --OR
							-- Not needed because we expand it above
							--((rstUserObject.clientgroupid <> 0 AND EXISTS (SELECT TOP 1 1 FROM APP_ClientGroupAssoc WITH(NOLOCK) WHERE (APP_ClientGroupAssoc.clientGroupId = rstUserObject.clientGroupId  OR rstUserObject.clientGroupId=-10) AND (APP_ClientGroupAssoc.clientid=srcClientID OR APP_ClientGroupAssoc.clientid=destClientID))))
							)
			--AND  dbo.isRstJobVisible(@i_userId,commCellId,srcClientID,destClientID,appType,instanceID,bkpSetID) = 1
		END
	END
	IF @showPersistentRecoveryJobs = 0
	BEGIN
		DELETE #rstJobs
		WHERE opType = 29 /*QUICKDMRST*/
	END
    -- Completed, Completed with errors, Completed with warnings
    SELECT @successCount = COUNT(1)
    FROM  #rstJobs
    WHERE jobStatus IN (1,3,14)
    -- Failed, failed to start
    SELECT @failedCount = COUNT(1)
    FROM  #rstJobs
    WHERE jobStatus IN (2,9)
    -- Killed
    SELECT @killedCount = COUNT(1)
    FROM  #rstJobs
    WHERE jobStatus IN (4)
	SELECT 'Success' as 'JobStatus', @successCount As JobCount
	UNION
	SELECT 'Failed' as 'JobStatus', @failedCount As JobCount
	UNION
	SELECT 'Killed' as 'JobStatus', @killedCount As JobCount
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetRestoreSummaryCounts')
	delete from GxQscripts where name = 'JMGetRestoreSummaryCounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRestoreSummaryCounts')
	delete from GXDBVersions where aliasname = 'JMGetRestoreSummaryCounts'
GO

insert into GXDBVersions values(2, 'JMGetRestoreSummaryCounts',  '00010001000400060000', 'JMGetRestoreSummaryCounts', '00010001000400060000')
GO

