

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetRestartStringForJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  JMGetRestartStringForJob()
--  |
--  | Description:  Get restart string for a running or completed job
--  |
--  |       Input:  jobId, commcellId
--  |
--  |      Output:  restart string for that job
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------------------	        --------------------------------
--  |   1.1        Jawahar Ragunathan           Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetRestartStringForJob')
BEGIN
	print '>>> Drop Stored Procedure: JMGetRestartStringForJob <<<'
	drop procedure JMGetRestartStringForJob
END
IF EXISTS (select * from GxQscripts where name='JMGetRestartStringForJob')
	delete from GxQscripts where name = 'JMGetRestartStringForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRestartStringForJob')
	delete from GXDBVersions where aliasname = 'JMGetRestartStringForJob'
GO
print '... Creating Procedure: JMGetRestartStringForJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetRestartStringForJob
  @in_jobID INT,
  @in_commcellID INT
AS
  DECLARE @restartString VARCHAR(MAX);
SET NOCOUNT ON
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @opType INT;
	DECLARE @subOpType INT;
	DECLARE @appTypeId INT;
	DECLARE @instance INT;
	DECLARE @appId INT;
	DECLARE @iso365Backup BIT = 0;
	SELECT @restartString = restartString, @opType = opType, @subOpType = subOpType FROM JMJobInfo WITH (NOLOCK) WHERE jobId = @in_jobID AND commCellId = @in_commcellID
	IF (@restartString IS NOT NULL)
	BEGIN
		IF (@opType = 4)
		BEGIN
			SELECT @appId = applicationId, @iso365Backup = (bkpAttributesEx & 0x200000000000000 /*JMBKP_EX_O365_BACKUP*/) FROM JMBkpJobInfo WITH (NOLOCK) WHERE jobId = @in_jobID and commcellId = @in_commcellID
			SELECT @appTypeId = appTypeId FROM APP_Application WITH (NOLOCK) WHERE id = @appId
			IF (@appTypeId = 137/*EXCH_ONEPASS*/ AND @subOpType = 98/*TURBOARCHIVE*/)
				SELECT TOP 1 @restartString = restartString FROM JMBkpAttemptInfo WITH (NOLOCK) WHERE jobId = @in_jobID AND phaseNum = 8/*EXMBBKP*/ AND commCellId = @in_commcellID ORDER BY endTime DESC
			ELSE IF (@appTypeId = 134/*CLOUD_APPS*/)
				IF (@iso365Backup = 1) OR EXISTS (SELECT 0 FROM APP_InstanceProp WITH (NOLOCK) WHERE attrName = 'Cloud Apps Instance Type' AND componentNameId = @instance AND attrVal IN ('1', '2', '7'))
					SELECT TOP 1 @restartString = restartString FROM JMBkpAttemptInfo WITH (NOLOCK) WHERE jobId = @in_jobID AND phaseNum = 3/*CLOUDCONNECTORBACKUP*/ AND commCellId = @in_commcellID
						ORDER BY endTime DESC
			ELSE IF (@appTypeId = 78 /*SHAREPOINTDOCV2*/)
				IF (@iso365Backup = 1)
					SELECT TOP 1 @restartString = restartString FROM JMBkpAttemptInfo WITH (NOLOCK) WHERE jobId = @in_jobID AND phaseNum = 14/*SPPBKP*/ AND commCellId = @in_commcellID
						ORDER BY endTime DESC
		END
	END
	ELSE
	BEGIN
		IF EXISTS (SELECT 0 FROM JMBkpStats WITH (NOLOCK) WHERE jobId = @in_jobID AND commCellId = @in_commcellID
											AND (displayStatus = 16/*COMMITTED*/ OR (((bkpAttributesEx & 0x1000000/*JMBKP_EX_SYNTHFULL_AFTER_COMMITTED_JOB*/) <> 0) AND status IN (1,3,14))))
			SELECT TOP 1 @restartString = restartString FROM JMBkpAtmptStats WITH (NOLOCK) WHERE jobId = @in_jobID AND commCellId = @in_commcellID ORDER BY servEndDate DESC
	END
	SELECT ISNULL(@restartString, '') AS RestartString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetRestartStringForJob')
	delete from GxQscripts where name = 'JMGetRestartStringForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRestartStringForJob')
	delete from GXDBVersions where aliasname = 'JMGetRestartStringForJob'
GO

insert into GXDBVersions values(2, 'JMGetRestartStringForJob',  '00000000000000000000', 'JMGetRestartStringForJob', '00000000000000000000')
GO

