

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetRefCopySCFileCount.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--			Author: Jaya Rama Raju Inavolu
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetRefCopySCFileCount <<<'

IF EXISTS (select * from sysobjects where name='JMGetRefCopySCFileCount')
	drop procedure JMGetRefCopySCFileCount
IF EXISTS (select * from GxQscripts where name='JMGetRefCopySCFileCount')
	delete from GxQscripts where name = 'JMGetRefCopySCFileCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRefCopySCFileCount')
	delete from GXDBVersions where aliasname = 'JMGetRefCopySCFileCount'
GO
print '... Creating Procedure: JMGetRefCopySCFileCount'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMGetRefCopySCFileCount
  @inJobID INTEGER
AS
  DECLARE @currentCount BIGINT
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @defaultCommCellId INTEGER  = 2
	DECLARE @fullCycleNum	INTEGER
	DECLARE @refSCId		INTEGER
	DECLARE @bkpLevel		INTEGER
	SET @refSCId = (Select applicationId From JMBkpJobInfo Where jobId = @inJobID and commcellId = @defaultCommCellId)
	SET @bkpLevel = (Select bkpLevel From JMBkpJobInfo Where jobId = @inJobID and commcellId = @defaultCommCellId)
	SET @fullCycleNum = -1
	IF @bkpLevel = 2 /*INCR*/
	BEGIN
		SET @fullCycleNum = (
							 Select ISNULL(cast(attrVal as int) , -1) From APP_SubClientProp Where componentNameId = @refSCId and
							 attrName = 'sys:full cycle num' and modified = 0
							 )
	END
	SET @currentCount = ISNULL(
						(
						  (Select ISNULL(SUM(totalNumOfFiles), 0) From JMBkpStats Where appId = @refSCId and fullCycleNum = @fullCycleNum)
						  +
						  (Select filesXfered From JMBkpJobInfo Where jobId = @inJobID  and commcellId = @defaultCommCellId)
						), 0)
	SELECT @currentCount
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetRefCopySCFileCount')
	delete from GxQscripts where name = 'JMGetRefCopySCFileCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetRefCopySCFileCount')
	delete from GXDBVersions where aliasname = 'JMGetRefCopySCFileCount'
GO

insert into GXDBVersions values(2, 'JMGetRefCopySCFileCount',  '00000000000000000000', 'JMGetRefCopySCFileCount', '00000000000000000000')
GO

