

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetQueueConflictingJobsEnabledForCG.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  JMGetQueueConflictingJobsEnabledForCG()
--  |
--  | Description:  Select 1 when 'queue conflicting jobs' is enabled on any of the associated client groups for the input client
--  |
--  |       Input:  clientID
--  |
--  |      Output:  1 or 0
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------------------	        --------------------------------
--  |   1.1        Jawahar Ragunathan           Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetQueueConflictingJobsEnabledForCG <<<'

IF EXISTS (select * from sysobjects where name='JMGetQueueConflictingJobsEnabledForCG')
	drop procedure JMGetQueueConflictingJobsEnabledForCG
IF EXISTS (select * from GxQscripts where name='JMGetQueueConflictingJobsEnabledForCG')
	delete from GxQscripts where name = 'JMGetQueueConflictingJobsEnabledForCG'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetQueueConflictingJobsEnabledForCG')
	delete from GXDBVersions where aliasname = 'JMGetQueueConflictingJobsEnabledForCG'
GO
print '... Creating Procedure: JMGetQueueConflictingJobsEnabledForCG'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetQueueConflictingJobsEnabledForCG
  @i_clientID INT
AS
  DECLARE @queueConflictingJobsEnabledForCG INTEGER
SET NOCOUNT ON
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF EXISTS(SELECT 1 FROM APP_ComponentProp CP WITH(NOLOCK) INNER JOIN
							APP_ClientGroupAssoc CGA WITH(NOLOCK)
					   ON CP.componentId = CGA.clientGroupId AND
						  CGA.clientId = @i_clientID
WHERE CP.propertyTypeId = 1802 AND
						     CP.longVal = 1 AND
							 CP.modified=0
	)
	BEGIN
		SELECT 1;
	END
	ELSE
	BEGIN
		SELECT 0;
	END;
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetQueueConflictingJobsEnabledForCG')
	delete from GxQscripts where name = 'JMGetQueueConflictingJobsEnabledForCG'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetQueueConflictingJobsEnabledForCG')
	delete from GXDBVersions where aliasname = 'JMGetQueueConflictingJobsEnabledForCG'
GO

insert into GXDBVersions values(2, 'JMGetQueueConflictingJobsEnabledForCG',  '00000000000000000000', 'JMGetQueueConflictingJobsEnabledForCG', '00000000000000000000')
GO

