

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetQinetixUpdateClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetQinetixUpdateClients.sp,v $ $Id: JMGetQinetixUpdateClients.sp,v 1.1.2.4 2020/02/26 08:15:19 jragunathan Exp $";
--
--  +========================================================================+
--  |   Procedure:  JMGetQinetixUpdateClients()
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Sergio Bonilla   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetQinetixUpdateClients')
BEGIN
	print '>>> Drop Stored Procedure: JMGetQinetixUpdateClients <<<'
	drop procedure JMGetQinetixUpdateClients
END
IF EXISTS (select * from GxQscripts where name='JMGetQinetixUpdateClients')
	delete from GxQscripts where name = 'JMGetQinetixUpdateClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetQinetixUpdateClients')
	delete from GXDBVersions where aliasname = 'JMGetQinetixUpdateClients'
GO
print '... Creating Procedure: JMGetQinetixUpdateClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetQinetixUpdateClients
  @jobId BIGINT,
  @commCellId INT,
  @userId INT = 0,
  @isVSAJob INT = 0,
  @isForRunningJob INT = 0,
  @vmClientId INT = 0
AS
  DECLARE @o_jobId INT
  DECLARE @o_clientId INT
  DECLARE @o_clientName NVARCHAR(255)
  DECLARE @o_category INT
  DECLARE @o_status INT
  DECLARE @o_statusMessage NVARCHAR(256)
  DECLARE @o_installedUpdates NVARCHAR(MAX)
  DECLARE @o_remotecacheClientId INT
  DECLARE @o_displayName NVARCHAR(1024)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @userName NVARCHAR(1024) = ''
	DECLARE @bkpAttributesEx BIGINT = 0
	IF object_id('tempdb.dbo.#JMQUpdateStatusTbl') IS NOT NULL DROP TABLE #JMQUpdateStatusTbl
CREATE TABLE #JMQUpdateStatusTbl (jobId INT, clientId INT, clientName NVARCHAR(255), category INT, status INT, statusMessage NVARCHAR(256), installedUpdates NVARCHAR(256), remotecacheClientId INT DEFAULT 0, displayName NVARCHAR(1024))
	CREATE CLUSTERED INDEX [JMQUpdateStatusTbl_jobId_clientId] ON [#JMQUpdateStatusTbl]([jobId],[clientId])
	IF @isForRunningJob = 0
	BEGIN
		SELECT @bkpAttributesEx=bkpAttributesEx FROM JMBkpStats (NOLOCK) WHERE jobId = @jobId
	END
	IF @userId = 0
	BEGIN
		INSERT INTO #JMQUpdateStatusTbl
		(jobId, clientId, clientName, category, status, statusMessage, installedUpdates, displayName)
		SELECT jobId, clientId, clientName, category, QU.status, statusMessage, installedUpdates, displayName
		FROM JMQinetixUpdateStatus QU (NOLOCK)
		LEFT OUTER JOIN App_Client C (NOLOCK) ON C.id = QU.clientId
		WHERE QU.jobId = @jobId
		AND commCellId = @commCellId
	END
	ELSE
	BEGIN
		IF @isVSAJob = 1
		BEGIN
			INSERT INTO #JMQUpdateStatusTbl
			(jobId, clientId, clientName, category, status, statusMessage, installedUpdates, displayName)
			SELECT jobId, clientId, clientName, category, QU.status, statusMessage, installedUpdates, displayName
			FROM JMQinetixUpdateStatus QU (NOLOCK)
			LEFT OUTER JOIN App_Client C (NOLOCK) ON C.id = QU.clientId
			WHERE QU.jobId = @jobId
			AND commCellId = @commCellId
			AND
			(
				dbo.isVisible(@userId, @jobId, @commCellId, 0, 0, 0, 0, 0, 0) = 1
				OR
				dbo.isClientVisible(@userId, clientId, 0, 0, 0, 0) = 1
			)
		END
		ELSE
		BEGIN
			IF @isForRunningJob = 1
			BEGIN
				INSERT INTO #JMQUpdateStatusTbl
				(jobId, clientId, clientName, category, status, statusMessage, installedUpdates, displayName)
				SELECT jobId, clientId, clientName, category, QU.status, statusMessage, installedUpdates, displayName
				FROM JMQinetixUpdateStatus QU (NOLOCK)
				LEFT OUTER JOIN App_Client C (NOLOCK) ON C.id = QU.clientId
				WHERE jobId = @jobId
				AND QU.commCellId = @commCellId
				AND
				(
					dbo.isAdminJobVisible(@userId, @commCellId, 0, @jobId, 0, clientId) > 0
					OR
					EXISTS(SELECT 1 FROM JMJobInfo (NOLOCK) WHERE jobId = @jobId AND userId = @userId AND commCellId = @commCellId)
				)
			END
			ELSE
			BEGIN
				SELECT TOP 1 @userName = login FROM UMUsers (NOLOCK) WHERE id = @userName
				INSERT INTO #JMQUpdateStatusTbl
				(jobId, clientId, clientName, category, status, statusMessage, installedUpdates, displayName)
				SELECT jobId, clientId, clientName, category, QU.status, statusMessage, installedUpdates, displayName
				FROM JMQinetixUpdateStatus QU (NOLOCK)
				LEFT OUTER JOIN App_Client C (NOLOCK) ON C.id = QU.clientId
				WHERE jobId = @jobId
				AND QU.commCellId = @commCellId
				AND
				(
					dbo.isAdminJobVisible(@userId, @commCellId, 0, @jobId, 0, clientId) > 0
					OR
					EXISTS(SELECT 1 FROM JMAdminJobStatsTable (NOLOCK) WHERE jobId = @jobId AND commCellId = @commCellId AND username = @userName)
				)
			END
		END
	END
	IF @vmClientId > 0
		DELETE #JMQUpdateStatusTbl WHERE clientId <> @vmClientId
	IF @isForRunningJob = 0 AND (@bkpAttributesEx&0x100000000000000 = 0x100000000000000) --JMBKP_EX_VSA_PARENT_SYNTHFULL
	BEGIN
		UPDATE #JMQUpdateStatusTbl
		SET jobId = (
			SELECT JL.childJobId
				FROM JMJobDataLink JL (NOLOCK)
				JOIN App_Application A (NOLOCK) ON A.id = JL.childAppid
				WHERE JL.commCellId = @commCellId
				AND JL.parentJobId = @jobId
				AND A.clientId = #JMQUpdateStatusTbl.clientId
AND JL.linkType = 7
			)
	END
	UPDATE QUS SET QUS.remotecacheClientId = JMM.intData
		FROM #JMQUpdateStatusTbl QUS
INNER JOIN JMMisc JMM (NOLOCK) ON QUS.clientId = JMM.attribute AND JMM.jobId = @jobId AND JMM.itemType = 82
	SELECT jobId, clientId, clientName, category, status, statusMessage, installedUpdates, remotecacheClientId, displayName
	FROM #JMQUpdateStatusTbl
	IF object_id('tempdb.dbo.#JMQUpdateStatusTbl') IS NOT NULL DROP TABLE #JMQUpdateStatusTbl
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetQinetixUpdateClients')
	delete from GxQscripts where name = 'JMGetQinetixUpdateClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetQinetixUpdateClients')
	delete from GXDBVersions where aliasname = 'JMGetQinetixUpdateClients'
GO

insert into GXDBVersions values(2, 'JMGetQinetixUpdateClients',  '00010001000200040000', 'JMGetQinetixUpdateClients', '00010001000200040000')
GO

