

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetPreScanMetaData.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetPreScanMetaData.sp,v $ $Id: JMGetPreScanMetaData.sp,v 1.1.2.12 2020/08/12 20:57:44 abhinawkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetPreScanMetaData')
BEGIN
	print '>>> Drop Stored Procedure: JMGetPreScanMetaData <<<'
	drop procedure JMGetPreScanMetaData
END
IF EXISTS (select * from GxQscripts where name='JMGetPreScanMetaData')
	delete from GxQscripts where name = 'JMGetPreScanMetaData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetPreScanMetaData')
	delete from GXDBVersions where aliasname = 'JMGetPreScanMetaData'
GO
print '... Creating Procedure: JMGetPreScanMetaData'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetPreScanMetaData
  @input XML
AS
  DECLARE @output XML
BEGIN
	SET NOCOUNT ON
    DECLARE @appID INT = 0
    DECLARE @dsID INT = 0
	DECLARE @InstanceId INT = 0
	DECLARE @AppTypeId INT = 0
	DECLARE @SampleRows INT = 0
	DECLARE @IgnoreListConfig varchar(100) = 'DefaultDatabaseIgnoreList'
    DECLARE @ServName varchar(max) = ''
    DECLARE @InsName varchar(max) = ''
   	DECLARE @clientId INT = 0
   	DECLARE @idaId INT = 0
    DECLARE @UserName varchar(max) = ''
    DECLARE @Password varchar(max) = ''
    DECLARE @IntegratedAuth INT = 0
	DECLARE @InstanceName nvarchar(1024)
	DECLARE @DBType INT = 0
    DECLARE @DBTypeStr varchar(20) = ''
    DECLARE @dumpPath varchar(max) = ''
    DECLARE @schemaIgnoreList varchar(max) = ''
	DECLARE @dbIgnoreList varchar(max) = ''
	DECLARE @tableIgnoreList varchar(max) = ''
	DECLARE @columnIgnoreList varchar(max) = ''
    DECLARE @tnsAdminPath varchar(max) = ''
    DECLARE @oracleHome varchar(max) = ''
    DECLARE @accessNodes varchar(max) = ''
    DECLARE @databaseName varchar(max) = ''
    DECLARE @osUserName varchar(max) = ''
    DECLARE @osDomainName varchar(max) = ''
    DECLARE @osPassword varchar(max) = ''
    DECLARE @MSSQLDBTYPE INT = 0
    DECLARE @ORACLEDBTYPE INT = 1
    DECLARE @MYSQLDBTYPE INT = 2
    DECLARE @usedClientId INT = 0
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
    SELECT @appID = ISNULL(T.c.value('@appID', 'int'), 0)
        FROM   @input.nodes('/DM2ContentIndexing_DatabaseConfigReq[1]') T(c)
    SELECT @dsID = attrVal FROM APP_SubClientProp WHERE componentNameId = @appID AND modIFied = 0 AND attrName = 'Indexing datasource id'
	SELECT @InstanceId = PropertyValue FROM SEDataSourceProperty WHERE DataSourceId = @dsid AND propertyId in (SELECT propertyId FROM SEProperty WHERE PropertyName = 'dbinstanceid')
    SELECT @InstanceName = name FROM APP_InstanceName WHERE id = @InstanceId
    SELECT @AppTypeId = appTypeId, @clientId = clientId FROM App_Application WHERE instance = @InstanceId
    SELECT @idaId = id FROM APP_IDAName where clientId = @clientId AND appTypeId = @AppTypeId
    IF EXISTS(select * from APP_IDAProp where componentNameId = @idaId AND attrName = 'Cloud Proxy Servers' AND modified = 0)
    BEGIN
        SELECT @accessNodes = attrVal FROM APP_IDAProp where componentNameId = @idaId AND attrName = 'Cloud Proxy Servers' AND modified = 0
    END
    ELSE IF EXISTS(select * from APP_InstanceProp where componentNameId = @InstanceId AND attrName = 'GDPR Proxy Servers' AND modified = 0)
    BEGIN
        SELECT @accessNodes = attrVal FROM APP_InstanceProp where componentNameId = @InstanceId AND attrName = 'GDPR Proxy Servers' AND modified = 0
    END
	SET @SampleRows = ISNULL((SELECT CAST(value AS INT) FROM GxGlobalParam WHERE name = 'DefaultAnalyzeRowCount' and ISNUMERIC(value) = 1), 100)
IF @AppTypeId in (4, 16, 70, 81) --> MsSQL
	BEGIN
		SET @DBType = @MSSQLDBTYPE
		SET @DBTypeStr = 'MSSQL'
	END
ELSE IF @AppTypeId IN (2, 22, 23, 80) --> Oracle
	BEGIN
		SET @DBType = @ORACLEDBTYPE
		SET @DBTypeStr = 'ORACLE'
	END
ELSE IF @AppTypeId IN (104) --> MySql
	BEGIN
		SET @DBType = @MYSQLDBTYPE
		SET @DBTypeStr = 'MYSQL'
	END
    IF LEN(@accessNodes) = 0
    BEGIN
        SET @usedClientId = @clientId
    END
    ELSE
    BEGIN
		DECLARE @accessNodesXML xml = CAST(@accessNodes AS XML)
        SELECT @usedClientId = ISNULL(T.cc.value('@clientId','int'),0)
        FROM @accessNodesXML.nodes('/App_MemberServers/memberServers/client') AS T(cc)
    END
    DECLARE @fsSeparator varchar(2)  = '\'
    IF NOT EXISTS (SELECT top 1 1 FROM simOperatingSystem WITH (NOLOCK) WHERE id IN (SELECT simOperatingSystemId FROM APP_Client WITH (NOLOCK) where id = @usedClientId) and Type = 'Windows')
    BEGIN
        SET @fsSeparator = '/'
    END
    DECLARE @ServerNameLabel varchar(max) = @fsSeparator + '!SN!'
    DECLARE @InstanceNameLabel varchar(max) = @fsSeparator + '!IN!'
    SELECT @dumpPath = fileName + @fsSeparator + 'DB_Dump_Folder' FROM APP_ScFilterFile WHERE componentNameId = @appID AND type = 1 AND modIFied = 0
	IF @DBType = @MSSQLDBTYPE
    BEGIN
	    IF OBJECT_ID('tempdb.dbo.#SQLAuthDetails') IS NOT NULL
	    BEGIN
		    DROP TABLE #SQLAuthDetails
	    END
	    CREATE TABLE #SQLAuthDetails (instanceId int, authType int, userName nvarchar(1024), userPassword nvarchar(1024), [level] int)
		EXEC AppGetSqlAuth @InstanceId, 0, 0, 0
        --ignore system databases and schemas
        SET @dbIgnoreList = 'master;model;msdb;tempdb'
        SET @schemaIgnoreList = 'sys;INFORMATION_SCHEMA'
		IF PATINDEX('%\%', @InstanceName) > 0
		BEGIN
			SELECT @ServName = SUBSTRING(@InstanceName, 0, PATINDEX('%\%', @InstanceName)), @InsName = SUBSTRING(@InstanceName,PATINDEX('%\%', @InstanceName)+1, LEN(@InstanceName)) from #SQLAuthDetails
		END
		ELSE
		BEGIN
			SET @ServName = @InstanceName
			SET @InsName = 'MSSQLSERVER'
		END
        SET @dumpPath = @dumpPath + @ServerNameLabel + @ServName + @InstanceNameLabel + @InsName
        SELECT @UserName = userName, @Password = userPassword FROM #SQLAuthDetails
        SET @IntegratedAuth = 1
	    IF OBJECT_ID('tempdb.dbo.#SQLAuthDetails') IS NOT NULL
	    BEGIN
		    DROP TABLE #SQLAuthDetails
	    END
	END
	ELSE IF @DBType = @ORACLEDBTYPE
	BEGIN
		SET @IgnoreListConfig = 'DefaultSchemaIgnoreList'
        --ignore system schemas
		SET @schemaIgnoreList = 'ANONYMOUS;CTXSYS;DBSNMP;EXFSYS;LBACSYS;MDSYS;MGMT_VIEW;OLAPSYS;ORDDATA;OWBSYS;ORDPLUGINS;ORDSYS;OUTLN;SI_INFORMTN_SCHEMA;SYS;SYSMAN;SYSTEM;WK_TEST;WKSYS;WKPROXY;WMSYS;XDB;APEX_PUBLIC_USER;DIP;FLOWS_040100;FLOWS_FILES;MDDATA;ORACLE_OCM;SPATIAL_CSW_ADMIN_USR;SPATIAL_WFS_ADMIN_USR;XS$NULL;APEX_030200;APPQOSSYS;BI;PM;IX;SH;OE;HR'
        SELECT @ServName = C.net_hostname FROM APP_Application SC INNER JOIN APP_Client C
            ON SC.clientId = C.id WHERE SC.instance = @InstanceId
        SET @dumpPath = @dumpPath + @ServerNameLabel + @ServName + @InstanceNameLabel + @InstanceName
        SET @databaseName = @InstanceName
IF @AppTypeId = 80
        BEGIN
            SELECT TOP 1
                @UserName = InstanceOraUser,
                @Password = InstanceOraPasswd,
                @InstanceName = InstanceOraService,
                @tnsAdminPath = tnsAdmin,
                @oracleHome = oracleHome
            FROM App_OracleRacInstance
            WHERE instaceId = @InstanceId
            ORDER BY instanceNumber
        END
        ELSE
        BEGIN
		DECLARE @sqlConnectMachine NVARCHAR(200) = ''
		;WITH CTE
		as
		(
		SELECT attrName, attrVal
		FROM APP_InstanceProp
		WHERE componentNameId = @InstanceId and modIFied = 0
		)
		SELECT @UserName = [SQL Connect] , @Password = dbo.pswConvertV5ToV3([SQL Connect Password]) ,
            @sqlConnectMachine = [SQL Connect Machine] , @tnsAdminPath = [TNS admin path],
            @oracleHome = [Oracle Home], @osUserName = [Oracle User],
            @osDomainName = [Domain Name], @osPassword = dbo.pswConvertV5ToV3([Domain User Password])
		FROM CTE
		PIVOT (MIN(attrval) FOR AttrName in ([SQL Connect],[SQL Connect Password],[SQL Connect Machine],
                [TNS admin path], [Oracle Home], [Oracle User], [Domain Name], [Domain User Password])) as DataPivot;
		IF LEN(@sqlConnectMachine) > 0
		BEGIN
			SET @InstanceName = @sqlConnectMachine
		END
		END
        IF @tnsAdminPath IS NULL OR @tnsAdminPath = ''
        BEGIN
            SET @tnsAdminPath = @oracleHome + @fsSeparator + 'network' + @fsSeparator + 'admin'
        END
	END
	ELSE IF @DBType = @MYSQLDBTYPE
	BEGIN
        DECLARE @socketFile NVARCHAR(MAX) = ''
        DECLARE @proxyServerName NVARCHAR(MAX) = ''
		;WITH CTE
		as
		(
		SELECT attrName, attrVal
		FROM APP_InstanceProp
		WHERE componentNameId = @InstanceId and modIFied = 0
		)
		SELECT @UserName = [MySQL SA user] , @Password = [MySQL SA password] , @proxyServerName = [MySQL proxy server name] , @socketFile = [MySQL socket file]
		FROM CTE
		PIVOT (MIN(attrval) FOR AttrName in ([MySQL SA user],[MySQL SA password],[MySQL proxy server name],[MySQL socket file])) as DataPivot;
        SELECT @ServName = SUBSTRING(@proxyServerName, 0, PATINDEX('%\%', @proxyServerName)), @InsName = SUBSTRING(@proxyServerName,PATINDEX('%\%', @proxyServerName)+1, LEN(@proxyServerName))
        SET @dumpPath = @dumpPath + @ServerNameLabel + @ServName + @InstanceNameLabel + @InsName
        SELECT @ServName = C.net_hostname FROM APP_Application SC INNER JOIN APP_Client C
            ON SC.clientId = C.id WHERE SC.instance = @InstanceId
        SELECT @InstanceName = @ServName + ':' + @socketFile
    END
    IF @IgnoreListConfig = 'DefaultSchemaIgnoreList'
    BEGIN
	    SET @tableIgnoreList = ISNULL((SELECT value FROM GxGlobalParam WHERE name = @IgnoreListConfig AND modified = 0), @tableIgnoreList)
	END
	ELSE
	BEGIN
	    SET @dbIgnoreList = ISNULL((SELECT value FROM GxGlobalParam WHERE name = @IgnoreListConfig AND modified = 0), @dbIgnoreList)
	END
	SET @output = (SELECT @UserName AS '@userName', @Password AS '@password', @IntegratedAuth AS '@integratedAuth',
            @InstanceName AS '@instanceName', @DBType as '@databaseType', @databaseName as '@databaseName',
            @dumpPath as '@dbDumpPath', @schemaIgnoreList as '@schemaIgnoreList', @dbIgnoreList as '@dbIgnoreList',
            @tableIgnoreList as '@tableIgnoreList', @columnIgnoreList as '@columnIgnoreList',
            @tnsAdminPath as '@tnsAdminPath', @oracleHome as '@oracleHome', @accessNodes as '@accessNodes',
            @osUserName as '@osUserName', @osDomainName as '@osDomainName', @osPassword as '@osPassword'
	FOR XML PATH ('DM2ContentIndexing_DatabaseConfigResp'), TYPE)
    SELECT @output
	SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetPreScanMetaData')
	delete from GxQscripts where name = 'JMGetPreScanMetaData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetPreScanMetaData')
	delete from GXDBVersions where aliasname = 'JMGetPreScanMetaData'
GO

insert into GXDBVersions values(2, 'JMGetPreScanMetaData',  '00010001000200120000', 'JMGetPreScanMetaData', '00010001000200120000')
GO

