

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetOracleRACStreamInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetOracleRACStreamInfo.sp,v $ $Id: JMGetOracleRACStreamInfo.sp,v 1.1 2014/08/11 21:08:02 jraju Exp $";
---- =============================================
---- Author:		Jaya Rama Raju Inavolu
---- Description:	Get the job options
---- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetOracleRACStreamInfo <<<'

IF EXISTS (select * from sysobjects where name='JMGetOracleRACStreamInfo')
	drop procedure JMGetOracleRACStreamInfo
IF EXISTS (select * from GxQscripts where name='JMGetOracleRACStreamInfo')
	delete from GxQscripts where name = 'JMGetOracleRACStreamInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetOracleRACStreamInfo')
	delete from GXDBVersions where aliasname = 'JMGetOracleRACStreamInfo'
GO
print '... Creating Procedure: JMGetOracleRACStreamInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetOracleRACStreamInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inputXml XML
AS
BEGIN
  DECLARE @outputXml XML 
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @jmRacStreamInfo TABLE
	(
		jobId				int,
		commCellId			int,
		dataType			int
	)
	INSERT INTO @jmRacStreamInfo
	SELECT
	ISNULL(i.col.value('@jobId', 'int'), 0),
	ISNULL(i.col.value('@commCellId', 'int'), 2),
	ISNULL(i.col.value('@dataType', 'int'), 0)
	FROM
	@inputXml.nodes('JobManager_GetOracleRACStreamInfoReq') i(col)
	SET @outputXml =
	(
		SELECT
		t1.jobId '@jobId',
		t1.commCellId '@commCellId',
		t2.racInstanceId '@racIntanceId',
		t2.racHostId '@racHostId',
		t2.dataStreamsNeeded '@dataStreamsNeeded',
		t2.dataStreamsAllocated '@dataStreamsAllocated',
		t2.logsStreamsNeeded '@logStreamsNeeded',
		t2.logsStreamsAllocated '@logsStreamsAllocated',
		t2.status	'@status'
		FROM @jmRacStreamInfo t1, JmOracleRACStreamInfo t2
		WHERE t1.jobId = t2.jobId AND t1.commCellId = t2.commCellId AND ((t1.dataType = 1 And t2.dataStreamsAllocated >0 ) OR (t1.dataType = 0 And t2.logsStreamsAllocated >0 ))
		FOR XML PATH('racStreamInfo'), ROOT('JobManager_GetOracleRACStreamInfoResp')
	)
	IF @outputXml IS NULL
		SET @outputXml = '<JobManager_GetOracleRACStreamInfoResp/>'
	SELECT @outputXml
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetOracleRACStreamInfo')
	delete from GxQscripts where name = 'JMGetOracleRACStreamInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetOracleRACStreamInfo')
	delete from GXDBVersions where aliasname = 'JMGetOracleRACStreamInfo'
GO

insert into GXDBVersions values(2, 'JMGetOracleRACStreamInfo',  '00010001000000000000', 'JMGetOracleRACStreamInfo', '00010001000000000000')
GO

