

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetNonCloudLaptopJobsForCG.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetNonCloudLaptopJobsForCG.sp,v $ $Id: JMGetNonCloudLaptopJobsForCG.sp,v 1.1.4.4 2020/11/17 14:29:37 cnaik Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "JMGetJobsForMA"
--	|	This stored procedure gets running jobs using given MA. This is used in CatalogMigrationJob
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMGetNonCloudLaptopJobsForCG')
BEGIN
	print '>>> Drop Stored Procedure: JMGetNonCloudLaptopJobsForCG <<<'
	drop procedure JMGetNonCloudLaptopJobsForCG
END
IF EXISTS (select * from GxQscripts where name='JMGetNonCloudLaptopJobsForCG')
	delete from GxQscripts where name = 'JMGetNonCloudLaptopJobsForCG'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetNonCloudLaptopJobsForCG')
	delete from GXDBVersions where aliasname = 'JMGetNonCloudLaptopJobsForCG'
GO
print '... Creating Procedure: JMGetNonCloudLaptopJobsForCG'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMGetNonCloudLaptopJobsForCG
-- Input arguments
  @i_clientGroupID INTEGER
AS
  DECLARE @o_jobId integer
BEGIN
	WITH ClientWithPackageInstall_CTE(ClientID,attrName,NoOfPackage)
	AS
	(
		SELECT componentNameId,attrName,COUNT(*) AS NoOfPackages FROM APP_ClientProp WITH(NOLOCK)
		WHERE attrName = 'PackagesToInstall' AND modified = 0
		GROUP BY componentNameId,attrName
		HAVING COUNT(*) = 1
	)
	SELECT jobInfo.jobId FROM JMBkpJobInfo jobInfo INNER JOIN APP_Application app ON jobInfo.applicationId = app.id AND jobInfo.commcellId = 2
	INNER JOIN
	(
		SELECT DISTINCT cProp.componentNameId AS ClientID FROM APP_ClientProp cProp WITH(NOLOCK) INNER JOIN ClientWithPackageInstall_CTE packageInstall
			ON cProp.componentNameId = packageInstall.ClientID AND cProp.attrName = 'PackagesToInstall' AND cProp.modified = 0 AND cProp.attrVal IN ('54','1305')
				INNER JOIN APP_Application APP WITH (NOLOCK) on APP.clientId = packageInstall.ClientID
                INNER JOIN APP_BackupSetName B WITH (NOLOCK) on APP.backupSet = B.id
INNER JOIN APP_SubClientProp SCP WITH (NOLOCK) on SCP.componentNameId = APP.id AND  SCP.attrName = 'Cloud Mode Enabled' and SCP.modified = 0 and SCP.attrVal = '1' AND SCP.cs_attrName = CHECKSUM(N'Cloud Mode Enabled')        -- subClientProp has "Cloud Mode Enabled"='Cloud Mode Enabled' set
WHERE (B.status & 0x00008) = 0x00008                          -- default backupset CV_STATUS_DEFAULT = 8
                AND    B.id = APP.backupset
AND    (APP.subclientStatus & 0x00008 ) = 0x00008
		UNION
		SELECT ClientID FROM CommCellCloudLaptopClients
	) CloudLaptopClients ON CloudLaptopClients.ClientID = app.clientId
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetNonCloudLaptopJobsForCG')
	delete from GxQscripts where name = 'JMGetNonCloudLaptopJobsForCG'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetNonCloudLaptopJobsForCG')
	delete from GXDBVersions where aliasname = 'JMGetNonCloudLaptopJobsForCG'
GO

insert into GXDBVersions values(2, 'JMGetNonCloudLaptopJobsForCG',  '00010001000400040000', 'JMGetNonCloudLaptopJobsForCG', '00010001000400040000')
GO

