

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetNonAutomaticRunningJobsForClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--  +========================================================================+
--  |      Name	 :  JMGetNonAutomaticRunningJobsForClient
--  |
--  | Description:  It returns the traditional (Non automatic) running jobs for a given client.
--	|
--  |	   Input :	ClientID
--	|
--  |      Output:  List of legitimate non automatic running jobs for given client which should be resumed by JM immdiately after getting the notify request from client.
--	|
--  |   Revisions  Author      Description
--  |   ---------  -------  ---------------------------------------------
--  |     1.1      Hemant Mishra  Support for non automatic running jobs.
--  |     1.2					  extending the procedure to return automatic jobs also.
--  +========================================================================+
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetNonAutomaticRunningJobsForClient.sp,v $ $Id: JMGetNonAutomaticRunningJobsForClient.sp,v 1.3.86.1 2018/03/22 03:13:56 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetNonAutomaticRunningJobsForClient <<<'

IF EXISTS (select * from sysobjects where name='JMGetNonAutomaticRunningJobsForClient')
	drop procedure JMGetNonAutomaticRunningJobsForClient
IF EXISTS (select * from GxQscripts where name='JMGetNonAutomaticRunningJobsForClient')
	delete from GxQscripts where name = 'JMGetNonAutomaticRunningJobsForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetNonAutomaticRunningJobsForClient')
	delete from GXDBVersions where aliasname = 'JMGetNonAutomaticRunningJobsForClient'
GO
print '... Creating Procedure: JMGetNonAutomaticRunningJobsForClient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMGetNonAutomaticRunningJobsForClient
  @iClientID integer
AS
  DECLARE @oNonAutomaticRunningJob integer;
  DECLARE @oIsJobInPendingState integer;
  DECLARE @oIsAutomaticJob integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE   @JobsTobeResumed TABLE(t_jobId INT, t_IsJobInPendingState INT, t_IsAutomaticJob INT)
	-- 1) Check for legitimate running backup jobs.
	INSERT INTO @JobsTobeResumed
	--- PENDING =2  INIT_FROM_TYPE_AUTOMATIC= 6
	SELECT DISTINCT JBJI.jobId, (CASE WHEN JJI.state = 2 THEN 1 ELSE 0 END), (CASE WHEN TJR.initiatedFrom = 6 THEN 1 ELSE 0 END)
	FROM JMBkpJobInfo JBJI, JMJobInfo JJI, APP_Application App, APP_Client C, TM_JobRequest TJR, TM_Jobs TJ
	WHERE C.id = @iClientID
	AND APP.clientId = C.id
	AND JBJI.applicationId = APP.id
	AND JBJI.jobId = JJI.jobId
	AND JBJI.jobId = TJ.jobId
	AND TJ.jobRequestId = TJR.jobRequestId
	--AND TJR.initiatedFrom <> 6							-- INIT_FROM_TYPE_AUTOMATIC
	AND JJI.state NOT IN (4,5,6,7,8,9,10,11,12,13,19)	-- COMPLETED,STOPPED,KILLPENDING,STOPPENDING,INTERRUPTPENDING,COMPLETEDSUCCESS, COMPLETEDFAIL,STATEKILLED,COMPLETEDPARTIAL,COMPLETEDWITHWARNINGS
	AND JJI.opType NOT IN (14)							--  SynthFULL
	SELECT t_jobId, t_IsJobInPendingState, t_IsAutomaticJob FROM @JobsTobeResumed
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetNonAutomaticRunningJobsForClient')
	delete from GxQscripts where name = 'JMGetNonAutomaticRunningJobsForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetNonAutomaticRunningJobsForClient')
	delete from GXDBVersions where aliasname = 'JMGetNonAutomaticRunningJobsForClient'
GO

insert into GXDBVersions values(2, 'JMGetNonAutomaticRunningJobsForClient',  '00010003008600010000', 'JMGetNonAutomaticRunningJobsForClient', '00010003008600010000')
GO

