

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetNextJobsToSnapTapeForWF.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetNextJobsToSnapTapeForWF.sp,v $ $Id: JMGetNextJobsToSnapTapeForWF.sp,v 1.1.4.7 2020/11/21 00:00:22 bzhu Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "JMGetNextJobsToSnapTapeForWF"				|
--	|									|
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMGetNextJobsToSnapTapeForWF')
BEGIN
	print '>>> Drop Stored Procedure: JMGetNextJobsToSnapTapeForWF <<<'
	drop procedure JMGetNextJobsToSnapTapeForWF
END
IF EXISTS (select * from GxQscripts where name='JMGetNextJobsToSnapTapeForWF')
	delete from GxQscripts where name = 'JMGetNextJobsToSnapTapeForWF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetNextJobsToSnapTapeForWF')
	delete from GXDBVersions where aliasname = 'JMGetNextJobsToSnapTapeForWF'
GO
print '... Creating Procedure: JMGetNextJobsToSnapTapeForWF'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMGetNextJobsToSnapTapeForWF
  @injobID integer,
  @incommcellID integer,
  @insubmitStatus integer,
  @whereClause char(512)
AS
  DECLARE @jobId integer
  DECLARE @applicationId integer
  DECLARE @processedJobId integer
  DECLARE @bkpOptions integer
  DECLARE @fullCycleNum integer
  DECLARE @servEndDate integer
  DECLARE @childJobId integer
  DECLARE @submitStatus integer
  DECLARE @childOpType integer
  DECLARE @step integer
  DECLARE @stepType integer
  DECLARE @archGroupId integer
	DECLARE @errorReturn	integer
	SET @errorReturn = 0
	SET NOCOUNT ON
	select WF1.jobId, WF1.applicationId, WF1.processedJobId, WF1.bkpOptions, WF1.fullCycleNum, WF1.servEndDate, WF1.childJobId, WF1.submitStatus, WF1.childOpType, WF1.step, WF1.stepType, WF1.archGroupId
		FROM JMJobWF WF1 WITH(NOLOCK) WHERE
		WF1.jobId = @injobID AND
		WF1.commcellId = @incommcellID AND
		WF1.submitStatus = @insubmitStatus
		AND
		-- This will filter out jobs from same subclient if any job is running for that subclient already from current workflow
		NOT EXISTS (select 1 from JMJobWF WF2, JMJobInfo JI
					where WF2.jobId = @injobID AND WF2.commcellId = @incommcellID
					AND WF2.applicationId = WF1.applicationId
					AND WF2.childJobId <> WF1.childJobId AND WF2.childJobId <> 0
					AND WF2.childJobId = JI.jobId AND WF2.commcellID = JI.commCellId)
		AND
		-- This will filter out jobs from same subclient if any job is failed for that subclient already from current workflow.
		NOT EXISTS (select 1 from JMJobWF WF3, JMBkpStats JS
					where WF3.jobId = @injobID AND WF3.commcellId = @incommcellID
					AND WF3.applicationId = WF1.applicationId
					AND WF3.childJobId <> WF1.childJobId AND WF3.childJobId <> 0
					AND WF3.childJobId = JS.jobId AND WF3.commcellID = JS.commCellId
					AND WF3.applicationId = JS.appId
					AND JS.status NOT IN (1, 3, 14)
AND JS.bkpAttributesEx & 0x40000000 = 0 )  -- for parent job, allow it to continue
		AND
		 -- This will filter out any child jobs if parent subclient job is running or not submitted.
		NOT EXISTS (SELECT 1
			FROM JMVSAAppJobLink VSA
			INNER JOIN JMJobWF WF4 ON WF4.applicationId = VSA.parentAppId AND WF4.processedCommcellId = VSA.commCellId AND WF4.jobId = @injobID AND WF4.processedJobId = VSA.parentJobId
			LEFT OUTER JOIN JMBkpJobInfo JBI ON JBI.applicationId = WF4.applicationId AND JBI.jobId = WF4.childJobId AND WF4.childJobId <> 0
			WHERE WF1.processedJobId = VSA.childJobId AND WF1.processedCommcellId = VSA.commCellId AND WF1.applicationId = VSA.childAppId
				AND (JBI.jobId IS NOT NULL OR WF4.submitStatus <> 2) -- parent job is runnng or not submitted (CVWFJOB_SUBMITTED_COMPLETE)
			)
		AND
		-- this will filter out JMJobWF entry for VSA V2 child job
		NOT EXISTS (SELECT 1 FROM JMJobDataLink LNK
			WHERE WF1.jobId = @injobID
			AND WF1.commcellId = @incommcellID
			AND WF1.processedJobId = LNK.childJobId
			AND WF1.commcellId = LNK.commCellId
			AND LNK.linkType = 7 )  -- LINK_TYPE_FOR_VSA_V2_PARENT_CHILD_DEF
		AND -- for any VSA app aware subclient, only first job met the status criteria will be picked
			(NOT EXISTS (SELECT 1 FROM JMBkpStats JS
				WHERE JS.jobId = WF1.processedJobId AND JS.commCellId = WF1.commcellID
AND (JS.bkpAttributesEx & 0x40000 = 0x40000 OR JS.bkpAttributesEx & CONVERT(BIGINT, 0x20000000000000) = CONVERT(BIGINT, 0x20000000000000)) )  -- JMBKP_EX_VSA_APPAWARE = 0x40000, JMBKP_EX_APPAWARE_CHILD_JOB = 0x20000000000000LL
			OR
			WF1.processedJobId IN (select min( WF5.processedJobId) from JMJobWF WF5
			where WF5.jobId = @injobID AND WF5.commcellId = @incommcellID
			AND WF5.submitStatus = @insubmitStatus group by WF5.applicationId))
		order by WF1.itemId, WF1.applicationId, WF1.step, WF1.processedJobId
	SET NOCOUNT OFF
RETURN @errorReturn;
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetNextJobsToSnapTapeForWF')
	delete from GxQscripts where name = 'JMGetNextJobsToSnapTapeForWF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetNextJobsToSnapTapeForWF')
	delete from GXDBVersions where aliasname = 'JMGetNextJobsToSnapTapeForWF'
GO

insert into GXDBVersions values(2, 'JMGetNextJobsToSnapTapeForWF',  '00010001000400070000', 'JMGetNextJobsToSnapTapeForWF', '00010001000400070000')
GO

