

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetMobileJobControlSettings.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetMobileJobControlSettings.sp,v $ $Id: JMGetMobileJobControlSettings.sp,v 1.4.212.2 2018/03/22 03:01:30 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  JMGetMobileJobControlSettings()
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Bhavyan   				Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetMobileJobControlSettings <<<'

IF EXISTS (select * from sysobjects where name='JMGetMobileJobControlSettings')
	drop procedure JMGetMobileJobControlSettings
IF EXISTS (select * from GxQscripts where name='JMGetMobileJobControlSettings')
	delete from GxQscripts where name = 'JMGetMobileJobControlSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetMobileJobControlSettings')
	delete from GXDBVersions where aliasname = 'JMGetMobileJobControlSettings'
GO
print '... Creating Procedure: JMGetMobileJobControlSettings'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetMobileJobControlSettings
  @inXml XML,
  @outXml XML	OUTPUT
AS
SET NOCOUNT ON
BEGIN
DECLARE @i_userId INT
DECLARE @i_userGuid VARCHAR(36)
DECLARE @i_errorCode INT = 0
DECLARE @i_errorString NVARCHAR(MAX)
DECLARE @i_jobControlSetting NVARCHAR(MAX)
SET   @i_userGUID = ISNULL (( SELECT ref.value('@userGuid', 'VARCHAR(36)')
							  FROM  @inXml.nodes ('JobManager_GetJobControlSettingReq/userInfo') R(ref)), '')
IF (LEN(@i_userGuid) = 0)
BEGIN
	SET @i_errorCode = 1
	SET @i_errorString = 'Invalid User Info'
	GOTO EXIT_ERROR
END
SET @i_userId = ISNULL((SELECT TOP 1 id FROM UMUSERS WHERE userGuid = @i_userGuid) ,0)
IF (@i_userId = 0)
BEGIN
	SET @i_errorCode = 2
	SET @i_errorString = 'User Not Found'
	GOTO EXIT_ERROR
END
DECLARE @userXml XML = (
							SELECT stringVal
							FROM APP_ComponentProp
WHERE componentType = 14
								AND componentId = @i_userId
AND propertyTypeId = 1801
								AND modified = 0
					   )
SET @outXml = (
				SELECT ref.query('*')
				FROM @userXml.nodes('userPreference') R(ref)
				FOR XML PATH('userPreference'), ROOT('JobManager_GetJobControlSettingResp')
			  )
EXIT_ERROR:
	IF @i_errorCode <> 0 OR (@outXml is null)
		SET @outXml = '<JobManager_GetJobControlSettingResp />'
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetMobileJobControlSettings')
	delete from GxQscripts where name = 'JMGetMobileJobControlSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetMobileJobControlSettings')
	delete from GXDBVersions where aliasname = 'JMGetMobileJobControlSettings'
GO

insert into GXDBVersions values(2, 'JMGetMobileJobControlSettings',  '00010004021200020000', 'JMGetMobileJobControlSettings', '00010004021200020000')
GO

