

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetMAWithIndexCache.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--  +========================================================================+
--  |      Name	 :  JMGetMAWithIndexCache
--  |
--  |	   Input :	input XML request
--	 |
--  |      Output:  output XML
--	 |
--  |   Revisions  Author      Description
--  |   ---------  -------  ---------------------------------------------
--  |     1.1      avarsheny  for getting the MA which holds the last successful Index Cache
--  |
--  +========================================================================+
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetMAWithIndexCache.sp,v $ $Id: JMGetMAWithIndexCache.sp,v 1.6.72.3 2020/08/26 14:13:27 pmazur Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetMAWithIndexCache')
BEGIN
	print '>>> Drop Stored Procedure: JMGetMAWithIndexCache <<<'
	drop procedure JMGetMAWithIndexCache
END
IF EXISTS (select * from GxQscripts where name='JMGetMAWithIndexCache')
	delete from GxQscripts where name = 'JMGetMAWithIndexCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetMAWithIndexCache')
	delete from GXDBVersions where aliasname = 'JMGetMAWithIndexCache'
GO
print '... Creating Procedure: JMGetMAWithIndexCache'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetMAWithIndexCache
  @xmlTextInput XML
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE		@i_commCellId		INT
	DECLARE		@i_runningJob     INT
	DECLARE 		@i_jobId 			INT
	DECLARE 		@i_indexType		INT
	DECLARE 		@s_requestorClientName		NVARCHAR(512)
	SET @i_commCellId = ISNULL(( SELECT ref.value('@commCellId', 'int')
							FROM @xmlTextInput.nodes('JobManager_MAWithTheIndexCacheReq') R ( ref ) ), 2)
	SET @i_runningJob = ISNULL(( SELECT ref.value('@runningJob', 'int')
							FROM @xmlTextInput.nodes('JobManager_MAWithTheIndexCacheReq') R ( ref ) ), 1)
	SET @i_jobId = ISNULL(( SELECT ref.value('@jobID', 'int')
							FROM @xmlTextInput.nodes('JobManager_MAWithTheIndexCacheReq') R ( ref ) ), 0)
	SET @i_indexType = ISNULL(( SELECT ref.value('@indexType', 'int')
							FROM @xmlTextInput.nodes('JobManager_MAWithTheIndexCacheReq') R ( ref ) ), 0)
	SET @s_requestorClientName = ISNULL(( SELECT ref.value('@requestorMaClientName', 'NVARCHAR(512)')
							FROM @xmlTextInput.nodes('JobManager_MAWithTheIndexCacheReq') R ( ref ) ), 0)
	DECLARE @IndexType NVARCHAR(8) = ''
	DECLARE @MaName 	NVARCHAR(512) = ''
	IF (@i_jobId = 0)
	BEGIN
		DECLARE @i_appId INT
		SET @i_appId = ISNULL(( SELECT ref.value('@subClientId', 'int')
							FROM @xmlTextInput.nodes('JobManager_MAWithTheIndexCacheReq') R ( ref ) ), 0)
		SET @i_jobId = ISNULL((select TOP(1) jobId from JMBkpStats where commCellId=@i_commCellId AND appId=@i_appId ORDER BY toTime DESC), 0)
	END
	IF (@i_indexType = 6)
	BEGIN
SET @MaName = ISNULL((SELECT attributeValue FROM JMJobOptions WHERE jobId=@i_jobId AND commCellId=@i_commCellId AND attributeId=27), '')
		if @MaName=''
		BEGIN
			-- Change r CTS to return LastSeenMA if JobOption isn't present
			--  it is happening due to fact that backlogged AppAware BackupCopy have no LastSeenMA anymore (more than 7 days passed)
			--  which causing many restarts of the job until completion because of mismatched MAs passed to BCD-IndexRestore and Backup phases
			-- Try to fetch latest BCD IndexRestore MA for this backup copy job if any
			-- if not found - return default MA of the primary copy
			select TOP 1 @MaName=cl.name
			from APP_Client cl WITH(NOLOCK)
join JMJobOptions jo WITH(NOLOCK) on jo.attributeValueInt=cl.id and jo.attributeId=97 -- JM_BCD_INDEX_RESTORE_MA_ID_NAME		"BCD IndexRestore MA ID"
			join JMBkpJobInfo ji WITH(NOLOCK) on ji.jobId=jo.jobId and ji.commcellId=jo.commCellId
			join JMJobInfo jinfo WITH(NOLOCK) on jinfo.jobId=ji.jobId and jinfo.commCellId=ji.commcellId and jinfo.opType=60 -- SNAPTOTAPE
			where ji.jobIdActedOn=@i_jobId and ji.commcellId=@i_commCellId
			order by ji.jobId DESC
			if @MAName='' OR @MaName is NULL
			BEGIN
				select @MaName=cl.name from
				APP_Client cl WITH(NOLOCK)
				join mmdatapath mmd WITH(NOLOCK) on mmd.HostClientId=cl.id
				join archGroup ag WITH(NOLOCK) on ag.defaultCopy=mmd.copyid
				join jmbkpstats js WITH(NOLOCK) on js.logArchGrpId=ag.id or js.dataArchGrpId=ag.id
				where (mmd.flag & 1 >0) and js.jobid=@i_jobId and js.commCellId=@i_commCellId
			END
		END
	END
	ELSE
	BEGIN
SET @MaName = ISNULL((SELECT attributeValue FROM JMJobOptions WHERE jobId=@i_jobId AND commCellId=@i_commCellId AND attributeId=28), '')
	END
	if (EXISTS(
		select TOP 1 ic.IdxCacheId from IdxCache ic, IdxAccessPath ap, IdxAccessPath apRequestor where
			ic.IdxCacheType=1
			and ic.CatalogServerClientId=0
			and ic.IdxCacheId=ap.IdxCacheId
			and ic.IdxCacheId=apRequestor.IdxCacheId
			and
			(
				ap.ClientId=(select top 1 id from app_client with (NOLOCK) where name=@MaName) and ap.Flags=0
			)
			and
			(
				apRequestor.ClientId=(select top 1 id from app_client with (NOLOCK) where name=@s_requestorClientName) and apRequestor.Flags=0
			)
		))
	BEGIN
		SET @MaName=''
	END
	DECLARE @s_mangledName NVARCHAR(512)
	SET @s_mangledName=(select net_hostname+'*'+name+'*'+CAST(cvdport as NVARCHAR(16))+'*'+CAST(evmgrcPort as NVARCHAR(16)) from APP_Client where name=@MaName)
	SELECT @s_mangledName as '@mediaAgentName', @IndexType as '@indexType'
      FOR XML PATH('JobManager_MAWithTheIndexCacheResp')
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetMAWithIndexCache')
	delete from GxQscripts where name = 'JMGetMAWithIndexCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetMAWithIndexCache')
	delete from GXDBVersions where aliasname = 'JMGetMAWithIndexCache'
GO

insert into GXDBVersions values(2, 'JMGetMAWithIndexCache',  '00010006007200030000', 'JMGetMAWithIndexCache', '00010006007200030000')
GO

