

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetLocalizedMessage.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Prakash Varadharajan
--	Date:   02/10/2004
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetLocalizedMessage.sp,v $ $Id: JMGetLocalizedMessage.sp,v 1.2.302.1 2018/03/20 00:40:34 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetLocalizedMessage <<<'

IF EXISTS (select * from sysobjects where name='JMGetLocalizedMessage')
	drop procedure JMGetLocalizedMessage
IF EXISTS (select * from GxQscripts where name='JMGetLocalizedMessage')
	delete from GxQscripts where name = 'JMGetLocalizedMessage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetLocalizedMessage')
	delete from GXDBVersions where aliasname = 'JMGetLocalizedMessage'
GO
print '... Creating Procedure: JMGetLocalizedMessage'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMGetLocalizedMessage
  @localeId INTEGER,
  @messages CHAR(256)
AS
  DECLARE @r_MessageId INTEGER
  DECLARE @r_LocalizedMessage NVARCHAR(4000)
  DECLARE @r_ErrorCode NVARCHAR(4000)
	SET NOCOUNT ON
	DECLARE @msgId varchar(40)
	DECLARE @endIndex integer
	DECLARE @nextIndex integer
	DECLARE @startIndex integer
	SET @startIndex = 0
	SET @r_ErrorCode = ''
	SET @endIndex = CHARINDEX(',', @messages, @startIndex)
	IF (@endIndex IS null OR @endIndex = 0)
	BEGIN
		SELECT 0, @messages, @r_ErrorCode
	END
	ELSE
	BEGIN
		SET @nextIndex = CHARINDEX(',', @messages, @endIndex + 1)
		IF(@nextIndex IS null OR @nextIndex = 0)
		BEGIN
			SET @msgId = SUBSTRING(@messages,@startIndex,@endIndex-@startIndex)
			EXECUTE JMGetFailureReasonText @msgId, @localeId, @r_MessageId output, @r_LocalizedMessage output
			SET @r_ErrorCode = (SELECT '[' + CAST(SubSystemId AS VARCHAR) + ':' + CAST(MessageNum AS VARCHAR) + ']'
								FROM JMFailureReasonMsg, EvLocaleMsgs
								WHERE JMFailureReasonMsg.id = @msgId AND JMFailureReasonMsg.messageId = EvLocaleMsgs.MessageID
								AND EvLocaleMsgs.LocaleId = 0)
			SELECT @r_MessageId, @r_LocalizedMessage, @r_ErrorCode
		END
		ELSE
		BEGIN
			if OBJECT_ID('tempdb.dbo.#MyTempTable') IS NOT null
				DROP TABLE #MyTempTable
			CREATE TABLE #MyTempTable (messageId INT, messageText nvarchar(4000), errorCode varchar(1000))
			WHILE(@endIndex IS NOT null AND @endIndex <> 0)
			BEGIN
				SET @msgId = SUBSTRING(@messages,@startIndex,@endIndex-@startIndex)
				EXECUTE JMGetFailureReasonText @msgId, @localeId, @r_MessageId output, @r_LocalizedMessage output
				SET @r_ErrorCode = (SELECT '[' + CAST(SubSystemId AS VARCHAR) + ':' + CAST(MessageNum AS VARCHAR) + ']'
								FROM JMFailureReasonMsg, EvLocaleMsgs
								WHERE JMFailureReasonMsg.id = @msgId AND JMFailureReasonMsg.messageId = EvLocaleMsgs.MessageID
								AND EvLocaleMsgs.LocaleId = 0)
				INSERT INTO #MyTempTable VALUES (@r_MessageId, @r_LocalizedMessage, @r_ErrorCode)
				SET @startIndex = @endIndex + 1
				SET @endIndex = CHARINDEX(',', @messages, @startIndex)
			END
			SELECT * FROM #MyTempTable
			DROP TABLE #MyTempTable
		END
	END
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetLocalizedMessage')
	delete from GxQscripts where name = 'JMGetLocalizedMessage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetLocalizedMessage')
	delete from GXDBVersions where aliasname = 'JMGetLocalizedMessage'
GO

insert into GXDBVersions values(2, 'JMGetLocalizedMessage',  '00010002030200010000', 'JMGetLocalizedMessage', '00010002030200010000')
GO

