

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetLoadDetail.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetLoadDetail.sp,v $ $Id: JMGetLoadDetail.sp,v 1.9.50.1 2018/03/22 03:18:45 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  JMGetLoadDetail()
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Gokul Pattabiraman   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetLoadDetail <<<'

IF EXISTS (select * from sysobjects where name='JMGetLoadDetail')
	drop procedure JMGetLoadDetail
IF EXISTS (select * from GxQscripts where name='JMGetLoadDetail')
	delete from GxQscripts where name = 'JMGetLoadDetail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetLoadDetail')
	delete from GXDBVersions where aliasname = 'JMGetLoadDetail'
GO
print '... Creating Procedure: JMGetLoadDetail'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetLoadDetail
  @inXmlReq XML,
  @outXmlResp XML	OUTPUT
AS
SET NOCOUNT ON
BEGIN
	DECLARE @currentTime INTEGER
	SET @currentTime = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
	DECLARE @startTime				DATETIME
	DECLARE @endTime				DATETIME
	DECLARE @inStartTime			INTEGER
	DECLARE @inEndTime				INTEGER
	DECLARE @lastNHours				INTEGER = 6 -- Default last six hours
	DECLARE @outputDataInterval		INTEGER
	DECLARE @QNetSyncTimeInterval	NVARCHAR(32)
	DECLARE @everyNthRow			INTEGER
	-- Form the configuration from input XML if present
	SET @inStartTime = ISNULL(( SELECT   ref.value('@fromTime', 'int')
                               FROM     @inXmlReq . nodes('JobManager_LoadDetailReq/timeRange') R ( ref )
                             ), 0)
	SET @inEndTime = ISNULL(( SELECT   ref.value('@toTime', 'int')
                           FROM     @inXmlReq . nodes('JobManager_LoadDetailReq/timeRange') R ( ref )
                         ), 0)
    SET @outputDataInterval = ISNULL(( SELECT   ref.value('@intervalSize', 'int')
                           FROM     @inXmlReq . nodes('JobManager_LoadDetailReq') R ( ref )
                         ), 0)
    IF @outputDataInterval = 0
		SET @outputDataInterval = 1800 -- Default every half an hour
	IF @inStartTime = 0 AND @inEndTime = 0
	BEGIN
		-- Default values
		SET @endTime = DATEADD(s, @currentTime, '1970-01-01 00:00:00')
		SET @startTime = DATEADD(s, (@currentTime - (@lastNHours * 60 * 60)), '1970-01-01 00:00:00')
	END
	ELSE
	BEGIN
		SET @endTime = DATEADD(s, @inEndTime, '1970-01-01 00:00:00')
		SET @startTime = DATEADD(s, @inStartTime, '1970-01-01 00:00:00')
	END
	SELECT @QNetSyncTimeInterval = value
	FROM GXGlobalParam
	WHERE name = 'JMQnetJobStatePopulateInterval'
	IF @QNetSyncTimeInterval IS null
		SET @QNetSyncTimeInterval = '300' -- Default Value if value not set.
	SET @everyNthRow = @outputDataInterval /(CAST(@QNetSyncTimeInterval AS INTEGER))
	IF @everyNthRow = 0
		SET @everyNthRow = 1
	IF OBJECT_ID('tempdb.dbo.#JMJobStateHistory') IS NOT null
				DROP TABLE #JMJobStateHistory
	SELECT ROW_NUMBER() OVER(ORDER BY Modified DESC) AS RowID,*
	INTO #JMJobStateHistory
	FROM JMJobStateHistory WITH(READUNCOMMITTED)
	WHERE Modified > @startTime AND Modified < @endTime
	-- Truncate upto minute part
	UPDATE #JMJobStateHistory
	SET Modified = DATEADD(MINUTE, DATEDIFF(MINUTE, 0, Modified), 0)
	--SET Modified = CAST(CAST(Modified AS varchar(16)) AS DATETIME)
	-- Round off to the nearest 5 mins
	UPDATE #JMJobStateHistory
	SET Modified = CASE
					WHEN (DATEPART(MINUTE, Modified) % 5) <> 0
					THEN DATEADD(MINUTE,(5 - (DATEPART(MINUTE, Modified) % 5)), Modified)
					ELSE Modified
					END
	-- Form the output response
	SET @outXmlResp =
				(
					SELECT
					(
						SELECT DataTransferring AS '@jobsTranferring',
						(CASE WHEN (Running - DataTransferring) < 0 THEN 0 ELSE Running - DataTransferring END) AS '@jobsPreparingToTransfer',
						Waiting AS '@jobsWaiting',
						Pending AS '@jobsPending',
						DATEDIFF(s, '1970-01-01 00:00:00', Modified) AS 'time/@time'
						FROM #JMJobStateHistory
						WHERE (RowId - 1) % @everyNthRow = 0
						ORDER BY RowId DESC
						FOR XML PATH ('loadInfoList'), TYPE
					)
					FOR XML PATH('JobManager_LoadDetailResp'), TYPE
				)
	IF ( @outXmlResp IS null )
			SET @outXmlResp = '<JobManager_LoadDetailResp/>'
	SELECT @outXmlResp
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetLoadDetail')
	delete from GxQscripts where name = 'JMGetLoadDetail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetLoadDetail')
	delete from GXDBVersions where aliasname = 'JMGetLoadDetail'
GO

insert into GXDBVersions values(2, 'JMGetLoadDetail',  '00010009005000010000', 'JMGetLoadDetail', '00010009005000010000')
GO

