

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetLastSuccessfulJobForAppId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--			Author: Divakar Radhakrishnan
--			Date:   16/02/2018
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMGetLastSuccessfulJobForAppId')
BEGIN
	print '>>> Drop Stored Procedure: JMGetLastSuccessfulJobForAppId <<<'
	drop procedure JMGetLastSuccessfulJobForAppId
END
IF EXISTS (select * from GxQscripts where name='JMGetLastSuccessfulJobForAppId')
	delete from GxQscripts where name = 'JMGetLastSuccessfulJobForAppId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetLastSuccessfulJobForAppId')
	delete from GXDBVersions where aliasname = 'JMGetLastSuccessfulJobForAppId'
GO
print '... Creating Procedure: JMGetLastSuccessfulJobForAppId'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMGetLastSuccessfulJobForAppId
  @inAppId INTEGER,
  @inCommcellId INTEGER,
  @inOptype INTEGER,
  @inBkpLevel BIGINT,
  @inBkpAttributes BIGINT,
  @inBkpAttributesEx BIGINT,
  @inSubOpType INTEGER,
  @inExcludeBkpAttributes BIGINT,
  @inExcludeBkpAttributesEx BIGINT,
  @inExcludeSubOpType INTEGER,
  @inExcludeJobWithNoData INTEGER
AS
  DECLARE @outJobID INTEGER
  DECLARE @outCommCellId INTEGER
  DECLARE @outServStartDate INTEGER
  DECLARE @outServEndDate INTEGER
  DECLARE @bkpLevel INTEGER
  DECLARE @bkpAttributesEx BIGINT
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SELECT TOP 1 JMBkpStats.jobId,JMBkpStats.commCellId,JMBkpStats.servStartDate,JMBkpStats.servEndDate, JMBkpStats.bkpLevel, JMBkpStats.bkpAttributesEx
	FROM JMBkpStats WITH(NOLOCK)
		INNER JOIN JMJobStats WITH(NOLOCK)
			ON JMBkpStats.jobId = JMJobStats.jobId AND JMBkpStats.commCellId = JMJobStats.commCellId
	WHERE JMBkpStats.appId = @inAppId AND JMBkpStats.commCellId = @inCommcellId and JMBkpStats.status in (1, 3, 14)
			AND (@inOptype = 0 OR JMBkpStats.opType = @inOptype)
			AND (@inBkpLevel = 0 OR JMBkpStats.bkpLevel = @inBkpLevel)
			AND (@inBkpAttributes = 0 OR (JMBkpStats.bkpattributes & @inBkpAttributes) = @inBkpAttributes)
			AND (@inBkpAttributesEx = 0 OR (JMBkpStats.bkpAttributesEx & @inBkpAttributesEx) = @inBkpAttributesEx)
			AND (@inSubOpType = 0 OR JMJobStats.subOpType = @inSubOpType)
			AND (@inExcludeBkpAttributes = 0 OR (JMBkpStats.bkpattributes & @inExcludeBkpAttributes) = 0)
			AND (@inExcludeBkpAttributesEx = 0 OR (JMBkpStats.bkpAttributesEx & @inExcludeBkpAttributesEx) = 0)
			AND (@inExcludeSubOpType = 0 OR JMJobStats.subOpType <> @inExcludeSubOpType)
			AND (@inExcludeJobWithNoData = 0 OR JMBkpStats.totalUncompBytes > 0)
	ORDER BY servEndDate DESC
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetLastSuccessfulJobForAppId')
	delete from GxQscripts where name = 'JMGetLastSuccessfulJobForAppId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetLastSuccessfulJobForAppId')
	delete from GXDBVersions where aliasname = 'JMGetLastSuccessfulJobForAppId'
GO

insert into GXDBVersions values(2, 'JMGetLastSuccessfulJobForAppId',  '00000000000000000000', 'JMGetLastSuccessfulJobForAppId', '00000000000000000000')
GO

