

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetLastSuccessfulBkpTimeForSysStateBkp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +===================================================================================================+
--  |   Procedure:  JMGetLastSuccessfulBkpTimeForSysStateBkp()
--  |
--  | Description:  Select last successful backup time for system state subclient or 0 is there is none.
--  |
--  |       Input:  backupSetId, fromTime, toTime
--  |
--  |      Output:  last successful backuptime or 0 if not available.
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------------------	        --------------------------------
--  |   1.1        Jawahar Ragunathan           Initial Edit
--  +===================================================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetLastSuccessfulBkpTimeForSysStateBkp')
BEGIN
	print '>>> Drop Stored Procedure: JMGetLastSuccessfulBkpTimeForSysStateBkp <<<'
	drop procedure JMGetLastSuccessfulBkpTimeForSysStateBkp
END
IF EXISTS (select * from GxQscripts where name='JMGetLastSuccessfulBkpTimeForSysStateBkp')
	delete from GxQscripts where name = 'JMGetLastSuccessfulBkpTimeForSysStateBkp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetLastSuccessfulBkpTimeForSysStateBkp')
	delete from GXDBVersions where aliasname = 'JMGetLastSuccessfulBkpTimeForSysStateBkp'
GO
print '... Creating Procedure: JMGetLastSuccessfulBkpTimeForSysStateBkp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetLastSuccessfulBkpTimeForSysStateBkp
  @i_commcellId INT,
  @i_backupSetId INT,
  @i_subclientId INT,
  @i_fromTime INT,
  @i_toTime INT
AS
  DECLARE @o_toTime INT
  DECLARE @o_spSummary nvarchar(512)
SET NOCOUNT ON
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @archiveIndexPhase INT
	DECLARE @recentDisplayStatus INT
	DECLARE @recentJobId INT
	DECLARE @recentToTime INT
	--output toTime is likely modified only when system state backup jobs are found and if the last job is committed
	SET @o_toTime = @i_toTime
	SET @o_spSummary = ''
	IF @i_subclientId = 0
	BEGIN
		SET @o_spSummary = @o_spSummary + 'Subclient ID passed is [0]. '
		SELECT TOP 1 @i_subclientId = JBS.appId
			FROM JMBkpStats JBS WITH(NOLOCK)
				INNER JOIN APP_Application APP WITH(NOLOCK)
					ON APP.id = JBS.appId AND APP.backupSet = @i_backupSetId
					AND (JBS.bkpattributes & 0x100000) <> 0	AND JBS.status IN (1,3,14) AND JBS.displayStatus <> 16
					AND JBS.servStartDate >= @i_fromTime AND JBS.servEndDate <= @i_toTime AND JBS.commCellId = @i_commcellId AND JBS.dataStatus = 0 --DATA_STATUS_VALID
			ORDER BY JBS.servEndDate DESC
	END
	ELSE
	BEGIN
		IF NOT EXISTS(SELECT 0 FROM JMBkpStats WITH(NOLOCK)
							WHERE appid = @i_subclientId AND (bkpattributes & 0x100000) <> 0 AND status IN (1,3,14) AND displayStatus <> 16
								AND servStartDate >= @i_fromTime AND servEndDate <= @i_toTime AND commCellId = @i_commcellId AND dataStatus = 0 --DATA_STATUS_VALID
						)
		BEGIN
			SET @o_toTime = @i_toTime
			SET @o_spSummary = @o_spSummary + 'Subclient ID passed [' + CAST(@i_subclientId AS nvarchar(32)) + '] does not have a valid system state backup.'
			GOTO proc_exit
		END
	END
	SET @o_spSummary = @o_spSummary + 'Subclient ID is [' + CAST(@i_subclientId AS nvarchar(32)) + ']. '
	--no valid sys state bkp in time range
	IF @i_subclientId = 0
	BEGIN
		SET @o_spSummary = @o_spSummary + 'Not able to find a valid system state backup in the given time range [' + CAST(@i_fromTime AS nvarchar(32)) + '] to [' + CAST(@i_toTime AS nvarchar(32)) + '].'
		SET @o_toTime = @i_toTime
		GOTO proc_exit
	END
	SELECT TOP 1 @recentDisplayStatus = displayStatus, @recentJobId = jobId, @recentToTime = servEndDate
		FROM JMBkpStats WITH(NOLOCK)
			WHERE servStartDate >= @i_fromTime AND servEndDate <= @i_toTime AND commCellId = @i_commcellId
					AND appId = @i_subclientId AND status IN (1,3,14) AND dataStatus = 0 --DATA_STATUS_VALID
		ORDER BY servEndDate DESC
	IF (@recentDisplayStatus IS NULL)
	BEGIN
		SET @o_toTime = @i_toTime
		SET @o_spSummary = @o_spSummary + 'No valid backup job found for the subclient in the given time range [' + CAST(@i_fromTime AS nvarchar(32)) + '] to [' + CAST(@i_toTime AS nvarchar(32)) + '].'
	END
	ELSE IF (@recentDisplayStatus = 16)
	BEGIN
		SET @o_spSummary = @o_spSummary + 'The last job found [' + CAST(@recentJobId AS nvarchar(32)) + '] is committed, hence moving to previous job. '
		SET @o_toTime = 0
		SELECT TOP 1 @o_toTime = servEndDate, @recentJobId = jobId
			FROM JMBkpStats WITH(NOLOCK)
				WHERE appId = @i_subclientId
					AND displayStatus <> 16 AND status IN (1,3,14) AND servStartDate >= @i_fromTime AND servEndDate <= @i_toTime AND commCellId = @i_commcellId AND dataStatus = 0 --DATA_STATUS_VALID
			ORDER BY servEndDate DESC
		IF (@o_toTime = 0)
			SET @o_spSummary = @o_spSummary + 'Not able to find valid backup job for the subclient in the given time range [' + CAST(@i_fromTime AS nvarchar(32)) + '] to [' + CAST(@i_toTime AS nvarchar(32)) + '].'
		ELSE
			SET @o_spSummary = @o_spSummary + 'Previous backup job [' + CAST(@recentJobId AS nvarchar(32)) + '], that has to time [' + CAST(@o_toTime AS nvarchar(32)) + '] is a valid job.'
	END
	ELSE
	BEGIN
		SET @o_toTime = @i_toTime
		SET @o_spSummary = @o_spSummary + 'The recent backup job [' + CAST(@recentJobId AS nvarchar(32)) + '] that has to time [' + CAST(@recentToTime AS nvarchar(32)) + '] is valid.'
	END
	proc_exit:
	SELECT @o_toTime, @o_spSummary
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetLastSuccessfulBkpTimeForSysStateBkp')
	delete from GxQscripts where name = 'JMGetLastSuccessfulBkpTimeForSysStateBkp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetLastSuccessfulBkpTimeForSysStateBkp')
	delete from GXDBVersions where aliasname = 'JMGetLastSuccessfulBkpTimeForSysStateBkp'
GO

insert into GXDBVersions values(2, 'JMGetLastSuccessfulBkpTimeForSysStateBkp',  '00000000000000000000', 'JMGetLastSuccessfulBkpTimeForSysStateBkp', '00000000000000000000')
GO

