

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetLastMAParamForNAS.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +=================================================================================+
--  |   Procedure:  JMGetLastMAParamForNAS()
--  |
--  | Description:  Returns media agent that was used in the last backup attempt of
--  |				previous job in current cycle
--  |
--  |       Input:  commcellId, appId, opType, i_currentPhase
--  |
--  |      Output:  Last used media agent name
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------------------	        --------------------------------
--  |   1.1        Jawahar Ragunathan           Initial Edit
--  +=================================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetLastMAParamForNAS')
BEGIN
	print '>>> Drop Stored Procedure: JMGetLastMAParamForNAS <<<'
	drop procedure JMGetLastMAParamForNAS
END
IF EXISTS (select * from GxQscripts where name='JMGetLastMAParamForNAS')
	delete from GxQscripts where name = 'JMGetLastMAParamForNAS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetLastMAParamForNAS')
	delete from GXDBVersions where aliasname = 'JMGetLastMAParamForNAS'
GO
print '... Creating Procedure: JMGetLastMAParamForNAS'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetLastMAParamForNAS
  @i_commcellId INT,
  @i_jobId BIGINT,
  @i_appId INT,
  @i_opType INT,
  @i_currentPhase INT,
  @i_bkpLevel INT
AS
  DECLARE @lastJobId BIGINT
  DECLARE @lastMAParam nvarchar(MAX)
SET NOCOUNT ON
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @lastJob INT = 0;
	DECLARE @currentCycle INT = 0;
	DECLARE @mediaAgentId INT = 0;
	DECLARE @outParam nvarchar(MAX) = '';
	IF @i_bkpLevel = 1
		GOTO proc_exit;
	SELECT @currentCycle = ISNULL(attrVal,0) FROM APP_SubClientProp (NOLOCK) WHERE componentNameId = @i_appId AND attrName = 'sys:full cycle num' AND modified = 0
	IF @currentCycle = 0
		GOTO proc_exit;
	IF @i_opType = 4
	BEGIN
		SELECT TOP 1 @lastJob = ISNULL(jobId,0) FROM JMBkpStats (NOLOCK)
			WHERE appId = @i_appId AND commCellId = @i_commcellId AND opType = @i_opType AND fullCycleNum = @currentCycle AND status IN (1,3,14)
				ORDER BY servEndDate DESC
	END
	ELSE IF @i_opType = 60
	BEGIN
		DECLARE @snapJobId INT = 0;
		SELECT TOP 1 @lastJob = jobId, @snapJobId = jobIdActedOn FROM JMBkpStats (NOLOCK)
			WHERE appId = @i_appId AND commCellId = @i_commcellId AND opType = @i_opType AND status IN (1,3,14)
				ORDER BY servEndDate DESC
		IF NOT EXISTS (SELECT 1 FROM JMBkpStats (NOLOCK) WHERE jobId = @snapJobId AND fullCycleNum = @currentCycle)
			GOTO proc_exit;
	END
	IF @lastJob = 0
		GOTO proc_exit;
SELECT @mediaAgentId = intData FROM JMMisc (NOLOCK) WHERE jobId = @lastJob AND commcellId = @i_commcellId AND itemType = 83
proc_exit:
	SELECT @outParam = ISNULL(name,'') FROM APP_Client (NOLOCK) WHERE id = @mediaAgentId
	SET @outParam += ':';
	SET @mediaAgentId = 0;
SELECT @mediaAgentId = intData FROM JMMisc (NOLOCK) WHERE jobId = @i_jobId AND commcellId = @i_commcellId AND itemType = 83
	SELECT @outParam += ISNULL(name,'') FROM APP_Client (NOLOCK) WHERE id = @mediaAgentId
	SELECT @lastJob as 'lastJobId', @outParam as 'lastMAParam'
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetLastMAParamForNAS')
	delete from GxQscripts where name = 'JMGetLastMAParamForNAS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetLastMAParamForNAS')
	delete from GXDBVersions where aliasname = 'JMGetLastMAParamForNAS'
GO

insert into GXDBVersions values(2, 'JMGetLastMAParamForNAS',  '00000000000000000000', 'JMGetLastMAParamForNAS', '00000000000000000000')
GO

