

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetLastJobWithBackupCopyDone.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetLastJobWithBackupCopyDone.sp,v $ $Id: JMGetLastJobWithBackupCopyDone.sp,v 1.1.4.3 2018/03/22 03:02:53 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "JMGetLastJobWithBackupCopyDone"
--	|	This stored procedure gets last jobid for which backup copy is done or synthFull job
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetLastJobWithBackupCopyDone <<<'

IF EXISTS (select * from sysobjects where name='JMGetLastJobWithBackupCopyDone')
	drop procedure JMGetLastJobWithBackupCopyDone
IF EXISTS (select * from GxQscripts where name='JMGetLastJobWithBackupCopyDone')
	delete from GxQscripts where name = 'JMGetLastJobWithBackupCopyDone'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetLastJobWithBackupCopyDone')
	delete from GXDBVersions where aliasname = 'JMGetLastJobWithBackupCopyDone'
GO
print '... Creating Procedure: JMGetLastJobWithBackupCopyDone'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetLastJobWithBackupCopyDone
-- Input arguments
  @i_subClientId integer,
  @i_commcellId integer
AS
  DECLARE @o_lastJobId integer --Last job with backup copy done or SynthFull job
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
/*
	MR 202471: For Block level backups, last job id with backup copy done or if last job is synthfull then their job is is required.
*/
DECLARE @bkpAttributeEx BIGINT = 0
DECLARE @snapToTapeArchiveIndexPhase INT = 0
DECLARE @snapToTapeArchiveIndexPhaseType INT = 0x600000 -- (JM_PHASE_TYPE_SNAPTAPE_PHASE_OF_SNAPBACKUP | JM_PHASE_TYPE_ARCHIVE_INDEX)
DECLARE @fullCycleNum INT = 0
SET @fullCycleNum = ISNULL((SELECT attrVal from APP_SubClientProp where attrName='sys:full cycle num' and componentNameId=@i_subClientId and modified=0),0)
if OBJECT_ID('tempdb.dbo.#snapJobIds') is not null drop table dbo.#snapJobIds
create table #snapJobIds
(
	jobId BIGINT,
	bkpAttributeEx BIGINT,
	servEndDate BIGINT
);
SELECT @snapToTapeArchiveIndexPhase =  P.phase
FROM JMPhase P
INNER JOIN JMOpTable O ON P.opTableId = O.id
INNER JOIN APP_Application A ON O.appTypeType = A.appTypeId
WHERE A.id = @i_subClientId
AND O.operation = 59 -- SNAPBACKUP
AND P.phaseType & @snapToTapeArchiveIndexPhaseType = @snapToTapeArchiveIndexPhaseType
--When backup copy is run in same job, then we need to cehck if ArchiveIndex phase of backup copy has been run
INSERT INTO #snapJobIds
(jobId,bkpAttributeEx,servEndDate)
SELECT TOP 1  BkpStats.jobId, BkpStats.bkpAttributesEx,BkpStats.servEndDate
		FROM JMBkpStats BkpStats
          WHERE BkpStats.appid = @i_subClientId AND BkpStats.commCellId = @i_commcellId AND
BkpStats.status in (1,3,14) AND ((BkpStats.opType = 59 AND ((BkpStats.bkpAttributesEx & 0x800000) <> 0)
							AND EXISTS ( SELECT 1 FROM JMBkpAtmptStats attemptStat WHERE BkpStats.jobId = attemptStat.jobId AND BkpStats.commCellId = attemptStat.commCellId
											AND attemptStat.phase = @snapToTapeArchiveIndexPhase AND attemptStat.status in (1,3,14))))
			AND BkpStats.dataStatus = 0 /*DATA_STATUS_VALID*/
			AND BkpStats.fullCycleNum = @fullCycleNum
		ORDER BY BkpStats.servEndDate DESC
--When backup copy is run as separate job
INSERT INTO #snapJobIds
(jobId,bkpAttributeEx,servEndDate)
SELECT TOP 1 SNAP.jobId, BCOPY.bkpAttributesEx,BCOPY.servEndDate
		FROM JMBkpStats BCOPY INNER JOIN JMBkpStats SNAP
		ON BCOPY.jobIdActedOn=SNAP.jobId AND  SNAP.opType=59 AND BCOPY.opType=60 AND BCOPY.dataStatus=0
        AND BCOPY.appId=SNAP.appId AND BCOPY.commCellId=SNAP.commCellId
		WHERE BCOPY.appid = @i_subClientId AND BCOPY.commCellId = @i_commcellId
			AND BCOPY.status in (1,3,14)
			AND BCOPY.dataStatus = 0 /*DATA_STATUS_VALID*/
			AND SNAP.fullCycleNum = @fullCycleNum
		ORDER BY BCOPY.servEndDate DESC
--If the last job was synthFull job
INSERT INTO #snapJobIds(jobId,bkpAttributeEx,servEndDate)
SELECT TOP 1 jmstats.jobId, jmstats.bkpAttributesEx,jmstats.servEndDate
		FROM JMBkpStats jmstats
		WHERE jmstats.appid = @i_subClientId AND jmstats.commCellId = @i_commcellId
		AND jmstats.status in (1,3,14)
		AND jmstats.bkpLevel IN(64,128)
		AND jmstats.dataStatus = 0 /*DATA_STATUS_VALID*/
		AND jmstats.fullCycleNum = @fullCycleNum
		AND jmstats.cycleSequence = 1
		ORDER BY jmstats.servEndDate DESC
-- select the job which has max end time for latest
SELECT TOP 1 @o_lastJobId = jobId, @bkpAttributeEx  = bkpAttributeEx
		FROM #snapJobIds
		ORDER BY servEndDate DESC
SELECT ISNULL(@o_lastJobId ,0)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SELECT 0
END CATCH
if OBJECT_ID('tempdb.dbo.#snapJobIds') is not null drop table dbo.#snapJobIds
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetLastJobWithBackupCopyDone')
	delete from GxQscripts where name = 'JMGetLastJobWithBackupCopyDone'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetLastJobWithBackupCopyDone')
	delete from GXDBVersions where aliasname = 'JMGetLastJobWithBackupCopyDone'
GO

insert into GXDBVersions values(2, 'JMGetLastJobWithBackupCopyDone',  '00010001000400030000', 'JMGetLastJobWithBackupCopyDone', '00010001000400030000')
GO

