

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetLastIncrJobWithBackupCopyDone.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetLastIncrJobWithBackupCopyDone.sp,v $ $Id: JMGetLastIncrJobWithBackupCopyDone.sp,v 1.1.2.12 2020/07/28 01:59:37 pmazur Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "JMGetLastIncrJobWithBackupCopyDone"
--	|	This stored procedure gets last incremental jobid for which backup copy is done
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetLastIncrJobWithBackupCopyDone')
BEGIN
	print '>>> Drop Stored Procedure: JMGetLastIncrJobWithBackupCopyDone <<<'
	drop procedure JMGetLastIncrJobWithBackupCopyDone
END
IF EXISTS (select * from GxQscripts where name='JMGetLastIncrJobWithBackupCopyDone')
	delete from GxQscripts where name = 'JMGetLastIncrJobWithBackupCopyDone'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetLastIncrJobWithBackupCopyDone')
	delete from GXDBVersions where aliasname = 'JMGetLastIncrJobWithBackupCopyDone'
GO
print '... Creating Procedure: JMGetLastIncrJobWithBackupCopyDone'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetLastIncrJobWithBackupCopyDone
-- Input arguments
  @i_subClientId integer,
  @i_commcellId integer
AS
  DECLARE @o_snapJobId integer
  DECLARE @o_isBlockLevel integer
  DECLARE @o_isMetadataCollected integer	
  DECLARE @o_DestinationCopyID integer	
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
DECLARE @bkpAttributeEx BIGINT = 0
DECLARE @snapToTapeArchiveIndexPhase INT = 0
DECLARE @snapToTapeArchiveIndexPhaseType INT = 0x600000 -- (JM_PHASE_TYPE_SNAPTAPE_PHASE_OF_SNAPBACKUP | JM_PHASE_TYPE_ARCHIVE_INDEX)
DECLARE @fullCycleNum INT = 0
SET @fullCycleNum = ISNULL((SELECT attrVal from APP_SubClientProp where attrName='sys:full cycle num' and componentNameId=@i_subClientId and modified=0),0)
if OBJECT_ID('tempdb.dbo.#snapJobIds') is not null drop table dbo.#snapJobIds
create table #snapJobIds
(
	jobId BIGINT,
	bkpAttributeEx BIGINT,
	servEndDate BIGINT
);
SELECT @snapToTapeArchiveIndexPhase =  P.phase
FROM JMPhase P
INNER JOIN JMOpTable O ON P.opTableId = O.id
INNER JOIN APP_Application A ON O.appTypeType = A.appTypeId
WHERE A.id = @i_subClientId
AND O.operation = 59 -- SNAPBACKUP
AND P.phaseType & @snapToTapeArchiveIndexPhaseType = @snapToTapeArchiveIndexPhaseType
--When backup copy is run in same job, then we need to cehck if ArchiveIndex phase of backup copy has been run
INSERT INTO #snapJobIds
(jobId,bkpAttributeEx,servEndDate)
SELECT TOP 1  BkpStats.jobId, BkpStats.bkpAttributesEx,BkpStats.servEndDate
		FROM JMBkpStats BkpStats
          WHERE BkpStats.appid = @i_subClientId AND BkpStats.commCellId = @i_commcellId AND
BkpStats.status in (1,3,14) AND ((BkpStats.opType = 59 AND ((BkpStats.bkpAttributesEx & 0x800000) <> 0)
							AND EXISTS ( SELECT 1 FROM JMBkpAtmptStats attemptStat WHERE BkpStats.jobId = attemptStat.jobId AND BkpStats.commCellId = attemptStat.commCellId
											AND attemptStat.phase = @snapToTapeArchiveIndexPhase AND attemptStat.status in (1,3,14))))
			AND BkpStats.bkpLevel = 2
			AND BkpStats.dataStatus = 0 /*DATA_STATUS_VALID*/
			AND BkpStats.fullCycleNum = @fullCycleNum
		ORDER BY BkpStats.servEndDate DESC
--When backup copy is run as separate job
INSERT INTO #snapJobIds
(jobId,bkpAttributeEx,servEndDate)
SELECT TOP 1 SNAP.jobId, BCOPY.bkpAttributesEx,BCOPY.servEndDate
		FROM JMBkpStats BCOPY INNER JOIN JMBkpStats SNAP
		ON BCOPY.jobIdActedOn=SNAP.jobId AND  SNAP.opType=59 AND BCOPY.opType=60 AND BCOPY.dataStatus=0
        AND BCOPY.appId=SNAP.appId AND BCOPY.commCellId=SNAP.commCellId
		WHERE BCOPY.appid = @i_subClientId AND BCOPY.commCellId = @i_commcellId
			AND BCOPY.status in (1,3,14)
			AND BCOPY.bkpLevel = 2
			AND BCOPY.dataStatus = 0 /*DATA_STATUS_VALID*/
			AND SNAP.fullCycleNum = @fullCycleNum
		ORDER BY BCOPY.servEndDate DESC
-- select the job which has max end time for latest
SELECT TOP 1 @o_snapJobId = jobId, @bkpAttributeEx  = bkpAttributeEx
		FROM #snapJobIds
		ORDER BY servEndDate DESC
SET @o_isBlockLevel			= (@bkpAttributeEx & 0x10)
DECLARE @isCatalogedOffline integer = 0;
SET @isCatalogedOffline =  CASE  WHEN EXISTS (
								select 1 from archFile af1 WITH(NOLOCK) where af1.jobId=@o_snapJobId and af1.commcellid=@i_commcellId and af1.fileType=9 and af1.isValid=1
							)  THEN 1 ELSE 0 END
-- fileType 9 == CVA_DATATYPE_FILE_INDEX
SET @o_isMetadataCollected	=  CASE WHEN (((@bkpAttributeEx & 0x40) <> 0)  OR (@isCatalogedOffline > 0)) THEN 1 else 0 END
SET @o_DestinationCopyID = ISNULL((SELECT TOP 1 AG.defaultCopy
		FROM   JMJobDataStats JDS WITH (NOLOCK) INNER JOIN archGroup AG WITH (NOLOCK)
				ON  JDS.jobId = @o_snapJobId AND JDS.archGrpId = AG.id AND JDS.archGrpCopyId = AG.defaultCopy),0)
SELECT @o_snapJobId, @o_isBlocklevel, @o_isMetadataCollected, @o_DestinationCopyID
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SELECT 0, 0, 0, 0
END CATCH
if OBJECT_ID('tempdb.dbo.#snapJobIds') is not null drop table dbo.#snapJobIds
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetLastIncrJobWithBackupCopyDone')
	delete from GxQscripts where name = 'JMGetLastIncrJobWithBackupCopyDone'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetLastIncrJobWithBackupCopyDone')
	delete from GXDBVersions where aliasname = 'JMGetLastIncrJobWithBackupCopyDone'
GO

insert into GXDBVersions values(2, 'JMGetLastIncrJobWithBackupCopyDone',  '00010001000200120000', 'JMGetLastIncrJobWithBackupCopyDone', '00010001000200120000')
GO

