

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetLastDependentJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetLastDependentJob.sp,v $ $Id: JMGetLastDependentJob.sp,v 1.4.60.2 2018/03/22 02:58:25 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "JMGetLastDependentJob"				|
--	|									|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetLastDependentJob <<<'

IF EXISTS (select * from sysobjects where name='JMGetLastDependentJob')
	drop procedure JMGetLastDependentJob
IF EXISTS (select * from GxQscripts where name='JMGetLastDependentJob')
	delete from GxQscripts where name = 'JMGetLastDependentJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetLastDependentJob')
	delete from GXDBVersions where aliasname = 'JMGetLastDependentJob'
GO
print '... Creating Procedure: JMGetLastDependentJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMGetLastDependentJob
  @inJobId integer,
  @inAppType integer,
  @inOpType integer,
  @inphaseNum integer
AS
  DECLARE @outJobId integer
BEGIN TRY
if object_id('tempdb.dbo.#edcRunningJobs') is not null	DROP TABLE #edcRunningJobs
CREATE TABLE #edcRunningJobs(JobId INTEGER)
if object_id('tempdb.dbo.#edcDependentJobs') is not null	DROP TABLE #edcDependentJobs
CREATE TABLE #edcDependentJobs(JobId INTEGER)
--Step1: Get list of EDC jobs running phase2
INSERT INTO #edcRunningJobs
SELECT jobId FROM JMJobInfo Where opType = @inOpType AND currentPhase = @inphaseNum and jobId <> @inJobId
and commCellId = 2
--Step2: Insert the jobs from jmdepencytriggertable. So there are some jobs waiting for these jobs to finish
INSERT INTO #edcDependentJobs
SELECT jobId FROM JMDependencyTriggerTable where jobId in (select jobId from #edcRunningJobs)
--Step3: Insert the jobs from jmdepencytriggertable. So there are some jobs waiting for these jobs to finish
INSERT INTO #edcDependentJobs
SELECT jobId FROM JMDependencyTable where jobId in (select jobId from #edcRunningJobs)
--Step4: If there are no jobs in #edcDependentJobs table then select those jobs in jmjobinfo table and this should be
-- the second job
IF NOT EXISTS(SELECT *FROM #edcDependentJobs)
INSERT INTO #edcDependentJobs
SELECT jobId FROM JMJobInfo Where opType = @inOpType AND currentPhase = @inphaseNum and jobId <> @inJobId
and commCellId = 2
-- Return the dependent jobs
SELECT distinct jobId From #edcDependentJobs
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Error -- Assumming there may not be any exception
	SELECT 0
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetLastDependentJob')
	delete from GxQscripts where name = 'JMGetLastDependentJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetLastDependentJob')
	delete from GXDBVersions where aliasname = 'JMGetLastDependentJob'
GO

insert into GXDBVersions values(2, 'JMGetLastDependentJob',  '00010004006000020000', 'JMGetLastDependentJob', '00010004006000020000')
GO

