

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetJobsWithCIStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--						Author: Gokul Pattabiraman
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetJobsWithCIStatus <<<'

IF EXISTS (select * from sysobjects where name='JMGetJobsWithCIStatus')
	drop procedure JMGetJobsWithCIStatus
IF EXISTS (select * from GxQscripts where name='JMGetJobsWithCIStatus')
	delete from GxQscripts where name = 'JMGetJobsWithCIStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobsWithCIStatus')
	delete from GXDBVersions where aliasname = 'JMGetJobsWithCIStatus'
GO
print '... Creating Procedure: JMGetJobsWithCIStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetJobsWithCIStatus
  @inSubClientID INT,
  @inFromTime INT,
  @inToTime INT
AS
  DECLARE @outJobID INT
  DECLARE @outCommCellID INT
  DECLARE @outCIStatus INT
  DECLARE @outjobEndTime INT
  DECLARE @outBkpLevel INT
  DECLARE @outIsAged INT
  DECLARE @outEngineType NVARCHAR(1024)
DECLARE @jobTbl TABLE
( jobId	INT, commCellId INT, CIStatus INT, jobEndTime INT, bkpLevel INT, outIsAged INT, cloudId INT)
INSERT INTO @jobTbl
SELECT AF.jobId, AF.commCellId , MAX(AF.flags & 496), BKP.servEndDate,  BKP.bkpLevel , BKP.agedTime, MAX(AF.cloudId)
FROM JMBkpStats BKP WITH (NOLOCK)
INNER JOIN archFile AF WITH (NOLOCK) ON BKP.jobId = AF.jobId AND BKP.commCellId = AF.commCellId
WHERE
(
	(@inToTime =  0 AND BKP.servEndDate > @inFromTime) OR
	(BKP.servEndDate > @inFromTime AND BKP.servEndDate <= @inToTime)
)
AND BKP.appId = @inSubClientID
AND BKP.status IN (1, 3, 14) --typedef enum CVJobStatus{ JMSUCCESS=1, PARTIALSUCCESS=3, JMSUCCESSWITHWARNINGS = 14,
AND AF.isValid = 1
GROUP BY AF.jobId, AF.commCellId, BKP.servEndDate, BKP.bkpLevel, BKP.agedTime
INSERT INTO @jobTbl
SELECT AF.jobId, AF.commCellId , MAX(AF.flags & 496), LH.servEnd,  LH.ER_BkpLevel , LH.dataStatus, MAX(AF.cloudId)
FROM JMAdminJobStatsTable LH WITH (NOLOCK)
INNER JOIN archFile AF WITH (NOLOCK) ON LH.jobId = AF.jobId AND LH.commCellId = AF.commCellId
WHERE
(
	(@inToTime =  0 AND LH.servEnd > @inFromTime) OR
	(LH.servEnd > @inFromTime AND LH.servEnd <= @inToTime)
)
AND LH.appId = @inSubClientID
AND LH.status IN (1, 3, 14) --typedef enum CVJobStatus{ JMSUCCESS=1, PARTIALSUCCESS=3, JMSUCCESSWITHWARNINGS = 14,
AND AF.isValid = 1
GROUP BY AF.jobId, AF.commCellId, LH.servEnd, LH.ER_BkpLevel, LH.dataStatus
SELECT T.jobId, T.commCellId, T.CIStatus, T.jobEndTime, T.bkpLevel,
case
   When T.outIsAged IN(1,2) Then 1
   Else	0
   End,
   ISNULL((select stringVal From APP_ComponentProp(NOLOCK) comp Where comp.propertyTypeId = 1014 AND comp.componentId = T.cloudId), '')
FROM @jobTbl T
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'JMGetJobsWithCIStatus')
	delete from GxQscripts where name = 'JMGetJobsWithCIStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobsWithCIStatus')
	delete from GXDBVersions where aliasname = 'JMGetJobsWithCIStatus'
GO

insert into GXDBVersions values(2, 'JMGetJobsWithCIStatus',  '00000000000000000000', 'JMGetJobsWithCIStatus', '00000000000000000000')
GO

