

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetJobsToControl.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  JMGetJobsToControl()
--  |
--  | Description:  Gives the job IDs for the given userId, entityType and entityId
--  |
--  |       Input:  userId, entityType and entityId
--  |
--  |      Output:  Job IDs
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------------------	        --------------------------------
--  |   1.1        Jawahar Ragunathan           Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetJobsToControl <<<'

IF EXISTS (select * from sysobjects where name='JMGetJobsToControl')
	drop procedure JMGetJobsToControl
IF EXISTS (select * from GxQscripts where name='JMGetJobsToControl')
	delete from GxQscripts where name = 'JMGetJobsToControl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobsToControl')
	delete from GXDBVersions where aliasname = 'JMGetJobsToControl'
GO
print '... Creating Procedure: JMGetJobsToControl'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetJobsToControl
  @i_userId INT,
  @i_entityType INT,
  @i_entityId INT
AS
  DECLARE @jobID INTEGER
SET NOCOUNT ON
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_Bkp') IS NOT NULL DROP TABLE #SecIDANodeAccessTemp_Bkp
	IF OBJECT_ID(N'tempdb.dbo.#JMCanManageJob_adminObject') IS NOT NULL DROP TABLE #JMCanManageJob_adminObject
	IF OBJECT_ID(N'tempdb.dbo.#JMCanManageJob_rstObject') IS NOT NULL DROP TABLE #JMCanManageJob_rstObject
	IF OBJECT_ID(N'tempdb.dbo.#RunningJobs') IS NOT NULL DROP TABLE #RunningJobs
	CREATE TABLE #SecIDANodeAccessTemp_Bkp
	(
		t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
	)
	CREATE NONCLUSTERED INDEX [#SecIDANodeAccessTemp_Bkp_ClientID] ON [#SecIDANodeAccessTemp_Bkp]([t_clientId] ASC)
	CREATE NONCLUSTERED INDEX [#SecIDANodeAccessTemp_Bkp_subclientId] ON [#SecIDANodeAccessTemp_Bkp]([t_subclientId] ASC)
create table  #JMCanManageJob_adminObject ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
create table  #JMCanManageJob_rstObject ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	CREATE TABLE #RunningJobs(JobID INTEGER,
							opType INTEGER,
							userID INTEGER,
							commCellID INTEGER,
							clientID INTEGER,
							appTypeID INTEGER,
							instance INTEGER,
							backUpSetID INTEGER,
							applicationID INTEGER,
							workFlowID INTEGER,
							archGroupId INTEGER,
							jobType INTEGER) --enum CVJobType, 0 is any other jobs
	-- POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_BACKUP-1)| POWER(2,EV_RESTORE_IN_PLACE-1) | POWER(2,EV_RESTORE_OUTOF_PLACE-1) | POWER(2,EV_BROWSE-1)| POWER(2,EV_RUN_REPORTS-1) | POWER(2,EV_VISIBILITY-1)
	exec sec_getIdaObjectsForUser @i_userId,7,0,0,'#SecIDANodeAccessTemp_Bkp',0,'16,12,20,22,13,15,31',0
	exec sec_getUserObjects @i_userId,2013,0,'#JMCanManageJob_adminObject'
    exec sec_getUserObjects @i_userId,14033,0,'#JMCanManageJob_adminObject'
    exec sec_getUserObjects @i_userId,2231,0,'#JMCanManageJob_adminObject'
	exec sec_getUserObjects @i_userId,2012,0,'#JMCanManageJob_rstObject'
	DECLARE @adminCap INTEGER
		SET @adminCap = POWER(2,1-1) | POWER(2,16-1) | POWER(2,4-1) | POWER(2,8-1) | POWER(2,31-1)
		--POWER(2,EV_SCHEDULE_ADMIN-1) | POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_MANAGE_ARCHIVES-1) | POWER(2,EV_MANAGE_LIBRARY-1) | POWER(2,EV_VISIBILITY-1)
	DECLARE @restoreCap INTEGER
		SET @restoreCap = POWER(2,16-1) | POWER(2,20-1) | POWER(2,22-1) | POWER(2,31-1)
		-- POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_RESTORE_IN_PLACE-1) | POWER(2,EV_RESTORE_OUTOF_PLACE-1) | POWER(2,EV_VISIBILITY-1)
	DELETE FROM #JMCanManageJob_adminObject WHERE (Capabilities & @adminCap) = 0
	DELETE FROM #JMCanManageJob_rstObject WHERE (Capabilities & @restoreCap) = 0
	DECLARE @isAdminUser INTEGER = 0
	EXECUTE sec_isUserAdmin @i_userId ,@isAdminUser OUTPUT
	INSERT INTO #RunningJobs
	SELECT jobID,opType,userId,commCellId,clientId,appTypeId,instance,backupSet,applicationId,0,currentPolicy,1 FROM RunningBackups RB WITH(NOLOCK)
		WHERE @isAdminUser = 1 OR @i_userId = RB.userId OR
			EXISTS (SELECT 1 FROM  #SecIDANodeAccessTemp_Bkp secIDANode WITH(NOLOCK) WHERE secIDANode.t_subclientId = RB.applicationId)
	UNION
	SELECT RA.jobID,RA.opType,userId,RA.commCellId,clientId,appType,instance,backupSet,RA.appId,infoTable.workFlowId,infoTable.archGrpID,0 FROM RunningAdminJobs RA WITH(NOLOCK) INNER JOIN JMAdminJobInfoTable infoTable WITH(NOLOCK)
		ON RA.jobID = infoTable.jobId
			WHERE @isAdminUser = 1 OR
				@i_userId = (SELECT id FROM UMUsers WHERE login=RA.UserName)
				--@i_userId = RA.userId
				OR
                EXISTS
                (
					SELECT 1 FROM #JMCanManageJob_adminObject userObject WITH(NOLOCK)
					WHERE
						--(RA.opType = 85 AND (@hasVMProvisioningFilter = 1 AND @isAdminUser = 1))
                        --OR
                        (RA.opType = 90 AND infoTable.workFlowID <> 0 AND userObject.workflowId = infoTable.workFlowID)
                        OR
                        (RA.opType IN (104,13) AND RA.archGrpId <> 0 AND userObject.archGroupId = RA.archGrpId)
                        OR
(userObject.commCellId=2 AND userObject.clientGroupId=0 AND userObject.clientId=0 AND userObject.appTypeId=0 AND userObject.instanceId=0 AND userObject.backupsetId=0 AND userObject.subClientId=0 AND userObject.mediaAgentId=0 AND userObject.libraryId=0 AND userObject.archGroupId=0 AND userObject.vtContainerId=0 AND userObject.vtPolicyId=0 AND userObject.vtShelfId=0 AND userObject.reviewSetId=0 AND userObject.querySetId=0 AND userObject.downloadSetId=0 AND userObject.ermId=0 AND userObject.legalHoldId=0 AND userObject.tagId=0 AND userObject.cdPolicyId=0 AND userObject.complianceReportId=0 AND userObject.taskId=0 AND userObject.workflowId=0 AND userObject.logMonitoringPolicyId=0 AND userObject.arrayId=0 AND userObject.cloudId=0 AND userObject.userGroupId=0 AND userObject.providerId=0 AND userObject.entityId1=0 AND userObject.entityId2=0 AND userObject.entityId3=0 AND userObject.entityId4=0 AND userObject.entityId5=0									AND userObject.entityId6=0 AND userObject.entityId7=0 AND userObject.entityId8=0 AND userObject.entityId9=0)
                        OR
                        (RA.opType IN (21,32,41,42,46,47)  AND (libraryId =-10 OR userObject.libraryId IN (SELECT attributeValueInt FROM JMJobOptions jOption WITH(NOLOCK) WHERE jOption.jobId = RA.jobID AND jOption.commCellId = RA.commCellId AND jOption.attributeId = 10)))
                )
	UNION
	SELECT jobID,opType,userId,commCellId,srcClientId,appType,instanceID,bkpSetID,0,0,0,2 FROM RunningRestores RR WITH(NOLOCK)
		WHERE
			@isAdminUser = 1 OR @i_userId = RR.userId	OR
			EXISTS(
				SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK)
				WHERE
rstUserObject.commCellId=2 AND rstUserObject.clientGroupId=0 AND rstUserObject.clientId=0 AND rstUserObject.appTypeId=0 AND rstUserObject.instanceId=0 AND rstUserObject.backupsetId=0 AND rstUserObject.subClientId=0 AND rstUserObject.mediaAgentId=0 AND rstUserObject.libraryId=0 AND rstUserObject.archGroupId=0 AND rstUserObject.vtContainerId=0 AND rstUserObject.vtPolicyId=0 AND rstUserObject.vtShelfId=0 AND rstUserObject.reviewSetId=0 AND rstUserObject.querySetId=0 AND rstUserObject.downloadSetId=0 AND rstUserObject.ermId=0 AND rstUserObject.legalHoldId=0 AND rstUserObject.tagId=0 AND rstUserObject.cdPolicyId=0 AND rstUserObject.complianceReportId=0 AND rstUserObject.taskId=0 AND rstUserObject.workflowId=0 AND rstUserObject.logMonitoringPolicyId=0 AND rstUserObject.arrayId=0 AND rstUserObject.cloudId=0 AND rstUserObject.userGroupId=0 AND rstUserObject.providerId=0 AND rstUserObject.entityId1=0 AND rstUserObject.entityId2=0 AND rstUserObject.entityId3=0 AND rstUserObject.entityId4=0 AND rstUserObject.entityId5=0									AND rstUserObject.entityId6=0 AND rstUserObject.entityId7=0 AND rstUserObject.entityId8=0 AND rstUserObject.entityId9=0 OR
(rstUserObject.clientId=-10) OR
					 (rstUserObject.clientid=destClientID) OR
					 (rstUserObject.clientid=srcClientID AND apptypeid=0) OR
					 (rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=0) OR
					 (rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=0) OR
					 (rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=bkpSetID AND rstUserObject.subclientid=0) OR
((rstUserObject.clientgroupid <> 0 AND EXISTS (SELECT TOP 1 1 FROM APP_ClientGroupAssoc WITH(NOLOCK) WHERE (APP_ClientGroupAssoc.clientGroupId = rstUserObject.clientGroupId  OR rstUserObject.clientGroupId=-10) AND (APP_ClientGroupAssoc.clientid=srcClientID OR APP_ClientGroupAssoc.clientid=destClientID))))
			)
	UNION
	SELECT jobID,opType,userId,commCellId,destClientId,appType,instanceID,bkpSetID,0,0,0,2 FROM RunningRestores RR WITH(NOLOCK)
		WHERE
			@isAdminUser = 1 OR @i_userId = RR.userId	OR
			EXISTS(
				SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK)
				WHERE
rstUserObject.commCellId=2 AND rstUserObject.clientGroupId=0 AND rstUserObject.clientId=0 AND rstUserObject.appTypeId=0 AND rstUserObject.instanceId=0 AND rstUserObject.backupsetId=0 AND rstUserObject.subClientId=0 AND rstUserObject.mediaAgentId=0 AND rstUserObject.libraryId=0 AND rstUserObject.archGroupId=0 AND rstUserObject.vtContainerId=0 AND rstUserObject.vtPolicyId=0 AND rstUserObject.vtShelfId=0 AND rstUserObject.reviewSetId=0 AND rstUserObject.querySetId=0 AND rstUserObject.downloadSetId=0 AND rstUserObject.ermId=0 AND rstUserObject.legalHoldId=0 AND rstUserObject.tagId=0 AND rstUserObject.cdPolicyId=0 AND rstUserObject.complianceReportId=0 AND rstUserObject.taskId=0 AND rstUserObject.workflowId=0 AND rstUserObject.logMonitoringPolicyId=0 AND rstUserObject.arrayId=0 AND rstUserObject.cloudId=0 AND rstUserObject.userGroupId=0 AND rstUserObject.providerId=0 AND rstUserObject.entityId1=0 AND rstUserObject.entityId2=0 AND rstUserObject.entityId3=0 AND rstUserObject.entityId4=0 AND rstUserObject.entityId5=0									AND rstUserObject.entityId6=0 AND rstUserObject.entityId7=0 AND rstUserObject.entityId8=0 AND rstUserObject.entityId9=0 OR
(rstUserObject.clientId=-10) OR
					 (rstUserObject.clientid=destClientID) OR
					 (rstUserObject.clientid=srcClientID AND apptypeid=0) OR
					 (rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=0) OR
					 (rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=0) OR
					 (rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=bkpSetID AND rstUserObject.subclientid=0) OR
((rstUserObject.clientgroupid <> 0 AND EXISTS (SELECT TOP 1 1 FROM APP_ClientGroupAssoc WITH(NOLOCK) WHERE (APP_ClientGroupAssoc.clientGroupId = rstUserObject.clientGroupId  OR rstUserObject.clientGroupId=-10) AND (APP_ClientGroupAssoc.clientid=srcClientID OR APP_ClientGroupAssoc.clientid=destClientID))))
			)
create table  #JMCanManageJob_userObject ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	exec sec_getUserObjects @i_userId,2013,0,'#JMCanManageJob_userObject' -- For non-workflow jobs
	exec sec_getUserObjects @i_userId,14033,0,'#JMCanManageJob_userObject' --For workflow jobs
	exec sec_getUserObjects @i_userId,2231,0,'#JMCanManageJob_userObject' --For aux Copy Jobs, get permission at storage policy level
	DELETE FROM #JMCanManageJob_userObject
WHERE  (Capabilities & power(2, 16-1) = 0) -- delete all entities where manage cap is not present
	DELETE rJob FROM #RunningJobs rJob
	WHERE
(@i_entityType = 28 AND NOT EXISTS (SELECT 1 FROM APP_ClientGroupAssoc assoc WITH(NOLOCK) WHERE assoc.clientid = rJob.clientId AND assoc.clientGroupId = @i_entityId))  --ClientGroup
		OR
(@i_entityType = 17 AND rJob.archGroupId <> @i_entityId)  --Storage Policy
		OR
(@i_entityType = 160  AND rJob.archGroupId <> @i_entityId)  --Storage Pool
		OR
(@i_entityType = 184 AND rJob.opType <> @i_entityId)  -- opType
	SELECT DISTINCT rJob.JobID FROM #RunningJobs rJob WITH(NOLOCK)
	WHERE
		@isAdminUser = 1 OR @i_userId = rJob.userID OR
		EXISTS(
			SELECT TOP 1 1 FROM #JMCanManageJob_userObject userObject WITH(NOLOCK)
			WHERE
				(rJob.opType = 90 AND rJob.workFlowID <> 0 AND userObject.workflowId = rJob.workFlowID)
				OR
				(rJob.opType IN (104,13) AND rJob.archGroupId <> 0 AND userObject.archGroupId = rJob.archGroupId)
				OR
				(	rJob.jobType = 1 AND (rJob.clientID = userObject.clientId) AND --All backup job types
					(rJob.backUpSetID = userObject.backupsetId OR userObject.backupsetId = 0) AND
					(rJob.instance = userObject.instanceId OR userObject.instanceId =0) AND
					(rJob.appTypeID = userObject.appTypeId OR userObject.appTypeId=0) AND
					(rJob.applicationID = userObject.subClientId OR userObject.subClientId =0)
				)
				OR
				(	rJob.jobType = 2 AND (rJob.clientID = userObject.clientId) AND --All restore jobs
					(rJob.backUpSetID = userObject.backupsetId OR userObject.backupsetId = 0) AND
					(rJob.instance = userObject.instanceId OR userObject.instanceId =0) AND
					(rJob.appTypeID = userObject.appTypeId OR userObject.appTypeId=0)
				)
				OR
(userObject.commCellId=2 AND userObject.clientGroupId=0 AND userObject.clientId=0 AND userObject.appTypeId=0 AND userObject.instanceId=0 AND userObject.backupsetId=0 AND userObject.subClientId=0 AND userObject.mediaAgentId=0 AND userObject.libraryId=0 AND userObject.archGroupId=0 AND userObject.vtContainerId=0 AND userObject.vtPolicyId=0 AND userObject.vtShelfId=0 AND userObject.reviewSetId=0 AND userObject.querySetId=0 AND userObject.downloadSetId=0 AND userObject.ermId=0 AND userObject.legalHoldId=0 AND userObject.tagId=0 AND userObject.cdPolicyId=0 AND userObject.complianceReportId=0 AND userObject.taskId=0 AND userObject.workflowId=0 AND userObject.logMonitoringPolicyId=0 AND userObject.arrayId=0 AND userObject.cloudId=0 AND userObject.userGroupId=0 AND userObject.providerId=0 AND userObject.entityId1=0 AND userObject.entityId2=0 AND userObject.entityId3=0 AND userObject.entityId4=0 AND userObject.entityId5=0									AND userObject.entityId6=0 AND userObject.entityId7=0 AND userObject.entityId8=0 AND userObject.entityId9=0)
		)
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_Bkp') IS NOT NULL DROP TABLE #SecIDANodeAccessTemp_Bkp
	IF OBJECT_ID(N'tempdb.dbo.#JMCanManageJob_adminObject') IS NOT NULL DROP TABLE #JMCanManageJob_adminObject
	IF OBJECT_ID(N'tempdb.dbo.#JMCanManageJob_rstObject') IS NOT NULL DROP TABLE #JMCanManageJob_rstObject
	IF OBJECT_ID(N'tempdb.dbo.#RunningJobs') IS NOT NULL DROP TABLE #RunningJobs
	IF OBJECT_ID(N'tempdb.dbo.#JMCanManageJob_userObject') IS NOT NULL DROP TABLE #JMCanManageJob_userObject
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetJobsToControl')
	delete from GxQscripts where name = 'JMGetJobsToControl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobsToControl')
	delete from GXDBVersions where aliasname = 'JMGetJobsToControl'
GO

insert into GXDBVersions values(2, 'JMGetJobsToControl',  '00000000000000000000', 'JMGetJobsToControl', '00000000000000000000')
GO

