

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetJobsToBeProcessed.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--
--
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetJobsToBeProcessed.sp,v $ $Id: JMGetJobsToBeProcessed.sp,v 1.8.60.3 2018/03/22 03:05:40 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetJobsToBeProcessed <<<'

IF EXISTS (select * from sysobjects where name='JMGetJobsToBeProcessed')
	drop procedure JMGetJobsToBeProcessed
IF EXISTS (select * from GxQscripts where name='JMGetJobsToBeProcessed')
	delete from GxQscripts where name = 'JMGetJobsToBeProcessed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobsToBeProcessed')
	delete from GXDBVersions where aliasname = 'JMGetJobsToBeProcessed'
GO
print '... Creating Procedure: JMGetJobsToBeProcessed'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMGetJobsToBeProcessed
  @firstTimeAfterJMRestart INTEGER,
  @immediateJobSignal INTEGER
AS
  DECLARE @jobId INTEGER
  DECLARE @taskId INTEGER
  DECLARE @subTaskId INTEGER
  DECLARE @subTaskType INTEGER
  DECLARE @operationType INTEGER
  DECLARE @initiatedFrom INTEGER
  DECLARE @userId INTEGER
  DECLARE @appId INTEGER
  DECLARE @backupLevel INTEGER
  DECLARE @dataStream INTEGER
  DECLARE @createNewIndex INTEGER
  DECLARE @startNewMedia INTEGER
BEGIN TRY
	BEGIN TRAN
		UPDATE TM_Jobs SET STATUS = 4097
		WHERE
			STATUS = 0
			OR (
					@firstTimeAfterJMRestart = 1
					AND STATUS = 1
			)
		IF @immediateJobSignal = 1
			-- Step4: Select the jobs to be processed
			SELECT TM_Jobs.jobId, TM_JobRequest.taskId, TM_JobRequest.subTaskId, TM_JobRequest.subTaskType, TM_JobRequest.operationType,
			TM_JobRequest.initiatedFrom, TM_JobRequest.userId, 0, 0, 0, 0, 0
			FROM TM_Jobs, TM_JobRequest WITH(NOLOCK)
			WHERE TM_JOBS.STATUS = 4097 AND TM_Jobs.jobRequestId = TM_JobRequest.jobRequestId
			ORDER BY TM_JobRequest.initiatedFrom, TM_Jobs.jobId
		ELSE
			-- Step4: Select the jobs to be processed
			SELECT TM_Jobs.jobId, TM_JobRequest.taskId, TM_JobRequest.subTaskId, TM_JobRequest.subTaskType, TM_JobRequest.operationType,
			TM_JobRequest.initiatedFrom, TM_JobRequest.userId, 0, 0, 0, 0, 0
			FROM TM_Jobs, TM_JobRequest WITH(NOLOCK)
			WHERE TM_JOBS.STATUS = 4097 AND TM_Jobs.jobRequestId = TM_JobRequest.jobRequestId
		-- Step1: Update the status of previous selected jobs
		UPDATE TM_Jobs SET STATUS = 1 WHERE STATUS = 4097
	COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	ROLLBACK TRAN
END CATCH
GO


IF EXISTS (select * from GxQscripts where name = 'JMGetJobsToBeProcessed')
	delete from GxQscripts where name = 'JMGetJobsToBeProcessed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobsToBeProcessed')
	delete from GXDBVersions where aliasname = 'JMGetJobsToBeProcessed'
GO

insert into GXDBVersions values(2, 'JMGetJobsToBeProcessed',  '00010008006000030000', 'JMGetJobsToBeProcessed', '00010008006000030000')
GO

