

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetJobsSuccessFailedCount.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetJobsSuccessFailedCount.sp,v $ $Id: JMGetJobsSuccessFailedCount.sp,v 1.6.88.3 2020/06/01 02:37:13 sbonilla Exp $";
--
--  +========================================================================+
--  |   Procedure:  JMGetJobsSuccessFailedCount()
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Gokul Pattabiraman   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetJobsSuccessFailedCount')
BEGIN
	print '>>> Drop Stored Procedure: JMGetJobsSuccessFailedCount <<<'
	drop procedure JMGetJobsSuccessFailedCount
END
IF EXISTS (select * from GxQscripts where name='JMGetJobsSuccessFailedCount')
	delete from GxQscripts where name = 'JMGetJobsSuccessFailedCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobsSuccessFailedCount')
	delete from GXDBVersions where aliasname = 'JMGetJobsSuccessFailedCount'
GO
print '... Creating Procedure: JMGetJobsSuccessFailedCount'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetJobsSuccessFailedCount
  @i_userId INT,
  @inXmlReq XML,
  @outXmlResp XML	OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @currentTime INTEGER
	SET @currentTime = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
	-- Table for all jobs
	IF object_id('tempdb.dbo.#JobsInitTable') is not null
		DROP TABLE #JobsInitTable
	CREATE TABLE #JobsInitTable
	(
		jobId		INTEGER,
		endTime		INTEGER,
		jobStatus	INTEGER,
		appId		INTEGER,
		commcellId	INTEGER,
		username    NVARCHAR(256)
	)
	CREATE CLUSTERED INDEX JobsInitTable_appId_Index1 ON #JobsInitTable ([appId])
	IF object_id('tempdb.dbo.#JobsAppTable') is not null
		DROP TABLE #JobsAppTable
	CREATE TABLE #JobsAppTable
	(
		jobId		INTEGER,
		endTime		INTEGER,
		jobStatus	INTEGER,
		commcellId	INTEGER,
		appId		INTEGER,
		clientId	INTEGER,
		appTypeId	INTEGER,
		instanceId	INTEGER,
		backupSetId	INTEGER,
		username    NVARCHAR(256)
	)
	CREATE CLUSTERED INDEX JobsAppTable_username_Index1 ON #JobsAppTable ([username])
	IF object_id('tempdb.dbo.#JobsTable') is not null
		DROP TABLE #JobsTable
	CREATE TABLE #JobsTable
	(
		jobId		INTEGER,
		endTime		INTEGER,
		jobStatus	INTEGER
	)
	CREATE CLUSTERED INDEX JobsTable_endTime_JobStatus_Index1 ON #JobsTable ([endTime], [jobStatus])
	IF object_id('tempdb.dbo.#OutPutTable') is not null
		DROP TABLE #OutPutTable
	-- Table for finalOutPut
	CREATE TABLE #OutPutTable
	(
		intervalStartTime	INTEGER,
		intervalEndTime		INTEGER,
		successFulJobs		INTEGER,
		failedJobs			INTEGER,
		killedJobs			INTEGER
	)
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_Bkp') IS NOT NULL
		DROP TABLE #SecIDANodeAccessTemp_Bkp
    CREATE TABLE #SecIDANodeAccessTemp_Bkp
    (
        t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
    )
    CREATE CLUSTERED INDEX [#SecIDANodeAccessTemp_Bkp_subclientId] ON [#SecIDANodeAccessTemp_Bkp]([t_subclientId] ASC)
	-- Variables
	DECLARE @startTime			INTEGER
	DECLARE @endTime			INTEGER
	DECLARE @tempTime 			DATETIME
	DECLARE @timeIntervalSize	INTEGER = 1800  -- Half an hour time frame
	DECLARE @pastNHours			INTEGER = 6		-- Default Last six hours
	DECLARE @interValStart		INTEGER
	DECLARE @interValEnd		INTEGER = 0
	DECLARE @successCount		INTEGER
	DECLARE @failedCount		INTEGER
	DECLARE @killedCount		INTEGER
	-- Form the configuration from input XML if present
	SET @endTime = ISNULL(( SELECT   ref.value('@toTime', 'int')
                               FROM     @inXmlReq . nodes('JobManager_JobsSucessFailCountReq/timeRange') R ( ref )
                             ), 0)
	SET @startTime = ISNULL(( SELECT   ref.value('@fromTime', 'int')
                           FROM     @inXmlReq . nodes('JobManager_JobsSucessFailCountReq/timeRange') R ( ref )
                         ), 0)
    SET @timeIntervalSize = ISNULL(( SELECT   ref.value('@intervalSize', 'int')
                           FROM     @inXmlReq . nodes('JobManager_JobsSucessFailCountReq') R ( ref )
                         ), 1800)
	IF @startTime = 0 AND @endTime = 0
	BEGIN
		SET @endTime = @currentTime
		SET @startTime = @currentTime - (@pastNHours * 60 * 60)
	END
	-- Rounding off the start time.
	SET @tempTime = dbo.GetDateTime(@startTime)
	SET @tempTime = DATEADD(MINUTE, DATEDIFF(MINUTE, 0, @tempTime), 0)
	--SET @tempTime = CAST(CAST(@tempTime AS varchar(16)) AS DATETIME)
	-- Round off to the nearest 5 mins
	SET @tempTime = CASE
						WHEN (DATEPART(MINUTE, @tempTime) % 5) <> 0
						THEN DATEADD(MINUTE,(5 - (DATEPART(MINUTE, @tempTime) % 5)), @tempTime)
						ELSE @tempTime
						END
	SET @startTime = dbo.getUnixTime(@tempTime)
	-- Now repeat rounding off for end time
	SET @tempTime = dbo.GetDateTime(@endTime)
	SET @tempTime = DATEADD(MINUTE, DATEDIFF(MINUTE, 0, @tempTime), 0)
	--SET @tempTime = CAST(CAST(@tempTime AS varchar(16)) AS DATETIME)
	-- Round off to the nearest 5 mins
	SET @tempTime = CASE
						WHEN (DATEPART(MINUTE, @tempTime) % 5) <> 0
						THEN DATEADD(MINUTE,(5 - (DATEPART(MINUTE, @tempTime) % 5)), @tempTime)
						ELSE @tempTime
						END
	SET @endTime = dbo.getUnixTime(@tempTime)
	-- Get all jobs first from DB to jobtable
	INSERT INTO #JobsInitTable
	(jobId, endTime, jobStatus, appId, commcellId)
	SELECT jobId, servEndDate, status, appId, commcellId
	FROM JMBkpStats WITH(READUNCOMMITTED)
	WHERE
	servEndDate >= @startTime
	AND servEndDate <= @endTime
	IF @i_userId = 0
	BEGIN
		INSERT INTO #jobsTable
		(jobId, endTime, jobStatus)
		SELECT jobId, endTime, jobStatus
		FROM #JobsInitTable
		--DROP TABLE BEFORE GOING INTO LOOP
		IF object_id('tempdb.dbo.#JobsInitTable') is not null
			DROP TABLE #JobsInitTable
	END
	ELSE
	BEGIN
		INSERT INTO #JobsAppTable
		(jobId, endTime, jobStatus, commcellId, clientId, appTypeId, instanceId, backupSetId, appId, username)
		SELECT jobId, endTime, jobStatus, JI.commcellId, clientId, appTypeId, instance, backupSet, appId, username
		FROM #JobsInitTable JI
		JOIN APP_Application APP WITH(READUNCOMMITTED)
		ON JI.appId = APP.id
		--DROP TABLE BEFORE GOING GETTING SECURITY
		IF object_id('tempdb.dbo.#JobsInitTable') is not null
			DROP TABLE #JobsInitTable
		-- capabilities required to view a backup job are one of the following: Job Management, Data Protection Operations, Browse and In Place Recover, Browse and Out of Place Recover, Browse, Report Management, View
		-- POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_BACKUP-1)| POWER(2,EV_RESTORE_IN_PLACE-1) | POWER(2,EV_RESTORE_OUTOF_PLACE-1) | POWER(2,EV_BROWSE-1)| POWER(2,EV_RUN_REPORTS-1) | POWER(2,EV_VISIBILITY-1)
	    EXEC sec_getIdaObjectsForUser @i_userId, 7, 0, 0, '#SecIDANodeAccessTemp_Bkp', 0, '16,12,20,22,13,15,31', 0
		INSERT INTO #jobsTable
		(jobId, endTime, jobStatus)
		SELECT JI.jobId, JI.endTime, JI.jobStatus
		FROM #JobsAppTable JI
		JOIN #SecIDANodeAccessTemp_Bkp BE ON BE.t_subclientId = JI.appId
		UNION
		SELECT jobId, endTime, jobStatus
		FROM #JobsAppTable JI
		JOIN UMUsers (NOLOCK) U ON U.login = username AND @i_userId = U.id
		--DROP TABLE BEFORE GOING INTO LOOP
		IF object_id('tempdb.dbo.#JobsAppTable') is not null
			DROP TABLE #JobsAppTable
	END
	-- For each interval get the count from jobtable
	SET @interValStart = @startTime
	WHILE @interValStart < @endTime
	BEGIN
		-- Intitialize
		SET @interValEnd = @interValStart + @timeIntervalSize
		-- Completed, Completed with errors, Completed with warnings
		SELECT @successCount = COUNT(*)
		FROM  #jobsTable
		WHERE endTime >= @interValStart
		AND endTime <@interValEnd
		AND jobStatus IN (1,3,14)
		-- Failed, failed to start
		SELECT @failedCount = COUNT(*)
		FROM  #jobsTable
		WHERE endTime >= @interValStart
		AND endTime <@interValEnd
		AND jobStatus IN (2,9)
		-- Killed
		SELECT @killedCount = COUNT(*)
		FROM  #jobsTable
		WHERE endTime >= @interValStart
		AND endTime <@interValEnd
		AND jobStatus IN (4)
		INSERT INTO #OutPutTable
		VALUES(@interValStart, @interValEnd-1, @successCount, @failedCount, @killedCount)
		SET @interValStart = @interValEnd
	END
	-- Form the output response
	SET @outXmlResp =
				(
					SELECT
					(
						SELECT successFulJobs AS '@successfulJobs', failedJobs AS '@failedJobs', killedJobs AS '@killedJobs',
						intervalStartTime AS 'timeRange/@fromTime' , intervalEndTime AS 'timeRange/@toTime'
						FROM #OutPutTable
						FOR XML PATH ('successFailList'), TYPE
					)
					FOR XML PATH('JobManager_JobsSucessFailCountResp'), TYPE
				)
	IF ( @outXmlResp IS null )
			SET @outXmlResp = '<JobManager_JobsSucessFailCountResp />'
	SELECT @outXmlResp
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_Bkp') IS NOT NULL
		DROP TABLE #SecIDANodeAccessTemp_Bkp
	IF object_id('tempdb.dbo.#JobsInitTable') is not null
		DROP TABLE #JobsInitTable
	IF object_id('tempdb.dbo.#JobsAppTable') is not null
		DROP TABLE #JobsAppTable
	IF object_id('tempdb.dbo.#JobsTable') is not null
		DROP TABLE #JobsTable
	IF object_id('tempdb.dbo.#OutPutTable') is not null
		DROP TABLE #OutPutTable
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetJobsSuccessFailedCount')
	delete from GxQscripts where name = 'JMGetJobsSuccessFailedCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobsSuccessFailedCount')
	delete from GXDBVersions where aliasname = 'JMGetJobsSuccessFailedCount'
GO

insert into GXDBVersions values(2, 'JMGetJobsSuccessFailedCount',  '00010006008800030000', 'JMGetJobsSuccessFailedCount', '00010006008800030000')
GO

