

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetJobsForecastInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetJobsForecastInfo.sp,v $ $Id: JMGetJobsForecastInfo.sp,v 1.1.2.10.26.1 2021/04/24 02:35:07 snandhini Exp $";
---- =============================================
---- Author:		Jaya Rama Raju Inavolu
---- Description:	Get the data copied info.
---- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMGetJobsForecastInfo')
BEGIN
	print '>>> Drop Stored Procedure: JMGetJobsForecastInfo <<<'
	drop procedure JMGetJobsForecastInfo
END
IF EXISTS (select * from GxQscripts where name='JMGetJobsForecastInfo')
	delete from GxQscripts where name = 'JMGetJobsForecastInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobsForecastInfo')
	delete from GXDBVersions where aliasname = 'JMGetJobsForecastInfo'
GO
print '... Creating Procedure: JMGetJobsForecastInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMGetJobsForecastInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @subClientID INTEGER,
  @opType INTEGER,
  @backupLevel INTEGER,
  @doNotIncludeOpWindow INTEGER
AS
  DECLARE @JobID INTEGER
  DECLARE @commCellID INTEGER
  DECLARE @jobRunTime INTEGER
  DECLARE @jobRunTimeWithoutOpWin INTEGER
  DECLARE @objectCount BIGINT
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @configurableFromDateTimestamp INT = ISNULL((SELECT TOP 1 value from GxGlobalParam WHERE name='FromTimeForAnomalyAlert' and modified=0),0)
DECLARE @TempTable TABLE(JobID INTEGER, CommCellID INTEGER, duration INTEGER,durationWithoutOpWin INTEGER, startDate INTEGER,filesToXfer BIGINT)
INSERT INTO @TempTable(jobId, commcellId, duration, durationWithoutOpWin, startDate, filesToXfer)
SELECT TOP 200 jobid, commCellID, (servEndDate - servStartDate), 0, servStartDate,
CASE WHEN appType IN( 53,22,13) THEN totaluncompbytestoxfer
		 ELSE filestoxfer
		 END
FROM JMBkpStats WITH(NOLOCK)
WHERE appId = @subClientID AND opType = @opType AND bkpLevel = @backupLevel AND status IN(1,3,14) AND servStartDate > @configurableFromDateTimestamp
ORDER BY servStartDate DESC
DECLARE @count INT = @@ROWCOUNT
IF  @count < 200 AND (@optype = 14 /*CVOpType_SYNTHFULL*/ OR @backupLevel = 64 /*CVBkpLevel_SYNTHETIC_FULL*/ )
BEGIN
	DECLARE @earliestJobStartTime INT = ISNULL((SELECT MIN(startDate) FROM @TempTable),0)
	INSERT INTO @TempTable(jobId, commcellId, duration, durationWithoutOpWin, startDate, filesToXfer)
SELECT TOP(200 - @count) 0, 0, jobEndTime-jobStartTime, 0, jobStartTime, filesToXfer
	FROM HistoryDB.dbo.JMJobRuntimeHistory
	WHERE opType = @opType AND bkpLevel = @backupLevel AND subclientid = @subClientId AND
	((jobStartTime < @earliestJobStartTime) OR (@earliestJobStartTime = 0))
	ORDER BY jobStartTime DESC
END
IF @doNotIncludeOpWindow = 1
BEGIN
     DECLARE @eventsTable table(eventId int, timeSource int, messageId integer,jobId bigint)
/*	((1054 | (CAST(POWER(2, 24) AS BIGINT) * 19)),(1611 | (CAST(POWER(2, 24) AS BIGINT) * 83))),
((1055 | (CAST(POWER(2, 24) AS BIGINT) * 19)),(1608 | (CAST(POWER(2, 24) AS BIGINT) * 83))),
((1056 | (CAST(POWER(2, 24) AS BIGINT) * 19)),(1607 | (CAST(POWER(2, 24) AS BIGINT) * 83)))	*/
	 -- list of events associated with the job
     INSERT INTO @eventsTable
		SELECT id, timeSource, messageId, jobid
		FROM EvMsg
		INNER JOIN @TempTable ON jobId = (POWER(CONVERT(BIGINT, 2), 32) * jobId_h + jobId_l)
	 UPDATE Final SET durationWithoutOpWin = ISNULL(duration-suspended, duration)
	 FROM @TempTable Final
	 LEFT JOIN
	 (
		SELECT B.jobId, SUM(B.resumedTime-B.suspendedTime)suspended
		 FROM
		 (
			SELECT A.jobId, MIN(A.resumedTime) resumedTime , A.suspendedTime FROM
			(
				SELECT JobResumed.jobId, JobResumed.messageId,JobResumed.timeSource resumedTime,JobSuspended.timeSource suspendedTime
				FROM @eventsTable JobResumed
				INNER JOIN @eventsTable JobSuspended
				ON
				(JobSuspended.jobId = JobResumed.jobId) AND (JobResumed.timeSource>JobSuspended.timeSource) AND
				(
(JobResumed.messageId=(1054 | (CAST(POWER(2, 24) AS BIGINT) * 19)) AND JobSuspended.messageId=(1068 | (CAST(POWER(2, 24) AS BIGINT) * 19)))  OR
(JobResumed.messageId=(1055 | (CAST(POWER(2, 24) AS BIGINT) * 19)) AND JobSuspended.messageId=(318 | (CAST(POWER(2, 24) AS BIGINT) * 19))) OR
(JobResumed.messageId=(1056 | (CAST(POWER(2, 24) AS BIGINT) * 19)) AND JobSuspended.messageId in ((754 | (CAST(POWER(2, 24) AS BIGINT) * 19)),(751 | (CAST(POWER(2, 24) AS BIGINT) * 19)),(747 | (CAST(POWER(2, 24) AS BIGINT) * 19)),(740 | (CAST(POWER(2, 24) AS BIGINT) * 19)),(741 | (CAST(POWER(2, 24) AS BIGINT) * 19))) )
				)
			)A
			GROUP BY A.messageId,A.suspendedTime,A.jobId
		 )B GROUP BY B.jobId
	 )C ON C.jobId = Final.jobId
END
SELECT JobID,CommCellID,duration,durationWithoutOpWin,filesToXfer
FROM @TempTable
ORDER BY startDate
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetJobsForecastInfo')
	delete from GxQscripts where name = 'JMGetJobsForecastInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobsForecastInfo')
	delete from GXDBVersions where aliasname = 'JMGetJobsForecastInfo'
GO

insert into GXDBVersions values(2, 'JMGetJobsForecastInfo',  'v1.1.2.10.26.1', 'JMGetJobsForecastInfo', 'v1.1.2.10.26.1')
GO

