

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetJobsForUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetJobsForUser.sp,v $ $Id: JMGetJobsForUser.sp,v 1.4.2.5 2018/03/27 09:18:58 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  JMGetJobsForUser()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output:
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Divakar               Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetJobsForUser <<<'

IF EXISTS (select * from sysobjects where name='JMGetJobsForUser')
	drop procedure JMGetJobsForUser
IF EXISTS (select * from GxQscripts where name='JMGetJobsForUser')
	delete from GxQscripts where name = 'JMGetJobsForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobsForUser')
	delete from GXDBVersions where aliasname = 'JMGetJobsForUser'
GO
print '... Creating Procedure: JMGetJobsForUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetJobsForUser
  @i_userId INT
AS
  DECLARE @jobID INTEGER
SET NOCOUNT ON
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @RunningJobs TABLE (JobID INTEGER,
							opType INTEGER,
							userID INTEGER,
							commCellID INTEGER,
							clientID INTEGER,
							appTypeID INTEGER,
							instance INTEGER,
							backUpSetID INTEGER,
							applicationID INTEGER,
							workFlowID INTEGER,
							archGroupId INTEGER,
							jobType INTEGER) --enum CVJobType, 0 is any other jobs
	DECLARE @isUserAdmin integer =0
	EXECUTE sec_isUserAdmin @i_userId ,@isUserAdmin OUTPUT
	IF @isUserAdmin = 1
	BEGIN
		SELECT jobId FROM JMJobInfo
		RETURN;
	END
	INSERT INTO @RunningJobs
	SELECT jobID,opType,userId,commCellId,clientId,appTypeId,instance,backupSet,applicationId,0,0,1 FROM RunningBackups
		WHERE dbo.isVisible(@i_userId,jobID,2,0,0,0,0,0,0) = 1
	UNION
	SELECT runningJob.jobID,runningJob.opType,userId,runningJob.commCellId,clientId,appType,instance,backupSet,runningJob.appId,infoTable.workFlowId,infoTable.archGrpID,0 FROM RunningAdminJobs runningJob INNER JOIN JMAdminJobInfoTable infoTable
		ON runningJob.jobID = infoTable.jobId
			WHERE dbo.isVisible(@i_userId,runningJob.jobID,2,0,0,0,0,0,0) = 1
	UNION
	SELECT jobID,opType,userId,commCellId,srcClientId,appType,instanceID,bkpSetID,0,0,0,2 FROM RunningRestores
		WHERE dbo.isVisible(@i_userId,jobID,2,0,0,0,0,0,0) = 1
create table  #JMCanManageJob_userObject ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	exec sec_getUserObjects @i_userId,2013,0,'#JMCanManageJob_userObject' -- For non-workflow jobs
	exec sec_getUserObjects @i_userId,14033,0,'#JMCanManageJob_userObject' --For workflow jobs
	exec sec_getUserObjects @i_userId,2231,0,'#JMCanManageJob_userObject' --For aux Copy Jobs, get permission at storage policy level
	DELETE FROM #JMCanManageJob_userObject
WHERE  (Capabilities & power(2, 16-1) = 0) -- delete all entities where manage cap is not present
	SELECT DISTINCT rJob.JobID
	 FROM
		@RunningJobs rJob, #JMCanManageJob_userObject userObject
			WHERE (rJob.opType = 90 AND rJob.workFlowID <> 0 AND userObject.workflowId = rJob.workFlowID)
				OR
				  (rJob.opType IN (104,13) AND rJob.archGroupId <> 0 AND userObject.archGroupId = rJob.archGroupId)
				OR
				 (rJob.jobType = 1 AND (rJob.clientID = userObject.clientId) AND --All backup job types
						(rJob.backUpSetID = userObject.backupsetId OR userObject.backupsetId = 0) AND
						(rJob.instance = userObject.instanceId OR userObject.instanceId =0) AND
						(rJob.appTypeID = userObject.appTypeId OR userObject.appTypeId=0) AND
						(rJob.applicationID = userObject.subClientId OR userObject.subClientId =0))
					OR
					(rJob.jobType = 2 AND (rJob.clientID = userObject.clientId) AND --All restore jobs
						(rJob.backUpSetID = userObject.backupsetId OR userObject.backupsetId = 0) AND
						(rJob.instance = userObject.instanceId OR userObject.instanceId =0) AND
						(rJob.appTypeID = userObject.appTypeId OR userObject.appTypeId=0))
					OR
(userObject.commCellId=2 AND userObject.clientGroupId=0 AND userObject.clientId=0 AND userObject.appTypeId=0 AND userObject.instanceId=0 AND userObject.backupsetId=0 AND userObject.subClientId=0 AND userObject.mediaAgentId=0 AND userObject.libraryId=0 AND userObject.archGroupId=0 AND userObject.vtContainerId=0 AND userObject.vtPolicyId=0 AND userObject.vtShelfId=0 AND userObject.reviewSetId=0 AND userObject.querySetId=0 AND userObject.downloadSetId=0 AND userObject.ermId=0 AND userObject.legalHoldId=0 AND userObject.tagId=0 AND userObject.cdPolicyId=0 AND userObject.complianceReportId=0 AND userObject.taskId=0 AND userObject.workflowId=0 AND userObject.logMonitoringPolicyId=0 AND userObject.arrayId=0 AND userObject.cloudId=0 AND userObject.userGroupId=0 AND userObject.providerId=0 AND userObject.entityId1=0 AND userObject.entityId2=0 AND userObject.entityId3=0 AND userObject.entityId4=0 AND userObject.entityId5=0									AND userObject.entityId6=0 AND userObject.entityId7=0 AND userObject.entityId8=0 AND userObject.entityId9=0)
					OR
						rJob.userID = @i_userId --If job is submitted by the user
	UNION
	SELECT DISTINCT rJob.JobID --When #JMCanManageJob_userObject is empty above query might not return anything, hence explicity select jobs submitted by the user
		FROM
			@RunningJobs rJob	WHERE rJob.userID = @i_userId
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetJobsForUser')
	delete from GxQscripts where name = 'JMGetJobsForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobsForUser')
	delete from GXDBVersions where aliasname = 'JMGetJobsForUser'
GO

insert into GXDBVersions values(2, 'JMGetJobsForUser',  '00010004000200050000', 'JMGetJobsForUser', '00010004000200050000')
GO

