

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetJobsForMA.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetJobsForMA.sp,v $ $Id: JMGetJobsForMA.sp,v 1.2.44.1 2018/03/27 08:41:27 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "JMGetJobsForMA"
--	|	This stored procedure gets running jobs using given MA. This is used in CatalogMigrationJob
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetJobsForMA <<<'

IF EXISTS (select * from sysobjects where name='JMGetJobsForMA')
	drop procedure JMGetJobsForMA
IF EXISTS (select * from GxQscripts where name='JMGetJobsForMA')
	delete from GxQscripts where name = 'JMGetJobsForMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobsForMA')
	delete from GXDBVersions where aliasname = 'JMGetJobsForMA'
GO
print '... Creating Procedure: JMGetJobsForMA'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetJobsForMA
-- Input arguments
  @i_maClientID INTEGER
AS
  DECLARE @o_jobId integer
BEGIN
SELECT jbk.jobId FROM JMBkpJobInfo jbk WITH (NOLOCK)
	INNER JOIN APP_CommCell cmc
		ON jbk.commcellId = cmc.id
			INNER JOIN APP_Application app WITH (NOLOCK)
				ON jbk.applicationId = app.id
					INNER JOIN APP_BackupSetName bkpset WITH (NOLOCK)
						ON bkpset.id = app.backupSet
					WHERE jobId IN(select JobId_l FROM MMResourceToJob rtj
	INNER JOIN MMResource mmr ON rtj.ReservationId = mmr.ReservationId AND mmr.ClientId =
		(select id from APP_Client WHERE id = @i_maClientID))
UNION
SELECT JMRstInfo.jobId FROM JMRstJobInfo JMRstInfo WITH (NOLOCK)
	INNER JOIN APP_BackupSetName APPBkpSet WITH (NOLOCK)
		ON JMRstInfo.bkpSetID = APPBkpSet.id
			INNER JOIN App_IndexDBInfo APPIndDBInfo
				ON APPBkpSet.GUID = APPIndDBInfo.backupSetGUID
					WHERE APPIndDBInfo.currentIdxServer = @i_maClientID
UNION
SELECT JMBkpInfo.jobId FROM JMBkpJobInfo JMBkpInfo WITH (NOLOCK)
	INNER JOIN APP_Application  AppID WITH (NOLOCK)
		ON JMBkpInfo.applicationId = AppID.id
			INNER JOIN APP_BackupSetName APPBkpSet WITH (NOLOCK)
				ON AppID.backupSet = APPBkpSet.id
					INNER JOIN App_IndexDBInfo APPIndDBInfo
						ON APPBkpSet.GUID = APPIndDBInfo.backupSetGUID
							WHERE APPIndDBInfo.currentIdxServer = @i_maClientID
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetJobsForMA')
	delete from GxQscripts where name = 'JMGetJobsForMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobsForMA')
	delete from GXDBVersions where aliasname = 'JMGetJobsForMA'
GO

insert into GXDBVersions values(2, 'JMGetJobsForMA',  '00010002004400010000', 'JMGetJobsForMA', '00010002004400010000')
GO

