

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetJobSummary.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetJobSummary.sp,v $ $Id: JMGetJobSummary.sp,v 1.10.88.5 2020/11/17 19:29:06 gstoops Exp $";
--
--  +========================================================================+
--  |   Procedure:  JMGetJobSummary()
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Gokul Pattabiraman   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMGetJobSummary')
BEGIN
	print '>>> Drop Stored Procedure: JMGetJobSummary <<<'
	drop procedure JMGetJobSummary
END
IF EXISTS (select * from GxQscripts where name='JMGetJobSummary')
	delete from GxQscripts where name = 'JMGetJobSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobSummary')
	delete from GXDBVersions where aliasname = 'JMGetJobSummary'
GO
print '... Creating Procedure: JMGetJobSummary'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMGetJobSummary
  @i_userId INT,
  @inXmlReq XML,
  @outXmlResp XML	OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @Jobs TABLE (
		jobId int,
		state int,
		isCompleted int,
		isAnomalous int
	)
	--Tenant admin should be able to view jobs submitted by other users in the company.
	IF OBJECT_ID('tempdb.dbo.#getUsersInCompanyOutputTbl') IS NOT NULL
		DROP TABLE #getUsersInCompanyOutputTbl
	CREATE TABLE #getUsersInCompanyOutputTbl (
		userId INTEGER,
		PRIMARY KEY(userId)
	)
	--Populates #getUsersInCompanyOutputTbl
	EXEC sec_getUsersInCompany @i_userId
	DECLARE @lastCompletedTime INT = dbo.GetUnixTime(GETUTCDATE()) - 300 --(5*60 SECONDS)
	DECLARE @defaultCCId INT = 2
	INSERT INTO @Jobs
		SELECT jobID, state, 0,
		CASE WHEN guiAlertColorLevel >= 100000 THEN 1 ELSE 0 END
		FROM RunningBackups WITH (NOLOCK)
		WHERE commCellId = @defaultCCId
		AND (@i_userId = 0 OR @i_userId = userId OR dbo.isBkpJobVisible(@i_userId,commCellId,clientId,appTypeId,instance,backupSet,applicationId) = 1)
	UNION ALL
		SELECT JM.jobId, JM.status, 1,
		CASE WHEN LongRunning.attributeValueInt IS NOT NULL AND LongRunning.attributeValueInt > 3600 AND ((JM.servEndDate - JM.servStartDate) > LongRunning.attributeValueInt) THEN 1 ELSE 0 END
		FROM JMBkpStats JM
		LEFT JOIN APP_Application AP ON JM.appID = AP.id
LEFT OUTER JOIN JMJobOptions LongRunning ON JM.jobId = LongRunning.jobId AND LongRunning.commCellId = Jm.commCellId AND LongRunning.attributeId = 76
		WHERE servEndDate > @lastCompletedTime
		and JM.commCellId = @defaultCCId
		AND (@i_userId = 0 OR @i_userId = ISNULL((Select id From UMUsers(NOLOCK) where login = JM.username),0)
		     OR dbo.isBkpJobVisible(@i_userId,JM.commCellId,clientId,appType,instance,backupSet, appID) = 1)
	UNION ALL
		SELECT jobID, state, 0,
		CASE WHEN guiAlertColorLevel >= 100000 THEN 1 ELSE 0 END
		FROM RunningAdminJobs WITH (NOLOCK)
		LEFT JOIN #getUsersInCompanyOutputTbl UIC ON UIC.userId = (SELECT id FROM UMUsers(NOLOCK) WHERE login=UserName)
		WHERE commCellId = @defaultCCId
		AND (@i_userId = 0 OR @i_userId = ISNULL((Select id From UMUsers(NOLOCK) where login = UserName),0)
		     OR dbo.isAdminJobVisible(@i_userId, commcellId, archGrpID, jobId, opType, 0) = 1
			 OR UIC.userId IS NOT NULL)
	UNION ALL
		SELECT JM.jobId, JM.status, 1, 0
		FROM JMAdminJobStatsTable JM
		LEFT JOIN #getUsersInCompanyOutputTbl UIC ON UIC.userId = (SELECT id FROM UMUsers WHERE login=JM.username)
		WHERE servEnd > @lastCompletedTime
		and commCellId = @defaultCCId
		AND (@i_userId = 0 OR @i_userId = ISNULL((Select id From UMUsers(NOLOCK) where login = JM.username),0)
		     OR dbo.isAdminJobVisible(@i_userId, commcellId,archGrpID, jobId, opType, 0) = 1
			 OR UIC.userId IS NOT NULL)
	UNION ALL
		SELECT jobID, state, 0,
		CASE WHEN guiAlertColorLevel >= 100000 THEN 1 ELSE 0 END
		FROM RunningRestores WITH (NOLOCK)
		WHERE commCellId = @defaultCCId
		AND (@i_userId = 0 OR @i_userId = userId OR dbo.isRstJobVisible(@i_userId, commCellId, srcClientID, destClientID, appType, instanceID, bkpSetID) = 1)
	UNION ALL
		SELECT JM.jobId, JM.status, 1, 0
		FROM JMRestoreStats JM
		WHERE JM.servEndTime > @lastCompletedTime
		and commCellId = @defaultCCId
		AND (@i_userId = 0 OR @i_userId = ISNULL((Select id From UMUsers(NOLOCK) where login = JM.username),0)
		     OR dbo.isRstJobVisible(@i_userId, commCellId, srcClientID, destClientID, appType, instanceID, bkpSetID) = 1)
	-- Form the XML
	SET @outXmlResp =
		(
		SELECT
			(SELECT COUNT(*) FROM @Jobs WHERE state = 1 and isCompleted = 0) AS '@runningJobs',   -- RUNNING = 1
			(SELECT COUNT(*) FROM @Jobs WHERE state = 2 and isCompleted = 0) AS '@pendingJobs',  -- PENDING = 2
			(SELECT COUNT(*) FROM @Jobs WHERE state = 3 and isCompleted = 0) AS '@waitingJobs' , -- WAITING = 3
			(SELECT COUNT(*) FROM @Jobs WHERE state IN (5,14) and isCompleted = 0) AS '@suspendedJobs' , -- STOPPED, DORMANT = 5, 14
			(SELECT COUNT(*) FROM @Jobs WHERE state = 15 and isCompleted = 0) AS '@queuedJobs' , -- QUEUED = 15
			(SELECT COUNT(*) FROM @Jobs WHERE state = 6 and isCompleted = 0) AS '@killPendingJobs', -- KILLPENDING = 6
			(SELECT COUNT(*) FROM @Jobs WHERE state = 7 and isCompleted = 0) AS '@suspendPendingJobs'  ,-- STOPPENDING = 7
			(SELECT COUNT(*) FROM @Jobs WHERE state = 8 and isCompleted = 0) AS '@interruptPendingJobs', -- INTERRUPTPENDING = 8
			(SELECT COUNT(*) FROM @Jobs WHERE state IN (1,3) and isCompleted = 1) AS '@completedJobs',
			(SELECT COUNT(*) from @jobs where state IN (2,9) and isCompleted = 1) AS '@failedJobs',
			(SELECT COUNT(*) FROM @Jobs WHERE state = 4 and isCompleted = 1) AS '@killedJobs',
			(SELECT COUNT(*) FROM @Jobs WHERE isAnomalous = 1) AS '@anomalousJobs'
			FOR XML PATH('JobManager_JobSummaryResp'), TYPE
		)
	IF ( @outXmlResp IS null )
		SET @outXmlResp = '<JobManager_JobSummaryResp />'
	SELECT @outXmlResp
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetJobSummary')
	delete from GxQscripts where name = 'JMGetJobSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobSummary')
	delete from GXDBVersions where aliasname = 'JMGetJobSummary'
GO

insert into GXDBVersions values(2, 'JMGetJobSummary',  '00010010008800050000', 'JMGetJobSummary', '00010010008800050000')
GO

